/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apptest.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.apptest.AppTestClient;
import software.amazon.awssdk.services.apptest.internal.UserAgentUtils;
import software.amazon.awssdk.services.apptest.model.ListTestConfigurationsRequest;
import software.amazon.awssdk.services.apptest.model.ListTestConfigurationsResponse;
import software.amazon.awssdk.services.apptest.model.TestConfigurationSummary;

public class ListTestConfigurationsIterable
implements SdkIterable<ListTestConfigurationsResponse> {
    private final AppTestClient client;
    private final ListTestConfigurationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListTestConfigurationsIterable(AppTestClient client, ListTestConfigurationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListTestConfigurationsResponseFetcher();
    }

    public Iterator<ListTestConfigurationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<TestConfigurationSummary> testConfigurations() {
        Function<ListTestConfigurationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.testConfigurations() != null) {
                return response.testConfigurations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListTestConfigurationsResponseFetcher
    implements SyncPageFetcher<ListTestConfigurationsResponse> {
        private ListTestConfigurationsResponseFetcher() {
        }

        public boolean hasNextPage(ListTestConfigurationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListTestConfigurationsResponse nextPage(ListTestConfigurationsResponse previousPage) {
            if (previousPage == null) {
                return ListTestConfigurationsIterable.this.client.listTestConfigurations(ListTestConfigurationsIterable.this.firstRequest);
            }
            return ListTestConfigurationsIterable.this.client.listTestConfigurations((ListTestConfigurationsRequest)((Object)ListTestConfigurationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

