/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apptest;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.apptest.model.CreateTestCaseRequest;
import software.amazon.awssdk.services.apptest.model.CreateTestCaseResponse;
import software.amazon.awssdk.services.apptest.model.CreateTestConfigurationRequest;
import software.amazon.awssdk.services.apptest.model.CreateTestConfigurationResponse;
import software.amazon.awssdk.services.apptest.model.CreateTestSuiteRequest;
import software.amazon.awssdk.services.apptest.model.CreateTestSuiteResponse;
import software.amazon.awssdk.services.apptest.model.DeleteTestCaseRequest;
import software.amazon.awssdk.services.apptest.model.DeleteTestCaseResponse;
import software.amazon.awssdk.services.apptest.model.DeleteTestConfigurationRequest;
import software.amazon.awssdk.services.apptest.model.DeleteTestConfigurationResponse;
import software.amazon.awssdk.services.apptest.model.DeleteTestRunRequest;
import software.amazon.awssdk.services.apptest.model.DeleteTestRunResponse;
import software.amazon.awssdk.services.apptest.model.DeleteTestSuiteRequest;
import software.amazon.awssdk.services.apptest.model.DeleteTestSuiteResponse;
import software.amazon.awssdk.services.apptest.model.GetTestCaseRequest;
import software.amazon.awssdk.services.apptest.model.GetTestCaseResponse;
import software.amazon.awssdk.services.apptest.model.GetTestConfigurationRequest;
import software.amazon.awssdk.services.apptest.model.GetTestConfigurationResponse;
import software.amazon.awssdk.services.apptest.model.GetTestRunStepRequest;
import software.amazon.awssdk.services.apptest.model.GetTestRunStepResponse;
import software.amazon.awssdk.services.apptest.model.GetTestSuiteRequest;
import software.amazon.awssdk.services.apptest.model.GetTestSuiteResponse;
import software.amazon.awssdk.services.apptest.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.apptest.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.apptest.model.ListTestCasesRequest;
import software.amazon.awssdk.services.apptest.model.ListTestCasesResponse;
import software.amazon.awssdk.services.apptest.model.ListTestConfigurationsRequest;
import software.amazon.awssdk.services.apptest.model.ListTestConfigurationsResponse;
import software.amazon.awssdk.services.apptest.model.ListTestRunStepsRequest;
import software.amazon.awssdk.services.apptest.model.ListTestRunStepsResponse;
import software.amazon.awssdk.services.apptest.model.ListTestRunTestCasesRequest;
import software.amazon.awssdk.services.apptest.model.ListTestRunTestCasesResponse;
import software.amazon.awssdk.services.apptest.model.ListTestRunsRequest;
import software.amazon.awssdk.services.apptest.model.ListTestRunsResponse;
import software.amazon.awssdk.services.apptest.model.ListTestSuitesRequest;
import software.amazon.awssdk.services.apptest.model.ListTestSuitesResponse;
import software.amazon.awssdk.services.apptest.model.StartTestRunRequest;
import software.amazon.awssdk.services.apptest.model.StartTestRunResponse;
import software.amazon.awssdk.services.apptest.model.TagResourceRequest;
import software.amazon.awssdk.services.apptest.model.TagResourceResponse;
import software.amazon.awssdk.services.apptest.model.UntagResourceRequest;
import software.amazon.awssdk.services.apptest.model.UntagResourceResponse;
import software.amazon.awssdk.services.apptest.model.UpdateTestCaseRequest;
import software.amazon.awssdk.services.apptest.model.UpdateTestCaseResponse;
import software.amazon.awssdk.services.apptest.model.UpdateTestConfigurationRequest;
import software.amazon.awssdk.services.apptest.model.UpdateTestConfigurationResponse;
import software.amazon.awssdk.services.apptest.model.UpdateTestSuiteRequest;
import software.amazon.awssdk.services.apptest.model.UpdateTestSuiteResponse;
import software.amazon.awssdk.services.apptest.paginators.ListTestCasesPublisher;
import software.amazon.awssdk.services.apptest.paginators.ListTestConfigurationsPublisher;
import software.amazon.awssdk.services.apptest.paginators.ListTestRunStepsPublisher;
import software.amazon.awssdk.services.apptest.paginators.ListTestRunTestCasesPublisher;
import software.amazon.awssdk.services.apptest.paginators.ListTestRunsPublisher;
import software.amazon.awssdk.services.apptest.paginators.ListTestSuitesPublisher;

/**
 * Service client for accessing AWS Mainframe Modernization Application Testing asynchronously. This can be created
 * using the static {@link #builder()} method.The asynchronous client performs non-blocking I/O when configured with any
 * {@code SdkAsyncHttpClient} supported in the SDK. However, full non-blocking is not guaranteed as the async client may
 * perform blocking calls in some cases such as credentials retrieval and endpoint discovery as part of the async API
 * call.
 *
 * <p>
 * AWS Mainframe Modernization Application Testing provides tools and resources for automated functional equivalence
 * testing for your migration projects.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface AppTestAsyncClient extends AwsClient {
    String SERVICE_NAME = "apptest";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "apptest";

    /**
     * <p>
     * Creates a test case.
     * </p>
     *
     * @param createTestCaseRequest
     * @return A Java Future containing the result of the CreateTestCase operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException One or more quotas for AWS Application Testing exceeds the limit.</li>
     *         <li>ThrottlingException The number of requests made exceeds the limit.</li>
     *         <li>AccessDeniedException The account or role doesn't have the right permissions to make the request.</li>
     *         <li>ValidationException One or more parameter provided in the request is not valid.</li>
     *         <li>ConflictException The parameters provided in the request conflict with existing resources.</li>
     *         <li>InternalServerException An unexpected error occurred during the processing of the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppTestException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppTestAsyncClient.CreateTestCase
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/apptest-2022-12-06/CreateTestCase" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateTestCaseResponse> createTestCase(CreateTestCaseRequest createTestCaseRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a test case.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateTestCaseRequest.Builder} avoiding the need to
     * create one manually via {@link CreateTestCaseRequest#builder()}
     * </p>
     *
     * @param createTestCaseRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apptest.model.CreateTestCaseRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateTestCase operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException One or more quotas for AWS Application Testing exceeds the limit.</li>
     *         <li>ThrottlingException The number of requests made exceeds the limit.</li>
     *         <li>AccessDeniedException The account or role doesn't have the right permissions to make the request.</li>
     *         <li>ValidationException One or more parameter provided in the request is not valid.</li>
     *         <li>ConflictException The parameters provided in the request conflict with existing resources.</li>
     *         <li>InternalServerException An unexpected error occurred during the processing of the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppTestException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppTestAsyncClient.CreateTestCase
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/apptest-2022-12-06/CreateTestCase" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateTestCaseResponse> createTestCase(Consumer<CreateTestCaseRequest.Builder> createTestCaseRequest) {
        return createTestCase(CreateTestCaseRequest.builder().applyMutation(createTestCaseRequest).build());
    }

    /**
     * <p>
     * Creates a test configuration.
     * </p>
     *
     * @param createTestConfigurationRequest
     * @return A Java Future containing the result of the CreateTestConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException One or more quotas for AWS Application Testing exceeds the limit.</li>
     *         <li>ThrottlingException The number of requests made exceeds the limit.</li>
     *         <li>AccessDeniedException The account or role doesn't have the right permissions to make the request.</li>
     *         <li>ValidationException One or more parameter provided in the request is not valid.</li>
     *         <li>ConflictException The parameters provided in the request conflict with existing resources.</li>
     *         <li>InternalServerException An unexpected error occurred during the processing of the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppTestException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppTestAsyncClient.CreateTestConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/apptest-2022-12-06/CreateTestConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateTestConfigurationResponse> createTestConfiguration(
            CreateTestConfigurationRequest createTestConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a test configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateTestConfigurationRequest.Builder} avoiding
     * the need to create one manually via {@link CreateTestConfigurationRequest#builder()}
     * </p>
     *
     * @param createTestConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apptest.model.CreateTestConfigurationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the CreateTestConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException One or more quotas for AWS Application Testing exceeds the limit.</li>
     *         <li>ThrottlingException The number of requests made exceeds the limit.</li>
     *         <li>AccessDeniedException The account or role doesn't have the right permissions to make the request.</li>
     *         <li>ValidationException One or more parameter provided in the request is not valid.</li>
     *         <li>ConflictException The parameters provided in the request conflict with existing resources.</li>
     *         <li>InternalServerException An unexpected error occurred during the processing of the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppTestException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppTestAsyncClient.CreateTestConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/apptest-2022-12-06/CreateTestConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateTestConfigurationResponse> createTestConfiguration(
            Consumer<CreateTestConfigurationRequest.Builder> createTestConfigurationRequest) {
        return createTestConfiguration(CreateTestConfigurationRequest.builder().applyMutation(createTestConfigurationRequest)
                .build());
    }

    /**
     * <p>
     * Creates a test suite.
     * </p>
     *
     * @param createTestSuiteRequest
     * @return A Java Future containing the result of the CreateTestSuite operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException One or more quotas for AWS Application Testing exceeds the limit.</li>
     *         <li>ThrottlingException The number of requests made exceeds the limit.</li>
     *         <li>AccessDeniedException The account or role doesn't have the right permissions to make the request.</li>
     *         <li>ValidationException One or more parameter provided in the request is not valid.</li>
     *         <li>ConflictException The parameters provided in the request conflict with existing resources.</li>
     *         <li>InternalServerException An unexpected error occurred during the processing of the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppTestException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppTestAsyncClient.CreateTestSuite
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/apptest-2022-12-06/CreateTestSuite" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateTestSuiteResponse> createTestSuite(CreateTestSuiteRequest createTestSuiteRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a test suite.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateTestSuiteRequest.Builder} avoiding the need
     * to create one manually via {@link CreateTestSuiteRequest#builder()}
     * </p>
     *
     * @param createTestSuiteRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apptest.model.CreateTestSuiteRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateTestSuite operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException One or more quotas for AWS Application Testing exceeds the limit.</li>
     *         <li>ThrottlingException The number of requests made exceeds the limit.</li>
     *         <li>AccessDeniedException The account or role doesn't have the right permissions to make the request.</li>
     *         <li>ValidationException One or more parameter provided in the request is not valid.</li>
     *         <li>ConflictException The parameters provided in the request conflict with existing resources.</li>
     *         <li>InternalServerException An unexpected error occurred during the processing of the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppTestException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppTestAsyncClient.CreateTestSuite
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/apptest-2022-12-06/CreateTestSuite" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateTestSuiteResponse> createTestSuite(
            Consumer<CreateTestSuiteRequest.Builder> createTestSuiteRequest) {
        return createTestSuite(CreateTestSuiteRequest.builder().applyMutation(createTestSuiteRequest).build());
    }

    /**
     * <p>
     * Deletes a test case.
     * </p>
     *
     * @param deleteTestCaseRequest
     * @return A Java Future containing the result of the DeleteTestCase operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The number of requests made exceeds the limit.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>AccessDeniedException The account or role doesn't have the right permissions to make the request.</li>
     *         <li>ValidationException One or more parameter provided in the request is not valid.</li>
     *         <li>ConflictException The parameters provided in the request conflict with existing resources.</li>
     *         <li>InternalServerException An unexpected error occurred during the processing of the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppTestException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppTestAsyncClient.DeleteTestCase
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/apptest-2022-12-06/DeleteTestCase" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteTestCaseResponse> deleteTestCase(DeleteTestCaseRequest deleteTestCaseRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a test case.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTestCaseRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteTestCaseRequest#builder()}
     * </p>
     *
     * @param deleteTestCaseRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apptest.model.DeleteTestCaseRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteTestCase operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The number of requests made exceeds the limit.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>AccessDeniedException The account or role doesn't have the right permissions to make the request.</li>
     *         <li>ValidationException One or more parameter provided in the request is not valid.</li>
     *         <li>ConflictException The parameters provided in the request conflict with existing resources.</li>
     *         <li>InternalServerException An unexpected error occurred during the processing of the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppTestException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppTestAsyncClient.DeleteTestCase
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/apptest-2022-12-06/DeleteTestCase" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteTestCaseResponse> deleteTestCase(Consumer<DeleteTestCaseRequest.Builder> deleteTestCaseRequest) {
        return deleteTestCase(DeleteTestCaseRequest.builder().applyMutation(deleteTestCaseRequest).build());
    }

    /**
     * <p>
     * Deletes a test configuration.
     * </p>
     *
     * @param deleteTestConfigurationRequest
     * @return A Java Future containing the result of the DeleteTestConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException One or more quotas for AWS Application Testing exceeds the limit.</li>
     *         <li>ThrottlingException The number of requests made exceeds the limit.</li>
     *         <li>AccessDeniedException The account or role doesn't have the right permissions to make the request.</li>
     *         <li>ValidationException One or more parameter provided in the request is not valid.</li>
     *         <li>ConflictException The parameters provided in the request conflict with existing resources.</li>
     *         <li>InternalServerException An unexpected error occurred during the processing of the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppTestException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppTestAsyncClient.DeleteTestConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/apptest-2022-12-06/DeleteTestConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteTestConfigurationResponse> deleteTestConfiguration(
            DeleteTestConfigurationRequest deleteTestConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a test configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTestConfigurationRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteTestConfigurationRequest#builder()}
     * </p>
     *
     * @param deleteTestConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apptest.model.DeleteTestConfigurationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteTestConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException One or more quotas for AWS Application Testing exceeds the limit.</li>
     *         <li>ThrottlingException The number of requests made exceeds the limit.</li>
     *         <li>AccessDeniedException The account or role doesn't have the right permissions to make the request.</li>
     *         <li>ValidationException One or more parameter provided in the request is not valid.</li>
     *         <li>ConflictException The parameters provided in the request conflict with existing resources.</li>
     *         <li>InternalServerException An unexpected error occurred during the processing of the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppTestException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppTestAsyncClient.DeleteTestConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/apptest-2022-12-06/DeleteTestConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteTestConfigurationResponse> deleteTestConfiguration(
            Consumer<DeleteTestConfigurationRequest.Builder> deleteTestConfigurationRequest) {
        return deleteTestConfiguration(DeleteTestConfigurationRequest.builder().applyMutation(deleteTestConfigurationRequest)
                .build());
    }

    /**
     * <p>
     * Deletes a test run.
     * </p>
     *
     * @param deleteTestRunRequest
     * @return A Java Future containing the result of the DeleteTestRun operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The number of requests made exceeds the limit.</li>
     *         <li>AccessDeniedException The account or role doesn't have the right permissions to make the request.</li>
     *         <li>ValidationException One or more parameter provided in the request is not valid.</li>
     *         <li>ConflictException The parameters provided in the request conflict with existing resources.</li>
     *         <li>InternalServerException An unexpected error occurred during the processing of the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppTestException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppTestAsyncClient.DeleteTestRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/apptest-2022-12-06/DeleteTestRun" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteTestRunResponse> deleteTestRun(DeleteTestRunRequest deleteTestRunRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a test run.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTestRunRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteTestRunRequest#builder()}
     * </p>
     *
     * @param deleteTestRunRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apptest.model.DeleteTestRunRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteTestRun operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The number of requests made exceeds the limit.</li>
     *         <li>AccessDeniedException The account or role doesn't have the right permissions to make the request.</li>
     *         <li>ValidationException One or more parameter provided in the request is not valid.</li>
     *         <li>ConflictException The parameters provided in the request conflict with existing resources.</li>
     *         <li>InternalServerException An unexpected error occurred during the processing of the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppTestException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppTestAsyncClient.DeleteTestRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/apptest-2022-12-06/DeleteTestRun" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteTestRunResponse> deleteTestRun(Consumer<DeleteTestRunRequest.Builder> deleteTestRunRequest) {
        return deleteTestRun(DeleteTestRunRequest.builder().applyMutation(deleteTestRunRequest).build());
    }

    /**
     * <p>
     * Deletes a test suite.
     * </p>
     *
     * @param deleteTestSuiteRequest
     * @return A Java Future containing the result of the DeleteTestSuite operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException One or more quotas for AWS Application Testing exceeds the limit.</li>
     *         <li>ThrottlingException The number of requests made exceeds the limit.</li>
     *         <li>AccessDeniedException The account or role doesn't have the right permissions to make the request.</li>
     *         <li>ValidationException One or more parameter provided in the request is not valid.</li>
     *         <li>ConflictException The parameters provided in the request conflict with existing resources.</li>
     *         <li>InternalServerException An unexpected error occurred during the processing of the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppTestException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppTestAsyncClient.DeleteTestSuite
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/apptest-2022-12-06/DeleteTestSuite" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteTestSuiteResponse> deleteTestSuite(DeleteTestSuiteRequest deleteTestSuiteRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a test suite.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTestSuiteRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteTestSuiteRequest#builder()}
     * </p>
     *
     * @param deleteTestSuiteRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apptest.model.DeleteTestSuiteRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteTestSuite operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException One or more quotas for AWS Application Testing exceeds the limit.</li>
     *         <li>ThrottlingException The number of requests made exceeds the limit.</li>
     *         <li>AccessDeniedException The account or role doesn't have the right permissions to make the request.</li>
     *         <li>ValidationException One or more parameter provided in the request is not valid.</li>
     *         <li>ConflictException The parameters provided in the request conflict with existing resources.</li>
     *         <li>InternalServerException An unexpected error occurred during the processing of the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppTestException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppTestAsyncClient.DeleteTestSuite
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/apptest-2022-12-06/DeleteTestSuite" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteTestSuiteResponse> deleteTestSuite(
            Consumer<DeleteTestSuiteRequest.Builder> deleteTestSuiteRequest) {
        return deleteTestSuite(DeleteTestSuiteRequest.builder().applyMutation(deleteTestSuiteRequest).build());
    }

    /**
     * <p>
     * Gets a test case.
     * </p>
     *
     * @param getTestCaseRequest
     * @return A Java Future containing the result of the GetTestCase operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The number of requests made exceeds the limit.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>AccessDeniedException The account or role doesn't have the right permissions to make the request.</li>
     *         <li>ValidationException One or more parameter provided in the request is not valid.</li>
     *         <li>InternalServerException An unexpected error occurred during the processing of the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppTestException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppTestAsyncClient.GetTestCase
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/apptest-2022-12-06/GetTestCase" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetTestCaseResponse> getTestCase(GetTestCaseRequest getTestCaseRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a test case.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTestCaseRequest.Builder} avoiding the need to
     * create one manually via {@link GetTestCaseRequest#builder()}
     * </p>
     *
     * @param getTestCaseRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apptest.model.GetTestCaseRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetTestCase operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The number of requests made exceeds the limit.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>AccessDeniedException The account or role doesn't have the right permissions to make the request.</li>
     *         <li>ValidationException One or more parameter provided in the request is not valid.</li>
     *         <li>InternalServerException An unexpected error occurred during the processing of the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppTestException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppTestAsyncClient.GetTestCase
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/apptest-2022-12-06/GetTestCase" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetTestCaseResponse> getTestCase(Consumer<GetTestCaseRequest.Builder> getTestCaseRequest) {
        return getTestCase(GetTestCaseRequest.builder().applyMutation(getTestCaseRequest).build());
    }

    /**
     * <p>
     * Gets a test configuration.
     * </p>
     *
     * @param getTestConfigurationRequest
     * @return A Java Future containing the result of the GetTestConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The number of requests made exceeds the limit.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>AccessDeniedException The account or role doesn't have the right permissions to make the request.</li>
     *         <li>ValidationException One or more parameter provided in the request is not valid.</li>
     *         <li>InternalServerException An unexpected error occurred during the processing of the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppTestException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppTestAsyncClient.GetTestConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/apptest-2022-12-06/GetTestConfiguration" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetTestConfigurationResponse> getTestConfiguration(
            GetTestConfigurationRequest getTestConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a test configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTestConfigurationRequest.Builder} avoiding the
     * need to create one manually via {@link GetTestConfigurationRequest#builder()}
     * </p>
     *
     * @param getTestConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apptest.model.GetTestConfigurationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetTestConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The number of requests made exceeds the limit.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>AccessDeniedException The account or role doesn't have the right permissions to make the request.</li>
     *         <li>ValidationException One or more parameter provided in the request is not valid.</li>
     *         <li>InternalServerException An unexpected error occurred during the processing of the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppTestException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppTestAsyncClient.GetTestConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/apptest-2022-12-06/GetTestConfiguration" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetTestConfigurationResponse> getTestConfiguration(
            Consumer<GetTestConfigurationRequest.Builder> getTestConfigurationRequest) {
        return getTestConfiguration(GetTestConfigurationRequest.builder().applyMutation(getTestConfigurationRequest).build());
    }

    /**
     * <p>
     * Gets a test run step.
     * </p>
     *
     * @param getTestRunStepRequest
     * @return A Java Future containing the result of the GetTestRunStep operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The number of requests made exceeds the limit.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>AccessDeniedException The account or role doesn't have the right permissions to make the request.</li>
     *         <li>ValidationException One or more parameter provided in the request is not valid.</li>
     *         <li>InternalServerException An unexpected error occurred during the processing of the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppTestException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppTestAsyncClient.GetTestRunStep
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/apptest-2022-12-06/GetTestRunStep" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetTestRunStepResponse> getTestRunStep(GetTestRunStepRequest getTestRunStepRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a test run step.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTestRunStepRequest.Builder} avoiding the need to
     * create one manually via {@link GetTestRunStepRequest#builder()}
     * </p>
     *
     * @param getTestRunStepRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apptest.model.GetTestRunStepRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetTestRunStep operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The number of requests made exceeds the limit.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>AccessDeniedException The account or role doesn't have the right permissions to make the request.</li>
     *         <li>ValidationException One or more parameter provided in the request is not valid.</li>
     *         <li>InternalServerException An unexpected error occurred during the processing of the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppTestException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppTestAsyncClient.GetTestRunStep
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/apptest-2022-12-06/GetTestRunStep" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetTestRunStepResponse> getTestRunStep(Consumer<GetTestRunStepRequest.Builder> getTestRunStepRequest) {
        return getTestRunStep(GetTestRunStepRequest.builder().applyMutation(getTestRunStepRequest).build());
    }

    /**
     * <p>
     * Gets a test suite.
     * </p>
     *
     * @param getTestSuiteRequest
     * @return A Java Future containing the result of the GetTestSuite operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The number of requests made exceeds the limit.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>AccessDeniedException The account or role doesn't have the right permissions to make the request.</li>
     *         <li>ValidationException One or more parameter provided in the request is not valid.</li>
     *         <li>InternalServerException An unexpected error occurred during the processing of the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppTestException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppTestAsyncClient.GetTestSuite
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/apptest-2022-12-06/GetTestSuite" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetTestSuiteResponse> getTestSuite(GetTestSuiteRequest getTestSuiteRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets a test suite.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTestSuiteRequest.Builder} avoiding the need to
     * create one manually via {@link GetTestSuiteRequest#builder()}
     * </p>
     *
     * @param getTestSuiteRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apptest.model.GetTestSuiteRequest.Builder} to create a request.
     * @return A Java Future containing the result of the GetTestSuite operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The number of requests made exceeds the limit.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>AccessDeniedException The account or role doesn't have the right permissions to make the request.</li>
     *         <li>ValidationException One or more parameter provided in the request is not valid.</li>
     *         <li>InternalServerException An unexpected error occurred during the processing of the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppTestException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppTestAsyncClient.GetTestSuite
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/apptest-2022-12-06/GetTestSuite" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<GetTestSuiteResponse> getTestSuite(Consumer<GetTestSuiteRequest.Builder> getTestSuiteRequest) {
        return getTestSuite(GetTestSuiteRequest.builder().applyMutation(getTestSuiteRequest).build());
    }

    /**
     * <p>
     * Lists tags for a resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The number of requests made exceeds the limit.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>AccessDeniedException The account or role doesn't have the right permissions to make the request.</li>
     *         <li>ValidationException One or more parameter provided in the request is not valid.</li>
     *         <li>InternalServerException An unexpected error occurred during the processing of the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppTestException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppTestAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/apptest-2022-12-06/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists tags for a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apptest.model.ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The number of requests made exceeds the limit.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>AccessDeniedException The account or role doesn't have the right permissions to make the request.</li>
     *         <li>ValidationException One or more parameter provided in the request is not valid.</li>
     *         <li>InternalServerException An unexpected error occurred during the processing of the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppTestException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppTestAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/apptest-2022-12-06/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Lists test cases.
     * </p>
     *
     * @param listTestCasesRequest
     * @return A Java Future containing the result of the ListTestCases operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The number of requests made exceeds the limit.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>AccessDeniedException The account or role doesn't have the right permissions to make the request.</li>
     *         <li>ValidationException One or more parameter provided in the request is not valid.</li>
     *         <li>InternalServerException An unexpected error occurred during the processing of the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppTestException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppTestAsyncClient.ListTestCases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/apptest-2022-12-06/ListTestCases" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListTestCasesResponse> listTestCases(ListTestCasesRequest listTestCasesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists test cases.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTestCasesRequest.Builder} avoiding the need to
     * create one manually via {@link ListTestCasesRequest#builder()}
     * </p>
     *
     * @param listTestCasesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apptest.model.ListTestCasesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListTestCases operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The number of requests made exceeds the limit.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>AccessDeniedException The account or role doesn't have the right permissions to make the request.</li>
     *         <li>ValidationException One or more parameter provided in the request is not valid.</li>
     *         <li>InternalServerException An unexpected error occurred during the processing of the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppTestException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppTestAsyncClient.ListTestCases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/apptest-2022-12-06/ListTestCases" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListTestCasesResponse> listTestCases(Consumer<ListTestCasesRequest.Builder> listTestCasesRequest) {
        return listTestCases(ListTestCasesRequest.builder().applyMutation(listTestCasesRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listTestCases(software.amazon.awssdk.services.apptest.model.ListTestCasesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apptest.paginators.ListTestCasesPublisher publisher = client.listTestCasesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apptest.paginators.ListTestCasesPublisher publisher = client.listTestCasesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.apptest.model.ListTestCasesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.apptest.model.ListTestCasesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTestCases(software.amazon.awssdk.services.apptest.model.ListTestCasesRequest)} operation.</b>
     * </p>
     *
     * @param listTestCasesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The number of requests made exceeds the limit.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>AccessDeniedException The account or role doesn't have the right permissions to make the request.</li>
     *         <li>ValidationException One or more parameter provided in the request is not valid.</li>
     *         <li>InternalServerException An unexpected error occurred during the processing of the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppTestException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppTestAsyncClient.ListTestCases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/apptest-2022-12-06/ListTestCases" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTestCasesPublisher listTestCasesPaginator(ListTestCasesRequest listTestCasesRequest) {
        return new ListTestCasesPublisher(this, listTestCasesRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listTestCases(software.amazon.awssdk.services.apptest.model.ListTestCasesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apptest.paginators.ListTestCasesPublisher publisher = client.listTestCasesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apptest.paginators.ListTestCasesPublisher publisher = client.listTestCasesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.apptest.model.ListTestCasesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.apptest.model.ListTestCasesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTestCases(software.amazon.awssdk.services.apptest.model.ListTestCasesRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTestCasesRequest.Builder} avoiding the need to
     * create one manually via {@link ListTestCasesRequest#builder()}
     * </p>
     *
     * @param listTestCasesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apptest.model.ListTestCasesRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The number of requests made exceeds the limit.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>AccessDeniedException The account or role doesn't have the right permissions to make the request.</li>
     *         <li>ValidationException One or more parameter provided in the request is not valid.</li>
     *         <li>InternalServerException An unexpected error occurred during the processing of the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppTestException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppTestAsyncClient.ListTestCases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/apptest-2022-12-06/ListTestCases" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTestCasesPublisher listTestCasesPaginator(Consumer<ListTestCasesRequest.Builder> listTestCasesRequest) {
        return listTestCasesPaginator(ListTestCasesRequest.builder().applyMutation(listTestCasesRequest).build());
    }

    /**
     * <p>
     * Lists test configurations.
     * </p>
     *
     * @param listTestConfigurationsRequest
     * @return A Java Future containing the result of the ListTestConfigurations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The number of requests made exceeds the limit.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>AccessDeniedException The account or role doesn't have the right permissions to make the request.</li>
     *         <li>ValidationException One or more parameter provided in the request is not valid.</li>
     *         <li>InternalServerException An unexpected error occurred during the processing of the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppTestException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppTestAsyncClient.ListTestConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/apptest-2022-12-06/ListTestConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTestConfigurationsResponse> listTestConfigurations(
            ListTestConfigurationsRequest listTestConfigurationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists test configurations.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTestConfigurationsRequest.Builder} avoiding the
     * need to create one manually via {@link ListTestConfigurationsRequest#builder()}
     * </p>
     *
     * @param listTestConfigurationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apptest.model.ListTestConfigurationsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTestConfigurations operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The number of requests made exceeds the limit.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>AccessDeniedException The account or role doesn't have the right permissions to make the request.</li>
     *         <li>ValidationException One or more parameter provided in the request is not valid.</li>
     *         <li>InternalServerException An unexpected error occurred during the processing of the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppTestException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppTestAsyncClient.ListTestConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/apptest-2022-12-06/ListTestConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTestConfigurationsResponse> listTestConfigurations(
            Consumer<ListTestConfigurationsRequest.Builder> listTestConfigurationsRequest) {
        return listTestConfigurations(ListTestConfigurationsRequest.builder().applyMutation(listTestConfigurationsRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listTestConfigurations(software.amazon.awssdk.services.apptest.model.ListTestConfigurationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apptest.paginators.ListTestConfigurationsPublisher publisher = client.listTestConfigurationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apptest.paginators.ListTestConfigurationsPublisher publisher = client.listTestConfigurationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.apptest.model.ListTestConfigurationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.apptest.model.ListTestConfigurationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTestConfigurations(software.amazon.awssdk.services.apptest.model.ListTestConfigurationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listTestConfigurationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The number of requests made exceeds the limit.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>AccessDeniedException The account or role doesn't have the right permissions to make the request.</li>
     *         <li>ValidationException One or more parameter provided in the request is not valid.</li>
     *         <li>InternalServerException An unexpected error occurred during the processing of the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppTestException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppTestAsyncClient.ListTestConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/apptest-2022-12-06/ListTestConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTestConfigurationsPublisher listTestConfigurationsPaginator(
            ListTestConfigurationsRequest listTestConfigurationsRequest) {
        return new ListTestConfigurationsPublisher(this, listTestConfigurationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listTestConfigurations(software.amazon.awssdk.services.apptest.model.ListTestConfigurationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apptest.paginators.ListTestConfigurationsPublisher publisher = client.listTestConfigurationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apptest.paginators.ListTestConfigurationsPublisher publisher = client.listTestConfigurationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.apptest.model.ListTestConfigurationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.apptest.model.ListTestConfigurationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTestConfigurations(software.amazon.awssdk.services.apptest.model.ListTestConfigurationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTestConfigurationsRequest.Builder} avoiding the
     * need to create one manually via {@link ListTestConfigurationsRequest#builder()}
     * </p>
     *
     * @param listTestConfigurationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apptest.model.ListTestConfigurationsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The number of requests made exceeds the limit.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>AccessDeniedException The account or role doesn't have the right permissions to make the request.</li>
     *         <li>ValidationException One or more parameter provided in the request is not valid.</li>
     *         <li>InternalServerException An unexpected error occurred during the processing of the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppTestException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppTestAsyncClient.ListTestConfigurations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/apptest-2022-12-06/ListTestConfigurations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTestConfigurationsPublisher listTestConfigurationsPaginator(
            Consumer<ListTestConfigurationsRequest.Builder> listTestConfigurationsRequest) {
        return listTestConfigurationsPaginator(ListTestConfigurationsRequest.builder()
                .applyMutation(listTestConfigurationsRequest).build());
    }

    /**
     * <p>
     * Lists test run steps.
     * </p>
     *
     * @param listTestRunStepsRequest
     * @return A Java Future containing the result of the ListTestRunSteps operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The number of requests made exceeds the limit.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>AccessDeniedException The account or role doesn't have the right permissions to make the request.</li>
     *         <li>ValidationException One or more parameter provided in the request is not valid.</li>
     *         <li>InternalServerException An unexpected error occurred during the processing of the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppTestException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppTestAsyncClient.ListTestRunSteps
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/apptest-2022-12-06/ListTestRunSteps" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListTestRunStepsResponse> listTestRunSteps(ListTestRunStepsRequest listTestRunStepsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists test run steps.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTestRunStepsRequest.Builder} avoiding the need
     * to create one manually via {@link ListTestRunStepsRequest#builder()}
     * </p>
     *
     * @param listTestRunStepsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apptest.model.ListTestRunStepsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListTestRunSteps operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The number of requests made exceeds the limit.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>AccessDeniedException The account or role doesn't have the right permissions to make the request.</li>
     *         <li>ValidationException One or more parameter provided in the request is not valid.</li>
     *         <li>InternalServerException An unexpected error occurred during the processing of the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppTestException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppTestAsyncClient.ListTestRunSteps
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/apptest-2022-12-06/ListTestRunSteps" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListTestRunStepsResponse> listTestRunSteps(
            Consumer<ListTestRunStepsRequest.Builder> listTestRunStepsRequest) {
        return listTestRunSteps(ListTestRunStepsRequest.builder().applyMutation(listTestRunStepsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listTestRunSteps(software.amazon.awssdk.services.apptest.model.ListTestRunStepsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apptest.paginators.ListTestRunStepsPublisher publisher = client.listTestRunStepsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apptest.paginators.ListTestRunStepsPublisher publisher = client.listTestRunStepsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.apptest.model.ListTestRunStepsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.apptest.model.ListTestRunStepsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTestRunSteps(software.amazon.awssdk.services.apptest.model.ListTestRunStepsRequest)} operation.</b>
     * </p>
     *
     * @param listTestRunStepsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The number of requests made exceeds the limit.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>AccessDeniedException The account or role doesn't have the right permissions to make the request.</li>
     *         <li>ValidationException One or more parameter provided in the request is not valid.</li>
     *         <li>InternalServerException An unexpected error occurred during the processing of the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppTestException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppTestAsyncClient.ListTestRunSteps
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/apptest-2022-12-06/ListTestRunSteps" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTestRunStepsPublisher listTestRunStepsPaginator(ListTestRunStepsRequest listTestRunStepsRequest) {
        return new ListTestRunStepsPublisher(this, listTestRunStepsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listTestRunSteps(software.amazon.awssdk.services.apptest.model.ListTestRunStepsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apptest.paginators.ListTestRunStepsPublisher publisher = client.listTestRunStepsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apptest.paginators.ListTestRunStepsPublisher publisher = client.listTestRunStepsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.apptest.model.ListTestRunStepsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.apptest.model.ListTestRunStepsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTestRunSteps(software.amazon.awssdk.services.apptest.model.ListTestRunStepsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTestRunStepsRequest.Builder} avoiding the need
     * to create one manually via {@link ListTestRunStepsRequest#builder()}
     * </p>
     *
     * @param listTestRunStepsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apptest.model.ListTestRunStepsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The number of requests made exceeds the limit.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>AccessDeniedException The account or role doesn't have the right permissions to make the request.</li>
     *         <li>ValidationException One or more parameter provided in the request is not valid.</li>
     *         <li>InternalServerException An unexpected error occurred during the processing of the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppTestException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppTestAsyncClient.ListTestRunSteps
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/apptest-2022-12-06/ListTestRunSteps" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTestRunStepsPublisher listTestRunStepsPaginator(Consumer<ListTestRunStepsRequest.Builder> listTestRunStepsRequest) {
        return listTestRunStepsPaginator(ListTestRunStepsRequest.builder().applyMutation(listTestRunStepsRequest).build());
    }

    /**
     * <p>
     * Lists test run test cases.
     * </p>
     *
     * @param listTestRunTestCasesRequest
     * @return A Java Future containing the result of the ListTestRunTestCases operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The number of requests made exceeds the limit.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>AccessDeniedException The account or role doesn't have the right permissions to make the request.</li>
     *         <li>ValidationException One or more parameter provided in the request is not valid.</li>
     *         <li>InternalServerException An unexpected error occurred during the processing of the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppTestException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppTestAsyncClient.ListTestRunTestCases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/apptest-2022-12-06/ListTestRunTestCases" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListTestRunTestCasesResponse> listTestRunTestCases(
            ListTestRunTestCasesRequest listTestRunTestCasesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists test run test cases.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTestRunTestCasesRequest.Builder} avoiding the
     * need to create one manually via {@link ListTestRunTestCasesRequest#builder()}
     * </p>
     *
     * @param listTestRunTestCasesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apptest.model.ListTestRunTestCasesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTestRunTestCases operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The number of requests made exceeds the limit.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>AccessDeniedException The account or role doesn't have the right permissions to make the request.</li>
     *         <li>ValidationException One or more parameter provided in the request is not valid.</li>
     *         <li>InternalServerException An unexpected error occurred during the processing of the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppTestException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppTestAsyncClient.ListTestRunTestCases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/apptest-2022-12-06/ListTestRunTestCases" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListTestRunTestCasesResponse> listTestRunTestCases(
            Consumer<ListTestRunTestCasesRequest.Builder> listTestRunTestCasesRequest) {
        return listTestRunTestCases(ListTestRunTestCasesRequest.builder().applyMutation(listTestRunTestCasesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listTestRunTestCases(software.amazon.awssdk.services.apptest.model.ListTestRunTestCasesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apptest.paginators.ListTestRunTestCasesPublisher publisher = client.listTestRunTestCasesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apptest.paginators.ListTestRunTestCasesPublisher publisher = client.listTestRunTestCasesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.apptest.model.ListTestRunTestCasesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.apptest.model.ListTestRunTestCasesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTestRunTestCases(software.amazon.awssdk.services.apptest.model.ListTestRunTestCasesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listTestRunTestCasesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The number of requests made exceeds the limit.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>AccessDeniedException The account or role doesn't have the right permissions to make the request.</li>
     *         <li>ValidationException One or more parameter provided in the request is not valid.</li>
     *         <li>InternalServerException An unexpected error occurred during the processing of the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppTestException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppTestAsyncClient.ListTestRunTestCases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/apptest-2022-12-06/ListTestRunTestCases" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTestRunTestCasesPublisher listTestRunTestCasesPaginator(ListTestRunTestCasesRequest listTestRunTestCasesRequest) {
        return new ListTestRunTestCasesPublisher(this, listTestRunTestCasesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listTestRunTestCases(software.amazon.awssdk.services.apptest.model.ListTestRunTestCasesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apptest.paginators.ListTestRunTestCasesPublisher publisher = client.listTestRunTestCasesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apptest.paginators.ListTestRunTestCasesPublisher publisher = client.listTestRunTestCasesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.apptest.model.ListTestRunTestCasesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.apptest.model.ListTestRunTestCasesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTestRunTestCases(software.amazon.awssdk.services.apptest.model.ListTestRunTestCasesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTestRunTestCasesRequest.Builder} avoiding the
     * need to create one manually via {@link ListTestRunTestCasesRequest#builder()}
     * </p>
     *
     * @param listTestRunTestCasesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apptest.model.ListTestRunTestCasesRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The number of requests made exceeds the limit.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>AccessDeniedException The account or role doesn't have the right permissions to make the request.</li>
     *         <li>ValidationException One or more parameter provided in the request is not valid.</li>
     *         <li>InternalServerException An unexpected error occurred during the processing of the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppTestException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppTestAsyncClient.ListTestRunTestCases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/apptest-2022-12-06/ListTestRunTestCases" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTestRunTestCasesPublisher listTestRunTestCasesPaginator(
            Consumer<ListTestRunTestCasesRequest.Builder> listTestRunTestCasesRequest) {
        return listTestRunTestCasesPaginator(ListTestRunTestCasesRequest.builder().applyMutation(listTestRunTestCasesRequest)
                .build());
    }

    /**
     * <p>
     * Lists test runs.
     * </p>
     *
     * @param listTestRunsRequest
     * @return A Java Future containing the result of the ListTestRuns operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The number of requests made exceeds the limit.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>AccessDeniedException The account or role doesn't have the right permissions to make the request.</li>
     *         <li>ValidationException One or more parameter provided in the request is not valid.</li>
     *         <li>InternalServerException An unexpected error occurred during the processing of the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppTestException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppTestAsyncClient.ListTestRuns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/apptest-2022-12-06/ListTestRuns" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListTestRunsResponse> listTestRuns(ListTestRunsRequest listTestRunsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists test runs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTestRunsRequest.Builder} avoiding the need to
     * create one manually via {@link ListTestRunsRequest#builder()}
     * </p>
     *
     * @param listTestRunsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apptest.model.ListTestRunsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListTestRuns operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The number of requests made exceeds the limit.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>AccessDeniedException The account or role doesn't have the right permissions to make the request.</li>
     *         <li>ValidationException One or more parameter provided in the request is not valid.</li>
     *         <li>InternalServerException An unexpected error occurred during the processing of the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppTestException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppTestAsyncClient.ListTestRuns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/apptest-2022-12-06/ListTestRuns" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListTestRunsResponse> listTestRuns(Consumer<ListTestRunsRequest.Builder> listTestRunsRequest) {
        return listTestRuns(ListTestRunsRequest.builder().applyMutation(listTestRunsRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listTestRuns(software.amazon.awssdk.services.apptest.model.ListTestRunsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apptest.paginators.ListTestRunsPublisher publisher = client.listTestRunsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apptest.paginators.ListTestRunsPublisher publisher = client.listTestRunsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.apptest.model.ListTestRunsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.apptest.model.ListTestRunsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTestRuns(software.amazon.awssdk.services.apptest.model.ListTestRunsRequest)} operation.</b>
     * </p>
     *
     * @param listTestRunsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The number of requests made exceeds the limit.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>AccessDeniedException The account or role doesn't have the right permissions to make the request.</li>
     *         <li>ValidationException One or more parameter provided in the request is not valid.</li>
     *         <li>InternalServerException An unexpected error occurred during the processing of the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppTestException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppTestAsyncClient.ListTestRuns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/apptest-2022-12-06/ListTestRuns" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTestRunsPublisher listTestRunsPaginator(ListTestRunsRequest listTestRunsRequest) {
        return new ListTestRunsPublisher(this, listTestRunsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listTestRuns(software.amazon.awssdk.services.apptest.model.ListTestRunsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apptest.paginators.ListTestRunsPublisher publisher = client.listTestRunsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apptest.paginators.ListTestRunsPublisher publisher = client.listTestRunsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.apptest.model.ListTestRunsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.apptest.model.ListTestRunsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTestRuns(software.amazon.awssdk.services.apptest.model.ListTestRunsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTestRunsRequest.Builder} avoiding the need to
     * create one manually via {@link ListTestRunsRequest#builder()}
     * </p>
     *
     * @param listTestRunsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apptest.model.ListTestRunsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The number of requests made exceeds the limit.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>AccessDeniedException The account or role doesn't have the right permissions to make the request.</li>
     *         <li>ValidationException One or more parameter provided in the request is not valid.</li>
     *         <li>InternalServerException An unexpected error occurred during the processing of the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppTestException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppTestAsyncClient.ListTestRuns
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/apptest-2022-12-06/ListTestRuns" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTestRunsPublisher listTestRunsPaginator(Consumer<ListTestRunsRequest.Builder> listTestRunsRequest) {
        return listTestRunsPaginator(ListTestRunsRequest.builder().applyMutation(listTestRunsRequest).build());
    }

    /**
     * <p>
     * Lists test suites.
     * </p>
     *
     * @param listTestSuitesRequest
     * @return A Java Future containing the result of the ListTestSuites operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The number of requests made exceeds the limit.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>AccessDeniedException The account or role doesn't have the right permissions to make the request.</li>
     *         <li>ValidationException One or more parameter provided in the request is not valid.</li>
     *         <li>InternalServerException An unexpected error occurred during the processing of the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppTestException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppTestAsyncClient.ListTestSuites
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/apptest-2022-12-06/ListTestSuites" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListTestSuitesResponse> listTestSuites(ListTestSuitesRequest listTestSuitesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists test suites.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTestSuitesRequest.Builder} avoiding the need to
     * create one manually via {@link ListTestSuitesRequest#builder()}
     * </p>
     *
     * @param listTestSuitesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apptest.model.ListTestSuitesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListTestSuites operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The number of requests made exceeds the limit.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>AccessDeniedException The account or role doesn't have the right permissions to make the request.</li>
     *         <li>ValidationException One or more parameter provided in the request is not valid.</li>
     *         <li>InternalServerException An unexpected error occurred during the processing of the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppTestException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppTestAsyncClient.ListTestSuites
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/apptest-2022-12-06/ListTestSuites" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListTestSuitesResponse> listTestSuites(Consumer<ListTestSuitesRequest.Builder> listTestSuitesRequest) {
        return listTestSuites(ListTestSuitesRequest.builder().applyMutation(listTestSuitesRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listTestSuites(software.amazon.awssdk.services.apptest.model.ListTestSuitesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apptest.paginators.ListTestSuitesPublisher publisher = client.listTestSuitesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apptest.paginators.ListTestSuitesPublisher publisher = client.listTestSuitesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.apptest.model.ListTestSuitesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.apptest.model.ListTestSuitesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTestSuites(software.amazon.awssdk.services.apptest.model.ListTestSuitesRequest)} operation.</b>
     * </p>
     *
     * @param listTestSuitesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The number of requests made exceeds the limit.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>AccessDeniedException The account or role doesn't have the right permissions to make the request.</li>
     *         <li>ValidationException One or more parameter provided in the request is not valid.</li>
     *         <li>InternalServerException An unexpected error occurred during the processing of the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppTestException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppTestAsyncClient.ListTestSuites
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/apptest-2022-12-06/ListTestSuites" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTestSuitesPublisher listTestSuitesPaginator(ListTestSuitesRequest listTestSuitesRequest) {
        return new ListTestSuitesPublisher(this, listTestSuitesRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listTestSuites(software.amazon.awssdk.services.apptest.model.ListTestSuitesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apptest.paginators.ListTestSuitesPublisher publisher = client.listTestSuitesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.apptest.paginators.ListTestSuitesPublisher publisher = client.listTestSuitesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.apptest.model.ListTestSuitesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.apptest.model.ListTestSuitesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTestSuites(software.amazon.awssdk.services.apptest.model.ListTestSuitesRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTestSuitesRequest.Builder} avoiding the need to
     * create one manually via {@link ListTestSuitesRequest#builder()}
     * </p>
     *
     * @param listTestSuitesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apptest.model.ListTestSuitesRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The number of requests made exceeds the limit.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>AccessDeniedException The account or role doesn't have the right permissions to make the request.</li>
     *         <li>ValidationException One or more parameter provided in the request is not valid.</li>
     *         <li>InternalServerException An unexpected error occurred during the processing of the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppTestException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppTestAsyncClient.ListTestSuites
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/apptest-2022-12-06/ListTestSuites" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTestSuitesPublisher listTestSuitesPaginator(Consumer<ListTestSuitesRequest.Builder> listTestSuitesRequest) {
        return listTestSuitesPaginator(ListTestSuitesRequest.builder().applyMutation(listTestSuitesRequest).build());
    }

    /**
     * <p>
     * Starts a test run.
     * </p>
     *
     * @param startTestRunRequest
     * @return A Java Future containing the result of the StartTestRun operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException One or more quotas for AWS Application Testing exceeds the limit.</li>
     *         <li>ThrottlingException The number of requests made exceeds the limit.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>AccessDeniedException The account or role doesn't have the right permissions to make the request.</li>
     *         <li>ValidationException One or more parameter provided in the request is not valid.</li>
     *         <li>ConflictException The parameters provided in the request conflict with existing resources.</li>
     *         <li>InternalServerException An unexpected error occurred during the processing of the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppTestException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppTestAsyncClient.StartTestRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/apptest-2022-12-06/StartTestRun" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StartTestRunResponse> startTestRun(StartTestRunRequest startTestRunRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts a test run.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartTestRunRequest.Builder} avoiding the need to
     * create one manually via {@link StartTestRunRequest#builder()}
     * </p>
     *
     * @param startTestRunRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apptest.model.StartTestRunRequest.Builder} to create a request.
     * @return A Java Future containing the result of the StartTestRun operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException One or more quotas for AWS Application Testing exceeds the limit.</li>
     *         <li>ThrottlingException The number of requests made exceeds the limit.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>AccessDeniedException The account or role doesn't have the right permissions to make the request.</li>
     *         <li>ValidationException One or more parameter provided in the request is not valid.</li>
     *         <li>ConflictException The parameters provided in the request conflict with existing resources.</li>
     *         <li>InternalServerException An unexpected error occurred during the processing of the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppTestException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppTestAsyncClient.StartTestRun
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/apptest-2022-12-06/StartTestRun" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StartTestRunResponse> startTestRun(Consumer<StartTestRunRequest.Builder> startTestRunRequest) {
        return startTestRun(StartTestRunRequest.builder().applyMutation(startTestRunRequest).build());
    }

    /**
     * <p>
     * Specifies tags of a resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException One or more quotas for AWS Application Testing exceeds the limit.</li>
     *         <li>ThrottlingException The number of requests made exceeds the limit.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>AccessDeniedException The account or role doesn't have the right permissions to make the request.</li>
     *         <li>ValidationException One or more parameter provided in the request is not valid.</li>
     *         <li>InternalServerException An unexpected error occurred during the processing of the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppTestException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppTestAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/apptest-2022-12-06/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Specifies tags of a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apptest.model.TagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ServiceQuotaExceededException One or more quotas for AWS Application Testing exceeds the limit.</li>
     *         <li>ThrottlingException The number of requests made exceeds the limit.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>AccessDeniedException The account or role doesn't have the right permissions to make the request.</li>
     *         <li>ValidationException One or more parameter provided in the request is not valid.</li>
     *         <li>InternalServerException An unexpected error occurred during the processing of the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppTestException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppTestAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/apptest-2022-12-06/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Untags a resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The number of requests made exceeds the limit.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>AccessDeniedException The account or role doesn't have the right permissions to make the request.</li>
     *         <li>ValidationException One or more parameter provided in the request is not valid.</li>
     *         <li>InternalServerException An unexpected error occurred during the processing of the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppTestException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppTestAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/apptest-2022-12-06/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Untags a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apptest.model.UntagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The number of requests made exceeds the limit.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>AccessDeniedException The account or role doesn't have the right permissions to make the request.</li>
     *         <li>ValidationException One or more parameter provided in the request is not valid.</li>
     *         <li>InternalServerException An unexpected error occurred during the processing of the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppTestException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppTestAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/apptest-2022-12-06/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates a test case.
     * </p>
     *
     * @param updateTestCaseRequest
     * @return A Java Future containing the result of the UpdateTestCase operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The number of requests made exceeds the limit.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>AccessDeniedException The account or role doesn't have the right permissions to make the request.</li>
     *         <li>ValidationException One or more parameter provided in the request is not valid.</li>
     *         <li>ConflictException The parameters provided in the request conflict with existing resources.</li>
     *         <li>InternalServerException An unexpected error occurred during the processing of the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppTestException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppTestAsyncClient.UpdateTestCase
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/apptest-2022-12-06/UpdateTestCase" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateTestCaseResponse> updateTestCase(UpdateTestCaseRequest updateTestCaseRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a test case.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateTestCaseRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateTestCaseRequest#builder()}
     * </p>
     *
     * @param updateTestCaseRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apptest.model.UpdateTestCaseRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateTestCase operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The number of requests made exceeds the limit.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>AccessDeniedException The account or role doesn't have the right permissions to make the request.</li>
     *         <li>ValidationException One or more parameter provided in the request is not valid.</li>
     *         <li>ConflictException The parameters provided in the request conflict with existing resources.</li>
     *         <li>InternalServerException An unexpected error occurred during the processing of the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppTestException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppTestAsyncClient.UpdateTestCase
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/apptest-2022-12-06/UpdateTestCase" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateTestCaseResponse> updateTestCase(Consumer<UpdateTestCaseRequest.Builder> updateTestCaseRequest) {
        return updateTestCase(UpdateTestCaseRequest.builder().applyMutation(updateTestCaseRequest).build());
    }

    /**
     * <p>
     * Updates a test configuration.
     * </p>
     *
     * @param updateTestConfigurationRequest
     * @return A Java Future containing the result of the UpdateTestConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The number of requests made exceeds the limit.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>AccessDeniedException The account or role doesn't have the right permissions to make the request.</li>
     *         <li>ValidationException One or more parameter provided in the request is not valid.</li>
     *         <li>ConflictException The parameters provided in the request conflict with existing resources.</li>
     *         <li>InternalServerException An unexpected error occurred during the processing of the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppTestException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppTestAsyncClient.UpdateTestConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/apptest-2022-12-06/UpdateTestConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateTestConfigurationResponse> updateTestConfiguration(
            UpdateTestConfigurationRequest updateTestConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a test configuration.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateTestConfigurationRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateTestConfigurationRequest#builder()}
     * </p>
     *
     * @param updateTestConfigurationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apptest.model.UpdateTestConfigurationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateTestConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The number of requests made exceeds the limit.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>AccessDeniedException The account or role doesn't have the right permissions to make the request.</li>
     *         <li>ValidationException One or more parameter provided in the request is not valid.</li>
     *         <li>ConflictException The parameters provided in the request conflict with existing resources.</li>
     *         <li>InternalServerException An unexpected error occurred during the processing of the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppTestException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppTestAsyncClient.UpdateTestConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/apptest-2022-12-06/UpdateTestConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateTestConfigurationResponse> updateTestConfiguration(
            Consumer<UpdateTestConfigurationRequest.Builder> updateTestConfigurationRequest) {
        return updateTestConfiguration(UpdateTestConfigurationRequest.builder().applyMutation(updateTestConfigurationRequest)
                .build());
    }

    /**
     * <p>
     * Updates a test suite.
     * </p>
     *
     * @param updateTestSuiteRequest
     * @return A Java Future containing the result of the UpdateTestSuite operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The number of requests made exceeds the limit.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>AccessDeniedException The account or role doesn't have the right permissions to make the request.</li>
     *         <li>ValidationException One or more parameter provided in the request is not valid.</li>
     *         <li>ConflictException The parameters provided in the request conflict with existing resources.</li>
     *         <li>InternalServerException An unexpected error occurred during the processing of the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppTestException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppTestAsyncClient.UpdateTestSuite
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/apptest-2022-12-06/UpdateTestSuite" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateTestSuiteResponse> updateTestSuite(UpdateTestSuiteRequest updateTestSuiteRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a test suite.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateTestSuiteRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateTestSuiteRequest#builder()}
     * </p>
     *
     * @param updateTestSuiteRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.apptest.model.UpdateTestSuiteRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateTestSuite operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>ThrottlingException The number of requests made exceeds the limit.</li>
     *         <li>ResourceNotFoundException The specified resource was not found.</li>
     *         <li>AccessDeniedException The account or role doesn't have the right permissions to make the request.</li>
     *         <li>ValidationException One or more parameter provided in the request is not valid.</li>
     *         <li>ConflictException The parameters provided in the request conflict with existing resources.</li>
     *         <li>InternalServerException An unexpected error occurred during the processing of the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>AppTestException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample AppTestAsyncClient.UpdateTestSuite
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/apptest-2022-12-06/UpdateTestSuite" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateTestSuiteResponse> updateTestSuite(
            Consumer<UpdateTestSuiteRequest.Builder> updateTestSuiteRequest) {
        return updateTestSuite(UpdateTestSuiteRequest.builder().applyMutation(updateTestSuiteRequest).build());
    }

    @Override
    default AppTestServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link AppTestAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static AppTestAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link AppTestAsyncClient}.
     */
    static AppTestAsyncClientBuilder builder() {
        return new DefaultAppTestAsyncClientBuilder();
    }
}
