/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apptest.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summarizes a batch job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchSummary implements SdkPojo, Serializable, ToCopyableBuilder<BatchSummary.Builder, BatchSummary> {
    private static final SdkField<BatchStepInput> STEP_INPUT_FIELD = SdkField.<BatchStepInput> builder(MarshallingType.SDK_POJO)
            .memberName("stepInput").getter(getter(BatchSummary::stepInput)).setter(setter(Builder::stepInput))
            .constructor(BatchStepInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stepInput").build()).build();

    private static final SdkField<BatchStepOutput> STEP_OUTPUT_FIELD = SdkField
            .<BatchStepOutput> builder(MarshallingType.SDK_POJO).memberName("stepOutput")
            .getter(getter(BatchSummary::stepOutput)).setter(setter(Builder::stepOutput)).constructor(BatchStepOutput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stepOutput").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STEP_INPUT_FIELD,
            STEP_OUTPUT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final BatchStepInput stepInput;

    private final BatchStepOutput stepOutput;

    private BatchSummary(BuilderImpl builder) {
        this.stepInput = builder.stepInput;
        this.stepOutput = builder.stepOutput;
    }

    /**
     * <p>
     * The step input of the batch summary.
     * </p>
     * 
     * @return The step input of the batch summary.
     */
    public final BatchStepInput stepInput() {
        return stepInput;
    }

    /**
     * <p>
     * The step output of the batch summary.
     * </p>
     * 
     * @return The step output of the batch summary.
     */
    public final BatchStepOutput stepOutput() {
        return stepOutput;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stepInput());
        hashCode = 31 * hashCode + Objects.hashCode(stepOutput());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchSummary)) {
            return false;
        }
        BatchSummary other = (BatchSummary) obj;
        return Objects.equals(stepInput(), other.stepInput()) && Objects.equals(stepOutput(), other.stepOutput());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchSummary").add("StepInput", stepInput()).add("StepOutput", stepOutput()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "stepInput":
            return Optional.ofNullable(clazz.cast(stepInput()));
        case "stepOutput":
            return Optional.ofNullable(clazz.cast(stepOutput()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("stepInput", STEP_INPUT_FIELD);
        map.put("stepOutput", STEP_OUTPUT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchSummary, T> g) {
        return obj -> g.apply((BatchSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BatchSummary> {
        /**
         * <p>
         * The step input of the batch summary.
         * </p>
         * 
         * @param stepInput
         *        The step input of the batch summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stepInput(BatchStepInput stepInput);

        /**
         * <p>
         * The step input of the batch summary.
         * </p>
         * This is a convenience method that creates an instance of the {@link BatchStepInput.Builder} avoiding the need
         * to create one manually via {@link BatchStepInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BatchStepInput.Builder#build()} is called immediately and its
         * result is passed to {@link #stepInput(BatchStepInput)}.
         * 
         * @param stepInput
         *        a consumer that will call methods on {@link BatchStepInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stepInput(BatchStepInput)
         */
        default Builder stepInput(Consumer<BatchStepInput.Builder> stepInput) {
            return stepInput(BatchStepInput.builder().applyMutation(stepInput).build());
        }

        /**
         * <p>
         * The step output of the batch summary.
         * </p>
         * 
         * @param stepOutput
         *        The step output of the batch summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stepOutput(BatchStepOutput stepOutput);

        /**
         * <p>
         * The step output of the batch summary.
         * </p>
         * This is a convenience method that creates an instance of the {@link BatchStepOutput.Builder} avoiding the
         * need to create one manually via {@link BatchStepOutput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BatchStepOutput.Builder#build()} is called immediately and its
         * result is passed to {@link #stepOutput(BatchStepOutput)}.
         * 
         * @param stepOutput
         *        a consumer that will call methods on {@link BatchStepOutput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stepOutput(BatchStepOutput)
         */
        default Builder stepOutput(Consumer<BatchStepOutput.Builder> stepOutput) {
            return stepOutput(BatchStepOutput.builder().applyMutation(stepOutput).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private BatchStepInput stepInput;

        private BatchStepOutput stepOutput;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchSummary model) {
            stepInput(model.stepInput);
            stepOutput(model.stepOutput);
        }

        public final BatchStepInput.Builder getStepInput() {
            return stepInput != null ? stepInput.toBuilder() : null;
        }

        public final void setStepInput(BatchStepInput.BuilderImpl stepInput) {
            this.stepInput = stepInput != null ? stepInput.build() : null;
        }

        @Override
        public final Builder stepInput(BatchStepInput stepInput) {
            this.stepInput = stepInput;
            return this;
        }

        public final BatchStepOutput.Builder getStepOutput() {
            return stepOutput != null ? stepOutput.toBuilder() : null;
        }

        public final void setStepOutput(BatchStepOutput.BuilderImpl stepOutput) {
            this.stepOutput = stepOutput != null ? stepOutput.build() : null;
        }

        @Override
        public final Builder stepOutput(BatchStepOutput stepOutput) {
            this.stepOutput = stepOutput;
            return this;
        }

        @Override
        public BatchSummary build() {
            return new BatchSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
