/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apptest.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Creates a CloudFormation summary.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateCloudFormationSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<CreateCloudFormationSummary.Builder, CreateCloudFormationSummary> {
    private static final SdkField<CreateCloudFormationStepInput> STEP_INPUT_FIELD = SdkField
            .<CreateCloudFormationStepInput> builder(MarshallingType.SDK_POJO).memberName("stepInput")
            .getter(getter(CreateCloudFormationSummary::stepInput)).setter(setter(Builder::stepInput))
            .constructor(CreateCloudFormationStepInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stepInput").build()).build();

    private static final SdkField<CreateCloudFormationStepOutput> STEP_OUTPUT_FIELD = SdkField
            .<CreateCloudFormationStepOutput> builder(MarshallingType.SDK_POJO).memberName("stepOutput")
            .getter(getter(CreateCloudFormationSummary::stepOutput)).setter(setter(Builder::stepOutput))
            .constructor(CreateCloudFormationStepOutput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stepOutput").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STEP_INPUT_FIELD,
            STEP_OUTPUT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final CreateCloudFormationStepInput stepInput;

    private final CreateCloudFormationStepOutput stepOutput;

    private CreateCloudFormationSummary(BuilderImpl builder) {
        this.stepInput = builder.stepInput;
        this.stepOutput = builder.stepOutput;
    }

    /**
     * <p>
     * The step input of the CloudFormation summary.
     * </p>
     * 
     * @return The step input of the CloudFormation summary.
     */
    public final CreateCloudFormationStepInput stepInput() {
        return stepInput;
    }

    /**
     * <p>
     * The step output of the CloudFormation summary.
     * </p>
     * 
     * @return The step output of the CloudFormation summary.
     */
    public final CreateCloudFormationStepOutput stepOutput() {
        return stepOutput;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stepInput());
        hashCode = 31 * hashCode + Objects.hashCode(stepOutput());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCloudFormationSummary)) {
            return false;
        }
        CreateCloudFormationSummary other = (CreateCloudFormationSummary) obj;
        return Objects.equals(stepInput(), other.stepInput()) && Objects.equals(stepOutput(), other.stepOutput());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateCloudFormationSummary").add("StepInput", stepInput()).add("StepOutput", stepOutput())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "stepInput":
            return Optional.ofNullable(clazz.cast(stepInput()));
        case "stepOutput":
            return Optional.ofNullable(clazz.cast(stepOutput()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("stepInput", STEP_INPUT_FIELD);
        map.put("stepOutput", STEP_OUTPUT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateCloudFormationSummary, T> g) {
        return obj -> g.apply((CreateCloudFormationSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CreateCloudFormationSummary> {
        /**
         * <p>
         * The step input of the CloudFormation summary.
         * </p>
         * 
         * @param stepInput
         *        The step input of the CloudFormation summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stepInput(CreateCloudFormationStepInput stepInput);

        /**
         * <p>
         * The step input of the CloudFormation summary.
         * </p>
         * This is a convenience method that creates an instance of the {@link CreateCloudFormationStepInput.Builder}
         * avoiding the need to create one manually via {@link CreateCloudFormationStepInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CreateCloudFormationStepInput.Builder#build()} is called
         * immediately and its result is passed to {@link #stepInput(CreateCloudFormationStepInput)}.
         * 
         * @param stepInput
         *        a consumer that will call methods on {@link CreateCloudFormationStepInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stepInput(CreateCloudFormationStepInput)
         */
        default Builder stepInput(Consumer<CreateCloudFormationStepInput.Builder> stepInput) {
            return stepInput(CreateCloudFormationStepInput.builder().applyMutation(stepInput).build());
        }

        /**
         * <p>
         * The step output of the CloudFormation summary.
         * </p>
         * 
         * @param stepOutput
         *        The step output of the CloudFormation summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stepOutput(CreateCloudFormationStepOutput stepOutput);

        /**
         * <p>
         * The step output of the CloudFormation summary.
         * </p>
         * This is a convenience method that creates an instance of the {@link CreateCloudFormationStepOutput.Builder}
         * avoiding the need to create one manually via {@link CreateCloudFormationStepOutput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CreateCloudFormationStepOutput.Builder#build()} is called
         * immediately and its result is passed to {@link #stepOutput(CreateCloudFormationStepOutput)}.
         * 
         * @param stepOutput
         *        a consumer that will call methods on {@link CreateCloudFormationStepOutput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stepOutput(CreateCloudFormationStepOutput)
         */
        default Builder stepOutput(Consumer<CreateCloudFormationStepOutput.Builder> stepOutput) {
            return stepOutput(CreateCloudFormationStepOutput.builder().applyMutation(stepOutput).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private CreateCloudFormationStepInput stepInput;

        private CreateCloudFormationStepOutput stepOutput;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCloudFormationSummary model) {
            stepInput(model.stepInput);
            stepOutput(model.stepOutput);
        }

        public final CreateCloudFormationStepInput.Builder getStepInput() {
            return stepInput != null ? stepInput.toBuilder() : null;
        }

        public final void setStepInput(CreateCloudFormationStepInput.BuilderImpl stepInput) {
            this.stepInput = stepInput != null ? stepInput.build() : null;
        }

        @Override
        public final Builder stepInput(CreateCloudFormationStepInput stepInput) {
            this.stepInput = stepInput;
            return this;
        }

        public final CreateCloudFormationStepOutput.Builder getStepOutput() {
            return stepOutput != null ? stepOutput.toBuilder() : null;
        }

        public final void setStepOutput(CreateCloudFormationStepOutput.BuilderImpl stepOutput) {
            this.stepOutput = stepOutput != null ? stepOutput.build() : null;
        }

        @Override
        public final Builder stepOutput(CreateCloudFormationStepOutput stepOutput) {
            this.stepOutput = stepOutput;
            return this;
        }

        @Override
        public CreateCloudFormationSummary build() {
            return new CreateCloudFormationSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
