/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apptest.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetTestCaseResponse extends AppTestResponse implements
        ToCopyableBuilder<GetTestCaseResponse.Builder, GetTestCaseResponse> {
    private static final SdkField<String> TEST_CASE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("testCaseId").getter(getter(GetTestCaseResponse::testCaseId)).setter(setter(Builder::testCaseId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testCaseId").build()).build();

    private static final SdkField<String> TEST_CASE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("testCaseArn").getter(getter(GetTestCaseResponse::testCaseArn)).setter(setter(Builder::testCaseArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testCaseArn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(GetTestCaseResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(GetTestCaseResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<TestCaseLatestVersion> LATEST_VERSION_FIELD = SdkField
            .<TestCaseLatestVersion> builder(MarshallingType.SDK_POJO).memberName("latestVersion")
            .getter(getter(GetTestCaseResponse::latestVersion)).setter(setter(Builder::latestVersion))
            .constructor(TestCaseLatestVersion::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("latestVersion").build()).build();

    private static final SdkField<Integer> TEST_CASE_VERSION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("testCaseVersion").getter(getter(GetTestCaseResponse::testCaseVersion))
            .setter(setter(Builder::testCaseVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testCaseVersion").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(GetTestCaseResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("statusReason").getter(getter(GetTestCaseResponse::statusReason)).setter(setter(Builder::statusReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReason").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationTime").getter(getter(GetTestCaseResponse::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()).build();

    private static final SdkField<Instant> LAST_UPDATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdateTime").getter(getter(GetTestCaseResponse::lastUpdateTime))
            .setter(setter(Builder::lastUpdateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdateTime").build()).build();

    private static final SdkField<List<Step>> STEPS_FIELD = SdkField
            .<List<Step>> builder(MarshallingType.LIST)
            .memberName("steps")
            .getter(getter(GetTestCaseResponse::steps))
            .setter(setter(Builder::steps))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("steps").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Step> builder(MarshallingType.SDK_POJO)
                                            .constructor(Step::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(GetTestCaseResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEST_CASE_ID_FIELD,
            TEST_CASE_ARN_FIELD, NAME_FIELD, DESCRIPTION_FIELD, LATEST_VERSION_FIELD, TEST_CASE_VERSION_FIELD, STATUS_FIELD,
            STATUS_REASON_FIELD, CREATION_TIME_FIELD, LAST_UPDATE_TIME_FIELD, STEPS_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String testCaseId;

    private final String testCaseArn;

    private final String name;

    private final String description;

    private final TestCaseLatestVersion latestVersion;

    private final Integer testCaseVersion;

    private final String status;

    private final String statusReason;

    private final Instant creationTime;

    private final Instant lastUpdateTime;

    private final List<Step> steps;

    private final Map<String, String> tags;

    private GetTestCaseResponse(BuilderImpl builder) {
        super(builder);
        this.testCaseId = builder.testCaseId;
        this.testCaseArn = builder.testCaseArn;
        this.name = builder.name;
        this.description = builder.description;
        this.latestVersion = builder.latestVersion;
        this.testCaseVersion = builder.testCaseVersion;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.creationTime = builder.creationTime;
        this.lastUpdateTime = builder.lastUpdateTime;
        this.steps = builder.steps;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The response test ID of the test case.
     * </p>
     * 
     * @return The response test ID of the test case.
     */
    public final String testCaseId() {
        return testCaseId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the test case.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the test case.
     */
    public final String testCaseArn() {
        return testCaseArn;
    }

    /**
     * <p>
     * The name of the test case.
     * </p>
     * 
     * @return The name of the test case.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The description of the test case.
     * </p>
     * 
     * @return The description of the test case.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The latest version of the test case.
     * </p>
     * 
     * @return The latest version of the test case.
     */
    public final TestCaseLatestVersion latestVersion() {
        return latestVersion;
    }

    /**
     * <p>
     * The case version of the test case.
     * </p>
     * 
     * @return The case version of the test case.
     */
    public final Integer testCaseVersion() {
        return testCaseVersion;
    }

    /**
     * <p>
     * The status of the test case.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TestCaseLifecycle#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the test case.
     * @see TestCaseLifecycle
     */
    public final TestCaseLifecycle status() {
        return TestCaseLifecycle.fromValue(status);
    }

    /**
     * <p>
     * The status of the test case.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TestCaseLifecycle#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the test case.
     * @see TestCaseLifecycle
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The status reason of the test case.
     * </p>
     * 
     * @return The status reason of the test case.
     */
    public final String statusReason() {
        return statusReason;
    }

    /**
     * <p>
     * The creation time of the test case.
     * </p>
     * 
     * @return The creation time of the test case.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The last update time of the test case.
     * </p>
     * 
     * @return The last update time of the test case.
     */
    public final Instant lastUpdateTime() {
        return lastUpdateTime;
    }

    /**
     * For responses, this returns true if the service returned a value for the Steps property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasSteps() {
        return steps != null && !(steps instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The steps of the test case.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSteps} method.
     * </p>
     * 
     * @return The steps of the test case.
     */
    public final List<Step> steps() {
        return steps;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags of the test case.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags of the test case.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(testCaseId());
        hashCode = 31 * hashCode + Objects.hashCode(testCaseArn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(latestVersion());
        hashCode = 31 * hashCode + Objects.hashCode(testCaseVersion());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdateTime());
        hashCode = 31 * hashCode + Objects.hashCode(hasSteps() ? steps() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTestCaseResponse)) {
            return false;
        }
        GetTestCaseResponse other = (GetTestCaseResponse) obj;
        return Objects.equals(testCaseId(), other.testCaseId()) && Objects.equals(testCaseArn(), other.testCaseArn())
                && Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(latestVersion(), other.latestVersion())
                && Objects.equals(testCaseVersion(), other.testCaseVersion())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusReason(), other.statusReason()) && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastUpdateTime(), other.lastUpdateTime()) && hasSteps() == other.hasSteps()
                && Objects.equals(steps(), other.steps()) && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetTestCaseResponse").add("TestCaseId", testCaseId()).add("TestCaseArn", testCaseArn())
                .add("Name", name()).add("Description", description()).add("LatestVersion", latestVersion())
                .add("TestCaseVersion", testCaseVersion()).add("Status", statusAsString()).add("StatusReason", statusReason())
                .add("CreationTime", creationTime()).add("LastUpdateTime", lastUpdateTime())
                .add("Steps", hasSteps() ? steps() : null).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "testCaseId":
            return Optional.ofNullable(clazz.cast(testCaseId()));
        case "testCaseArn":
            return Optional.ofNullable(clazz.cast(testCaseArn()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "latestVersion":
            return Optional.ofNullable(clazz.cast(latestVersion()));
        case "testCaseVersion":
            return Optional.ofNullable(clazz.cast(testCaseVersion()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "statusReason":
            return Optional.ofNullable(clazz.cast(statusReason()));
        case "creationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "lastUpdateTime":
            return Optional.ofNullable(clazz.cast(lastUpdateTime()));
        case "steps":
            return Optional.ofNullable(clazz.cast(steps()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("testCaseId", TEST_CASE_ID_FIELD);
        map.put("testCaseArn", TEST_CASE_ARN_FIELD);
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("latestVersion", LATEST_VERSION_FIELD);
        map.put("testCaseVersion", TEST_CASE_VERSION_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("statusReason", STATUS_REASON_FIELD);
        map.put("creationTime", CREATION_TIME_FIELD);
        map.put("lastUpdateTime", LAST_UPDATE_TIME_FIELD);
        map.put("steps", STEPS_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetTestCaseResponse, T> g) {
        return obj -> g.apply((GetTestCaseResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppTestResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetTestCaseResponse> {
        /**
         * <p>
         * The response test ID of the test case.
         * </p>
         * 
         * @param testCaseId
         *        The response test ID of the test case.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder testCaseId(String testCaseId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the test case.
         * </p>
         * 
         * @param testCaseArn
         *        The Amazon Resource Name (ARN) of the test case.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder testCaseArn(String testCaseArn);

        /**
         * <p>
         * The name of the test case.
         * </p>
         * 
         * @param name
         *        The name of the test case.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of the test case.
         * </p>
         * 
         * @param description
         *        The description of the test case.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The latest version of the test case.
         * </p>
         * 
         * @param latestVersion
         *        The latest version of the test case.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestVersion(TestCaseLatestVersion latestVersion);

        /**
         * <p>
         * The latest version of the test case.
         * </p>
         * This is a convenience method that creates an instance of the {@link TestCaseLatestVersion.Builder} avoiding
         * the need to create one manually via {@link TestCaseLatestVersion#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TestCaseLatestVersion.Builder#build()} is called immediately and
         * its result is passed to {@link #latestVersion(TestCaseLatestVersion)}.
         * 
         * @param latestVersion
         *        a consumer that will call methods on {@link TestCaseLatestVersion.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #latestVersion(TestCaseLatestVersion)
         */
        default Builder latestVersion(Consumer<TestCaseLatestVersion.Builder> latestVersion) {
            return latestVersion(TestCaseLatestVersion.builder().applyMutation(latestVersion).build());
        }

        /**
         * <p>
         * The case version of the test case.
         * </p>
         * 
         * @param testCaseVersion
         *        The case version of the test case.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder testCaseVersion(Integer testCaseVersion);

        /**
         * <p>
         * The status of the test case.
         * </p>
         * 
         * @param status
         *        The status of the test case.
         * @see TestCaseLifecycle
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TestCaseLifecycle
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the test case.
         * </p>
         * 
         * @param status
         *        The status of the test case.
         * @see TestCaseLifecycle
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TestCaseLifecycle
         */
        Builder status(TestCaseLifecycle status);

        /**
         * <p>
         * The status reason of the test case.
         * </p>
         * 
         * @param statusReason
         *        The status reason of the test case.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusReason(String statusReason);

        /**
         * <p>
         * The creation time of the test case.
         * </p>
         * 
         * @param creationTime
         *        The creation time of the test case.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The last update time of the test case.
         * </p>
         * 
         * @param lastUpdateTime
         *        The last update time of the test case.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdateTime(Instant lastUpdateTime);

        /**
         * <p>
         * The steps of the test case.
         * </p>
         * 
         * @param steps
         *        The steps of the test case.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder steps(Collection<Step> steps);

        /**
         * <p>
         * The steps of the test case.
         * </p>
         * 
         * @param steps
         *        The steps of the test case.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder steps(Step... steps);

        /**
         * <p>
         * The steps of the test case.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.apptest.model.Step.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.apptest.model.Step#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.apptest.model.Step.Builder#build()} is called immediately and its
         * result is passed to {@link #steps(List<Step>)}.
         * 
         * @param steps
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.apptest.model.Step.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #steps(java.util.Collection<Step>)
         */
        Builder steps(Consumer<Step.Builder>... steps);

        /**
         * <p>
         * The tags of the test case.
         * </p>
         * 
         * @param tags
         *        The tags of the test case.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl extends AppTestResponse.BuilderImpl implements Builder {
        private String testCaseId;

        private String testCaseArn;

        private String name;

        private String description;

        private TestCaseLatestVersion latestVersion;

        private Integer testCaseVersion;

        private String status;

        private String statusReason;

        private Instant creationTime;

        private Instant lastUpdateTime;

        private List<Step> steps = DefaultSdkAutoConstructList.getInstance();

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetTestCaseResponse model) {
            super(model);
            testCaseId(model.testCaseId);
            testCaseArn(model.testCaseArn);
            name(model.name);
            description(model.description);
            latestVersion(model.latestVersion);
            testCaseVersion(model.testCaseVersion);
            status(model.status);
            statusReason(model.statusReason);
            creationTime(model.creationTime);
            lastUpdateTime(model.lastUpdateTime);
            steps(model.steps);
            tags(model.tags);
        }

        public final String getTestCaseId() {
            return testCaseId;
        }

        public final void setTestCaseId(String testCaseId) {
            this.testCaseId = testCaseId;
        }

        @Override
        public final Builder testCaseId(String testCaseId) {
            this.testCaseId = testCaseId;
            return this;
        }

        public final String getTestCaseArn() {
            return testCaseArn;
        }

        public final void setTestCaseArn(String testCaseArn) {
            this.testCaseArn = testCaseArn;
        }

        @Override
        public final Builder testCaseArn(String testCaseArn) {
            this.testCaseArn = testCaseArn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final TestCaseLatestVersion.Builder getLatestVersion() {
            return latestVersion != null ? latestVersion.toBuilder() : null;
        }

        public final void setLatestVersion(TestCaseLatestVersion.BuilderImpl latestVersion) {
            this.latestVersion = latestVersion != null ? latestVersion.build() : null;
        }

        @Override
        public final Builder latestVersion(TestCaseLatestVersion latestVersion) {
            this.latestVersion = latestVersion;
            return this;
        }

        public final Integer getTestCaseVersion() {
            return testCaseVersion;
        }

        public final void setTestCaseVersion(Integer testCaseVersion) {
            this.testCaseVersion = testCaseVersion;
        }

        @Override
        public final Builder testCaseVersion(Integer testCaseVersion) {
            this.testCaseVersion = testCaseVersion;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TestCaseLifecycle status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastUpdateTime() {
            return lastUpdateTime;
        }

        public final void setLastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
        }

        @Override
        public final Builder lastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
            return this;
        }

        public final List<Step.Builder> getSteps() {
            List<Step.Builder> result = StepListCopier.copyToBuilder(this.steps);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSteps(Collection<Step.BuilderImpl> steps) {
            this.steps = StepListCopier.copyFromBuilder(steps);
        }

        @Override
        public final Builder steps(Collection<Step> steps) {
            this.steps = StepListCopier.copy(steps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder steps(Step... steps) {
            steps(Arrays.asList(steps));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder steps(Consumer<Step.Builder>... steps) {
            steps(Stream.of(steps).map(c -> Step.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public GetTestCaseResponse build() {
            return new GetTestCaseResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
