/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apptest.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies a resource action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResourceAction implements SdkPojo, Serializable, ToCopyableBuilder<ResourceAction.Builder, ResourceAction> {
    private static final SdkField<M2ManagedApplicationAction> M2_MANAGED_APPLICATION_ACTION_FIELD = SdkField
            .<M2ManagedApplicationAction> builder(MarshallingType.SDK_POJO)
            .memberName("m2ManagedApplicationAction")
            .getter(getter(ResourceAction::m2ManagedApplicationAction))
            .setter(setter(Builder::m2ManagedApplicationAction))
            .constructor(M2ManagedApplicationAction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("m2ManagedApplicationAction").build())
            .build();

    private static final SdkField<M2NonManagedApplicationAction> M2_NON_MANAGED_APPLICATION_ACTION_FIELD = SdkField
            .<M2NonManagedApplicationAction> builder(MarshallingType.SDK_POJO)
            .memberName("m2NonManagedApplicationAction")
            .getter(getter(ResourceAction::m2NonManagedApplicationAction))
            .setter(setter(Builder::m2NonManagedApplicationAction))
            .constructor(M2NonManagedApplicationAction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("m2NonManagedApplicationAction")
                    .build()).build();

    private static final SdkField<CloudFormationAction> CLOUD_FORMATION_ACTION_FIELD = SdkField
            .<CloudFormationAction> builder(MarshallingType.SDK_POJO).memberName("cloudFormationAction")
            .getter(getter(ResourceAction::cloudFormationAction)).setter(setter(Builder::cloudFormationAction))
            .constructor(CloudFormationAction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cloudFormationAction").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            M2_MANAGED_APPLICATION_ACTION_FIELD, M2_NON_MANAGED_APPLICATION_ACTION_FIELD, CLOUD_FORMATION_ACTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final M2ManagedApplicationAction m2ManagedApplicationAction;

    private final M2NonManagedApplicationAction m2NonManagedApplicationAction;

    private final CloudFormationAction cloudFormationAction;

    private final Type type;

    private ResourceAction(BuilderImpl builder) {
        this.m2ManagedApplicationAction = builder.m2ManagedApplicationAction;
        this.m2NonManagedApplicationAction = builder.m2NonManagedApplicationAction;
        this.cloudFormationAction = builder.cloudFormationAction;
        this.type = builder.type;
    }

    /**
     * <p>
     * The AWS Mainframe Modernization managed application action of the resource action.
     * </p>
     * 
     * @return The AWS Mainframe Modernization managed application action of the resource action.
     */
    public final M2ManagedApplicationAction m2ManagedApplicationAction() {
        return m2ManagedApplicationAction;
    }

    /**
     * <p>
     * The AWS Mainframe Modernization non-managed application action of the resource action.
     * </p>
     * 
     * @return The AWS Mainframe Modernization non-managed application action of the resource action.
     */
    public final M2NonManagedApplicationAction m2NonManagedApplicationAction() {
        return m2NonManagedApplicationAction;
    }

    /**
     * <p>
     * The CloudFormation action of the resource action.
     * </p>
     * 
     * @return The CloudFormation action of the resource action.
     */
    public final CloudFormationAction cloudFormationAction() {
        return cloudFormationAction;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(m2ManagedApplicationAction());
        hashCode = 31 * hashCode + Objects.hashCode(m2NonManagedApplicationAction());
        hashCode = 31 * hashCode + Objects.hashCode(cloudFormationAction());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceAction)) {
            return false;
        }
        ResourceAction other = (ResourceAction) obj;
        return Objects.equals(m2ManagedApplicationAction(), other.m2ManagedApplicationAction())
                && Objects.equals(m2NonManagedApplicationAction(), other.m2NonManagedApplicationAction())
                && Objects.equals(cloudFormationAction(), other.cloudFormationAction());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResourceAction").add("M2ManagedApplicationAction", m2ManagedApplicationAction())
                .add("M2NonManagedApplicationAction", m2NonManagedApplicationAction())
                .add("CloudFormationAction", cloudFormationAction()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "m2ManagedApplicationAction":
            return Optional.ofNullable(clazz.cast(m2ManagedApplicationAction()));
        case "m2NonManagedApplicationAction":
            return Optional.ofNullable(clazz.cast(m2NonManagedApplicationAction()));
        case "cloudFormationAction":
            return Optional.ofNullable(clazz.cast(cloudFormationAction()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #m2ManagedApplicationAction()} initialized to the given value.
     *
     * <p>
     * The AWS Mainframe Modernization managed application action of the resource action.
     * </p>
     * 
     * @param m2ManagedApplicationAction
     *        The AWS Mainframe Modernization managed application action of the resource action.
     */
    public static ResourceAction fromM2ManagedApplicationAction(M2ManagedApplicationAction m2ManagedApplicationAction) {
        return builder().m2ManagedApplicationAction(m2ManagedApplicationAction).build();
    }

    /**
     * Create an instance of this class with {@link #m2ManagedApplicationAction()} initialized to the given value.
     *
     * <p>
     * The AWS Mainframe Modernization managed application action of the resource action.
     * </p>
     * 
     * @param m2ManagedApplicationAction
     *        The AWS Mainframe Modernization managed application action of the resource action.
     */
    public static ResourceAction fromM2ManagedApplicationAction(
            Consumer<M2ManagedApplicationAction.Builder> m2ManagedApplicationAction) {
        M2ManagedApplicationAction.Builder builder = M2ManagedApplicationAction.builder();
        m2ManagedApplicationAction.accept(builder);
        return fromM2ManagedApplicationAction(builder.build());
    }

    /**
     * Create an instance of this class with {@link #m2NonManagedApplicationAction()} initialized to the given value.
     *
     * <p>
     * The AWS Mainframe Modernization non-managed application action of the resource action.
     * </p>
     * 
     * @param m2NonManagedApplicationAction
     *        The AWS Mainframe Modernization non-managed application action of the resource action.
     */
    public static ResourceAction fromM2NonManagedApplicationAction(M2NonManagedApplicationAction m2NonManagedApplicationAction) {
        return builder().m2NonManagedApplicationAction(m2NonManagedApplicationAction).build();
    }

    /**
     * Create an instance of this class with {@link #m2NonManagedApplicationAction()} initialized to the given value.
     *
     * <p>
     * The AWS Mainframe Modernization non-managed application action of the resource action.
     * </p>
     * 
     * @param m2NonManagedApplicationAction
     *        The AWS Mainframe Modernization non-managed application action of the resource action.
     */
    public static ResourceAction fromM2NonManagedApplicationAction(
            Consumer<M2NonManagedApplicationAction.Builder> m2NonManagedApplicationAction) {
        M2NonManagedApplicationAction.Builder builder = M2NonManagedApplicationAction.builder();
        m2NonManagedApplicationAction.accept(builder);
        return fromM2NonManagedApplicationAction(builder.build());
    }

    /**
     * Create an instance of this class with {@link #cloudFormationAction()} initialized to the given value.
     *
     * <p>
     * The CloudFormation action of the resource action.
     * </p>
     * 
     * @param cloudFormationAction
     *        The CloudFormation action of the resource action.
     */
    public static ResourceAction fromCloudFormationAction(CloudFormationAction cloudFormationAction) {
        return builder().cloudFormationAction(cloudFormationAction).build();
    }

    /**
     * Create an instance of this class with {@link #cloudFormationAction()} initialized to the given value.
     *
     * <p>
     * The CloudFormation action of the resource action.
     * </p>
     * 
     * @param cloudFormationAction
     *        The CloudFormation action of the resource action.
     */
    public static ResourceAction fromCloudFormationAction(Consumer<CloudFormationAction.Builder> cloudFormationAction) {
        CloudFormationAction.Builder builder = CloudFormationAction.builder();
        cloudFormationAction.accept(builder);
        return fromCloudFormationAction(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("m2ManagedApplicationAction", M2_MANAGED_APPLICATION_ACTION_FIELD);
        map.put("m2NonManagedApplicationAction", M2_NON_MANAGED_APPLICATION_ACTION_FIELD);
        map.put("cloudFormationAction", CLOUD_FORMATION_ACTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ResourceAction, T> g) {
        return obj -> g.apply((ResourceAction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResourceAction> {
        /**
         * <p>
         * The AWS Mainframe Modernization managed application action of the resource action.
         * </p>
         * 
         * @param m2ManagedApplicationAction
         *        The AWS Mainframe Modernization managed application action of the resource action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder m2ManagedApplicationAction(M2ManagedApplicationAction m2ManagedApplicationAction);

        /**
         * <p>
         * The AWS Mainframe Modernization managed application action of the resource action.
         * </p>
         * This is a convenience method that creates an instance of the {@link M2ManagedApplicationAction.Builder}
         * avoiding the need to create one manually via {@link M2ManagedApplicationAction#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link M2ManagedApplicationAction.Builder#build()} is called immediately
         * and its result is passed to {@link #m2ManagedApplicationAction(M2ManagedApplicationAction)}.
         * 
         * @param m2ManagedApplicationAction
         *        a consumer that will call methods on {@link M2ManagedApplicationAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #m2ManagedApplicationAction(M2ManagedApplicationAction)
         */
        default Builder m2ManagedApplicationAction(Consumer<M2ManagedApplicationAction.Builder> m2ManagedApplicationAction) {
            return m2ManagedApplicationAction(M2ManagedApplicationAction.builder().applyMutation(m2ManagedApplicationAction)
                    .build());
        }

        /**
         * <p>
         * The AWS Mainframe Modernization non-managed application action of the resource action.
         * </p>
         * 
         * @param m2NonManagedApplicationAction
         *        The AWS Mainframe Modernization non-managed application action of the resource action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder m2NonManagedApplicationAction(M2NonManagedApplicationAction m2NonManagedApplicationAction);

        /**
         * <p>
         * The AWS Mainframe Modernization non-managed application action of the resource action.
         * </p>
         * This is a convenience method that creates an instance of the {@link M2NonManagedApplicationAction.Builder}
         * avoiding the need to create one manually via {@link M2NonManagedApplicationAction#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link M2NonManagedApplicationAction.Builder#build()} is called
         * immediately and its result is passed to {@link #m2NonManagedApplicationAction(M2NonManagedApplicationAction)}.
         * 
         * @param m2NonManagedApplicationAction
         *        a consumer that will call methods on {@link M2NonManagedApplicationAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #m2NonManagedApplicationAction(M2NonManagedApplicationAction)
         */
        default Builder m2NonManagedApplicationAction(
                Consumer<M2NonManagedApplicationAction.Builder> m2NonManagedApplicationAction) {
            return m2NonManagedApplicationAction(M2NonManagedApplicationAction.builder()
                    .applyMutation(m2NonManagedApplicationAction).build());
        }

        /**
         * <p>
         * The CloudFormation action of the resource action.
         * </p>
         * 
         * @param cloudFormationAction
         *        The CloudFormation action of the resource action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudFormationAction(CloudFormationAction cloudFormationAction);

        /**
         * <p>
         * The CloudFormation action of the resource action.
         * </p>
         * This is a convenience method that creates an instance of the {@link CloudFormationAction.Builder} avoiding
         * the need to create one manually via {@link CloudFormationAction#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CloudFormationAction.Builder#build()} is called immediately and
         * its result is passed to {@link #cloudFormationAction(CloudFormationAction)}.
         * 
         * @param cloudFormationAction
         *        a consumer that will call methods on {@link CloudFormationAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cloudFormationAction(CloudFormationAction)
         */
        default Builder cloudFormationAction(Consumer<CloudFormationAction.Builder> cloudFormationAction) {
            return cloudFormationAction(CloudFormationAction.builder().applyMutation(cloudFormationAction).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private M2ManagedApplicationAction m2ManagedApplicationAction;

        private M2NonManagedApplicationAction m2NonManagedApplicationAction;

        private CloudFormationAction cloudFormationAction;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceAction model) {
            m2ManagedApplicationAction(model.m2ManagedApplicationAction);
            m2NonManagedApplicationAction(model.m2NonManagedApplicationAction);
            cloudFormationAction(model.cloudFormationAction);
        }

        public final M2ManagedApplicationAction.Builder getM2ManagedApplicationAction() {
            return m2ManagedApplicationAction != null ? m2ManagedApplicationAction.toBuilder() : null;
        }

        public final void setM2ManagedApplicationAction(M2ManagedApplicationAction.BuilderImpl m2ManagedApplicationAction) {
            Object oldValue = this.m2ManagedApplicationAction;
            this.m2ManagedApplicationAction = m2ManagedApplicationAction != null ? m2ManagedApplicationAction.build() : null;
            handleUnionValueChange(Type.M2_MANAGED_APPLICATION_ACTION, oldValue, this.m2ManagedApplicationAction);
        }

        @Override
        public final Builder m2ManagedApplicationAction(M2ManagedApplicationAction m2ManagedApplicationAction) {
            Object oldValue = this.m2ManagedApplicationAction;
            this.m2ManagedApplicationAction = m2ManagedApplicationAction;
            handleUnionValueChange(Type.M2_MANAGED_APPLICATION_ACTION, oldValue, this.m2ManagedApplicationAction);
            return this;
        }

        public final M2NonManagedApplicationAction.Builder getM2NonManagedApplicationAction() {
            return m2NonManagedApplicationAction != null ? m2NonManagedApplicationAction.toBuilder() : null;
        }

        public final void setM2NonManagedApplicationAction(M2NonManagedApplicationAction.BuilderImpl m2NonManagedApplicationAction) {
            Object oldValue = this.m2NonManagedApplicationAction;
            this.m2NonManagedApplicationAction = m2NonManagedApplicationAction != null ? m2NonManagedApplicationAction.build()
                    : null;
            handleUnionValueChange(Type.M2_NON_MANAGED_APPLICATION_ACTION, oldValue, this.m2NonManagedApplicationAction);
        }

        @Override
        public final Builder m2NonManagedApplicationAction(M2NonManagedApplicationAction m2NonManagedApplicationAction) {
            Object oldValue = this.m2NonManagedApplicationAction;
            this.m2NonManagedApplicationAction = m2NonManagedApplicationAction;
            handleUnionValueChange(Type.M2_NON_MANAGED_APPLICATION_ACTION, oldValue, this.m2NonManagedApplicationAction);
            return this;
        }

        public final CloudFormationAction.Builder getCloudFormationAction() {
            return cloudFormationAction != null ? cloudFormationAction.toBuilder() : null;
        }

        public final void setCloudFormationAction(CloudFormationAction.BuilderImpl cloudFormationAction) {
            Object oldValue = this.cloudFormationAction;
            this.cloudFormationAction = cloudFormationAction != null ? cloudFormationAction.build() : null;
            handleUnionValueChange(Type.CLOUD_FORMATION_ACTION, oldValue, this.cloudFormationAction);
        }

        @Override
        public final Builder cloudFormationAction(CloudFormationAction cloudFormationAction) {
            Object oldValue = this.cloudFormationAction;
            this.cloudFormationAction = cloudFormationAction;
            handleUnionValueChange(Type.CLOUD_FORMATION_ACTION, oldValue, this.cloudFormationAction);
            return this;
        }

        @Override
        public ResourceAction build() {
            return new ResourceAction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see ResourceAction#type()
     */
    public enum Type {
        M2_MANAGED_APPLICATION_ACTION,

        M2_NON_MANAGED_APPLICATION_ACTION,

        CLOUD_FORMATION_ACTION,

        UNKNOWN_TO_SDK_VERSION
    }
}
