/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apptest.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the source database metadata.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SourceDatabaseMetadata implements SdkPojo, Serializable,
        ToCopyableBuilder<SourceDatabaseMetadata.Builder, SourceDatabaseMetadata> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(SourceDatabaseMetadata::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<String> CAPTURE_TOOL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("captureTool").getter(getter(SourceDatabaseMetadata::captureToolAsString))
            .setter(setter(Builder::captureTool))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("captureTool").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(TYPE_FIELD, CAPTURE_TOOL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String type;

    private final String captureTool;

    private SourceDatabaseMetadata(BuilderImpl builder) {
        this.type = builder.type;
        this.captureTool = builder.captureTool;
    }

    /**
     * <p>
     * The type of the source database metadata.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link SourceDatabase#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the source database metadata.
     * @see SourceDatabase
     */
    public final SourceDatabase type() {
        return SourceDatabase.fromValue(type);
    }

    /**
     * <p>
     * The type of the source database metadata.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link SourceDatabase#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the source database metadata.
     * @see SourceDatabase
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The capture tool of the source database metadata.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #captureTool} will
     * return {@link CaptureTool#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #captureToolAsString}.
     * </p>
     * 
     * @return The capture tool of the source database metadata.
     * @see CaptureTool
     */
    public final CaptureTool captureTool() {
        return CaptureTool.fromValue(captureTool);
    }

    /**
     * <p>
     * The capture tool of the source database metadata.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #captureTool} will
     * return {@link CaptureTool#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #captureToolAsString}.
     * </p>
     * 
     * @return The capture tool of the source database metadata.
     * @see CaptureTool
     */
    public final String captureToolAsString() {
        return captureTool;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(captureToolAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SourceDatabaseMetadata)) {
            return false;
        }
        SourceDatabaseMetadata other = (SourceDatabaseMetadata) obj;
        return Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(captureToolAsString(), other.captureToolAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SourceDatabaseMetadata").add("Type", typeAsString()).add("CaptureTool", captureToolAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "captureTool":
            return Optional.ofNullable(clazz.cast(captureToolAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("type", TYPE_FIELD);
        map.put("captureTool", CAPTURE_TOOL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SourceDatabaseMetadata, T> g) {
        return obj -> g.apply((SourceDatabaseMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SourceDatabaseMetadata> {
        /**
         * <p>
         * The type of the source database metadata.
         * </p>
         * 
         * @param type
         *        The type of the source database metadata.
         * @see SourceDatabase
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SourceDatabase
         */
        Builder type(String type);

        /**
         * <p>
         * The type of the source database metadata.
         * </p>
         * 
         * @param type
         *        The type of the source database metadata.
         * @see SourceDatabase
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SourceDatabase
         */
        Builder type(SourceDatabase type);

        /**
         * <p>
         * The capture tool of the source database metadata.
         * </p>
         * 
         * @param captureTool
         *        The capture tool of the source database metadata.
         * @see CaptureTool
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CaptureTool
         */
        Builder captureTool(String captureTool);

        /**
         * <p>
         * The capture tool of the source database metadata.
         * </p>
         * 
         * @param captureTool
         *        The capture tool of the source database metadata.
         * @see CaptureTool
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CaptureTool
         */
        Builder captureTool(CaptureTool captureTool);
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private String captureTool;

        private BuilderImpl() {
        }

        private BuilderImpl(SourceDatabaseMetadata model) {
            type(model.type);
            captureTool(model.captureTool);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(SourceDatabase type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getCaptureTool() {
            return captureTool;
        }

        public final void setCaptureTool(String captureTool) {
            this.captureTool = captureTool;
        }

        @Override
        public final Builder captureTool(String captureTool) {
            this.captureTool = captureTool;
            return this;
        }

        @Override
        public final Builder captureTool(CaptureTool captureTool) {
            this.captureTool(captureTool == null ? null : captureTool.toString());
            return this;
        }

        @Override
        public SourceDatabaseMetadata build() {
            return new SourceDatabaseMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
