/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apptest.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies a step action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StepAction implements SdkPojo, Serializable, ToCopyableBuilder<StepAction.Builder, StepAction> {
    private static final SdkField<ResourceAction> RESOURCE_ACTION_FIELD = SdkField
            .<ResourceAction> builder(MarshallingType.SDK_POJO).memberName("resourceAction")
            .getter(getter(StepAction::resourceAction)).setter(setter(Builder::resourceAction))
            .constructor(ResourceAction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceAction").build()).build();

    private static final SdkField<MainframeAction> MAINFRAME_ACTION_FIELD = SdkField
            .<MainframeAction> builder(MarshallingType.SDK_POJO).memberName("mainframeAction")
            .getter(getter(StepAction::mainframeAction)).setter(setter(Builder::mainframeAction))
            .constructor(MainframeAction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mainframeAction").build()).build();

    private static final SdkField<CompareAction> COMPARE_ACTION_FIELD = SdkField
            .<CompareAction> builder(MarshallingType.SDK_POJO).memberName("compareAction")
            .getter(getter(StepAction::compareAction)).setter(setter(Builder::compareAction)).constructor(CompareAction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("compareAction").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ACTION_FIELD,
            MAINFRAME_ACTION_FIELD, COMPARE_ACTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ResourceAction resourceAction;

    private final MainframeAction mainframeAction;

    private final CompareAction compareAction;

    private final Type type;

    private StepAction(BuilderImpl builder) {
        this.resourceAction = builder.resourceAction;
        this.mainframeAction = builder.mainframeAction;
        this.compareAction = builder.compareAction;
        this.type = builder.type;
    }

    /**
     * <p>
     * The resource action of the step action.
     * </p>
     * 
     * @return The resource action of the step action.
     */
    public final ResourceAction resourceAction() {
        return resourceAction;
    }

    /**
     * <p>
     * The mainframe action of the step action.
     * </p>
     * 
     * @return The mainframe action of the step action.
     */
    public final MainframeAction mainframeAction() {
        return mainframeAction;
    }

    /**
     * <p>
     * The compare action of the step action.
     * </p>
     * 
     * @return The compare action of the step action.
     */
    public final CompareAction compareAction() {
        return compareAction;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resourceAction());
        hashCode = 31 * hashCode + Objects.hashCode(mainframeAction());
        hashCode = 31 * hashCode + Objects.hashCode(compareAction());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StepAction)) {
            return false;
        }
        StepAction other = (StepAction) obj;
        return Objects.equals(resourceAction(), other.resourceAction())
                && Objects.equals(mainframeAction(), other.mainframeAction())
                && Objects.equals(compareAction(), other.compareAction());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StepAction").add("ResourceAction", resourceAction()).add("MainframeAction", mainframeAction())
                .add("CompareAction", compareAction()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "resourceAction":
            return Optional.ofNullable(clazz.cast(resourceAction()));
        case "mainframeAction":
            return Optional.ofNullable(clazz.cast(mainframeAction()));
        case "compareAction":
            return Optional.ofNullable(clazz.cast(compareAction()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #resourceAction()} initialized to the given value.
     *
     * <p>
     * The resource action of the step action.
     * </p>
     * 
     * @param resourceAction
     *        The resource action of the step action.
     */
    public static StepAction fromResourceAction(ResourceAction resourceAction) {
        return builder().resourceAction(resourceAction).build();
    }

    /**
     * Create an instance of this class with {@link #resourceAction()} initialized to the given value.
     *
     * <p>
     * The resource action of the step action.
     * </p>
     * 
     * @param resourceAction
     *        The resource action of the step action.
     */
    public static StepAction fromResourceAction(Consumer<ResourceAction.Builder> resourceAction) {
        ResourceAction.Builder builder = ResourceAction.builder();
        resourceAction.accept(builder);
        return fromResourceAction(builder.build());
    }

    /**
     * Create an instance of this class with {@link #mainframeAction()} initialized to the given value.
     *
     * <p>
     * The mainframe action of the step action.
     * </p>
     * 
     * @param mainframeAction
     *        The mainframe action of the step action.
     */
    public static StepAction fromMainframeAction(MainframeAction mainframeAction) {
        return builder().mainframeAction(mainframeAction).build();
    }

    /**
     * Create an instance of this class with {@link #mainframeAction()} initialized to the given value.
     *
     * <p>
     * The mainframe action of the step action.
     * </p>
     * 
     * @param mainframeAction
     *        The mainframe action of the step action.
     */
    public static StepAction fromMainframeAction(Consumer<MainframeAction.Builder> mainframeAction) {
        MainframeAction.Builder builder = MainframeAction.builder();
        mainframeAction.accept(builder);
        return fromMainframeAction(builder.build());
    }

    /**
     * Create an instance of this class with {@link #compareAction()} initialized to the given value.
     *
     * <p>
     * The compare action of the step action.
     * </p>
     * 
     * @param compareAction
     *        The compare action of the step action.
     */
    public static StepAction fromCompareAction(CompareAction compareAction) {
        return builder().compareAction(compareAction).build();
    }

    /**
     * Create an instance of this class with {@link #compareAction()} initialized to the given value.
     *
     * <p>
     * The compare action of the step action.
     * </p>
     * 
     * @param compareAction
     *        The compare action of the step action.
     */
    public static StepAction fromCompareAction(Consumer<CompareAction.Builder> compareAction) {
        CompareAction.Builder builder = CompareAction.builder();
        compareAction.accept(builder);
        return fromCompareAction(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("resourceAction", RESOURCE_ACTION_FIELD);
        map.put("mainframeAction", MAINFRAME_ACTION_FIELD);
        map.put("compareAction", COMPARE_ACTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StepAction, T> g) {
        return obj -> g.apply((StepAction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StepAction> {
        /**
         * <p>
         * The resource action of the step action.
         * </p>
         * 
         * @param resourceAction
         *        The resource action of the step action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceAction(ResourceAction resourceAction);

        /**
         * <p>
         * The resource action of the step action.
         * </p>
         * This is a convenience method that creates an instance of the {@link ResourceAction.Builder} avoiding the need
         * to create one manually via {@link ResourceAction#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResourceAction.Builder#build()} is called immediately and its
         * result is passed to {@link #resourceAction(ResourceAction)}.
         * 
         * @param resourceAction
         *        a consumer that will call methods on {@link ResourceAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceAction(ResourceAction)
         */
        default Builder resourceAction(Consumer<ResourceAction.Builder> resourceAction) {
            return resourceAction(ResourceAction.builder().applyMutation(resourceAction).build());
        }

        /**
         * <p>
         * The mainframe action of the step action.
         * </p>
         * 
         * @param mainframeAction
         *        The mainframe action of the step action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mainframeAction(MainframeAction mainframeAction);

        /**
         * <p>
         * The mainframe action of the step action.
         * </p>
         * This is a convenience method that creates an instance of the {@link MainframeAction.Builder} avoiding the
         * need to create one manually via {@link MainframeAction#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MainframeAction.Builder#build()} is called immediately and its
         * result is passed to {@link #mainframeAction(MainframeAction)}.
         * 
         * @param mainframeAction
         *        a consumer that will call methods on {@link MainframeAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mainframeAction(MainframeAction)
         */
        default Builder mainframeAction(Consumer<MainframeAction.Builder> mainframeAction) {
            return mainframeAction(MainframeAction.builder().applyMutation(mainframeAction).build());
        }

        /**
         * <p>
         * The compare action of the step action.
         * </p>
         * 
         * @param compareAction
         *        The compare action of the step action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder compareAction(CompareAction compareAction);

        /**
         * <p>
         * The compare action of the step action.
         * </p>
         * This is a convenience method that creates an instance of the {@link CompareAction.Builder} avoiding the need
         * to create one manually via {@link CompareAction#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CompareAction.Builder#build()} is called immediately and its
         * result is passed to {@link #compareAction(CompareAction)}.
         * 
         * @param compareAction
         *        a consumer that will call methods on {@link CompareAction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #compareAction(CompareAction)
         */
        default Builder compareAction(Consumer<CompareAction.Builder> compareAction) {
            return compareAction(CompareAction.builder().applyMutation(compareAction).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ResourceAction resourceAction;

        private MainframeAction mainframeAction;

        private CompareAction compareAction;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(StepAction model) {
            resourceAction(model.resourceAction);
            mainframeAction(model.mainframeAction);
            compareAction(model.compareAction);
        }

        public final ResourceAction.Builder getResourceAction() {
            return resourceAction != null ? resourceAction.toBuilder() : null;
        }

        public final void setResourceAction(ResourceAction.BuilderImpl resourceAction) {
            Object oldValue = this.resourceAction;
            this.resourceAction = resourceAction != null ? resourceAction.build() : null;
            handleUnionValueChange(Type.RESOURCE_ACTION, oldValue, this.resourceAction);
        }

        @Override
        public final Builder resourceAction(ResourceAction resourceAction) {
            Object oldValue = this.resourceAction;
            this.resourceAction = resourceAction;
            handleUnionValueChange(Type.RESOURCE_ACTION, oldValue, this.resourceAction);
            return this;
        }

        public final MainframeAction.Builder getMainframeAction() {
            return mainframeAction != null ? mainframeAction.toBuilder() : null;
        }

        public final void setMainframeAction(MainframeAction.BuilderImpl mainframeAction) {
            Object oldValue = this.mainframeAction;
            this.mainframeAction = mainframeAction != null ? mainframeAction.build() : null;
            handleUnionValueChange(Type.MAINFRAME_ACTION, oldValue, this.mainframeAction);
        }

        @Override
        public final Builder mainframeAction(MainframeAction mainframeAction) {
            Object oldValue = this.mainframeAction;
            this.mainframeAction = mainframeAction;
            handleUnionValueChange(Type.MAINFRAME_ACTION, oldValue, this.mainframeAction);
            return this;
        }

        public final CompareAction.Builder getCompareAction() {
            return compareAction != null ? compareAction.toBuilder() : null;
        }

        public final void setCompareAction(CompareAction.BuilderImpl compareAction) {
            Object oldValue = this.compareAction;
            this.compareAction = compareAction != null ? compareAction.build() : null;
            handleUnionValueChange(Type.COMPARE_ACTION, oldValue, this.compareAction);
        }

        @Override
        public final Builder compareAction(CompareAction compareAction) {
            Object oldValue = this.compareAction;
            this.compareAction = compareAction;
            handleUnionValueChange(Type.COMPARE_ACTION, oldValue, this.compareAction);
            return this;
        }

        @Override
        public StepAction build() {
            return new StepAction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see StepAction#type()
     */
    public enum Type {
        RESOURCE_ACTION,

        MAINFRAME_ACTION,

        COMPARE_ACTION,

        UNKNOWN_TO_SDK_VERSION
    }
}
