/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apptest.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the test case run summary.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TestCaseRunSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<TestCaseRunSummary.Builder, TestCaseRunSummary> {
    private static final SdkField<String> TEST_CASE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("testCaseId").getter(getter(TestCaseRunSummary::testCaseId)).setter(setter(Builder::testCaseId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testCaseId").build()).build();

    private static final SdkField<Integer> TEST_CASE_VERSION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("testCaseVersion").getter(getter(TestCaseRunSummary::testCaseVersion))
            .setter(setter(Builder::testCaseVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testCaseVersion").build()).build();

    private static final SdkField<String> TEST_RUN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("testRunId").getter(getter(TestCaseRunSummary::testRunId)).setter(setter(Builder::testRunId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testRunId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(TestCaseRunSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("statusReason").getter(getter(TestCaseRunSummary::statusReason)).setter(setter(Builder::statusReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReason").build()).build();

    private static final SdkField<Instant> RUN_START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("runStartTime").getter(getter(TestCaseRunSummary::runStartTime)).setter(setter(Builder::runStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runStartTime").build()).build();

    private static final SdkField<Instant> RUN_END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("runEndTime").getter(getter(TestCaseRunSummary::runEndTime)).setter(setter(Builder::runEndTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runEndTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEST_CASE_ID_FIELD,
            TEST_CASE_VERSION_FIELD, TEST_RUN_ID_FIELD, STATUS_FIELD, STATUS_REASON_FIELD, RUN_START_TIME_FIELD,
            RUN_END_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String testCaseId;

    private final Integer testCaseVersion;

    private final String testRunId;

    private final String status;

    private final String statusReason;

    private final Instant runStartTime;

    private final Instant runEndTime;

    private TestCaseRunSummary(BuilderImpl builder) {
        this.testCaseId = builder.testCaseId;
        this.testCaseVersion = builder.testCaseVersion;
        this.testRunId = builder.testRunId;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.runStartTime = builder.runStartTime;
        this.runEndTime = builder.runEndTime;
    }

    /**
     * <p>
     * The test case id of the test case run summary.
     * </p>
     * 
     * @return The test case id of the test case run summary.
     */
    public final String testCaseId() {
        return testCaseId;
    }

    /**
     * <p>
     * The test case version of the test case run summary.
     * </p>
     * 
     * @return The test case version of the test case run summary.
     */
    public final Integer testCaseVersion() {
        return testCaseVersion;
    }

    /**
     * <p>
     * The test run id of the test case run summary.
     * </p>
     * 
     * @return The test run id of the test case run summary.
     */
    public final String testRunId() {
        return testRunId;
    }

    /**
     * <p>
     * The status of the test case run summary.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TestCaseRunStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the test case run summary.
     * @see TestCaseRunStatus
     */
    public final TestCaseRunStatus status() {
        return TestCaseRunStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the test case run summary.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TestCaseRunStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the test case run summary.
     * @see TestCaseRunStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The status reason of the test case run summary.
     * </p>
     * 
     * @return The status reason of the test case run summary.
     */
    public final String statusReason() {
        return statusReason;
    }

    /**
     * <p>
     * The run start time of the test case run summary.
     * </p>
     * 
     * @return The run start time of the test case run summary.
     */
    public final Instant runStartTime() {
        return runStartTime;
    }

    /**
     * <p>
     * The run end time of the test case run summary.
     * </p>
     * 
     * @return The run end time of the test case run summary.
     */
    public final Instant runEndTime() {
        return runEndTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(testCaseId());
        hashCode = 31 * hashCode + Objects.hashCode(testCaseVersion());
        hashCode = 31 * hashCode + Objects.hashCode(testRunId());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(runStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(runEndTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestCaseRunSummary)) {
            return false;
        }
        TestCaseRunSummary other = (TestCaseRunSummary) obj;
        return Objects.equals(testCaseId(), other.testCaseId()) && Objects.equals(testCaseVersion(), other.testCaseVersion())
                && Objects.equals(testRunId(), other.testRunId()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusReason(), other.statusReason()) && Objects.equals(runStartTime(), other.runStartTime())
                && Objects.equals(runEndTime(), other.runEndTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TestCaseRunSummary").add("TestCaseId", testCaseId()).add("TestCaseVersion", testCaseVersion())
                .add("TestRunId", testRunId()).add("Status", statusAsString()).add("StatusReason", statusReason())
                .add("RunStartTime", runStartTime()).add("RunEndTime", runEndTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "testCaseId":
            return Optional.ofNullable(clazz.cast(testCaseId()));
        case "testCaseVersion":
            return Optional.ofNullable(clazz.cast(testCaseVersion()));
        case "testRunId":
            return Optional.ofNullable(clazz.cast(testRunId()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "statusReason":
            return Optional.ofNullable(clazz.cast(statusReason()));
        case "runStartTime":
            return Optional.ofNullable(clazz.cast(runStartTime()));
        case "runEndTime":
            return Optional.ofNullable(clazz.cast(runEndTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("testCaseId", TEST_CASE_ID_FIELD);
        map.put("testCaseVersion", TEST_CASE_VERSION_FIELD);
        map.put("testRunId", TEST_RUN_ID_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("statusReason", STATUS_REASON_FIELD);
        map.put("runStartTime", RUN_START_TIME_FIELD);
        map.put("runEndTime", RUN_END_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TestCaseRunSummary, T> g) {
        return obj -> g.apply((TestCaseRunSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TestCaseRunSummary> {
        /**
         * <p>
         * The test case id of the test case run summary.
         * </p>
         * 
         * @param testCaseId
         *        The test case id of the test case run summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder testCaseId(String testCaseId);

        /**
         * <p>
         * The test case version of the test case run summary.
         * </p>
         * 
         * @param testCaseVersion
         *        The test case version of the test case run summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder testCaseVersion(Integer testCaseVersion);

        /**
         * <p>
         * The test run id of the test case run summary.
         * </p>
         * 
         * @param testRunId
         *        The test run id of the test case run summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder testRunId(String testRunId);

        /**
         * <p>
         * The status of the test case run summary.
         * </p>
         * 
         * @param status
         *        The status of the test case run summary.
         * @see TestCaseRunStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TestCaseRunStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the test case run summary.
         * </p>
         * 
         * @param status
         *        The status of the test case run summary.
         * @see TestCaseRunStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TestCaseRunStatus
         */
        Builder status(TestCaseRunStatus status);

        /**
         * <p>
         * The status reason of the test case run summary.
         * </p>
         * 
         * @param statusReason
         *        The status reason of the test case run summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusReason(String statusReason);

        /**
         * <p>
         * The run start time of the test case run summary.
         * </p>
         * 
         * @param runStartTime
         *        The run start time of the test case run summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runStartTime(Instant runStartTime);

        /**
         * <p>
         * The run end time of the test case run summary.
         * </p>
         * 
         * @param runEndTime
         *        The run end time of the test case run summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runEndTime(Instant runEndTime);
    }

    static final class BuilderImpl implements Builder {
        private String testCaseId;

        private Integer testCaseVersion;

        private String testRunId;

        private String status;

        private String statusReason;

        private Instant runStartTime;

        private Instant runEndTime;

        private BuilderImpl() {
        }

        private BuilderImpl(TestCaseRunSummary model) {
            testCaseId(model.testCaseId);
            testCaseVersion(model.testCaseVersion);
            testRunId(model.testRunId);
            status(model.status);
            statusReason(model.statusReason);
            runStartTime(model.runStartTime);
            runEndTime(model.runEndTime);
        }

        public final String getTestCaseId() {
            return testCaseId;
        }

        public final void setTestCaseId(String testCaseId) {
            this.testCaseId = testCaseId;
        }

        @Override
        public final Builder testCaseId(String testCaseId) {
            this.testCaseId = testCaseId;
            return this;
        }

        public final Integer getTestCaseVersion() {
            return testCaseVersion;
        }

        public final void setTestCaseVersion(Integer testCaseVersion) {
            this.testCaseVersion = testCaseVersion;
        }

        @Override
        public final Builder testCaseVersion(Integer testCaseVersion) {
            this.testCaseVersion = testCaseVersion;
            return this;
        }

        public final String getTestRunId() {
            return testRunId;
        }

        public final void setTestRunId(String testRunId) {
            this.testRunId = testRunId;
        }

        @Override
        public final Builder testRunId(String testRunId) {
            this.testRunId = testRunId;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TestCaseRunStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final Instant getRunStartTime() {
            return runStartTime;
        }

        public final void setRunStartTime(Instant runStartTime) {
            this.runStartTime = runStartTime;
        }

        @Override
        public final Builder runStartTime(Instant runStartTime) {
            this.runStartTime = runStartTime;
            return this;
        }

        public final Instant getRunEndTime() {
            return runEndTime;
        }

        public final void setRunEndTime(Instant runEndTime) {
            this.runEndTime = runEndTime;
        }

        @Override
        public final Builder runEndTime(Instant runEndTime) {
            this.runEndTime = runEndTime;
            return this;
        }

        @Override
        public TestCaseRunSummary build() {
            return new TestCaseRunSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
