/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apptest.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies a test case summary.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TestCaseSummary implements SdkPojo, Serializable, ToCopyableBuilder<TestCaseSummary.Builder, TestCaseSummary> {
    private static final SdkField<String> TEST_CASE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("testCaseId").getter(getter(TestCaseSummary::testCaseId)).setter(setter(Builder::testCaseId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testCaseId").build()).build();

    private static final SdkField<String> TEST_CASE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("testCaseArn").getter(getter(TestCaseSummary::testCaseArn)).setter(setter(Builder::testCaseArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testCaseArn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(TestCaseSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("statusReason").getter(getter(TestCaseSummary::statusReason)).setter(setter(Builder::statusReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReason").build()).build();

    private static final SdkField<Integer> LATEST_VERSION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("latestVersion").getter(getter(TestCaseSummary::latestVersion)).setter(setter(Builder::latestVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("latestVersion").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(TestCaseSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationTime").getter(getter(TestCaseSummary::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()).build();

    private static final SdkField<Instant> LAST_UPDATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdateTime").getter(getter(TestCaseSummary::lastUpdateTime)).setter(setter(Builder::lastUpdateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdateTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEST_CASE_ID_FIELD,
            TEST_CASE_ARN_FIELD, NAME_FIELD, STATUS_REASON_FIELD, LATEST_VERSION_FIELD, STATUS_FIELD, CREATION_TIME_FIELD,
            LAST_UPDATE_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String testCaseId;

    private final String testCaseArn;

    private final String name;

    private final String statusReason;

    private final Integer latestVersion;

    private final String status;

    private final Instant creationTime;

    private final Instant lastUpdateTime;

    private TestCaseSummary(BuilderImpl builder) {
        this.testCaseId = builder.testCaseId;
        this.testCaseArn = builder.testCaseArn;
        this.name = builder.name;
        this.statusReason = builder.statusReason;
        this.latestVersion = builder.latestVersion;
        this.status = builder.status;
        this.creationTime = builder.creationTime;
        this.lastUpdateTime = builder.lastUpdateTime;
    }

    /**
     * <p>
     * The test case ID of the test case summary.
     * </p>
     * 
     * @return The test case ID of the test case summary.
     */
    public final String testCaseId() {
        return testCaseId;
    }

    /**
     * <p>
     * The test case Amazon Resource Name (ARN) of the test case summary.
     * </p>
     * 
     * @return The test case Amazon Resource Name (ARN) of the test case summary.
     */
    public final String testCaseArn() {
        return testCaseArn;
    }

    /**
     * <p>
     * The name of the test case summary.
     * </p>
     * 
     * @return The name of the test case summary.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The status reason of the test case summary.
     * </p>
     * 
     * @return The status reason of the test case summary.
     */
    public final String statusReason() {
        return statusReason;
    }

    /**
     * <p>
     * The latest version of the test case summary.
     * </p>
     * 
     * @return The latest version of the test case summary.
     */
    public final Integer latestVersion() {
        return latestVersion;
    }

    /**
     * <p>
     * The status of the test case summary.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TestCaseLifecycle#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the test case summary.
     * @see TestCaseLifecycle
     */
    public final TestCaseLifecycle status() {
        return TestCaseLifecycle.fromValue(status);
    }

    /**
     * <p>
     * The status of the test case summary.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TestCaseLifecycle#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the test case summary.
     * @see TestCaseLifecycle
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The creation time of the test case summary.
     * </p>
     * 
     * @return The creation time of the test case summary.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The last update time of the test case summary.
     * </p>
     * 
     * @return The last update time of the test case summary.
     */
    public final Instant lastUpdateTime() {
        return lastUpdateTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(testCaseId());
        hashCode = 31 * hashCode + Objects.hashCode(testCaseArn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(latestVersion());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdateTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestCaseSummary)) {
            return false;
        }
        TestCaseSummary other = (TestCaseSummary) obj;
        return Objects.equals(testCaseId(), other.testCaseId()) && Objects.equals(testCaseArn(), other.testCaseArn())
                && Objects.equals(name(), other.name()) && Objects.equals(statusReason(), other.statusReason())
                && Objects.equals(latestVersion(), other.latestVersion())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastUpdateTime(), other.lastUpdateTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TestCaseSummary").add("TestCaseId", testCaseId()).add("TestCaseArn", testCaseArn())
                .add("Name", name()).add("StatusReason", statusReason()).add("LatestVersion", latestVersion())
                .add("Status", statusAsString()).add("CreationTime", creationTime()).add("LastUpdateTime", lastUpdateTime())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "testCaseId":
            return Optional.ofNullable(clazz.cast(testCaseId()));
        case "testCaseArn":
            return Optional.ofNullable(clazz.cast(testCaseArn()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "statusReason":
            return Optional.ofNullable(clazz.cast(statusReason()));
        case "latestVersion":
            return Optional.ofNullable(clazz.cast(latestVersion()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "creationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "lastUpdateTime":
            return Optional.ofNullable(clazz.cast(lastUpdateTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("testCaseId", TEST_CASE_ID_FIELD);
        map.put("testCaseArn", TEST_CASE_ARN_FIELD);
        map.put("name", NAME_FIELD);
        map.put("statusReason", STATUS_REASON_FIELD);
        map.put("latestVersion", LATEST_VERSION_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("creationTime", CREATION_TIME_FIELD);
        map.put("lastUpdateTime", LAST_UPDATE_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TestCaseSummary, T> g) {
        return obj -> g.apply((TestCaseSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TestCaseSummary> {
        /**
         * <p>
         * The test case ID of the test case summary.
         * </p>
         * 
         * @param testCaseId
         *        The test case ID of the test case summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder testCaseId(String testCaseId);

        /**
         * <p>
         * The test case Amazon Resource Name (ARN) of the test case summary.
         * </p>
         * 
         * @param testCaseArn
         *        The test case Amazon Resource Name (ARN) of the test case summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder testCaseArn(String testCaseArn);

        /**
         * <p>
         * The name of the test case summary.
         * </p>
         * 
         * @param name
         *        The name of the test case summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The status reason of the test case summary.
         * </p>
         * 
         * @param statusReason
         *        The status reason of the test case summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusReason(String statusReason);

        /**
         * <p>
         * The latest version of the test case summary.
         * </p>
         * 
         * @param latestVersion
         *        The latest version of the test case summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestVersion(Integer latestVersion);

        /**
         * <p>
         * The status of the test case summary.
         * </p>
         * 
         * @param status
         *        The status of the test case summary.
         * @see TestCaseLifecycle
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TestCaseLifecycle
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the test case summary.
         * </p>
         * 
         * @param status
         *        The status of the test case summary.
         * @see TestCaseLifecycle
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TestCaseLifecycle
         */
        Builder status(TestCaseLifecycle status);

        /**
         * <p>
         * The creation time of the test case summary.
         * </p>
         * 
         * @param creationTime
         *        The creation time of the test case summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The last update time of the test case summary.
         * </p>
         * 
         * @param lastUpdateTime
         *        The last update time of the test case summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdateTime(Instant lastUpdateTime);
    }

    static final class BuilderImpl implements Builder {
        private String testCaseId;

        private String testCaseArn;

        private String name;

        private String statusReason;

        private Integer latestVersion;

        private String status;

        private Instant creationTime;

        private Instant lastUpdateTime;

        private BuilderImpl() {
        }

        private BuilderImpl(TestCaseSummary model) {
            testCaseId(model.testCaseId);
            testCaseArn(model.testCaseArn);
            name(model.name);
            statusReason(model.statusReason);
            latestVersion(model.latestVersion);
            status(model.status);
            creationTime(model.creationTime);
            lastUpdateTime(model.lastUpdateTime);
        }

        public final String getTestCaseId() {
            return testCaseId;
        }

        public final void setTestCaseId(String testCaseId) {
            this.testCaseId = testCaseId;
        }

        @Override
        public final Builder testCaseId(String testCaseId) {
            this.testCaseId = testCaseId;
            return this;
        }

        public final String getTestCaseArn() {
            return testCaseArn;
        }

        public final void setTestCaseArn(String testCaseArn) {
            this.testCaseArn = testCaseArn;
        }

        @Override
        public final Builder testCaseArn(String testCaseArn) {
            this.testCaseArn = testCaseArn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getStatusReason() {
            return statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final Integer getLatestVersion() {
            return latestVersion;
        }

        public final void setLatestVersion(Integer latestVersion) {
            this.latestVersion = latestVersion;
        }

        @Override
        public final Builder latestVersion(Integer latestVersion) {
            this.latestVersion = latestVersion;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TestCaseLifecycle status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastUpdateTime() {
            return lastUpdateTime;
        }

        public final void setLastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
        }

        @Override
        public final Builder lastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
            return this;
        }

        @Override
        public TestCaseSummary build() {
            return new TestCaseSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
