/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apptest.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines a batch step input.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchStepInput implements SdkPojo, Serializable, ToCopyableBuilder<BatchStepInput.Builder, BatchStepInput> {
    private static final SdkField<MainframeResourceSummary> RESOURCE_FIELD = SdkField
            .<MainframeResourceSummary> builder(MarshallingType.SDK_POJO).memberName("resource")
            .getter(getter(BatchStepInput::resource)).setter(setter(Builder::resource))
            .constructor(MainframeResourceSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resource").build()).build();

    private static final SdkField<String> BATCH_JOB_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("batchJobName").getter(getter(BatchStepInput::batchJobName)).setter(setter(Builder::batchJobName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("batchJobName").build()).build();

    private static final SdkField<Map<String, String>> BATCH_JOB_PARAMETERS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("batchJobParameters")
            .getter(getter(BatchStepInput::batchJobParameters))
            .setter(setter(Builder::batchJobParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("batchJobParameters").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<List<String>> EXPORT_DATA_SET_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("exportDataSetNames")
            .getter(getter(BatchStepInput::exportDataSetNames))
            .setter(setter(Builder::exportDataSetNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exportDataSetNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<MainframeActionProperties> PROPERTIES_FIELD = SdkField
            .<MainframeActionProperties> builder(MarshallingType.SDK_POJO).memberName("properties")
            .getter(getter(BatchStepInput::properties)).setter(setter(Builder::properties))
            .constructor(MainframeActionProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("properties").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_FIELD,
            BATCH_JOB_NAME_FIELD, BATCH_JOB_PARAMETERS_FIELD, EXPORT_DATA_SET_NAMES_FIELD, PROPERTIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final MainframeResourceSummary resource;

    private final String batchJobName;

    private final Map<String, String> batchJobParameters;

    private final List<String> exportDataSetNames;

    private final MainframeActionProperties properties;

    private BatchStepInput(BuilderImpl builder) {
        this.resource = builder.resource;
        this.batchJobName = builder.batchJobName;
        this.batchJobParameters = builder.batchJobParameters;
        this.exportDataSetNames = builder.exportDataSetNames;
        this.properties = builder.properties;
    }

    /**
     * <p>
     * The resource of the batch step input.
     * </p>
     * 
     * @return The resource of the batch step input.
     */
    public final MainframeResourceSummary resource() {
        return resource;
    }

    /**
     * <p>
     * The batch job name of the batch step input.
     * </p>
     * 
     * @return The batch job name of the batch step input.
     */
    public final String batchJobName() {
        return batchJobName;
    }

    /**
     * For responses, this returns true if the service returned a value for the BatchJobParameters property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasBatchJobParameters() {
        return batchJobParameters != null && !(batchJobParameters instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The batch job parameters of the batch step input.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBatchJobParameters} method.
     * </p>
     * 
     * @return The batch job parameters of the batch step input.
     */
    public final Map<String, String> batchJobParameters() {
        return batchJobParameters;
    }

    /**
     * For responses, this returns true if the service returned a value for the ExportDataSetNames property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasExportDataSetNames() {
        return exportDataSetNames != null && !(exportDataSetNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The export data set names of the batch step input.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasExportDataSetNames} method.
     * </p>
     * 
     * @return The export data set names of the batch step input.
     */
    public final List<String> exportDataSetNames() {
        return exportDataSetNames;
    }

    /**
     * <p>
     * The properties of the batch step input.
     * </p>
     * 
     * @return The properties of the batch step input.
     */
    public final MainframeActionProperties properties() {
        return properties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resource());
        hashCode = 31 * hashCode + Objects.hashCode(batchJobName());
        hashCode = 31 * hashCode + Objects.hashCode(hasBatchJobParameters() ? batchJobParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasExportDataSetNames() ? exportDataSetNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(properties());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchStepInput)) {
            return false;
        }
        BatchStepInput other = (BatchStepInput) obj;
        return Objects.equals(resource(), other.resource()) && Objects.equals(batchJobName(), other.batchJobName())
                && hasBatchJobParameters() == other.hasBatchJobParameters()
                && Objects.equals(batchJobParameters(), other.batchJobParameters())
                && hasExportDataSetNames() == other.hasExportDataSetNames()
                && Objects.equals(exportDataSetNames(), other.exportDataSetNames())
                && Objects.equals(properties(), other.properties());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchStepInput").add("Resource", resource()).add("BatchJobName", batchJobName())
                .add("BatchJobParameters", hasBatchJobParameters() ? batchJobParameters() : null)
                .add("ExportDataSetNames", hasExportDataSetNames() ? exportDataSetNames() : null).add("Properties", properties())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "resource":
            return Optional.ofNullable(clazz.cast(resource()));
        case "batchJobName":
            return Optional.ofNullable(clazz.cast(batchJobName()));
        case "batchJobParameters":
            return Optional.ofNullable(clazz.cast(batchJobParameters()));
        case "exportDataSetNames":
            return Optional.ofNullable(clazz.cast(exportDataSetNames()));
        case "properties":
            return Optional.ofNullable(clazz.cast(properties()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("resource", RESOURCE_FIELD);
        map.put("batchJobName", BATCH_JOB_NAME_FIELD);
        map.put("batchJobParameters", BATCH_JOB_PARAMETERS_FIELD);
        map.put("exportDataSetNames", EXPORT_DATA_SET_NAMES_FIELD);
        map.put("properties", PROPERTIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchStepInput, T> g) {
        return obj -> g.apply((BatchStepInput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BatchStepInput> {
        /**
         * <p>
         * The resource of the batch step input.
         * </p>
         * 
         * @param resource
         *        The resource of the batch step input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resource(MainframeResourceSummary resource);

        /**
         * <p>
         * The resource of the batch step input.
         * </p>
         * This is a convenience method that creates an instance of the {@link MainframeResourceSummary.Builder}
         * avoiding the need to create one manually via {@link MainframeResourceSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MainframeResourceSummary.Builder#build()} is called immediately
         * and its result is passed to {@link #resource(MainframeResourceSummary)}.
         * 
         * @param resource
         *        a consumer that will call methods on {@link MainframeResourceSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resource(MainframeResourceSummary)
         */
        default Builder resource(Consumer<MainframeResourceSummary.Builder> resource) {
            return resource(MainframeResourceSummary.builder().applyMutation(resource).build());
        }

        /**
         * <p>
         * The batch job name of the batch step input.
         * </p>
         * 
         * @param batchJobName
         *        The batch job name of the batch step input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder batchJobName(String batchJobName);

        /**
         * <p>
         * The batch job parameters of the batch step input.
         * </p>
         * 
         * @param batchJobParameters
         *        The batch job parameters of the batch step input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder batchJobParameters(Map<String, String> batchJobParameters);

        /**
         * <p>
         * The export data set names of the batch step input.
         * </p>
         * 
         * @param exportDataSetNames
         *        The export data set names of the batch step input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportDataSetNames(Collection<String> exportDataSetNames);

        /**
         * <p>
         * The export data set names of the batch step input.
         * </p>
         * 
         * @param exportDataSetNames
         *        The export data set names of the batch step input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportDataSetNames(String... exportDataSetNames);

        /**
         * <p>
         * The properties of the batch step input.
         * </p>
         * 
         * @param properties
         *        The properties of the batch step input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder properties(MainframeActionProperties properties);

        /**
         * <p>
         * The properties of the batch step input.
         * </p>
         * This is a convenience method that creates an instance of the {@link MainframeActionProperties.Builder}
         * avoiding the need to create one manually via {@link MainframeActionProperties#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MainframeActionProperties.Builder#build()} is called immediately
         * and its result is passed to {@link #properties(MainframeActionProperties)}.
         * 
         * @param properties
         *        a consumer that will call methods on {@link MainframeActionProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #properties(MainframeActionProperties)
         */
        default Builder properties(Consumer<MainframeActionProperties.Builder> properties) {
            return properties(MainframeActionProperties.builder().applyMutation(properties).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private MainframeResourceSummary resource;

        private String batchJobName;

        private Map<String, String> batchJobParameters = DefaultSdkAutoConstructMap.getInstance();

        private List<String> exportDataSetNames = DefaultSdkAutoConstructList.getInstance();

        private MainframeActionProperties properties;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchStepInput model) {
            resource(model.resource);
            batchJobName(model.batchJobName);
            batchJobParameters(model.batchJobParameters);
            exportDataSetNames(model.exportDataSetNames);
            properties(model.properties);
        }

        public final MainframeResourceSummary.Builder getResource() {
            return resource != null ? resource.toBuilder() : null;
        }

        public final void setResource(MainframeResourceSummary.BuilderImpl resource) {
            this.resource = resource != null ? resource.build() : null;
        }

        @Override
        public final Builder resource(MainframeResourceSummary resource) {
            this.resource = resource;
            return this;
        }

        public final String getBatchJobName() {
            return batchJobName;
        }

        public final void setBatchJobName(String batchJobName) {
            this.batchJobName = batchJobName;
        }

        @Override
        public final Builder batchJobName(String batchJobName) {
            this.batchJobName = batchJobName;
            return this;
        }

        public final Map<String, String> getBatchJobParameters() {
            if (batchJobParameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return batchJobParameters;
        }

        public final void setBatchJobParameters(Map<String, String> batchJobParameters) {
            this.batchJobParameters = BatchJobParametersCopier.copy(batchJobParameters);
        }

        @Override
        public final Builder batchJobParameters(Map<String, String> batchJobParameters) {
            this.batchJobParameters = BatchJobParametersCopier.copy(batchJobParameters);
            return this;
        }

        public final Collection<String> getExportDataSetNames() {
            if (exportDataSetNames instanceof SdkAutoConstructList) {
                return null;
            }
            return exportDataSetNames;
        }

        public final void setExportDataSetNames(Collection<String> exportDataSetNames) {
            this.exportDataSetNames = ExportDataSetNamesCopier.copy(exportDataSetNames);
        }

        @Override
        public final Builder exportDataSetNames(Collection<String> exportDataSetNames) {
            this.exportDataSetNames = ExportDataSetNamesCopier.copy(exportDataSetNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exportDataSetNames(String... exportDataSetNames) {
            exportDataSetNames(Arrays.asList(exportDataSetNames));
            return this;
        }

        public final MainframeActionProperties.Builder getProperties() {
            return properties != null ? properties.toBuilder() : null;
        }

        public final void setProperties(MainframeActionProperties.BuilderImpl properties) {
            this.properties = properties != null ? properties.build() : null;
        }

        @Override
        public final Builder properties(MainframeActionProperties properties) {
            this.properties = properties;
            return this;
        }

        @Override
        public BatchStepInput build() {
            return new BatchStepInput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
