/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apptest.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the CloudFormation step summary.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CloudFormationStepSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<CloudFormationStepSummary.Builder, CloudFormationStepSummary> {
    private static final SdkField<CreateCloudFormationSummary> CREATE_CLOUDFORMATION_FIELD = SdkField
            .<CreateCloudFormationSummary> builder(MarshallingType.SDK_POJO).memberName("createCloudformation")
            .getter(getter(CloudFormationStepSummary::createCloudformation)).setter(setter(Builder::createCloudformation))
            .constructor(CreateCloudFormationSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createCloudformation").build())
            .build();

    private static final SdkField<DeleteCloudFormationSummary> DELETE_CLOUDFORMATION_FIELD = SdkField
            .<DeleteCloudFormationSummary> builder(MarshallingType.SDK_POJO).memberName("deleteCloudformation")
            .getter(getter(CloudFormationStepSummary::deleteCloudformation)).setter(setter(Builder::deleteCloudformation))
            .constructor(DeleteCloudFormationSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deleteCloudformation").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATE_CLOUDFORMATION_FIELD,
            DELETE_CLOUDFORMATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final CreateCloudFormationSummary createCloudformation;

    private final DeleteCloudFormationSummary deleteCloudformation;

    private final Type type;

    private CloudFormationStepSummary(BuilderImpl builder) {
        this.createCloudformation = builder.createCloudformation;
        this.deleteCloudformation = builder.deleteCloudformation;
        this.type = builder.type;
    }

    /**
     * <p>
     * Creates the CloudFormation summary of the step.
     * </p>
     * 
     * @return Creates the CloudFormation summary of the step.
     */
    public final CreateCloudFormationSummary createCloudformation() {
        return createCloudformation;
    }

    /**
     * <p>
     * Deletes the CloudFormation summary of the CloudFormation step summary.
     * </p>
     * 
     * @return Deletes the CloudFormation summary of the CloudFormation step summary.
     */
    public final DeleteCloudFormationSummary deleteCloudformation() {
        return deleteCloudformation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(createCloudformation());
        hashCode = 31 * hashCode + Objects.hashCode(deleteCloudformation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CloudFormationStepSummary)) {
            return false;
        }
        CloudFormationStepSummary other = (CloudFormationStepSummary) obj;
        return Objects.equals(createCloudformation(), other.createCloudformation())
                && Objects.equals(deleteCloudformation(), other.deleteCloudformation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CloudFormationStepSummary").add("CreateCloudformation", createCloudformation())
                .add("DeleteCloudformation", deleteCloudformation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "createCloudformation":
            return Optional.ofNullable(clazz.cast(createCloudformation()));
        case "deleteCloudformation":
            return Optional.ofNullable(clazz.cast(deleteCloudformation()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #createCloudformation()} initialized to the given value.
     *
     * <p>
     * Creates the CloudFormation summary of the step.
     * </p>
     * 
     * @param createCloudformation
     *        Creates the CloudFormation summary of the step.
     */
    public static CloudFormationStepSummary fromCreateCloudformation(CreateCloudFormationSummary createCloudformation) {
        return builder().createCloudformation(createCloudformation).build();
    }

    /**
     * Create an instance of this class with {@link #createCloudformation()} initialized to the given value.
     *
     * <p>
     * Creates the CloudFormation summary of the step.
     * </p>
     * 
     * @param createCloudformation
     *        Creates the CloudFormation summary of the step.
     */
    public static CloudFormationStepSummary fromCreateCloudformation(
            Consumer<CreateCloudFormationSummary.Builder> createCloudformation) {
        CreateCloudFormationSummary.Builder builder = CreateCloudFormationSummary.builder();
        createCloudformation.accept(builder);
        return fromCreateCloudformation(builder.build());
    }

    /**
     * Create an instance of this class with {@link #deleteCloudformation()} initialized to the given value.
     *
     * <p>
     * Deletes the CloudFormation summary of the CloudFormation step summary.
     * </p>
     * 
     * @param deleteCloudformation
     *        Deletes the CloudFormation summary of the CloudFormation step summary.
     */
    public static CloudFormationStepSummary fromDeleteCloudformation(DeleteCloudFormationSummary deleteCloudformation) {
        return builder().deleteCloudformation(deleteCloudformation).build();
    }

    /**
     * Create an instance of this class with {@link #deleteCloudformation()} initialized to the given value.
     *
     * <p>
     * Deletes the CloudFormation summary of the CloudFormation step summary.
     * </p>
     * 
     * @param deleteCloudformation
     *        Deletes the CloudFormation summary of the CloudFormation step summary.
     */
    public static CloudFormationStepSummary fromDeleteCloudformation(
            Consumer<DeleteCloudFormationSummary.Builder> deleteCloudformation) {
        DeleteCloudFormationSummary.Builder builder = DeleteCloudFormationSummary.builder();
        deleteCloudformation.accept(builder);
        return fromDeleteCloudformation(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("createCloudformation", CREATE_CLOUDFORMATION_FIELD);
        map.put("deleteCloudformation", DELETE_CLOUDFORMATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CloudFormationStepSummary, T> g) {
        return obj -> g.apply((CloudFormationStepSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CloudFormationStepSummary> {
        /**
         * <p>
         * Creates the CloudFormation summary of the step.
         * </p>
         * 
         * @param createCloudformation
         *        Creates the CloudFormation summary of the step.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createCloudformation(CreateCloudFormationSummary createCloudformation);

        /**
         * <p>
         * Creates the CloudFormation summary of the step.
         * </p>
         * This is a convenience method that creates an instance of the {@link CreateCloudFormationSummary.Builder}
         * avoiding the need to create one manually via {@link CreateCloudFormationSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CreateCloudFormationSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #createCloudformation(CreateCloudFormationSummary)}.
         * 
         * @param createCloudformation
         *        a consumer that will call methods on {@link CreateCloudFormationSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #createCloudformation(CreateCloudFormationSummary)
         */
        default Builder createCloudformation(Consumer<CreateCloudFormationSummary.Builder> createCloudformation) {
            return createCloudformation(CreateCloudFormationSummary.builder().applyMutation(createCloudformation).build());
        }

        /**
         * <p>
         * Deletes the CloudFormation summary of the CloudFormation step summary.
         * </p>
         * 
         * @param deleteCloudformation
         *        Deletes the CloudFormation summary of the CloudFormation step summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deleteCloudformation(DeleteCloudFormationSummary deleteCloudformation);

        /**
         * <p>
         * Deletes the CloudFormation summary of the CloudFormation step summary.
         * </p>
         * This is a convenience method that creates an instance of the {@link DeleteCloudFormationSummary.Builder}
         * avoiding the need to create one manually via {@link DeleteCloudFormationSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DeleteCloudFormationSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #deleteCloudformation(DeleteCloudFormationSummary)}.
         * 
         * @param deleteCloudformation
         *        a consumer that will call methods on {@link DeleteCloudFormationSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deleteCloudformation(DeleteCloudFormationSummary)
         */
        default Builder deleteCloudformation(Consumer<DeleteCloudFormationSummary.Builder> deleteCloudformation) {
            return deleteCloudformation(DeleteCloudFormationSummary.builder().applyMutation(deleteCloudformation).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private CreateCloudFormationSummary createCloudformation;

        private DeleteCloudFormationSummary deleteCloudformation;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(CloudFormationStepSummary model) {
            createCloudformation(model.createCloudformation);
            deleteCloudformation(model.deleteCloudformation);
        }

        public final CreateCloudFormationSummary.Builder getCreateCloudformation() {
            return createCloudformation != null ? createCloudformation.toBuilder() : null;
        }

        public final void setCreateCloudformation(CreateCloudFormationSummary.BuilderImpl createCloudformation) {
            Object oldValue = this.createCloudformation;
            this.createCloudformation = createCloudformation != null ? createCloudformation.build() : null;
            handleUnionValueChange(Type.CREATE_CLOUDFORMATION, oldValue, this.createCloudformation);
        }

        @Override
        public final Builder createCloudformation(CreateCloudFormationSummary createCloudformation) {
            Object oldValue = this.createCloudformation;
            this.createCloudformation = createCloudformation;
            handleUnionValueChange(Type.CREATE_CLOUDFORMATION, oldValue, this.createCloudformation);
            return this;
        }

        public final DeleteCloudFormationSummary.Builder getDeleteCloudformation() {
            return deleteCloudformation != null ? deleteCloudformation.toBuilder() : null;
        }

        public final void setDeleteCloudformation(DeleteCloudFormationSummary.BuilderImpl deleteCloudformation) {
            Object oldValue = this.deleteCloudformation;
            this.deleteCloudformation = deleteCloudformation != null ? deleteCloudformation.build() : null;
            handleUnionValueChange(Type.DELETE_CLOUDFORMATION, oldValue, this.deleteCloudformation);
        }

        @Override
        public final Builder deleteCloudformation(DeleteCloudFormationSummary deleteCloudformation) {
            Object oldValue = this.deleteCloudformation;
            this.deleteCloudformation = deleteCloudformation;
            handleUnionValueChange(Type.DELETE_CLOUDFORMATION, oldValue, this.deleteCloudformation);
            return this;
        }

        @Override
        public CloudFormationStepSummary build() {
            return new CloudFormationStepSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see CloudFormationStepSummary#type()
     */
    public enum Type {
        CREATE_CLOUDFORMATION,

        DELETE_CLOUDFORMATION,

        UNKNOWN_TO_SDK_VERSION
    }
}
