/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apptest.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the compare data sets step output.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CompareDataSetsStepOutput implements SdkPojo, Serializable,
        ToCopyableBuilder<CompareDataSetsStepOutput.Builder, CompareDataSetsStepOutput> {
    private static final SdkField<String> COMPARISON_OUTPUT_LOCATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("comparisonOutputLocation").getter(getter(CompareDataSetsStepOutput::comparisonOutputLocation))
            .setter(setter(Builder::comparisonOutputLocation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("comparisonOutputLocation").build())
            .build();

    private static final SdkField<String> COMPARISON_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("comparisonStatus").getter(getter(CompareDataSetsStepOutput::comparisonStatusAsString))
            .setter(setter(Builder::comparisonStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("comparisonStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            COMPARISON_OUTPUT_LOCATION_FIELD, COMPARISON_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String comparisonOutputLocation;

    private final String comparisonStatus;

    private CompareDataSetsStepOutput(BuilderImpl builder) {
        this.comparisonOutputLocation = builder.comparisonOutputLocation;
        this.comparisonStatus = builder.comparisonStatus;
    }

    /**
     * <p>
     * The comparison output location of the compare data sets step output.
     * </p>
     * 
     * @return The comparison output location of the compare data sets step output.
     */
    public final String comparisonOutputLocation() {
        return comparisonOutputLocation;
    }

    /**
     * <p>
     * The comparison status of the compare data sets step output.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #comparisonStatus}
     * will return {@link ComparisonStatusEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #comparisonStatusAsString}.
     * </p>
     * 
     * @return The comparison status of the compare data sets step output.
     * @see ComparisonStatusEnum
     */
    public final ComparisonStatusEnum comparisonStatus() {
        return ComparisonStatusEnum.fromValue(comparisonStatus);
    }

    /**
     * <p>
     * The comparison status of the compare data sets step output.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #comparisonStatus}
     * will return {@link ComparisonStatusEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #comparisonStatusAsString}.
     * </p>
     * 
     * @return The comparison status of the compare data sets step output.
     * @see ComparisonStatusEnum
     */
    public final String comparisonStatusAsString() {
        return comparisonStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(comparisonOutputLocation());
        hashCode = 31 * hashCode + Objects.hashCode(comparisonStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CompareDataSetsStepOutput)) {
            return false;
        }
        CompareDataSetsStepOutput other = (CompareDataSetsStepOutput) obj;
        return Objects.equals(comparisonOutputLocation(), other.comparisonOutputLocation())
                && Objects.equals(comparisonStatusAsString(), other.comparisonStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CompareDataSetsStepOutput").add("ComparisonOutputLocation", comparisonOutputLocation())
                .add("ComparisonStatus", comparisonStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "comparisonOutputLocation":
            return Optional.ofNullable(clazz.cast(comparisonOutputLocation()));
        case "comparisonStatus":
            return Optional.ofNullable(clazz.cast(comparisonStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("comparisonOutputLocation", COMPARISON_OUTPUT_LOCATION_FIELD);
        map.put("comparisonStatus", COMPARISON_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CompareDataSetsStepOutput, T> g) {
        return obj -> g.apply((CompareDataSetsStepOutput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CompareDataSetsStepOutput> {
        /**
         * <p>
         * The comparison output location of the compare data sets step output.
         * </p>
         * 
         * @param comparisonOutputLocation
         *        The comparison output location of the compare data sets step output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder comparisonOutputLocation(String comparisonOutputLocation);

        /**
         * <p>
         * The comparison status of the compare data sets step output.
         * </p>
         * 
         * @param comparisonStatus
         *        The comparison status of the compare data sets step output.
         * @see ComparisonStatusEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComparisonStatusEnum
         */
        Builder comparisonStatus(String comparisonStatus);

        /**
         * <p>
         * The comparison status of the compare data sets step output.
         * </p>
         * 
         * @param comparisonStatus
         *        The comparison status of the compare data sets step output.
         * @see ComparisonStatusEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ComparisonStatusEnum
         */
        Builder comparisonStatus(ComparisonStatusEnum comparisonStatus);
    }

    static final class BuilderImpl implements Builder {
        private String comparisonOutputLocation;

        private String comparisonStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(CompareDataSetsStepOutput model) {
            comparisonOutputLocation(model.comparisonOutputLocation);
            comparisonStatus(model.comparisonStatus);
        }

        public final String getComparisonOutputLocation() {
            return comparisonOutputLocation;
        }

        public final void setComparisonOutputLocation(String comparisonOutputLocation) {
            this.comparisonOutputLocation = comparisonOutputLocation;
        }

        @Override
        public final Builder comparisonOutputLocation(String comparisonOutputLocation) {
            this.comparisonOutputLocation = comparisonOutputLocation;
            return this;
        }

        public final String getComparisonStatus() {
            return comparisonStatus;
        }

        public final void setComparisonStatus(String comparisonStatus) {
            this.comparisonStatus = comparisonStatus;
        }

        @Override
        public final Builder comparisonStatus(String comparisonStatus) {
            this.comparisonStatus = comparisonStatus;
            return this;
        }

        @Override
        public final Builder comparisonStatus(ComparisonStatusEnum comparisonStatus) {
            this.comparisonStatus(comparisonStatus == null ? null : comparisonStatus.toString());
            return this;
        }

        @Override
        public CompareDataSetsStepOutput build() {
            return new CompareDataSetsStepOutput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
