/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apptest.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Compares data sets summary.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CompareDataSetsSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<CompareDataSetsSummary.Builder, CompareDataSetsSummary> {
    private static final SdkField<CompareDataSetsStepInput> STEP_INPUT_FIELD = SdkField
            .<CompareDataSetsStepInput> builder(MarshallingType.SDK_POJO).memberName("stepInput")
            .getter(getter(CompareDataSetsSummary::stepInput)).setter(setter(Builder::stepInput))
            .constructor(CompareDataSetsStepInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stepInput").build()).build();

    private static final SdkField<CompareDataSetsStepOutput> STEP_OUTPUT_FIELD = SdkField
            .<CompareDataSetsStepOutput> builder(MarshallingType.SDK_POJO).memberName("stepOutput")
            .getter(getter(CompareDataSetsSummary::stepOutput)).setter(setter(Builder::stepOutput))
            .constructor(CompareDataSetsStepOutput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stepOutput").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STEP_INPUT_FIELD,
            STEP_OUTPUT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final CompareDataSetsStepInput stepInput;

    private final CompareDataSetsStepOutput stepOutput;

    private CompareDataSetsSummary(BuilderImpl builder) {
        this.stepInput = builder.stepInput;
        this.stepOutput = builder.stepOutput;
    }

    /**
     * <p>
     * The step input of the compare data sets summary.
     * </p>
     * 
     * @return The step input of the compare data sets summary.
     */
    public final CompareDataSetsStepInput stepInput() {
        return stepInput;
    }

    /**
     * <p>
     * The step output of the compare data sets summary.
     * </p>
     * 
     * @return The step output of the compare data sets summary.
     */
    public final CompareDataSetsStepOutput stepOutput() {
        return stepOutput;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stepInput());
        hashCode = 31 * hashCode + Objects.hashCode(stepOutput());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CompareDataSetsSummary)) {
            return false;
        }
        CompareDataSetsSummary other = (CompareDataSetsSummary) obj;
        return Objects.equals(stepInput(), other.stepInput()) && Objects.equals(stepOutput(), other.stepOutput());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CompareDataSetsSummary").add("StepInput", stepInput()).add("StepOutput", stepOutput()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "stepInput":
            return Optional.ofNullable(clazz.cast(stepInput()));
        case "stepOutput":
            return Optional.ofNullable(clazz.cast(stepOutput()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("stepInput", STEP_INPUT_FIELD);
        map.put("stepOutput", STEP_OUTPUT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CompareDataSetsSummary, T> g) {
        return obj -> g.apply((CompareDataSetsSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CompareDataSetsSummary> {
        /**
         * <p>
         * The step input of the compare data sets summary.
         * </p>
         * 
         * @param stepInput
         *        The step input of the compare data sets summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stepInput(CompareDataSetsStepInput stepInput);

        /**
         * <p>
         * The step input of the compare data sets summary.
         * </p>
         * This is a convenience method that creates an instance of the {@link CompareDataSetsStepInput.Builder}
         * avoiding the need to create one manually via {@link CompareDataSetsStepInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CompareDataSetsStepInput.Builder#build()} is called immediately
         * and its result is passed to {@link #stepInput(CompareDataSetsStepInput)}.
         * 
         * @param stepInput
         *        a consumer that will call methods on {@link CompareDataSetsStepInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stepInput(CompareDataSetsStepInput)
         */
        default Builder stepInput(Consumer<CompareDataSetsStepInput.Builder> stepInput) {
            return stepInput(CompareDataSetsStepInput.builder().applyMutation(stepInput).build());
        }

        /**
         * <p>
         * The step output of the compare data sets summary.
         * </p>
         * 
         * @param stepOutput
         *        The step output of the compare data sets summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stepOutput(CompareDataSetsStepOutput stepOutput);

        /**
         * <p>
         * The step output of the compare data sets summary.
         * </p>
         * This is a convenience method that creates an instance of the {@link CompareDataSetsStepOutput.Builder}
         * avoiding the need to create one manually via {@link CompareDataSetsStepOutput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CompareDataSetsStepOutput.Builder#build()} is called immediately
         * and its result is passed to {@link #stepOutput(CompareDataSetsStepOutput)}.
         * 
         * @param stepOutput
         *        a consumer that will call methods on {@link CompareDataSetsStepOutput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stepOutput(CompareDataSetsStepOutput)
         */
        default Builder stepOutput(Consumer<CompareDataSetsStepOutput.Builder> stepOutput) {
            return stepOutput(CompareDataSetsStepOutput.builder().applyMutation(stepOutput).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private CompareDataSetsStepInput stepInput;

        private CompareDataSetsStepOutput stepOutput;

        private BuilderImpl() {
        }

        private BuilderImpl(CompareDataSetsSummary model) {
            stepInput(model.stepInput);
            stepOutput(model.stepOutput);
        }

        public final CompareDataSetsStepInput.Builder getStepInput() {
            return stepInput != null ? stepInput.toBuilder() : null;
        }

        public final void setStepInput(CompareDataSetsStepInput.BuilderImpl stepInput) {
            this.stepInput = stepInput != null ? stepInput.build() : null;
        }

        @Override
        public final Builder stepInput(CompareDataSetsStepInput stepInput) {
            this.stepInput = stepInput;
            return this;
        }

        public final CompareDataSetsStepOutput.Builder getStepOutput() {
            return stepOutput != null ? stepOutput.toBuilder() : null;
        }

        public final void setStepOutput(CompareDataSetsStepOutput.BuilderImpl stepOutput) {
            this.stepOutput = stepOutput != null ? stepOutput.build() : null;
        }

        @Override
        public final Builder stepOutput(CompareDataSetsStepOutput stepOutput) {
            this.stepOutput = stepOutput;
            return this;
        }

        @Override
        public CompareDataSetsSummary build() {
            return new CompareDataSetsSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
