/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apptest.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Compares the database Change Data Capture (CDC) step input.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CompareDatabaseCDCStepInput implements SdkPojo, Serializable,
        ToCopyableBuilder<CompareDatabaseCDCStepInput.Builder, CompareDatabaseCDCStepInput> {
    private static final SdkField<String> SOURCE_LOCATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourceLocation").getter(getter(CompareDatabaseCDCStepInput::sourceLocation))
            .setter(setter(Builder::sourceLocation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceLocation").build()).build();

    private static final SdkField<String> TARGET_LOCATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("targetLocation").getter(getter(CompareDatabaseCDCStepInput::targetLocation))
            .setter(setter(Builder::targetLocation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetLocation").build()).build();

    private static final SdkField<String> OUTPUT_LOCATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("outputLocation").getter(getter(CompareDatabaseCDCStepInput::outputLocation))
            .setter(setter(Builder::outputLocation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputLocation").build()).build();

    private static final SdkField<SourceDatabaseMetadata> SOURCE_METADATA_FIELD = SdkField
            .<SourceDatabaseMetadata> builder(MarshallingType.SDK_POJO).memberName("sourceMetadata")
            .getter(getter(CompareDatabaseCDCStepInput::sourceMetadata)).setter(setter(Builder::sourceMetadata))
            .constructor(SourceDatabaseMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceMetadata").build()).build();

    private static final SdkField<TargetDatabaseMetadata> TARGET_METADATA_FIELD = SdkField
            .<TargetDatabaseMetadata> builder(MarshallingType.SDK_POJO).memberName("targetMetadata")
            .getter(getter(CompareDatabaseCDCStepInput::targetMetadata)).setter(setter(Builder::targetMetadata))
            .constructor(TargetDatabaseMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetMetadata").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_LOCATION_FIELD,
            TARGET_LOCATION_FIELD, OUTPUT_LOCATION_FIELD, SOURCE_METADATA_FIELD, TARGET_METADATA_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String sourceLocation;

    private final String targetLocation;

    private final String outputLocation;

    private final SourceDatabaseMetadata sourceMetadata;

    private final TargetDatabaseMetadata targetMetadata;

    private CompareDatabaseCDCStepInput(BuilderImpl builder) {
        this.sourceLocation = builder.sourceLocation;
        this.targetLocation = builder.targetLocation;
        this.outputLocation = builder.outputLocation;
        this.sourceMetadata = builder.sourceMetadata;
        this.targetMetadata = builder.targetMetadata;
    }

    /**
     * <p>
     * The source location of the compare database CDC step input.
     * </p>
     * 
     * @return The source location of the compare database CDC step input.
     */
    public final String sourceLocation() {
        return sourceLocation;
    }

    /**
     * <p>
     * The target location of the compare database CDC step input.
     * </p>
     * 
     * @return The target location of the compare database CDC step input.
     */
    public final String targetLocation() {
        return targetLocation;
    }

    /**
     * <p>
     * The output location of the compare database CDC step input.
     * </p>
     * 
     * @return The output location of the compare database CDC step input.
     */
    public final String outputLocation() {
        return outputLocation;
    }

    /**
     * <p>
     * The source metadata of the compare database CDC step input.
     * </p>
     * 
     * @return The source metadata of the compare database CDC step input.
     */
    public final SourceDatabaseMetadata sourceMetadata() {
        return sourceMetadata;
    }

    /**
     * <p>
     * The target metadata location of the compare database CDC step input.
     * </p>
     * 
     * @return The target metadata location of the compare database CDC step input.
     */
    public final TargetDatabaseMetadata targetMetadata() {
        return targetMetadata;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sourceLocation());
        hashCode = 31 * hashCode + Objects.hashCode(targetLocation());
        hashCode = 31 * hashCode + Objects.hashCode(outputLocation());
        hashCode = 31 * hashCode + Objects.hashCode(sourceMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(targetMetadata());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CompareDatabaseCDCStepInput)) {
            return false;
        }
        CompareDatabaseCDCStepInput other = (CompareDatabaseCDCStepInput) obj;
        return Objects.equals(sourceLocation(), other.sourceLocation())
                && Objects.equals(targetLocation(), other.targetLocation())
                && Objects.equals(outputLocation(), other.outputLocation())
                && Objects.equals(sourceMetadata(), other.sourceMetadata())
                && Objects.equals(targetMetadata(), other.targetMetadata());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CompareDatabaseCDCStepInput").add("SourceLocation", sourceLocation())
                .add("TargetLocation", targetLocation()).add("OutputLocation", outputLocation())
                .add("SourceMetadata", sourceMetadata()).add("TargetMetadata", targetMetadata()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "sourceLocation":
            return Optional.ofNullable(clazz.cast(sourceLocation()));
        case "targetLocation":
            return Optional.ofNullable(clazz.cast(targetLocation()));
        case "outputLocation":
            return Optional.ofNullable(clazz.cast(outputLocation()));
        case "sourceMetadata":
            return Optional.ofNullable(clazz.cast(sourceMetadata()));
        case "targetMetadata":
            return Optional.ofNullable(clazz.cast(targetMetadata()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("sourceLocation", SOURCE_LOCATION_FIELD);
        map.put("targetLocation", TARGET_LOCATION_FIELD);
        map.put("outputLocation", OUTPUT_LOCATION_FIELD);
        map.put("sourceMetadata", SOURCE_METADATA_FIELD);
        map.put("targetMetadata", TARGET_METADATA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CompareDatabaseCDCStepInput, T> g) {
        return obj -> g.apply((CompareDatabaseCDCStepInput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CompareDatabaseCDCStepInput> {
        /**
         * <p>
         * The source location of the compare database CDC step input.
         * </p>
         * 
         * @param sourceLocation
         *        The source location of the compare database CDC step input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceLocation(String sourceLocation);

        /**
         * <p>
         * The target location of the compare database CDC step input.
         * </p>
         * 
         * @param targetLocation
         *        The target location of the compare database CDC step input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetLocation(String targetLocation);

        /**
         * <p>
         * The output location of the compare database CDC step input.
         * </p>
         * 
         * @param outputLocation
         *        The output location of the compare database CDC step input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputLocation(String outputLocation);

        /**
         * <p>
         * The source metadata of the compare database CDC step input.
         * </p>
         * 
         * @param sourceMetadata
         *        The source metadata of the compare database CDC step input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceMetadata(SourceDatabaseMetadata sourceMetadata);

        /**
         * <p>
         * The source metadata of the compare database CDC step input.
         * </p>
         * This is a convenience method that creates an instance of the {@link SourceDatabaseMetadata.Builder} avoiding
         * the need to create one manually via {@link SourceDatabaseMetadata#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SourceDatabaseMetadata.Builder#build()} is called immediately and
         * its result is passed to {@link #sourceMetadata(SourceDatabaseMetadata)}.
         * 
         * @param sourceMetadata
         *        a consumer that will call methods on {@link SourceDatabaseMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceMetadata(SourceDatabaseMetadata)
         */
        default Builder sourceMetadata(Consumer<SourceDatabaseMetadata.Builder> sourceMetadata) {
            return sourceMetadata(SourceDatabaseMetadata.builder().applyMutation(sourceMetadata).build());
        }

        /**
         * <p>
         * The target metadata location of the compare database CDC step input.
         * </p>
         * 
         * @param targetMetadata
         *        The target metadata location of the compare database CDC step input.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetMetadata(TargetDatabaseMetadata targetMetadata);

        /**
         * <p>
         * The target metadata location of the compare database CDC step input.
         * </p>
         * This is a convenience method that creates an instance of the {@link TargetDatabaseMetadata.Builder} avoiding
         * the need to create one manually via {@link TargetDatabaseMetadata#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TargetDatabaseMetadata.Builder#build()} is called immediately and
         * its result is passed to {@link #targetMetadata(TargetDatabaseMetadata)}.
         * 
         * @param targetMetadata
         *        a consumer that will call methods on {@link TargetDatabaseMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targetMetadata(TargetDatabaseMetadata)
         */
        default Builder targetMetadata(Consumer<TargetDatabaseMetadata.Builder> targetMetadata) {
            return targetMetadata(TargetDatabaseMetadata.builder().applyMutation(targetMetadata).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String sourceLocation;

        private String targetLocation;

        private String outputLocation;

        private SourceDatabaseMetadata sourceMetadata;

        private TargetDatabaseMetadata targetMetadata;

        private BuilderImpl() {
        }

        private BuilderImpl(CompareDatabaseCDCStepInput model) {
            sourceLocation(model.sourceLocation);
            targetLocation(model.targetLocation);
            outputLocation(model.outputLocation);
            sourceMetadata(model.sourceMetadata);
            targetMetadata(model.targetMetadata);
        }

        public final String getSourceLocation() {
            return sourceLocation;
        }

        public final void setSourceLocation(String sourceLocation) {
            this.sourceLocation = sourceLocation;
        }

        @Override
        public final Builder sourceLocation(String sourceLocation) {
            this.sourceLocation = sourceLocation;
            return this;
        }

        public final String getTargetLocation() {
            return targetLocation;
        }

        public final void setTargetLocation(String targetLocation) {
            this.targetLocation = targetLocation;
        }

        @Override
        public final Builder targetLocation(String targetLocation) {
            this.targetLocation = targetLocation;
            return this;
        }

        public final String getOutputLocation() {
            return outputLocation;
        }

        public final void setOutputLocation(String outputLocation) {
            this.outputLocation = outputLocation;
        }

        @Override
        public final Builder outputLocation(String outputLocation) {
            this.outputLocation = outputLocation;
            return this;
        }

        public final SourceDatabaseMetadata.Builder getSourceMetadata() {
            return sourceMetadata != null ? sourceMetadata.toBuilder() : null;
        }

        public final void setSourceMetadata(SourceDatabaseMetadata.BuilderImpl sourceMetadata) {
            this.sourceMetadata = sourceMetadata != null ? sourceMetadata.build() : null;
        }

        @Override
        public final Builder sourceMetadata(SourceDatabaseMetadata sourceMetadata) {
            this.sourceMetadata = sourceMetadata;
            return this;
        }

        public final TargetDatabaseMetadata.Builder getTargetMetadata() {
            return targetMetadata != null ? targetMetadata.toBuilder() : null;
        }

        public final void setTargetMetadata(TargetDatabaseMetadata.BuilderImpl targetMetadata) {
            this.targetMetadata = targetMetadata != null ? targetMetadata.build() : null;
        }

        @Override
        public final Builder targetMetadata(TargetDatabaseMetadata targetMetadata) {
            this.targetMetadata = targetMetadata;
            return this;
        }

        @Override
        public CompareDatabaseCDCStepInput build() {
            return new CompareDatabaseCDCStepInput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
