/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apptest.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Compares the database CDC summary.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CompareDatabaseCDCSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<CompareDatabaseCDCSummary.Builder, CompareDatabaseCDCSummary> {
    private static final SdkField<CompareDatabaseCDCStepInput> STEP_INPUT_FIELD = SdkField
            .<CompareDatabaseCDCStepInput> builder(MarshallingType.SDK_POJO).memberName("stepInput")
            .getter(getter(CompareDatabaseCDCSummary::stepInput)).setter(setter(Builder::stepInput))
            .constructor(CompareDatabaseCDCStepInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stepInput").build()).build();

    private static final SdkField<CompareDatabaseCDCStepOutput> STEP_OUTPUT_FIELD = SdkField
            .<CompareDatabaseCDCStepOutput> builder(MarshallingType.SDK_POJO).memberName("stepOutput")
            .getter(getter(CompareDatabaseCDCSummary::stepOutput)).setter(setter(Builder::stepOutput))
            .constructor(CompareDatabaseCDCStepOutput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stepOutput").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STEP_INPUT_FIELD,
            STEP_OUTPUT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final CompareDatabaseCDCStepInput stepInput;

    private final CompareDatabaseCDCStepOutput stepOutput;

    private CompareDatabaseCDCSummary(BuilderImpl builder) {
        this.stepInput = builder.stepInput;
        this.stepOutput = builder.stepOutput;
    }

    /**
     * <p>
     * The step input of the compare database CDC summary.
     * </p>
     * 
     * @return The step input of the compare database CDC summary.
     */
    public final CompareDatabaseCDCStepInput stepInput() {
        return stepInput;
    }

    /**
     * <p>
     * The step output of the compare database CDC summary.
     * </p>
     * 
     * @return The step output of the compare database CDC summary.
     */
    public final CompareDatabaseCDCStepOutput stepOutput() {
        return stepOutput;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stepInput());
        hashCode = 31 * hashCode + Objects.hashCode(stepOutput());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CompareDatabaseCDCSummary)) {
            return false;
        }
        CompareDatabaseCDCSummary other = (CompareDatabaseCDCSummary) obj;
        return Objects.equals(stepInput(), other.stepInput()) && Objects.equals(stepOutput(), other.stepOutput());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CompareDatabaseCDCSummary").add("StepInput", stepInput()).add("StepOutput", stepOutput())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "stepInput":
            return Optional.ofNullable(clazz.cast(stepInput()));
        case "stepOutput":
            return Optional.ofNullable(clazz.cast(stepOutput()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("stepInput", STEP_INPUT_FIELD);
        map.put("stepOutput", STEP_OUTPUT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CompareDatabaseCDCSummary, T> g) {
        return obj -> g.apply((CompareDatabaseCDCSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CompareDatabaseCDCSummary> {
        /**
         * <p>
         * The step input of the compare database CDC summary.
         * </p>
         * 
         * @param stepInput
         *        The step input of the compare database CDC summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stepInput(CompareDatabaseCDCStepInput stepInput);

        /**
         * <p>
         * The step input of the compare database CDC summary.
         * </p>
         * This is a convenience method that creates an instance of the {@link CompareDatabaseCDCStepInput.Builder}
         * avoiding the need to create one manually via {@link CompareDatabaseCDCStepInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CompareDatabaseCDCStepInput.Builder#build()} is called
         * immediately and its result is passed to {@link #stepInput(CompareDatabaseCDCStepInput)}.
         * 
         * @param stepInput
         *        a consumer that will call methods on {@link CompareDatabaseCDCStepInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stepInput(CompareDatabaseCDCStepInput)
         */
        default Builder stepInput(Consumer<CompareDatabaseCDCStepInput.Builder> stepInput) {
            return stepInput(CompareDatabaseCDCStepInput.builder().applyMutation(stepInput).build());
        }

        /**
         * <p>
         * The step output of the compare database CDC summary.
         * </p>
         * 
         * @param stepOutput
         *        The step output of the compare database CDC summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stepOutput(CompareDatabaseCDCStepOutput stepOutput);

        /**
         * <p>
         * The step output of the compare database CDC summary.
         * </p>
         * This is a convenience method that creates an instance of the {@link CompareDatabaseCDCStepOutput.Builder}
         * avoiding the need to create one manually via {@link CompareDatabaseCDCStepOutput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CompareDatabaseCDCStepOutput.Builder#build()} is called
         * immediately and its result is passed to {@link #stepOutput(CompareDatabaseCDCStepOutput)}.
         * 
         * @param stepOutput
         *        a consumer that will call methods on {@link CompareDatabaseCDCStepOutput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stepOutput(CompareDatabaseCDCStepOutput)
         */
        default Builder stepOutput(Consumer<CompareDatabaseCDCStepOutput.Builder> stepOutput) {
            return stepOutput(CompareDatabaseCDCStepOutput.builder().applyMutation(stepOutput).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private CompareDatabaseCDCStepInput stepInput;

        private CompareDatabaseCDCStepOutput stepOutput;

        private BuilderImpl() {
        }

        private BuilderImpl(CompareDatabaseCDCSummary model) {
            stepInput(model.stepInput);
            stepOutput(model.stepOutput);
        }

        public final CompareDatabaseCDCStepInput.Builder getStepInput() {
            return stepInput != null ? stepInput.toBuilder() : null;
        }

        public final void setStepInput(CompareDatabaseCDCStepInput.BuilderImpl stepInput) {
            this.stepInput = stepInput != null ? stepInput.build() : null;
        }

        @Override
        public final Builder stepInput(CompareDatabaseCDCStepInput stepInput) {
            this.stepInput = stepInput;
            return this;
        }

        public final CompareDatabaseCDCStepOutput.Builder getStepOutput() {
            return stepOutput != null ? stepOutput.toBuilder() : null;
        }

        public final void setStepOutput(CompareDatabaseCDCStepOutput.BuilderImpl stepOutput) {
            this.stepOutput = stepOutput != null ? stepOutput.build() : null;
        }

        @Override
        public final Builder stepOutput(CompareDatabaseCDCStepOutput stepOutput) {
            this.stepOutput = stepOutput;
            return this;
        }

        @Override
        public CompareDatabaseCDCSummary build() {
            return new CompareDatabaseCDCSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
