/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apptest.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies a file metadata.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FileMetadata implements SdkPojo, Serializable, ToCopyableBuilder<FileMetadata.Builder, FileMetadata> {
    private static final SdkField<List<DataSet>> DATA_SETS_FIELD = SdkField
            .<List<DataSet>> builder(MarshallingType.LIST)
            .memberName("dataSets")
            .getter(getter(FileMetadata::dataSets))
            .setter(setter(Builder::dataSets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DataSet> builder(MarshallingType.SDK_POJO)
                                            .constructor(DataSet::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<DatabaseCDC> DATABASE_CDC_FIELD = SdkField.<DatabaseCDC> builder(MarshallingType.SDK_POJO)
            .memberName("databaseCDC").getter(getter(FileMetadata::databaseCDC)).setter(setter(Builder::databaseCDC))
            .constructor(DatabaseCDC::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("databaseCDC").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SETS_FIELD,
            DATABASE_CDC_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<DataSet> dataSets;

    private final DatabaseCDC databaseCDC;

    private final Type type;

    private FileMetadata(BuilderImpl builder) {
        this.dataSets = builder.dataSets;
        this.databaseCDC = builder.databaseCDC;
        this.type = builder.type;
    }

    /**
     * For responses, this returns true if the service returned a value for the DataSets property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasDataSets() {
        return dataSets != null && !(dataSets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The data sets of the file metadata.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDataSets} method.
     * </p>
     * 
     * @return The data sets of the file metadata.
     */
    public final List<DataSet> dataSets() {
        return dataSets;
    }

    /**
     * <p>
     * The database CDC of the file metadata.
     * </p>
     * 
     * @return The database CDC of the file metadata.
     */
    public final DatabaseCDC databaseCDC() {
        return databaseCDC;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasDataSets() ? dataSets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(databaseCDC());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FileMetadata)) {
            return false;
        }
        FileMetadata other = (FileMetadata) obj;
        return hasDataSets() == other.hasDataSets() && Objects.equals(dataSets(), other.dataSets())
                && Objects.equals(databaseCDC(), other.databaseCDC());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FileMetadata").add("DataSets", hasDataSets() ? dataSets() : null)
                .add("DatabaseCDC", databaseCDC()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "dataSets":
            return Optional.ofNullable(clazz.cast(dataSets()));
        case "databaseCDC":
            return Optional.ofNullable(clazz.cast(databaseCDC()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #dataSets()} initialized to the given value.
     *
     * <p>
     * The data sets of the file metadata.
     * </p>
     * 
     * @param dataSets
     *        The data sets of the file metadata.
     */
    public static FileMetadata fromDataSets(List<DataSet> dataSets) {
        return builder().dataSets(dataSets).build();
    }

    /**
     * Create an instance of this class with {@link #databaseCDC()} initialized to the given value.
     *
     * <p>
     * The database CDC of the file metadata.
     * </p>
     * 
     * @param databaseCDC
     *        The database CDC of the file metadata.
     */
    public static FileMetadata fromDatabaseCDC(DatabaseCDC databaseCDC) {
        return builder().databaseCDC(databaseCDC).build();
    }

    /**
     * Create an instance of this class with {@link #databaseCDC()} initialized to the given value.
     *
     * <p>
     * The database CDC of the file metadata.
     * </p>
     * 
     * @param databaseCDC
     *        The database CDC of the file metadata.
     */
    public static FileMetadata fromDatabaseCDC(Consumer<DatabaseCDC.Builder> databaseCDC) {
        DatabaseCDC.Builder builder = DatabaseCDC.builder();
        databaseCDC.accept(builder);
        return fromDatabaseCDC(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("dataSets", DATA_SETS_FIELD);
        map.put("databaseCDC", DATABASE_CDC_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FileMetadata, T> g) {
        return obj -> g.apply((FileMetadata) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FileMetadata> {
        /**
         * <p>
         * The data sets of the file metadata.
         * </p>
         * 
         * @param dataSets
         *        The data sets of the file metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSets(Collection<DataSet> dataSets);

        /**
         * <p>
         * The data sets of the file metadata.
         * </p>
         * 
         * @param dataSets
         *        The data sets of the file metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSets(DataSet... dataSets);

        /**
         * <p>
         * The data sets of the file metadata.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.apptest.model.DataSet.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.apptest.model.DataSet#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.apptest.model.DataSet.Builder#build()} is called immediately and its
         * result is passed to {@link #dataSets(List<DataSet>)}.
         * 
         * @param dataSets
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.apptest.model.DataSet.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataSets(java.util.Collection<DataSet>)
         */
        Builder dataSets(Consumer<DataSet.Builder>... dataSets);

        /**
         * <p>
         * The database CDC of the file metadata.
         * </p>
         * 
         * @param databaseCDC
         *        The database CDC of the file metadata.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder databaseCDC(DatabaseCDC databaseCDC);

        /**
         * <p>
         * The database CDC of the file metadata.
         * </p>
         * This is a convenience method that creates an instance of the {@link DatabaseCDC.Builder} avoiding the need to
         * create one manually via {@link DatabaseCDC#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DatabaseCDC.Builder#build()} is called immediately and its result
         * is passed to {@link #databaseCDC(DatabaseCDC)}.
         * 
         * @param databaseCDC
         *        a consumer that will call methods on {@link DatabaseCDC.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #databaseCDC(DatabaseCDC)
         */
        default Builder databaseCDC(Consumer<DatabaseCDC.Builder> databaseCDC) {
            return databaseCDC(DatabaseCDC.builder().applyMutation(databaseCDC).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private List<DataSet> dataSets = DefaultSdkAutoConstructList.getInstance();

        private DatabaseCDC databaseCDC;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(FileMetadata model) {
            dataSets(model.dataSets);
            databaseCDC(model.databaseCDC);
        }

        public final List<DataSet.Builder> getDataSets() {
            List<DataSet.Builder> result = DataSetListCopier.copyToBuilder(this.dataSets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDataSets(Collection<DataSet.BuilderImpl> dataSets) {
            Object oldValue = this.dataSets;
            this.dataSets = DataSetListCopier.copyFromBuilder(dataSets);
            handleUnionValueChange(Type.DATA_SETS, oldValue, this.dataSets);
        }

        @Override
        public final Builder dataSets(Collection<DataSet> dataSets) {
            Object oldValue = this.dataSets;
            this.dataSets = DataSetListCopier.copy(dataSets);
            handleUnionValueChange(Type.DATA_SETS, oldValue, this.dataSets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataSets(DataSet... dataSets) {
            dataSets(Arrays.asList(dataSets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataSets(Consumer<DataSet.Builder>... dataSets) {
            dataSets(Stream.of(dataSets).map(c -> DataSet.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final DatabaseCDC.Builder getDatabaseCDC() {
            return databaseCDC != null ? databaseCDC.toBuilder() : null;
        }

        public final void setDatabaseCDC(DatabaseCDC.BuilderImpl databaseCDC) {
            Object oldValue = this.databaseCDC;
            this.databaseCDC = databaseCDC != null ? databaseCDC.build() : null;
            handleUnionValueChange(Type.DATABASE_CDC, oldValue, this.databaseCDC);
        }

        @Override
        public final Builder databaseCDC(DatabaseCDC databaseCDC) {
            Object oldValue = this.databaseCDC;
            this.databaseCDC = databaseCDC;
            handleUnionValueChange(Type.DATABASE_CDC, oldValue, this.databaseCDC);
            return this;
        }

        @Override
        public FileMetadata build() {
            return new FileMetadata(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see FileMetadata#type()
     */
    public enum Type {
        DATA_SETS,

        DATABASE_CDC,

        UNKNOWN_TO_SDK_VERSION
    }
}
