/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apptest.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the AWS Mainframe Modernization managed application action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class M2ManagedApplicationAction implements SdkPojo, Serializable,
        ToCopyableBuilder<M2ManagedApplicationAction.Builder, M2ManagedApplicationAction> {
    private static final SdkField<String> RESOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resource").getter(getter(M2ManagedApplicationAction::resource)).setter(setter(Builder::resource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resource").build()).build();

    private static final SdkField<String> ACTION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("actionType").getter(getter(M2ManagedApplicationAction::actionTypeAsString))
            .setter(setter(Builder::actionType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionType").build()).build();

    private static final SdkField<M2ManagedActionProperties> PROPERTIES_FIELD = SdkField
            .<M2ManagedActionProperties> builder(MarshallingType.SDK_POJO).memberName("properties")
            .getter(getter(M2ManagedApplicationAction::properties)).setter(setter(Builder::properties))
            .constructor(M2ManagedActionProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("properties").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_FIELD,
            ACTION_TYPE_FIELD, PROPERTIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String resource;

    private final String actionType;

    private final M2ManagedActionProperties properties;

    private M2ManagedApplicationAction(BuilderImpl builder) {
        this.resource = builder.resource;
        this.actionType = builder.actionType;
        this.properties = builder.properties;
    }

    /**
     * <p>
     * The resource of the AWS Mainframe Modernization managed application action.
     * </p>
     * 
     * @return The resource of the AWS Mainframe Modernization managed application action.
     */
    public final String resource() {
        return resource;
    }

    /**
     * <p>
     * The action type of the AWS Mainframe Modernization managed application action.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #actionType} will
     * return {@link M2ManagedActionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #actionTypeAsString}.
     * </p>
     * 
     * @return The action type of the AWS Mainframe Modernization managed application action.
     * @see M2ManagedActionType
     */
    public final M2ManagedActionType actionType() {
        return M2ManagedActionType.fromValue(actionType);
    }

    /**
     * <p>
     * The action type of the AWS Mainframe Modernization managed application action.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #actionType} will
     * return {@link M2ManagedActionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #actionTypeAsString}.
     * </p>
     * 
     * @return The action type of the AWS Mainframe Modernization managed application action.
     * @see M2ManagedActionType
     */
    public final String actionTypeAsString() {
        return actionType;
    }

    /**
     * <p>
     * The properties of the AWS Mainframe Modernization managed application action.
     * </p>
     * 
     * @return The properties of the AWS Mainframe Modernization managed application action.
     */
    public final M2ManagedActionProperties properties() {
        return properties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resource());
        hashCode = 31 * hashCode + Objects.hashCode(actionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(properties());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof M2ManagedApplicationAction)) {
            return false;
        }
        M2ManagedApplicationAction other = (M2ManagedApplicationAction) obj;
        return Objects.equals(resource(), other.resource()) && Objects.equals(actionTypeAsString(), other.actionTypeAsString())
                && Objects.equals(properties(), other.properties());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("M2ManagedApplicationAction").add("Resource", resource()).add("ActionType", actionTypeAsString())
                .add("Properties", properties()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "resource":
            return Optional.ofNullable(clazz.cast(resource()));
        case "actionType":
            return Optional.ofNullable(clazz.cast(actionTypeAsString()));
        case "properties":
            return Optional.ofNullable(clazz.cast(properties()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("resource", RESOURCE_FIELD);
        map.put("actionType", ACTION_TYPE_FIELD);
        map.put("properties", PROPERTIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<M2ManagedApplicationAction, T> g) {
        return obj -> g.apply((M2ManagedApplicationAction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, M2ManagedApplicationAction> {
        /**
         * <p>
         * The resource of the AWS Mainframe Modernization managed application action.
         * </p>
         * 
         * @param resource
         *        The resource of the AWS Mainframe Modernization managed application action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resource(String resource);

        /**
         * <p>
         * The action type of the AWS Mainframe Modernization managed application action.
         * </p>
         * 
         * @param actionType
         *        The action type of the AWS Mainframe Modernization managed application action.
         * @see M2ManagedActionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see M2ManagedActionType
         */
        Builder actionType(String actionType);

        /**
         * <p>
         * The action type of the AWS Mainframe Modernization managed application action.
         * </p>
         * 
         * @param actionType
         *        The action type of the AWS Mainframe Modernization managed application action.
         * @see M2ManagedActionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see M2ManagedActionType
         */
        Builder actionType(M2ManagedActionType actionType);

        /**
         * <p>
         * The properties of the AWS Mainframe Modernization managed application action.
         * </p>
         * 
         * @param properties
         *        The properties of the AWS Mainframe Modernization managed application action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder properties(M2ManagedActionProperties properties);

        /**
         * <p>
         * The properties of the AWS Mainframe Modernization managed application action.
         * </p>
         * This is a convenience method that creates an instance of the {@link M2ManagedActionProperties.Builder}
         * avoiding the need to create one manually via {@link M2ManagedActionProperties#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link M2ManagedActionProperties.Builder#build()} is called immediately
         * and its result is passed to {@link #properties(M2ManagedActionProperties)}.
         * 
         * @param properties
         *        a consumer that will call methods on {@link M2ManagedActionProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #properties(M2ManagedActionProperties)
         */
        default Builder properties(Consumer<M2ManagedActionProperties.Builder> properties) {
            return properties(M2ManagedActionProperties.builder().applyMutation(properties).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String resource;

        private String actionType;

        private M2ManagedActionProperties properties;

        private BuilderImpl() {
        }

        private BuilderImpl(M2ManagedApplicationAction model) {
            resource(model.resource);
            actionType(model.actionType);
            properties(model.properties);
        }

        public final String getResource() {
            return resource;
        }

        public final void setResource(String resource) {
            this.resource = resource;
        }

        @Override
        public final Builder resource(String resource) {
            this.resource = resource;
            return this;
        }

        public final String getActionType() {
            return actionType;
        }

        public final void setActionType(String actionType) {
            this.actionType = actionType;
        }

        @Override
        public final Builder actionType(String actionType) {
            this.actionType = actionType;
            return this;
        }

        @Override
        public final Builder actionType(M2ManagedActionType actionType) {
            this.actionType(actionType == null ? null : actionType.toString());
            return this;
        }

        public final M2ManagedActionProperties.Builder getProperties() {
            return properties != null ? properties.toBuilder() : null;
        }

        public final void setProperties(M2ManagedActionProperties.BuilderImpl properties) {
            this.properties = properties != null ? properties.build() : null;
        }

        @Override
        public final Builder properties(M2ManagedActionProperties properties) {
            this.properties = properties;
            return this;
        }

        @Override
        public M2ManagedApplicationAction build() {
            return new M2ManagedApplicationAction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
