/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apptest.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the AWS Mainframe Modernization managed application step output.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class M2ManagedApplicationStepOutput implements SdkPojo, Serializable,
        ToCopyableBuilder<M2ManagedApplicationStepOutput.Builder, M2ManagedApplicationStepOutput> {
    private static final SdkField<Map<String, String>> IMPORT_DATA_SET_SUMMARY_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("importDataSetSummary")
            .getter(getter(M2ManagedApplicationStepOutput::importDataSetSummary))
            .setter(setter(Builder::importDataSetSummary))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("importDataSetSummary").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(IMPORT_DATA_SET_SUMMARY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Map<String, String> importDataSetSummary;

    private M2ManagedApplicationStepOutput(BuilderImpl builder) {
        this.importDataSetSummary = builder.importDataSetSummary;
    }

    /**
     * For responses, this returns true if the service returned a value for the ImportDataSetSummary property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasImportDataSetSummary() {
        return importDataSetSummary != null && !(importDataSetSummary instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The import data set summary of the AWS Mainframe Modernization managed application step output.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasImportDataSetSummary} method.
     * </p>
     * 
     * @return The import data set summary of the AWS Mainframe Modernization managed application step output.
     */
    public final Map<String, String> importDataSetSummary() {
        return importDataSetSummary;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasImportDataSetSummary() ? importDataSetSummary() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof M2ManagedApplicationStepOutput)) {
            return false;
        }
        M2ManagedApplicationStepOutput other = (M2ManagedApplicationStepOutput) obj;
        return hasImportDataSetSummary() == other.hasImportDataSetSummary()
                && Objects.equals(importDataSetSummary(), other.importDataSetSummary());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("M2ManagedApplicationStepOutput")
                .add("ImportDataSetSummary", hasImportDataSetSummary() ? importDataSetSummary() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "importDataSetSummary":
            return Optional.ofNullable(clazz.cast(importDataSetSummary()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("importDataSetSummary", IMPORT_DATA_SET_SUMMARY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<M2ManagedApplicationStepOutput, T> g) {
        return obj -> g.apply((M2ManagedApplicationStepOutput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, M2ManagedApplicationStepOutput> {
        /**
         * <p>
         * The import data set summary of the AWS Mainframe Modernization managed application step output.
         * </p>
         * 
         * @param importDataSetSummary
         *        The import data set summary of the AWS Mainframe Modernization managed application step output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder importDataSetSummary(Map<String, String> importDataSetSummary);
    }

    static final class BuilderImpl implements Builder {
        private Map<String, String> importDataSetSummary = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(M2ManagedApplicationStepOutput model) {
            importDataSetSummary(model.importDataSetSummary);
        }

        public final Map<String, String> getImportDataSetSummary() {
            if (importDataSetSummary instanceof SdkAutoConstructMap) {
                return null;
            }
            return importDataSetSummary;
        }

        public final void setImportDataSetSummary(Map<String, String> importDataSetSummary) {
            this.importDataSetSummary = PropertiesCopier.copy(importDataSetSummary);
        }

        @Override
        public final Builder importDataSetSummary(Map<String, String> importDataSetSummary) {
            this.importDataSetSummary = PropertiesCopier.copy(importDataSetSummary);
            return this;
        }

        @Override
        public M2ManagedApplicationStepOutput build() {
            return new M2ManagedApplicationStepOutput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
