/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apptest.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the AWS Mainframe Modernization non-managed application.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class M2NonManagedApplication implements SdkPojo, Serializable,
        ToCopyableBuilder<M2NonManagedApplication.Builder, M2NonManagedApplication> {
    private static final SdkField<String> VPC_ENDPOINT_SERVICE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("vpcEndpointServiceName").getter(getter(M2NonManagedApplication::vpcEndpointServiceName))
            .setter(setter(Builder::vpcEndpointServiceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcEndpointServiceName").build())
            .build();

    private static final SdkField<String> LISTENER_PORT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("listenerPort").getter(getter(M2NonManagedApplication::listenerPort))
            .setter(setter(Builder::listenerPort))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("listenerPort").build()).build();

    private static final SdkField<String> RUNTIME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("runtime")
            .getter(getter(M2NonManagedApplication::runtimeAsString)).setter(setter(Builder::runtime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runtime").build()).build();

    private static final SdkField<String> WEB_APP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("webAppName").getter(getter(M2NonManagedApplication::webAppName)).setter(setter(Builder::webAppName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("webAppName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            VPC_ENDPOINT_SERVICE_NAME_FIELD, LISTENER_PORT_FIELD, RUNTIME_FIELD, WEB_APP_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String vpcEndpointServiceName;

    private final String listenerPort;

    private final String runtime;

    private final String webAppName;

    private M2NonManagedApplication(BuilderImpl builder) {
        this.vpcEndpointServiceName = builder.vpcEndpointServiceName;
        this.listenerPort = builder.listenerPort;
        this.runtime = builder.runtime;
        this.webAppName = builder.webAppName;
    }

    /**
     * <p>
     * The VPC endpoint service name of the AWS Mainframe Modernization non-managed application.
     * </p>
     * 
     * @return The VPC endpoint service name of the AWS Mainframe Modernization non-managed application.
     */
    public final String vpcEndpointServiceName() {
        return vpcEndpointServiceName;
    }

    /**
     * <p>
     * The listener port of the AWS Mainframe Modernization non-managed application.
     * </p>
     * 
     * @return The listener port of the AWS Mainframe Modernization non-managed application.
     */
    public final String listenerPort() {
        return listenerPort;
    }

    /**
     * <p>
     * The runtime of the AWS Mainframe Modernization non-managed application.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #runtime} will
     * return {@link M2NonManagedRuntime#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #runtimeAsString}.
     * </p>
     * 
     * @return The runtime of the AWS Mainframe Modernization non-managed application.
     * @see M2NonManagedRuntime
     */
    public final M2NonManagedRuntime runtime() {
        return M2NonManagedRuntime.fromValue(runtime);
    }

    /**
     * <p>
     * The runtime of the AWS Mainframe Modernization non-managed application.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #runtime} will
     * return {@link M2NonManagedRuntime#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #runtimeAsString}.
     * </p>
     * 
     * @return The runtime of the AWS Mainframe Modernization non-managed application.
     * @see M2NonManagedRuntime
     */
    public final String runtimeAsString() {
        return runtime;
    }

    /**
     * <p>
     * The web application name of the AWS Mainframe Modernization non-managed application.
     * </p>
     * 
     * @return The web application name of the AWS Mainframe Modernization non-managed application.
     */
    public final String webAppName() {
        return webAppName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(vpcEndpointServiceName());
        hashCode = 31 * hashCode + Objects.hashCode(listenerPort());
        hashCode = 31 * hashCode + Objects.hashCode(runtimeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(webAppName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof M2NonManagedApplication)) {
            return false;
        }
        M2NonManagedApplication other = (M2NonManagedApplication) obj;
        return Objects.equals(vpcEndpointServiceName(), other.vpcEndpointServiceName())
                && Objects.equals(listenerPort(), other.listenerPort())
                && Objects.equals(runtimeAsString(), other.runtimeAsString()) && Objects.equals(webAppName(), other.webAppName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("M2NonManagedApplication").add("VpcEndpointServiceName", vpcEndpointServiceName())
                .add("ListenerPort", listenerPort()).add("Runtime", runtimeAsString()).add("WebAppName", webAppName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "vpcEndpointServiceName":
            return Optional.ofNullable(clazz.cast(vpcEndpointServiceName()));
        case "listenerPort":
            return Optional.ofNullable(clazz.cast(listenerPort()));
        case "runtime":
            return Optional.ofNullable(clazz.cast(runtimeAsString()));
        case "webAppName":
            return Optional.ofNullable(clazz.cast(webAppName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("vpcEndpointServiceName", VPC_ENDPOINT_SERVICE_NAME_FIELD);
        map.put("listenerPort", LISTENER_PORT_FIELD);
        map.put("runtime", RUNTIME_FIELD);
        map.put("webAppName", WEB_APP_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<M2NonManagedApplication, T> g) {
        return obj -> g.apply((M2NonManagedApplication) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, M2NonManagedApplication> {
        /**
         * <p>
         * The VPC endpoint service name of the AWS Mainframe Modernization non-managed application.
         * </p>
         * 
         * @param vpcEndpointServiceName
         *        The VPC endpoint service name of the AWS Mainframe Modernization non-managed application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcEndpointServiceName(String vpcEndpointServiceName);

        /**
         * <p>
         * The listener port of the AWS Mainframe Modernization non-managed application.
         * </p>
         * 
         * @param listenerPort
         *        The listener port of the AWS Mainframe Modernization non-managed application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listenerPort(String listenerPort);

        /**
         * <p>
         * The runtime of the AWS Mainframe Modernization non-managed application.
         * </p>
         * 
         * @param runtime
         *        The runtime of the AWS Mainframe Modernization non-managed application.
         * @see M2NonManagedRuntime
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see M2NonManagedRuntime
         */
        Builder runtime(String runtime);

        /**
         * <p>
         * The runtime of the AWS Mainframe Modernization non-managed application.
         * </p>
         * 
         * @param runtime
         *        The runtime of the AWS Mainframe Modernization non-managed application.
         * @see M2NonManagedRuntime
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see M2NonManagedRuntime
         */
        Builder runtime(M2NonManagedRuntime runtime);

        /**
         * <p>
         * The web application name of the AWS Mainframe Modernization non-managed application.
         * </p>
         * 
         * @param webAppName
         *        The web application name of the AWS Mainframe Modernization non-managed application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder webAppName(String webAppName);
    }

    static final class BuilderImpl implements Builder {
        private String vpcEndpointServiceName;

        private String listenerPort;

        private String runtime;

        private String webAppName;

        private BuilderImpl() {
        }

        private BuilderImpl(M2NonManagedApplication model) {
            vpcEndpointServiceName(model.vpcEndpointServiceName);
            listenerPort(model.listenerPort);
            runtime(model.runtime);
            webAppName(model.webAppName);
        }

        public final String getVpcEndpointServiceName() {
            return vpcEndpointServiceName;
        }

        public final void setVpcEndpointServiceName(String vpcEndpointServiceName) {
            this.vpcEndpointServiceName = vpcEndpointServiceName;
        }

        @Override
        public final Builder vpcEndpointServiceName(String vpcEndpointServiceName) {
            this.vpcEndpointServiceName = vpcEndpointServiceName;
            return this;
        }

        public final String getListenerPort() {
            return listenerPort;
        }

        public final void setListenerPort(String listenerPort) {
            this.listenerPort = listenerPort;
        }

        @Override
        public final Builder listenerPort(String listenerPort) {
            this.listenerPort = listenerPort;
            return this;
        }

        public final String getRuntime() {
            return runtime;
        }

        public final void setRuntime(String runtime) {
            this.runtime = runtime;
        }

        @Override
        public final Builder runtime(String runtime) {
            this.runtime = runtime;
            return this;
        }

        @Override
        public final Builder runtime(M2NonManagedRuntime runtime) {
            this.runtime(runtime == null ? null : runtime.toString());
            return this;
        }

        public final String getWebAppName() {
            return webAppName;
        }

        public final void setWebAppName(String webAppName) {
            this.webAppName = webAppName;
        }

        @Override
        public final Builder webAppName(String webAppName) {
            this.webAppName = webAppName;
            return this;
        }

        @Override
        public M2NonManagedApplication build() {
            return new M2NonManagedApplication(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
