/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apptest.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the mainframe action.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MainframeAction implements SdkPojo, Serializable, ToCopyableBuilder<MainframeAction.Builder, MainframeAction> {
    private static final SdkField<String> RESOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resource").getter(getter(MainframeAction::resource)).setter(setter(Builder::resource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resource").build()).build();

    private static final SdkField<MainframeActionType> ACTION_TYPE_FIELD = SdkField
            .<MainframeActionType> builder(MarshallingType.SDK_POJO).memberName("actionType")
            .getter(getter(MainframeAction::actionType)).setter(setter(Builder::actionType))
            .constructor(MainframeActionType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionType").build()).build();

    private static final SdkField<MainframeActionProperties> PROPERTIES_FIELD = SdkField
            .<MainframeActionProperties> builder(MarshallingType.SDK_POJO).memberName("properties")
            .getter(getter(MainframeAction::properties)).setter(setter(Builder::properties))
            .constructor(MainframeActionProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("properties").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_FIELD,
            ACTION_TYPE_FIELD, PROPERTIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String resource;

    private final MainframeActionType actionType;

    private final MainframeActionProperties properties;

    private MainframeAction(BuilderImpl builder) {
        this.resource = builder.resource;
        this.actionType = builder.actionType;
        this.properties = builder.properties;
    }

    /**
     * <p>
     * The resource of the mainframe action.
     * </p>
     * 
     * @return The resource of the mainframe action.
     */
    public final String resource() {
        return resource;
    }

    /**
     * <p>
     * The action type of the mainframe action.
     * </p>
     * 
     * @return The action type of the mainframe action.
     */
    public final MainframeActionType actionType() {
        return actionType;
    }

    /**
     * <p>
     * The properties of the mainframe action.
     * </p>
     * 
     * @return The properties of the mainframe action.
     */
    public final MainframeActionProperties properties() {
        return properties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resource());
        hashCode = 31 * hashCode + Objects.hashCode(actionType());
        hashCode = 31 * hashCode + Objects.hashCode(properties());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MainframeAction)) {
            return false;
        }
        MainframeAction other = (MainframeAction) obj;
        return Objects.equals(resource(), other.resource()) && Objects.equals(actionType(), other.actionType())
                && Objects.equals(properties(), other.properties());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MainframeAction").add("Resource", resource()).add("ActionType", actionType())
                .add("Properties", properties()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "resource":
            return Optional.ofNullable(clazz.cast(resource()));
        case "actionType":
            return Optional.ofNullable(clazz.cast(actionType()));
        case "properties":
            return Optional.ofNullable(clazz.cast(properties()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("resource", RESOURCE_FIELD);
        map.put("actionType", ACTION_TYPE_FIELD);
        map.put("properties", PROPERTIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MainframeAction, T> g) {
        return obj -> g.apply((MainframeAction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MainframeAction> {
        /**
         * <p>
         * The resource of the mainframe action.
         * </p>
         * 
         * @param resource
         *        The resource of the mainframe action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resource(String resource);

        /**
         * <p>
         * The action type of the mainframe action.
         * </p>
         * 
         * @param actionType
         *        The action type of the mainframe action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actionType(MainframeActionType actionType);

        /**
         * <p>
         * The action type of the mainframe action.
         * </p>
         * This is a convenience method that creates an instance of the {@link MainframeActionType.Builder} avoiding the
         * need to create one manually via {@link MainframeActionType#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MainframeActionType.Builder#build()} is called immediately and
         * its result is passed to {@link #actionType(MainframeActionType)}.
         * 
         * @param actionType
         *        a consumer that will call methods on {@link MainframeActionType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #actionType(MainframeActionType)
         */
        default Builder actionType(Consumer<MainframeActionType.Builder> actionType) {
            return actionType(MainframeActionType.builder().applyMutation(actionType).build());
        }

        /**
         * <p>
         * The properties of the mainframe action.
         * </p>
         * 
         * @param properties
         *        The properties of the mainframe action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder properties(MainframeActionProperties properties);

        /**
         * <p>
         * The properties of the mainframe action.
         * </p>
         * This is a convenience method that creates an instance of the {@link MainframeActionProperties.Builder}
         * avoiding the need to create one manually via {@link MainframeActionProperties#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MainframeActionProperties.Builder#build()} is called immediately
         * and its result is passed to {@link #properties(MainframeActionProperties)}.
         * 
         * @param properties
         *        a consumer that will call methods on {@link MainframeActionProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #properties(MainframeActionProperties)
         */
        default Builder properties(Consumer<MainframeActionProperties.Builder> properties) {
            return properties(MainframeActionProperties.builder().applyMutation(properties).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String resource;

        private MainframeActionType actionType;

        private MainframeActionProperties properties;

        private BuilderImpl() {
        }

        private BuilderImpl(MainframeAction model) {
            resource(model.resource);
            actionType(model.actionType);
            properties(model.properties);
        }

        public final String getResource() {
            return resource;
        }

        public final void setResource(String resource) {
            this.resource = resource;
        }

        @Override
        public final Builder resource(String resource) {
            this.resource = resource;
            return this;
        }

        public final MainframeActionType.Builder getActionType() {
            return actionType != null ? actionType.toBuilder() : null;
        }

        public final void setActionType(MainframeActionType.BuilderImpl actionType) {
            this.actionType = actionType != null ? actionType.build() : null;
        }

        @Override
        public final Builder actionType(MainframeActionType actionType) {
            this.actionType = actionType;
            return this;
        }

        public final MainframeActionProperties.Builder getProperties() {
            return properties != null ? properties.toBuilder() : null;
        }

        public final void setProperties(MainframeActionProperties.BuilderImpl properties) {
            this.properties = properties != null ? properties.build() : null;
        }

        @Override
        public final Builder properties(MainframeActionProperties properties) {
            this.properties = properties;
            return this;
        }

        @Override
        public MainframeAction build() {
            return new MainframeAction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
