/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apptest.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the mainframe action type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MainframeActionType implements SdkPojo, Serializable,
        ToCopyableBuilder<MainframeActionType.Builder, MainframeActionType> {
    private static final SdkField<Batch> BATCH_FIELD = SdkField.<Batch> builder(MarshallingType.SDK_POJO).memberName("batch")
            .getter(getter(MainframeActionType::batch)).setter(setter(Builder::batch)).constructor(Batch::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("batch").build()).build();

    private static final SdkField<TN3270> TN3270_FIELD = SdkField.<TN3270> builder(MarshallingType.SDK_POJO).memberName("tn3270")
            .getter(getter(MainframeActionType::tn3270)).setter(setter(Builder::tn3270)).constructor(TN3270::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tn3270").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BATCH_FIELD, TN3270_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Batch batch;

    private final TN3270 tn3270;

    private final Type type;

    private MainframeActionType(BuilderImpl builder) {
        this.batch = builder.batch;
        this.tn3270 = builder.tn3270;
        this.type = builder.type;
    }

    /**
     * <p>
     * The batch of the mainframe action type.
     * </p>
     * 
     * @return The batch of the mainframe action type.
     */
    public final Batch batch() {
        return batch;
    }

    /**
     * <p>
     * The tn3270 port of the mainframe action type.
     * </p>
     * 
     * @return The tn3270 port of the mainframe action type.
     */
    public final TN3270 tn3270() {
        return tn3270;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(batch());
        hashCode = 31 * hashCode + Objects.hashCode(tn3270());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MainframeActionType)) {
            return false;
        }
        MainframeActionType other = (MainframeActionType) obj;
        return Objects.equals(batch(), other.batch()) && Objects.equals(tn3270(), other.tn3270());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MainframeActionType").add("Batch", batch()).add("Tn3270", tn3270()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "batch":
            return Optional.ofNullable(clazz.cast(batch()));
        case "tn3270":
            return Optional.ofNullable(clazz.cast(tn3270()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #batch()} initialized to the given value.
     *
     * <p>
     * The batch of the mainframe action type.
     * </p>
     * 
     * @param batch
     *        The batch of the mainframe action type.
     */
    public static MainframeActionType fromBatch(Batch batch) {
        return builder().batch(batch).build();
    }

    /**
     * Create an instance of this class with {@link #batch()} initialized to the given value.
     *
     * <p>
     * The batch of the mainframe action type.
     * </p>
     * 
     * @param batch
     *        The batch of the mainframe action type.
     */
    public static MainframeActionType fromBatch(Consumer<Batch.Builder> batch) {
        Batch.Builder builder = Batch.builder();
        batch.accept(builder);
        return fromBatch(builder.build());
    }

    /**
     * Create an instance of this class with {@link #tn3270()} initialized to the given value.
     *
     * <p>
     * The tn3270 port of the mainframe action type.
     * </p>
     * 
     * @param tn3270
     *        The tn3270 port of the mainframe action type.
     */
    public static MainframeActionType fromTn3270(TN3270 tn3270) {
        return builder().tn3270(tn3270).build();
    }

    /**
     * Create an instance of this class with {@link #tn3270()} initialized to the given value.
     *
     * <p>
     * The tn3270 port of the mainframe action type.
     * </p>
     * 
     * @param tn3270
     *        The tn3270 port of the mainframe action type.
     */
    public static MainframeActionType fromTn3270(Consumer<TN3270.Builder> tn3270) {
        TN3270.Builder builder = TN3270.builder();
        tn3270.accept(builder);
        return fromTn3270(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("batch", BATCH_FIELD);
        map.put("tn3270", TN3270_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MainframeActionType, T> g) {
        return obj -> g.apply((MainframeActionType) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MainframeActionType> {
        /**
         * <p>
         * The batch of the mainframe action type.
         * </p>
         * 
         * @param batch
         *        The batch of the mainframe action type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder batch(Batch batch);

        /**
         * <p>
         * The batch of the mainframe action type.
         * </p>
         * This is a convenience method that creates an instance of the {@link Batch.Builder} avoiding the need to
         * create one manually via {@link Batch#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Batch.Builder#build()} is called immediately and its result is
         * passed to {@link #batch(Batch)}.
         * 
         * @param batch
         *        a consumer that will call methods on {@link Batch.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #batch(Batch)
         */
        default Builder batch(Consumer<Batch.Builder> batch) {
            return batch(Batch.builder().applyMutation(batch).build());
        }

        /**
         * <p>
         * The tn3270 port of the mainframe action type.
         * </p>
         * 
         * @param tn3270
         *        The tn3270 port of the mainframe action type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tn3270(TN3270 tn3270);

        /**
         * <p>
         * The tn3270 port of the mainframe action type.
         * </p>
         * This is a convenience method that creates an instance of the {@link TN3270.Builder} avoiding the need to
         * create one manually via {@link TN3270#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TN3270.Builder#build()} is called immediately and its result is
         * passed to {@link #tn3270(TN3270)}.
         * 
         * @param tn3270
         *        a consumer that will call methods on {@link TN3270.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tn3270(TN3270)
         */
        default Builder tn3270(Consumer<TN3270.Builder> tn3270) {
            return tn3270(TN3270.builder().applyMutation(tn3270).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Batch batch;

        private TN3270 tn3270;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(MainframeActionType model) {
            batch(model.batch);
            tn3270(model.tn3270);
        }

        public final Batch.Builder getBatch() {
            return batch != null ? batch.toBuilder() : null;
        }

        public final void setBatch(Batch.BuilderImpl batch) {
            Object oldValue = this.batch;
            this.batch = batch != null ? batch.build() : null;
            handleUnionValueChange(Type.BATCH, oldValue, this.batch);
        }

        @Override
        public final Builder batch(Batch batch) {
            Object oldValue = this.batch;
            this.batch = batch;
            handleUnionValueChange(Type.BATCH, oldValue, this.batch);
            return this;
        }

        public final TN3270.Builder getTn3270() {
            return tn3270 != null ? tn3270.toBuilder() : null;
        }

        public final void setTn3270(TN3270.BuilderImpl tn3270) {
            Object oldValue = this.tn3270;
            this.tn3270 = tn3270 != null ? tn3270.build() : null;
            handleUnionValueChange(Type.TN3270, oldValue, this.tn3270);
        }

        @Override
        public final Builder tn3270(TN3270 tn3270) {
            Object oldValue = this.tn3270;
            this.tn3270 = tn3270;
            handleUnionValueChange(Type.TN3270, oldValue, this.tn3270);
            return this;
        }

        @Override
        public MainframeActionType build() {
            return new MainframeActionType(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see MainframeActionType#type()
     */
    public enum Type {
        BATCH,

        TN3270,

        UNKNOWN_TO_SDK_VERSION
    }
}
