/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apptest.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the mainframe resource summary.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MainframeResourceSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<MainframeResourceSummary.Builder, MainframeResourceSummary> {
    private static final SdkField<M2ManagedApplicationSummary> M2_MANAGED_APPLICATION_FIELD = SdkField
            .<M2ManagedApplicationSummary> builder(MarshallingType.SDK_POJO).memberName("m2ManagedApplication")
            .getter(getter(MainframeResourceSummary::m2ManagedApplication)).setter(setter(Builder::m2ManagedApplication))
            .constructor(M2ManagedApplicationSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("m2ManagedApplication").build())
            .build();

    private static final SdkField<M2NonManagedApplicationSummary> M2_NON_MANAGED_APPLICATION_FIELD = SdkField
            .<M2NonManagedApplicationSummary> builder(MarshallingType.SDK_POJO).memberName("m2NonManagedApplication")
            .getter(getter(MainframeResourceSummary::m2NonManagedApplication)).setter(setter(Builder::m2NonManagedApplication))
            .constructor(M2NonManagedApplicationSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("m2NonManagedApplication").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(M2_MANAGED_APPLICATION_FIELD,
            M2_NON_MANAGED_APPLICATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final M2ManagedApplicationSummary m2ManagedApplication;

    private final M2NonManagedApplicationSummary m2NonManagedApplication;

    private final Type type;

    private MainframeResourceSummary(BuilderImpl builder) {
        this.m2ManagedApplication = builder.m2ManagedApplication;
        this.m2NonManagedApplication = builder.m2NonManagedApplication;
        this.type = builder.type;
    }

    /**
     * <p>
     * The AWS Mainframe Modernization managed application in the mainframe resource summary.
     * </p>
     * 
     * @return The AWS Mainframe Modernization managed application in the mainframe resource summary.
     */
    public final M2ManagedApplicationSummary m2ManagedApplication() {
        return m2ManagedApplication;
    }

    /**
     * <p>
     * The AWS Mainframe Modernization non-managed application in the mainframe resource summary.
     * </p>
     * 
     * @return The AWS Mainframe Modernization non-managed application in the mainframe resource summary.
     */
    public final M2NonManagedApplicationSummary m2NonManagedApplication() {
        return m2NonManagedApplication;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(m2ManagedApplication());
        hashCode = 31 * hashCode + Objects.hashCode(m2NonManagedApplication());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MainframeResourceSummary)) {
            return false;
        }
        MainframeResourceSummary other = (MainframeResourceSummary) obj;
        return Objects.equals(m2ManagedApplication(), other.m2ManagedApplication())
                && Objects.equals(m2NonManagedApplication(), other.m2NonManagedApplication());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MainframeResourceSummary").add("M2ManagedApplication", m2ManagedApplication())
                .add("M2NonManagedApplication", m2NonManagedApplication()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "m2ManagedApplication":
            return Optional.ofNullable(clazz.cast(m2ManagedApplication()));
        case "m2NonManagedApplication":
            return Optional.ofNullable(clazz.cast(m2NonManagedApplication()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #m2ManagedApplication()} initialized to the given value.
     *
     * <p>
     * The AWS Mainframe Modernization managed application in the mainframe resource summary.
     * </p>
     * 
     * @param m2ManagedApplication
     *        The AWS Mainframe Modernization managed application in the mainframe resource summary.
     */
    public static MainframeResourceSummary fromM2ManagedApplication(M2ManagedApplicationSummary m2ManagedApplication) {
        return builder().m2ManagedApplication(m2ManagedApplication).build();
    }

    /**
     * Create an instance of this class with {@link #m2ManagedApplication()} initialized to the given value.
     *
     * <p>
     * The AWS Mainframe Modernization managed application in the mainframe resource summary.
     * </p>
     * 
     * @param m2ManagedApplication
     *        The AWS Mainframe Modernization managed application in the mainframe resource summary.
     */
    public static MainframeResourceSummary fromM2ManagedApplication(
            Consumer<M2ManagedApplicationSummary.Builder> m2ManagedApplication) {
        M2ManagedApplicationSummary.Builder builder = M2ManagedApplicationSummary.builder();
        m2ManagedApplication.accept(builder);
        return fromM2ManagedApplication(builder.build());
    }

    /**
     * Create an instance of this class with {@link #m2NonManagedApplication()} initialized to the given value.
     *
     * <p>
     * The AWS Mainframe Modernization non-managed application in the mainframe resource summary.
     * </p>
     * 
     * @param m2NonManagedApplication
     *        The AWS Mainframe Modernization non-managed application in the mainframe resource summary.
     */
    public static MainframeResourceSummary fromM2NonManagedApplication(M2NonManagedApplicationSummary m2NonManagedApplication) {
        return builder().m2NonManagedApplication(m2NonManagedApplication).build();
    }

    /**
     * Create an instance of this class with {@link #m2NonManagedApplication()} initialized to the given value.
     *
     * <p>
     * The AWS Mainframe Modernization non-managed application in the mainframe resource summary.
     * </p>
     * 
     * @param m2NonManagedApplication
     *        The AWS Mainframe Modernization non-managed application in the mainframe resource summary.
     */
    public static MainframeResourceSummary fromM2NonManagedApplication(
            Consumer<M2NonManagedApplicationSummary.Builder> m2NonManagedApplication) {
        M2NonManagedApplicationSummary.Builder builder = M2NonManagedApplicationSummary.builder();
        m2NonManagedApplication.accept(builder);
        return fromM2NonManagedApplication(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("m2ManagedApplication", M2_MANAGED_APPLICATION_FIELD);
        map.put("m2NonManagedApplication", M2_NON_MANAGED_APPLICATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<MainframeResourceSummary, T> g) {
        return obj -> g.apply((MainframeResourceSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MainframeResourceSummary> {
        /**
         * <p>
         * The AWS Mainframe Modernization managed application in the mainframe resource summary.
         * </p>
         * 
         * @param m2ManagedApplication
         *        The AWS Mainframe Modernization managed application in the mainframe resource summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder m2ManagedApplication(M2ManagedApplicationSummary m2ManagedApplication);

        /**
         * <p>
         * The AWS Mainframe Modernization managed application in the mainframe resource summary.
         * </p>
         * This is a convenience method that creates an instance of the {@link M2ManagedApplicationSummary.Builder}
         * avoiding the need to create one manually via {@link M2ManagedApplicationSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link M2ManagedApplicationSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #m2ManagedApplication(M2ManagedApplicationSummary)}.
         * 
         * @param m2ManagedApplication
         *        a consumer that will call methods on {@link M2ManagedApplicationSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #m2ManagedApplication(M2ManagedApplicationSummary)
         */
        default Builder m2ManagedApplication(Consumer<M2ManagedApplicationSummary.Builder> m2ManagedApplication) {
            return m2ManagedApplication(M2ManagedApplicationSummary.builder().applyMutation(m2ManagedApplication).build());
        }

        /**
         * <p>
         * The AWS Mainframe Modernization non-managed application in the mainframe resource summary.
         * </p>
         * 
         * @param m2NonManagedApplication
         *        The AWS Mainframe Modernization non-managed application in the mainframe resource summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder m2NonManagedApplication(M2NonManagedApplicationSummary m2NonManagedApplication);

        /**
         * <p>
         * The AWS Mainframe Modernization non-managed application in the mainframe resource summary.
         * </p>
         * This is a convenience method that creates an instance of the {@link M2NonManagedApplicationSummary.Builder}
         * avoiding the need to create one manually via {@link M2NonManagedApplicationSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link M2NonManagedApplicationSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #m2NonManagedApplication(M2NonManagedApplicationSummary)}.
         * 
         * @param m2NonManagedApplication
         *        a consumer that will call methods on {@link M2NonManagedApplicationSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #m2NonManagedApplication(M2NonManagedApplicationSummary)
         */
        default Builder m2NonManagedApplication(Consumer<M2NonManagedApplicationSummary.Builder> m2NonManagedApplication) {
            return m2NonManagedApplication(M2NonManagedApplicationSummary.builder().applyMutation(m2NonManagedApplication)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private M2ManagedApplicationSummary m2ManagedApplication;

        private M2NonManagedApplicationSummary m2NonManagedApplication;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(MainframeResourceSummary model) {
            m2ManagedApplication(model.m2ManagedApplication);
            m2NonManagedApplication(model.m2NonManagedApplication);
        }

        public final M2ManagedApplicationSummary.Builder getM2ManagedApplication() {
            return m2ManagedApplication != null ? m2ManagedApplication.toBuilder() : null;
        }

        public final void setM2ManagedApplication(M2ManagedApplicationSummary.BuilderImpl m2ManagedApplication) {
            Object oldValue = this.m2ManagedApplication;
            this.m2ManagedApplication = m2ManagedApplication != null ? m2ManagedApplication.build() : null;
            handleUnionValueChange(Type.M2_MANAGED_APPLICATION, oldValue, this.m2ManagedApplication);
        }

        @Override
        public final Builder m2ManagedApplication(M2ManagedApplicationSummary m2ManagedApplication) {
            Object oldValue = this.m2ManagedApplication;
            this.m2ManagedApplication = m2ManagedApplication;
            handleUnionValueChange(Type.M2_MANAGED_APPLICATION, oldValue, this.m2ManagedApplication);
            return this;
        }

        public final M2NonManagedApplicationSummary.Builder getM2NonManagedApplication() {
            return m2NonManagedApplication != null ? m2NonManagedApplication.toBuilder() : null;
        }

        public final void setM2NonManagedApplication(M2NonManagedApplicationSummary.BuilderImpl m2NonManagedApplication) {
            Object oldValue = this.m2NonManagedApplication;
            this.m2NonManagedApplication = m2NonManagedApplication != null ? m2NonManagedApplication.build() : null;
            handleUnionValueChange(Type.M2_NON_MANAGED_APPLICATION, oldValue, this.m2NonManagedApplication);
        }

        @Override
        public final Builder m2NonManagedApplication(M2NonManagedApplicationSummary m2NonManagedApplication) {
            Object oldValue = this.m2NonManagedApplication;
            this.m2NonManagedApplication = m2NonManagedApplication;
            handleUnionValueChange(Type.M2_NON_MANAGED_APPLICATION, oldValue, this.m2NonManagedApplication);
            return this;
        }

        @Override
        public MainframeResourceSummary build() {
            return new MainframeResourceSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see MainframeResourceSummary#type()
     */
    public enum Type {
        M2_MANAGED_APPLICATION,

        M2_NON_MANAGED_APPLICATION,

        UNKNOWN_TO_SDK_VERSION
    }
}
