/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apptest.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the resource action summary.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResourceActionSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ResourceActionSummary.Builder, ResourceActionSummary> {
    private static final SdkField<CloudFormationStepSummary> CLOUD_FORMATION_FIELD = SdkField
            .<CloudFormationStepSummary> builder(MarshallingType.SDK_POJO).memberName("cloudFormation")
            .getter(getter(ResourceActionSummary::cloudFormation)).setter(setter(Builder::cloudFormation))
            .constructor(CloudFormationStepSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cloudFormation").build()).build();

    private static final SdkField<M2ManagedApplicationStepSummary> M2_MANAGED_APPLICATION_FIELD = SdkField
            .<M2ManagedApplicationStepSummary> builder(MarshallingType.SDK_POJO).memberName("m2ManagedApplication")
            .getter(getter(ResourceActionSummary::m2ManagedApplication)).setter(setter(Builder::m2ManagedApplication))
            .constructor(M2ManagedApplicationStepSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("m2ManagedApplication").build())
            .build();

    private static final SdkField<M2NonManagedApplicationStepSummary> M2_NON_MANAGED_APPLICATION_FIELD = SdkField
            .<M2NonManagedApplicationStepSummary> builder(MarshallingType.SDK_POJO).memberName("m2NonManagedApplication")
            .getter(getter(ResourceActionSummary::m2NonManagedApplication)).setter(setter(Builder::m2NonManagedApplication))
            .constructor(M2NonManagedApplicationStepSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("m2NonManagedApplication").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLOUD_FORMATION_FIELD,
            M2_MANAGED_APPLICATION_FIELD, M2_NON_MANAGED_APPLICATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final CloudFormationStepSummary cloudFormation;

    private final M2ManagedApplicationStepSummary m2ManagedApplication;

    private final M2NonManagedApplicationStepSummary m2NonManagedApplication;

    private final Type type;

    private ResourceActionSummary(BuilderImpl builder) {
        this.cloudFormation = builder.cloudFormation;
        this.m2ManagedApplication = builder.m2ManagedApplication;
        this.m2NonManagedApplication = builder.m2NonManagedApplication;
        this.type = builder.type;
    }

    /**
     * <p>
     * The CloudFormation template of the resource action summary.
     * </p>
     * 
     * @return The CloudFormation template of the resource action summary.
     */
    public final CloudFormationStepSummary cloudFormation() {
        return cloudFormation;
    }

    /**
     * <p>
     * The AWS Mainframe Modernization managed application of the resource action summary.
     * </p>
     * 
     * @return The AWS Mainframe Modernization managed application of the resource action summary.
     */
    public final M2ManagedApplicationStepSummary m2ManagedApplication() {
        return m2ManagedApplication;
    }

    /**
     * <p>
     * The AWS Mainframe Modernization non-managed application of the resource action summary.
     * </p>
     * 
     * @return The AWS Mainframe Modernization non-managed application of the resource action summary.
     */
    public final M2NonManagedApplicationStepSummary m2NonManagedApplication() {
        return m2NonManagedApplication;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cloudFormation());
        hashCode = 31 * hashCode + Objects.hashCode(m2ManagedApplication());
        hashCode = 31 * hashCode + Objects.hashCode(m2NonManagedApplication());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceActionSummary)) {
            return false;
        }
        ResourceActionSummary other = (ResourceActionSummary) obj;
        return Objects.equals(cloudFormation(), other.cloudFormation())
                && Objects.equals(m2ManagedApplication(), other.m2ManagedApplication())
                && Objects.equals(m2NonManagedApplication(), other.m2NonManagedApplication());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResourceActionSummary").add("CloudFormation", cloudFormation())
                .add("M2ManagedApplication", m2ManagedApplication()).add("M2NonManagedApplication", m2NonManagedApplication())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "cloudFormation":
            return Optional.ofNullable(clazz.cast(cloudFormation()));
        case "m2ManagedApplication":
            return Optional.ofNullable(clazz.cast(m2ManagedApplication()));
        case "m2NonManagedApplication":
            return Optional.ofNullable(clazz.cast(m2NonManagedApplication()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #cloudFormation()} initialized to the given value.
     *
     * <p>
     * The CloudFormation template of the resource action summary.
     * </p>
     * 
     * @param cloudFormation
     *        The CloudFormation template of the resource action summary.
     */
    public static ResourceActionSummary fromCloudFormation(CloudFormationStepSummary cloudFormation) {
        return builder().cloudFormation(cloudFormation).build();
    }

    /**
     * Create an instance of this class with {@link #cloudFormation()} initialized to the given value.
     *
     * <p>
     * The CloudFormation template of the resource action summary.
     * </p>
     * 
     * @param cloudFormation
     *        The CloudFormation template of the resource action summary.
     */
    public static ResourceActionSummary fromCloudFormation(Consumer<CloudFormationStepSummary.Builder> cloudFormation) {
        CloudFormationStepSummary.Builder builder = CloudFormationStepSummary.builder();
        cloudFormation.accept(builder);
        return fromCloudFormation(builder.build());
    }

    /**
     * Create an instance of this class with {@link #m2ManagedApplication()} initialized to the given value.
     *
     * <p>
     * The AWS Mainframe Modernization managed application of the resource action summary.
     * </p>
     * 
     * @param m2ManagedApplication
     *        The AWS Mainframe Modernization managed application of the resource action summary.
     */
    public static ResourceActionSummary fromM2ManagedApplication(M2ManagedApplicationStepSummary m2ManagedApplication) {
        return builder().m2ManagedApplication(m2ManagedApplication).build();
    }

    /**
     * Create an instance of this class with {@link #m2ManagedApplication()} initialized to the given value.
     *
     * <p>
     * The AWS Mainframe Modernization managed application of the resource action summary.
     * </p>
     * 
     * @param m2ManagedApplication
     *        The AWS Mainframe Modernization managed application of the resource action summary.
     */
    public static ResourceActionSummary fromM2ManagedApplication(
            Consumer<M2ManagedApplicationStepSummary.Builder> m2ManagedApplication) {
        M2ManagedApplicationStepSummary.Builder builder = M2ManagedApplicationStepSummary.builder();
        m2ManagedApplication.accept(builder);
        return fromM2ManagedApplication(builder.build());
    }

    /**
     * Create an instance of this class with {@link #m2NonManagedApplication()} initialized to the given value.
     *
     * <p>
     * The AWS Mainframe Modernization non-managed application of the resource action summary.
     * </p>
     * 
     * @param m2NonManagedApplication
     *        The AWS Mainframe Modernization non-managed application of the resource action summary.
     */
    public static ResourceActionSummary fromM2NonManagedApplication(M2NonManagedApplicationStepSummary m2NonManagedApplication) {
        return builder().m2NonManagedApplication(m2NonManagedApplication).build();
    }

    /**
     * Create an instance of this class with {@link #m2NonManagedApplication()} initialized to the given value.
     *
     * <p>
     * The AWS Mainframe Modernization non-managed application of the resource action summary.
     * </p>
     * 
     * @param m2NonManagedApplication
     *        The AWS Mainframe Modernization non-managed application of the resource action summary.
     */
    public static ResourceActionSummary fromM2NonManagedApplication(
            Consumer<M2NonManagedApplicationStepSummary.Builder> m2NonManagedApplication) {
        M2NonManagedApplicationStepSummary.Builder builder = M2NonManagedApplicationStepSummary.builder();
        m2NonManagedApplication.accept(builder);
        return fromM2NonManagedApplication(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("cloudFormation", CLOUD_FORMATION_FIELD);
        map.put("m2ManagedApplication", M2_MANAGED_APPLICATION_FIELD);
        map.put("m2NonManagedApplication", M2_NON_MANAGED_APPLICATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ResourceActionSummary, T> g) {
        return obj -> g.apply((ResourceActionSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResourceActionSummary> {
        /**
         * <p>
         * The CloudFormation template of the resource action summary.
         * </p>
         * 
         * @param cloudFormation
         *        The CloudFormation template of the resource action summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudFormation(CloudFormationStepSummary cloudFormation);

        /**
         * <p>
         * The CloudFormation template of the resource action summary.
         * </p>
         * This is a convenience method that creates an instance of the {@link CloudFormationStepSummary.Builder}
         * avoiding the need to create one manually via {@link CloudFormationStepSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CloudFormationStepSummary.Builder#build()} is called immediately
         * and its result is passed to {@link #cloudFormation(CloudFormationStepSummary)}.
         * 
         * @param cloudFormation
         *        a consumer that will call methods on {@link CloudFormationStepSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cloudFormation(CloudFormationStepSummary)
         */
        default Builder cloudFormation(Consumer<CloudFormationStepSummary.Builder> cloudFormation) {
            return cloudFormation(CloudFormationStepSummary.builder().applyMutation(cloudFormation).build());
        }

        /**
         * <p>
         * The AWS Mainframe Modernization managed application of the resource action summary.
         * </p>
         * 
         * @param m2ManagedApplication
         *        The AWS Mainframe Modernization managed application of the resource action summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder m2ManagedApplication(M2ManagedApplicationStepSummary m2ManagedApplication);

        /**
         * <p>
         * The AWS Mainframe Modernization managed application of the resource action summary.
         * </p>
         * This is a convenience method that creates an instance of the {@link M2ManagedApplicationStepSummary.Builder}
         * avoiding the need to create one manually via {@link M2ManagedApplicationStepSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link M2ManagedApplicationStepSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #m2ManagedApplication(M2ManagedApplicationStepSummary)}.
         * 
         * @param m2ManagedApplication
         *        a consumer that will call methods on {@link M2ManagedApplicationStepSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #m2ManagedApplication(M2ManagedApplicationStepSummary)
         */
        default Builder m2ManagedApplication(Consumer<M2ManagedApplicationStepSummary.Builder> m2ManagedApplication) {
            return m2ManagedApplication(M2ManagedApplicationStepSummary.builder().applyMutation(m2ManagedApplication).build());
        }

        /**
         * <p>
         * The AWS Mainframe Modernization non-managed application of the resource action summary.
         * </p>
         * 
         * @param m2NonManagedApplication
         *        The AWS Mainframe Modernization non-managed application of the resource action summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder m2NonManagedApplication(M2NonManagedApplicationStepSummary m2NonManagedApplication);

        /**
         * <p>
         * The AWS Mainframe Modernization non-managed application of the resource action summary.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link M2NonManagedApplicationStepSummary.Builder} avoiding the need to create one manually via
         * {@link M2NonManagedApplicationStepSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link M2NonManagedApplicationStepSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #m2NonManagedApplication(M2NonManagedApplicationStepSummary)}.
         * 
         * @param m2NonManagedApplication
         *        a consumer that will call methods on {@link M2NonManagedApplicationStepSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #m2NonManagedApplication(M2NonManagedApplicationStepSummary)
         */
        default Builder m2NonManagedApplication(Consumer<M2NonManagedApplicationStepSummary.Builder> m2NonManagedApplication) {
            return m2NonManagedApplication(M2NonManagedApplicationStepSummary.builder().applyMutation(m2NonManagedApplication)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private CloudFormationStepSummary cloudFormation;

        private M2ManagedApplicationStepSummary m2ManagedApplication;

        private M2NonManagedApplicationStepSummary m2NonManagedApplication;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceActionSummary model) {
            cloudFormation(model.cloudFormation);
            m2ManagedApplication(model.m2ManagedApplication);
            m2NonManagedApplication(model.m2NonManagedApplication);
        }

        public final CloudFormationStepSummary.Builder getCloudFormation() {
            return cloudFormation != null ? cloudFormation.toBuilder() : null;
        }

        public final void setCloudFormation(CloudFormationStepSummary.BuilderImpl cloudFormation) {
            Object oldValue = this.cloudFormation;
            this.cloudFormation = cloudFormation != null ? cloudFormation.build() : null;
            handleUnionValueChange(Type.CLOUD_FORMATION, oldValue, this.cloudFormation);
        }

        @Override
        public final Builder cloudFormation(CloudFormationStepSummary cloudFormation) {
            Object oldValue = this.cloudFormation;
            this.cloudFormation = cloudFormation;
            handleUnionValueChange(Type.CLOUD_FORMATION, oldValue, this.cloudFormation);
            return this;
        }

        public final M2ManagedApplicationStepSummary.Builder getM2ManagedApplication() {
            return m2ManagedApplication != null ? m2ManagedApplication.toBuilder() : null;
        }

        public final void setM2ManagedApplication(M2ManagedApplicationStepSummary.BuilderImpl m2ManagedApplication) {
            Object oldValue = this.m2ManagedApplication;
            this.m2ManagedApplication = m2ManagedApplication != null ? m2ManagedApplication.build() : null;
            handleUnionValueChange(Type.M2_MANAGED_APPLICATION, oldValue, this.m2ManagedApplication);
        }

        @Override
        public final Builder m2ManagedApplication(M2ManagedApplicationStepSummary m2ManagedApplication) {
            Object oldValue = this.m2ManagedApplication;
            this.m2ManagedApplication = m2ManagedApplication;
            handleUnionValueChange(Type.M2_MANAGED_APPLICATION, oldValue, this.m2ManagedApplication);
            return this;
        }

        public final M2NonManagedApplicationStepSummary.Builder getM2NonManagedApplication() {
            return m2NonManagedApplication != null ? m2NonManagedApplication.toBuilder() : null;
        }

        public final void setM2NonManagedApplication(M2NonManagedApplicationStepSummary.BuilderImpl m2NonManagedApplication) {
            Object oldValue = this.m2NonManagedApplication;
            this.m2NonManagedApplication = m2NonManagedApplication != null ? m2NonManagedApplication.build() : null;
            handleUnionValueChange(Type.M2_NON_MANAGED_APPLICATION, oldValue, this.m2NonManagedApplication);
        }

        @Override
        public final Builder m2NonManagedApplication(M2NonManagedApplicationStepSummary m2NonManagedApplication) {
            Object oldValue = this.m2NonManagedApplication;
            this.m2NonManagedApplication = m2NonManagedApplication;
            handleUnionValueChange(Type.M2_NON_MANAGED_APPLICATION, oldValue, this.m2NonManagedApplication);
            return this;
        }

        @Override
        public ResourceActionSummary build() {
            return new ResourceActionSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see ResourceActionSummary#type()
     */
    public enum Type {
        CLOUD_FORMATION,

        M2_MANAGED_APPLICATION,

        M2_NON_MANAGED_APPLICATION,

        UNKNOWN_TO_SDK_VERSION
    }
}
