/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apptest.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines a data set.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataSet implements SdkPojo, Serializable, ToCopyableBuilder<DataSet.Builder, DataSet> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(DataSet::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(DataSet::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> CCSID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("ccsid")
            .getter(getter(DataSet::ccsid)).setter(setter(Builder::ccsid))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ccsid").build()).build();

    private static final SdkField<String> FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("format")
            .getter(getter(DataSet::formatAsString)).setter(setter(Builder::format))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("format").build()).build();

    private static final SdkField<Integer> LENGTH_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("length").getter(getter(DataSet::length)).setter(setter(Builder::length))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("length").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, NAME_FIELD,
            CCSID_FIELD, FORMAT_FIELD, LENGTH_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String type;

    private final String name;

    private final String ccsid;

    private final String format;

    private final Integer length;

    private DataSet(BuilderImpl builder) {
        this.type = builder.type;
        this.name = builder.name;
        this.ccsid = builder.ccsid;
        this.format = builder.format;
        this.length = builder.length;
    }

    /**
     * <p>
     * The type of the data set.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link DataSetType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the data set.
     * @see DataSetType
     */
    public final DataSetType type() {
        return DataSetType.fromValue(type);
    }

    /**
     * <p>
     * The type of the data set.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link DataSetType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the data set.
     * @see DataSetType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The name of the data set.
     * </p>
     * 
     * @return The name of the data set.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The CCSID of the data set.
     * </p>
     * 
     * @return The CCSID of the data set.
     */
    public final String ccsid() {
        return ccsid;
    }

    /**
     * <p>
     * The format of the data set.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #format} will
     * return {@link Format#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #formatAsString}.
     * </p>
     * 
     * @return The format of the data set.
     * @see Format
     */
    public final Format format() {
        return Format.fromValue(format);
    }

    /**
     * <p>
     * The format of the data set.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #format} will
     * return {@link Format#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #formatAsString}.
     * </p>
     * 
     * @return The format of the data set.
     * @see Format
     */
    public final String formatAsString() {
        return format;
    }

    /**
     * <p>
     * The length of the data set.
     * </p>
     * 
     * @return The length of the data set.
     */
    public final Integer length() {
        return length;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(ccsid());
        hashCode = 31 * hashCode + Objects.hashCode(formatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(length());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataSet)) {
            return false;
        }
        DataSet other = (DataSet) obj;
        return Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(name(), other.name())
                && Objects.equals(ccsid(), other.ccsid()) && Objects.equals(formatAsString(), other.formatAsString())
                && Objects.equals(length(), other.length());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataSet").add("Type", typeAsString()).add("Name", name()).add("Ccsid", ccsid())
                .add("Format", formatAsString()).add("Length", length()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "ccsid":
            return Optional.ofNullable(clazz.cast(ccsid()));
        case "format":
            return Optional.ofNullable(clazz.cast(formatAsString()));
        case "length":
            return Optional.ofNullable(clazz.cast(length()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("type", TYPE_FIELD);
        map.put("name", NAME_FIELD);
        map.put("ccsid", CCSID_FIELD);
        map.put("format", FORMAT_FIELD);
        map.put("length", LENGTH_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataSet, T> g) {
        return obj -> g.apply((DataSet) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataSet> {
        /**
         * <p>
         * The type of the data set.
         * </p>
         * 
         * @param type
         *        The type of the data set.
         * @see DataSetType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataSetType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of the data set.
         * </p>
         * 
         * @param type
         *        The type of the data set.
         * @see DataSetType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataSetType
         */
        Builder type(DataSetType type);

        /**
         * <p>
         * The name of the data set.
         * </p>
         * 
         * @param name
         *        The name of the data set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The CCSID of the data set.
         * </p>
         * 
         * @param ccsid
         *        The CCSID of the data set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ccsid(String ccsid);

        /**
         * <p>
         * The format of the data set.
         * </p>
         * 
         * @param format
         *        The format of the data set.
         * @see Format
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Format
         */
        Builder format(String format);

        /**
         * <p>
         * The format of the data set.
         * </p>
         * 
         * @param format
         *        The format of the data set.
         * @see Format
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Format
         */
        Builder format(Format format);

        /**
         * <p>
         * The length of the data set.
         * </p>
         * 
         * @param length
         *        The length of the data set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder length(Integer length);
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private String name;

        private String ccsid;

        private String format;

        private Integer length;

        private BuilderImpl() {
        }

        private BuilderImpl(DataSet model) {
            type(model.type);
            name(model.name);
            ccsid(model.ccsid);
            format(model.format);
            length(model.length);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(DataSetType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getCcsid() {
            return ccsid;
        }

        public final void setCcsid(String ccsid) {
            this.ccsid = ccsid;
        }

        @Override
        public final Builder ccsid(String ccsid) {
            this.ccsid = ccsid;
            return this;
        }

        public final String getFormat() {
            return format;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        public final Builder format(Format format) {
            this.format(format == null ? null : format.toString());
            return this;
        }

        public final Integer getLength() {
            return length;
        }

        public final void setLength(Integer length) {
            this.length = length;
        }

        @Override
        public final Builder length(Integer length) {
            this.length = length;
            return this;
        }

        @Override
        public DataSet build() {
            return new DataSet(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
