/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apptest.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines the Change Data Capture (CDC) of the database.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DatabaseCDC implements SdkPojo, Serializable, ToCopyableBuilder<DatabaseCDC.Builder, DatabaseCDC> {
    private static final SdkField<SourceDatabaseMetadata> SOURCE_METADATA_FIELD = SdkField
            .<SourceDatabaseMetadata> builder(MarshallingType.SDK_POJO).memberName("sourceMetadata")
            .getter(getter(DatabaseCDC::sourceMetadata)).setter(setter(Builder::sourceMetadata))
            .constructor(SourceDatabaseMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceMetadata").build()).build();

    private static final SdkField<TargetDatabaseMetadata> TARGET_METADATA_FIELD = SdkField
            .<TargetDatabaseMetadata> builder(MarshallingType.SDK_POJO).memberName("targetMetadata")
            .getter(getter(DatabaseCDC::targetMetadata)).setter(setter(Builder::targetMetadata))
            .constructor(TargetDatabaseMetadata::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetMetadata").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_METADATA_FIELD,
            TARGET_METADATA_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final SourceDatabaseMetadata sourceMetadata;

    private final TargetDatabaseMetadata targetMetadata;

    private DatabaseCDC(BuilderImpl builder) {
        this.sourceMetadata = builder.sourceMetadata;
        this.targetMetadata = builder.targetMetadata;
    }

    /**
     * <p>
     * The source metadata of the database CDC.
     * </p>
     * 
     * @return The source metadata of the database CDC.
     */
    public final SourceDatabaseMetadata sourceMetadata() {
        return sourceMetadata;
    }

    /**
     * <p>
     * The target metadata of the database CDC.
     * </p>
     * 
     * @return The target metadata of the database CDC.
     */
    public final TargetDatabaseMetadata targetMetadata() {
        return targetMetadata;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sourceMetadata());
        hashCode = 31 * hashCode + Objects.hashCode(targetMetadata());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DatabaseCDC)) {
            return false;
        }
        DatabaseCDC other = (DatabaseCDC) obj;
        return Objects.equals(sourceMetadata(), other.sourceMetadata())
                && Objects.equals(targetMetadata(), other.targetMetadata());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DatabaseCDC").add("SourceMetadata", sourceMetadata()).add("TargetMetadata", targetMetadata())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "sourceMetadata":
            return Optional.ofNullable(clazz.cast(sourceMetadata()));
        case "targetMetadata":
            return Optional.ofNullable(clazz.cast(targetMetadata()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("sourceMetadata", SOURCE_METADATA_FIELD);
        map.put("targetMetadata", TARGET_METADATA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DatabaseCDC, T> g) {
        return obj -> g.apply((DatabaseCDC) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DatabaseCDC> {
        /**
         * <p>
         * The source metadata of the database CDC.
         * </p>
         * 
         * @param sourceMetadata
         *        The source metadata of the database CDC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceMetadata(SourceDatabaseMetadata sourceMetadata);

        /**
         * <p>
         * The source metadata of the database CDC.
         * </p>
         * This is a convenience method that creates an instance of the {@link SourceDatabaseMetadata.Builder} avoiding
         * the need to create one manually via {@link SourceDatabaseMetadata#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SourceDatabaseMetadata.Builder#build()} is called immediately and
         * its result is passed to {@link #sourceMetadata(SourceDatabaseMetadata)}.
         * 
         * @param sourceMetadata
         *        a consumer that will call methods on {@link SourceDatabaseMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceMetadata(SourceDatabaseMetadata)
         */
        default Builder sourceMetadata(Consumer<SourceDatabaseMetadata.Builder> sourceMetadata) {
            return sourceMetadata(SourceDatabaseMetadata.builder().applyMutation(sourceMetadata).build());
        }

        /**
         * <p>
         * The target metadata of the database CDC.
         * </p>
         * 
         * @param targetMetadata
         *        The target metadata of the database CDC.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetMetadata(TargetDatabaseMetadata targetMetadata);

        /**
         * <p>
         * The target metadata of the database CDC.
         * </p>
         * This is a convenience method that creates an instance of the {@link TargetDatabaseMetadata.Builder} avoiding
         * the need to create one manually via {@link TargetDatabaseMetadata#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TargetDatabaseMetadata.Builder#build()} is called immediately and
         * its result is passed to {@link #targetMetadata(TargetDatabaseMetadata)}.
         * 
         * @param targetMetadata
         *        a consumer that will call methods on {@link TargetDatabaseMetadata.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targetMetadata(TargetDatabaseMetadata)
         */
        default Builder targetMetadata(Consumer<TargetDatabaseMetadata.Builder> targetMetadata) {
            return targetMetadata(TargetDatabaseMetadata.builder().applyMutation(targetMetadata).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private SourceDatabaseMetadata sourceMetadata;

        private TargetDatabaseMetadata targetMetadata;

        private BuilderImpl() {
        }

        private BuilderImpl(DatabaseCDC model) {
            sourceMetadata(model.sourceMetadata);
            targetMetadata(model.targetMetadata);
        }

        public final SourceDatabaseMetadata.Builder getSourceMetadata() {
            return sourceMetadata != null ? sourceMetadata.toBuilder() : null;
        }

        public final void setSourceMetadata(SourceDatabaseMetadata.BuilderImpl sourceMetadata) {
            this.sourceMetadata = sourceMetadata != null ? sourceMetadata.build() : null;
        }

        @Override
        public final Builder sourceMetadata(SourceDatabaseMetadata sourceMetadata) {
            this.sourceMetadata = sourceMetadata;
            return this;
        }

        public final TargetDatabaseMetadata.Builder getTargetMetadata() {
            return targetMetadata != null ? targetMetadata.toBuilder() : null;
        }

        public final void setTargetMetadata(TargetDatabaseMetadata.BuilderImpl targetMetadata) {
            this.targetMetadata = targetMetadata != null ? targetMetadata.build() : null;
        }

        @Override
        public final Builder targetMetadata(TargetDatabaseMetadata targetMetadata) {
            this.targetMetadata = targetMetadata;
            return this;
        }

        @Override
        public DatabaseCDC build() {
            return new DatabaseCDC(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
