/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apptest.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetTestSuiteRequest extends AppTestRequest implements
        ToCopyableBuilder<GetTestSuiteRequest.Builder, GetTestSuiteRequest> {
    private static final SdkField<String> TEST_SUITE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("testSuiteId").getter(getter(GetTestSuiteRequest::testSuiteId)).setter(setter(Builder::testSuiteId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("testSuiteId").build()).build();

    private static final SdkField<Integer> TEST_SUITE_VERSION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("testSuiteVersion").getter(getter(GetTestSuiteRequest::testSuiteVersion))
            .setter(setter(Builder::testSuiteVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("testSuiteVersion").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEST_SUITE_ID_FIELD,
            TEST_SUITE_VERSION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String testSuiteId;

    private final Integer testSuiteVersion;

    private GetTestSuiteRequest(BuilderImpl builder) {
        super(builder);
        this.testSuiteId = builder.testSuiteId;
        this.testSuiteVersion = builder.testSuiteVersion;
    }

    /**
     * <p>
     * The ID of the test suite.
     * </p>
     * 
     * @return The ID of the test suite.
     */
    public final String testSuiteId() {
        return testSuiteId;
    }

    /**
     * <p>
     * The version of the test suite.
     * </p>
     * 
     * @return The version of the test suite.
     */
    public final Integer testSuiteVersion() {
        return testSuiteVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(testSuiteId());
        hashCode = 31 * hashCode + Objects.hashCode(testSuiteVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTestSuiteRequest)) {
            return false;
        }
        GetTestSuiteRequest other = (GetTestSuiteRequest) obj;
        return Objects.equals(testSuiteId(), other.testSuiteId()) && Objects.equals(testSuiteVersion(), other.testSuiteVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetTestSuiteRequest").add("TestSuiteId", testSuiteId())
                .add("TestSuiteVersion", testSuiteVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "testSuiteId":
            return Optional.ofNullable(clazz.cast(testSuiteId()));
        case "testSuiteVersion":
            return Optional.ofNullable(clazz.cast(testSuiteVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("testSuiteId", TEST_SUITE_ID_FIELD);
        map.put("testSuiteVersion", TEST_SUITE_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetTestSuiteRequest, T> g) {
        return obj -> g.apply((GetTestSuiteRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends AppTestRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetTestSuiteRequest> {
        /**
         * <p>
         * The ID of the test suite.
         * </p>
         * 
         * @param testSuiteId
         *        The ID of the test suite.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder testSuiteId(String testSuiteId);

        /**
         * <p>
         * The version of the test suite.
         * </p>
         * 
         * @param testSuiteVersion
         *        The version of the test suite.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder testSuiteVersion(Integer testSuiteVersion);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AppTestRequest.BuilderImpl implements Builder {
        private String testSuiteId;

        private Integer testSuiteVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTestSuiteRequest model) {
            super(model);
            testSuiteId(model.testSuiteId);
            testSuiteVersion(model.testSuiteVersion);
        }

        public final String getTestSuiteId() {
            return testSuiteId;
        }

        public final void setTestSuiteId(String testSuiteId) {
            this.testSuiteId = testSuiteId;
        }

        @Override
        public final Builder testSuiteId(String testSuiteId) {
            this.testSuiteId = testSuiteId;
            return this;
        }

        public final Integer getTestSuiteVersion() {
            return testSuiteVersion;
        }

        public final void setTestSuiteVersion(Integer testSuiteVersion) {
            this.testSuiteVersion = testSuiteVersion;
        }

        @Override
        public final Builder testSuiteVersion(Integer testSuiteVersion) {
            this.testSuiteVersion = testSuiteVersion;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetTestSuiteRequest build() {
            return new GetTestSuiteRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
