/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apptest.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetTestSuiteResponse extends AppTestResponse implements
        ToCopyableBuilder<GetTestSuiteResponse.Builder, GetTestSuiteResponse> {
    private static final SdkField<String> TEST_SUITE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("testSuiteId").getter(getter(GetTestSuiteResponse::testSuiteId)).setter(setter(Builder::testSuiteId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testSuiteId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(GetTestSuiteResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<TestSuiteLatestVersion> LATEST_VERSION_FIELD = SdkField
            .<TestSuiteLatestVersion> builder(MarshallingType.SDK_POJO).memberName("latestVersion")
            .getter(getter(GetTestSuiteResponse::latestVersion)).setter(setter(Builder::latestVersion))
            .constructor(TestSuiteLatestVersion::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("latestVersion").build()).build();

    private static final SdkField<Integer> TEST_SUITE_VERSION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("testSuiteVersion").getter(getter(GetTestSuiteResponse::testSuiteVersion))
            .setter(setter(Builder::testSuiteVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testSuiteVersion").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(GetTestSuiteResponse::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("statusReason").getter(getter(GetTestSuiteResponse::statusReason)).setter(setter(Builder::statusReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReason").build()).build();

    private static final SdkField<String> TEST_SUITE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("testSuiteArn").getter(getter(GetTestSuiteResponse::testSuiteArn)).setter(setter(Builder::testSuiteArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testSuiteArn").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("creationTime").getter(getter(GetTestSuiteResponse::creationTime)).setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build()).build();

    private static final SdkField<Instant> LAST_UPDATE_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("lastUpdateTime").getter(getter(GetTestSuiteResponse::lastUpdateTime))
            .setter(setter(Builder::lastUpdateTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdateTime").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(GetTestSuiteResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<List<Step>> BEFORE_STEPS_FIELD = SdkField
            .<List<Step>> builder(MarshallingType.LIST)
            .memberName("beforeSteps")
            .getter(getter(GetTestSuiteResponse::beforeSteps))
            .setter(setter(Builder::beforeSteps))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("beforeSteps").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Step> builder(MarshallingType.SDK_POJO)
                                            .constructor(Step::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Step>> AFTER_STEPS_FIELD = SdkField
            .<List<Step>> builder(MarshallingType.LIST)
            .memberName("afterSteps")
            .getter(getter(GetTestSuiteResponse::afterSteps))
            .setter(setter(Builder::afterSteps))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("afterSteps").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Step> builder(MarshallingType.SDK_POJO)
                                            .constructor(Step::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<TestCases> TEST_CASES_FIELD = SdkField.<TestCases> builder(MarshallingType.SDK_POJO)
            .memberName("testCases").getter(getter(GetTestSuiteResponse::testCases)).setter(setter(Builder::testCases))
            .constructor(TestCases::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testCases").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(GetTestSuiteResponse::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEST_SUITE_ID_FIELD,
            NAME_FIELD, LATEST_VERSION_FIELD, TEST_SUITE_VERSION_FIELD, STATUS_FIELD, STATUS_REASON_FIELD, TEST_SUITE_ARN_FIELD,
            CREATION_TIME_FIELD, LAST_UPDATE_TIME_FIELD, DESCRIPTION_FIELD, BEFORE_STEPS_FIELD, AFTER_STEPS_FIELD,
            TEST_CASES_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String testSuiteId;

    private final String name;

    private final TestSuiteLatestVersion latestVersion;

    private final Integer testSuiteVersion;

    private final String status;

    private final String statusReason;

    private final String testSuiteArn;

    private final Instant creationTime;

    private final Instant lastUpdateTime;

    private final String description;

    private final List<Step> beforeSteps;

    private final List<Step> afterSteps;

    private final TestCases testCases;

    private final Map<String, String> tags;

    private GetTestSuiteResponse(BuilderImpl builder) {
        super(builder);
        this.testSuiteId = builder.testSuiteId;
        this.name = builder.name;
        this.latestVersion = builder.latestVersion;
        this.testSuiteVersion = builder.testSuiteVersion;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.testSuiteArn = builder.testSuiteArn;
        this.creationTime = builder.creationTime;
        this.lastUpdateTime = builder.lastUpdateTime;
        this.description = builder.description;
        this.beforeSteps = builder.beforeSteps;
        this.afterSteps = builder.afterSteps;
        this.testCases = builder.testCases;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The response ID of the test suite.
     * </p>
     * 
     * @return The response ID of the test suite.
     */
    public final String testSuiteId() {
        return testSuiteId;
    }

    /**
     * <p>
     * The name of the test suite.
     * </p>
     * 
     * @return The name of the test suite.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The latest version of the test suite.
     * </p>
     * 
     * @return The latest version of the test suite.
     */
    public final TestSuiteLatestVersion latestVersion() {
        return latestVersion;
    }

    /**
     * <p>
     * The version of the test suite.
     * </p>
     * 
     * @return The version of the test suite.
     */
    public final Integer testSuiteVersion() {
        return testSuiteVersion;
    }

    /**
     * <p>
     * The status of the test suite.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TestSuiteLifecycle#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the test suite.
     * @see TestSuiteLifecycle
     */
    public final TestSuiteLifecycle status() {
        return TestSuiteLifecycle.fromValue(status);
    }

    /**
     * <p>
     * The status of the test suite.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link TestSuiteLifecycle#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the test suite.
     * @see TestSuiteLifecycle
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The status reason of the test suite.
     * </p>
     * 
     * @return The status reason of the test suite.
     */
    public final String statusReason() {
        return statusReason;
    }

    /**
     * <p>
     * The test suite Amazon Resource Name (ARN).
     * </p>
     * 
     * @return The test suite Amazon Resource Name (ARN).
     */
    public final String testSuiteArn() {
        return testSuiteArn;
    }

    /**
     * <p>
     * The creation time of the test suite.
     * </p>
     * 
     * @return The creation time of the test suite.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The last update time of the test suite.
     * </p>
     * 
     * @return The last update time of the test suite.
     */
    public final Instant lastUpdateTime() {
        return lastUpdateTime;
    }

    /**
     * <p>
     * The description of the test suite.
     * </p>
     * 
     * @return The description of the test suite.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the BeforeSteps property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasBeforeSteps() {
        return beforeSteps != null && !(beforeSteps instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The before steps of the test suite.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBeforeSteps} method.
     * </p>
     * 
     * @return The before steps of the test suite.
     */
    public final List<Step> beforeSteps() {
        return beforeSteps;
    }

    /**
     * For responses, this returns true if the service returned a value for the AfterSteps property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAfterSteps() {
        return afterSteps != null && !(afterSteps instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The after steps of the test suite.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAfterSteps} method.
     * </p>
     * 
     * @return The after steps of the test suite.
     */
    public final List<Step> afterSteps() {
        return afterSteps;
    }

    /**
     * <p>
     * The test cases of the test suite.
     * </p>
     * 
     * @return The test cases of the test suite.
     */
    public final TestCases testCases() {
        return testCases;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags of the test suite.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags of the test suite.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(testSuiteId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(latestVersion());
        hashCode = 31 * hashCode + Objects.hashCode(testSuiteVersion());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(testSuiteArn());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdateTime());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasBeforeSteps() ? beforeSteps() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAfterSteps() ? afterSteps() : null);
        hashCode = 31 * hashCode + Objects.hashCode(testCases());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTestSuiteResponse)) {
            return false;
        }
        GetTestSuiteResponse other = (GetTestSuiteResponse) obj;
        return Objects.equals(testSuiteId(), other.testSuiteId()) && Objects.equals(name(), other.name())
                && Objects.equals(latestVersion(), other.latestVersion())
                && Objects.equals(testSuiteVersion(), other.testSuiteVersion())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusReason(), other.statusReason()) && Objects.equals(testSuiteArn(), other.testSuiteArn())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastUpdateTime(), other.lastUpdateTime()) && Objects.equals(description(), other.description())
                && hasBeforeSteps() == other.hasBeforeSteps() && Objects.equals(beforeSteps(), other.beforeSteps())
                && hasAfterSteps() == other.hasAfterSteps() && Objects.equals(afterSteps(), other.afterSteps())
                && Objects.equals(testCases(), other.testCases()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetTestSuiteResponse").add("TestSuiteId", testSuiteId()).add("Name", name())
                .add("LatestVersion", latestVersion()).add("TestSuiteVersion", testSuiteVersion())
                .add("Status", statusAsString()).add("StatusReason", statusReason()).add("TestSuiteArn", testSuiteArn())
                .add("CreationTime", creationTime()).add("LastUpdateTime", lastUpdateTime()).add("Description", description())
                .add("BeforeSteps", hasBeforeSteps() ? beforeSteps() : null)
                .add("AfterSteps", hasAfterSteps() ? afterSteps() : null).add("TestCases", testCases())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "testSuiteId":
            return Optional.ofNullable(clazz.cast(testSuiteId()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "latestVersion":
            return Optional.ofNullable(clazz.cast(latestVersion()));
        case "testSuiteVersion":
            return Optional.ofNullable(clazz.cast(testSuiteVersion()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "statusReason":
            return Optional.ofNullable(clazz.cast(statusReason()));
        case "testSuiteArn":
            return Optional.ofNullable(clazz.cast(testSuiteArn()));
        case "creationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "lastUpdateTime":
            return Optional.ofNullable(clazz.cast(lastUpdateTime()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "beforeSteps":
            return Optional.ofNullable(clazz.cast(beforeSteps()));
        case "afterSteps":
            return Optional.ofNullable(clazz.cast(afterSteps()));
        case "testCases":
            return Optional.ofNullable(clazz.cast(testCases()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("testSuiteId", TEST_SUITE_ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("latestVersion", LATEST_VERSION_FIELD);
        map.put("testSuiteVersion", TEST_SUITE_VERSION_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("statusReason", STATUS_REASON_FIELD);
        map.put("testSuiteArn", TEST_SUITE_ARN_FIELD);
        map.put("creationTime", CREATION_TIME_FIELD);
        map.put("lastUpdateTime", LAST_UPDATE_TIME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("beforeSteps", BEFORE_STEPS_FIELD);
        map.put("afterSteps", AFTER_STEPS_FIELD);
        map.put("testCases", TEST_CASES_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetTestSuiteResponse, T> g) {
        return obj -> g.apply((GetTestSuiteResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends AppTestResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetTestSuiteResponse> {
        /**
         * <p>
         * The response ID of the test suite.
         * </p>
         * 
         * @param testSuiteId
         *        The response ID of the test suite.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder testSuiteId(String testSuiteId);

        /**
         * <p>
         * The name of the test suite.
         * </p>
         * 
         * @param name
         *        The name of the test suite.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The latest version of the test suite.
         * </p>
         * 
         * @param latestVersion
         *        The latest version of the test suite.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestVersion(TestSuiteLatestVersion latestVersion);

        /**
         * <p>
         * The latest version of the test suite.
         * </p>
         * This is a convenience method that creates an instance of the {@link TestSuiteLatestVersion.Builder} avoiding
         * the need to create one manually via {@link TestSuiteLatestVersion#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TestSuiteLatestVersion.Builder#build()} is called immediately and
         * its result is passed to {@link #latestVersion(TestSuiteLatestVersion)}.
         * 
         * @param latestVersion
         *        a consumer that will call methods on {@link TestSuiteLatestVersion.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #latestVersion(TestSuiteLatestVersion)
         */
        default Builder latestVersion(Consumer<TestSuiteLatestVersion.Builder> latestVersion) {
            return latestVersion(TestSuiteLatestVersion.builder().applyMutation(latestVersion).build());
        }

        /**
         * <p>
         * The version of the test suite.
         * </p>
         * 
         * @param testSuiteVersion
         *        The version of the test suite.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder testSuiteVersion(Integer testSuiteVersion);

        /**
         * <p>
         * The status of the test suite.
         * </p>
         * 
         * @param status
         *        The status of the test suite.
         * @see TestSuiteLifecycle
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TestSuiteLifecycle
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the test suite.
         * </p>
         * 
         * @param status
         *        The status of the test suite.
         * @see TestSuiteLifecycle
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TestSuiteLifecycle
         */
        Builder status(TestSuiteLifecycle status);

        /**
         * <p>
         * The status reason of the test suite.
         * </p>
         * 
         * @param statusReason
         *        The status reason of the test suite.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusReason(String statusReason);

        /**
         * <p>
         * The test suite Amazon Resource Name (ARN).
         * </p>
         * 
         * @param testSuiteArn
         *        The test suite Amazon Resource Name (ARN).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder testSuiteArn(String testSuiteArn);

        /**
         * <p>
         * The creation time of the test suite.
         * </p>
         * 
         * @param creationTime
         *        The creation time of the test suite.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The last update time of the test suite.
         * </p>
         * 
         * @param lastUpdateTime
         *        The last update time of the test suite.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdateTime(Instant lastUpdateTime);

        /**
         * <p>
         * The description of the test suite.
         * </p>
         * 
         * @param description
         *        The description of the test suite.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The before steps of the test suite.
         * </p>
         * 
         * @param beforeSteps
         *        The before steps of the test suite.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder beforeSteps(Collection<Step> beforeSteps);

        /**
         * <p>
         * The before steps of the test suite.
         * </p>
         * 
         * @param beforeSteps
         *        The before steps of the test suite.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder beforeSteps(Step... beforeSteps);

        /**
         * <p>
         * The before steps of the test suite.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.apptest.model.Step.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.apptest.model.Step#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.apptest.model.Step.Builder#build()} is called immediately and its
         * result is passed to {@link #beforeSteps(List<Step>)}.
         * 
         * @param beforeSteps
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.apptest.model.Step.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #beforeSteps(java.util.Collection<Step>)
         */
        Builder beforeSteps(Consumer<Step.Builder>... beforeSteps);

        /**
         * <p>
         * The after steps of the test suite.
         * </p>
         * 
         * @param afterSteps
         *        The after steps of the test suite.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder afterSteps(Collection<Step> afterSteps);

        /**
         * <p>
         * The after steps of the test suite.
         * </p>
         * 
         * @param afterSteps
         *        The after steps of the test suite.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder afterSteps(Step... afterSteps);

        /**
         * <p>
         * The after steps of the test suite.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.apptest.model.Step.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.apptest.model.Step#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.apptest.model.Step.Builder#build()} is called immediately and its
         * result is passed to {@link #afterSteps(List<Step>)}.
         * 
         * @param afterSteps
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.apptest.model.Step.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #afterSteps(java.util.Collection<Step>)
         */
        Builder afterSteps(Consumer<Step.Builder>... afterSteps);

        /**
         * <p>
         * The test cases of the test suite.
         * </p>
         * 
         * @param testCases
         *        The test cases of the test suite.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder testCases(TestCases testCases);

        /**
         * <p>
         * The test cases of the test suite.
         * </p>
         * This is a convenience method that creates an instance of the {@link TestCases.Builder} avoiding the need to
         * create one manually via {@link TestCases#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TestCases.Builder#build()} is called immediately and its result
         * is passed to {@link #testCases(TestCases)}.
         * 
         * @param testCases
         *        a consumer that will call methods on {@link TestCases.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #testCases(TestCases)
         */
        default Builder testCases(Consumer<TestCases.Builder> testCases) {
            return testCases(TestCases.builder().applyMutation(testCases).build());
        }

        /**
         * <p>
         * The tags of the test suite.
         * </p>
         * 
         * @param tags
         *        The tags of the test suite.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);
    }

    static final class BuilderImpl extends AppTestResponse.BuilderImpl implements Builder {
        private String testSuiteId;

        private String name;

        private TestSuiteLatestVersion latestVersion;

        private Integer testSuiteVersion;

        private String status;

        private String statusReason;

        private String testSuiteArn;

        private Instant creationTime;

        private Instant lastUpdateTime;

        private String description;

        private List<Step> beforeSteps = DefaultSdkAutoConstructList.getInstance();

        private List<Step> afterSteps = DefaultSdkAutoConstructList.getInstance();

        private TestCases testCases;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetTestSuiteResponse model) {
            super(model);
            testSuiteId(model.testSuiteId);
            name(model.name);
            latestVersion(model.latestVersion);
            testSuiteVersion(model.testSuiteVersion);
            status(model.status);
            statusReason(model.statusReason);
            testSuiteArn(model.testSuiteArn);
            creationTime(model.creationTime);
            lastUpdateTime(model.lastUpdateTime);
            description(model.description);
            beforeSteps(model.beforeSteps);
            afterSteps(model.afterSteps);
            testCases(model.testCases);
            tags(model.tags);
        }

        public final String getTestSuiteId() {
            return testSuiteId;
        }

        public final void setTestSuiteId(String testSuiteId) {
            this.testSuiteId = testSuiteId;
        }

        @Override
        public final Builder testSuiteId(String testSuiteId) {
            this.testSuiteId = testSuiteId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final TestSuiteLatestVersion.Builder getLatestVersion() {
            return latestVersion != null ? latestVersion.toBuilder() : null;
        }

        public final void setLatestVersion(TestSuiteLatestVersion.BuilderImpl latestVersion) {
            this.latestVersion = latestVersion != null ? latestVersion.build() : null;
        }

        @Override
        public final Builder latestVersion(TestSuiteLatestVersion latestVersion) {
            this.latestVersion = latestVersion;
            return this;
        }

        public final Integer getTestSuiteVersion() {
            return testSuiteVersion;
        }

        public final void setTestSuiteVersion(Integer testSuiteVersion) {
            this.testSuiteVersion = testSuiteVersion;
        }

        @Override
        public final Builder testSuiteVersion(Integer testSuiteVersion) {
            this.testSuiteVersion = testSuiteVersion;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TestSuiteLifecycle status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final String getTestSuiteArn() {
            return testSuiteArn;
        }

        public final void setTestSuiteArn(String testSuiteArn) {
            this.testSuiteArn = testSuiteArn;
        }

        @Override
        public final Builder testSuiteArn(String testSuiteArn) {
            this.testSuiteArn = testSuiteArn;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastUpdateTime() {
            return lastUpdateTime;
        }

        public final void setLastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
        }

        @Override
        public final Builder lastUpdateTime(Instant lastUpdateTime) {
            this.lastUpdateTime = lastUpdateTime;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<Step.Builder> getBeforeSteps() {
            List<Step.Builder> result = StepListCopier.copyToBuilder(this.beforeSteps);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBeforeSteps(Collection<Step.BuilderImpl> beforeSteps) {
            this.beforeSteps = StepListCopier.copyFromBuilder(beforeSteps);
        }

        @Override
        public final Builder beforeSteps(Collection<Step> beforeSteps) {
            this.beforeSteps = StepListCopier.copy(beforeSteps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder beforeSteps(Step... beforeSteps) {
            beforeSteps(Arrays.asList(beforeSteps));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder beforeSteps(Consumer<Step.Builder>... beforeSteps) {
            beforeSteps(Stream.of(beforeSteps).map(c -> Step.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Step.Builder> getAfterSteps() {
            List<Step.Builder> result = StepListCopier.copyToBuilder(this.afterSteps);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAfterSteps(Collection<Step.BuilderImpl> afterSteps) {
            this.afterSteps = StepListCopier.copyFromBuilder(afterSteps);
        }

        @Override
        public final Builder afterSteps(Collection<Step> afterSteps) {
            this.afterSteps = StepListCopier.copy(afterSteps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder afterSteps(Step... afterSteps) {
            afterSteps(Arrays.asList(afterSteps));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder afterSteps(Consumer<Step.Builder>... afterSteps) {
            afterSteps(Stream.of(afterSteps).map(c -> Step.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final TestCases.Builder getTestCases() {
            return testCases != null ? testCases.toBuilder() : null;
        }

        public final void setTestCases(TestCases.BuilderImpl testCases) {
            this.testCases = testCases != null ? testCases.build() : null;
        }

        @Override
        public final Builder testCases(TestCases testCases) {
            this.testCases = testCases;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        @Override
        public GetTestSuiteResponse build() {
            return new GetTestSuiteResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
