/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apptest.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the AWS Mainframe Modernization managed application step summary.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class M2ManagedApplicationStepSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<M2ManagedApplicationStepSummary.Builder, M2ManagedApplicationStepSummary> {
    private static final SdkField<M2ManagedApplicationStepInput> STEP_INPUT_FIELD = SdkField
            .<M2ManagedApplicationStepInput> builder(MarshallingType.SDK_POJO).memberName("stepInput")
            .getter(getter(M2ManagedApplicationStepSummary::stepInput)).setter(setter(Builder::stepInput))
            .constructor(M2ManagedApplicationStepInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stepInput").build()).build();

    private static final SdkField<M2ManagedApplicationStepOutput> STEP_OUTPUT_FIELD = SdkField
            .<M2ManagedApplicationStepOutput> builder(MarshallingType.SDK_POJO).memberName("stepOutput")
            .getter(getter(M2ManagedApplicationStepSummary::stepOutput)).setter(setter(Builder::stepOutput))
            .constructor(M2ManagedApplicationStepOutput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stepOutput").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STEP_INPUT_FIELD,
            STEP_OUTPUT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final M2ManagedApplicationStepInput stepInput;

    private final M2ManagedApplicationStepOutput stepOutput;

    private M2ManagedApplicationStepSummary(BuilderImpl builder) {
        this.stepInput = builder.stepInput;
        this.stepOutput = builder.stepOutput;
    }

    /**
     * <p>
     * The step input of the AWS Mainframe Modernization managed application step summary.
     * </p>
     * 
     * @return The step input of the AWS Mainframe Modernization managed application step summary.
     */
    public final M2ManagedApplicationStepInput stepInput() {
        return stepInput;
    }

    /**
     * <p>
     * The step output of the AWS Mainframe Modernization managed application step summary.
     * </p>
     * 
     * @return The step output of the AWS Mainframe Modernization managed application step summary.
     */
    public final M2ManagedApplicationStepOutput stepOutput() {
        return stepOutput;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stepInput());
        hashCode = 31 * hashCode + Objects.hashCode(stepOutput());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof M2ManagedApplicationStepSummary)) {
            return false;
        }
        M2ManagedApplicationStepSummary other = (M2ManagedApplicationStepSummary) obj;
        return Objects.equals(stepInput(), other.stepInput()) && Objects.equals(stepOutput(), other.stepOutput());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("M2ManagedApplicationStepSummary").add("StepInput", stepInput()).add("StepOutput", stepOutput())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "stepInput":
            return Optional.ofNullable(clazz.cast(stepInput()));
        case "stepOutput":
            return Optional.ofNullable(clazz.cast(stepOutput()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("stepInput", STEP_INPUT_FIELD);
        map.put("stepOutput", STEP_OUTPUT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<M2ManagedApplicationStepSummary, T> g) {
        return obj -> g.apply((M2ManagedApplicationStepSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, M2ManagedApplicationStepSummary> {
        /**
         * <p>
         * The step input of the AWS Mainframe Modernization managed application step summary.
         * </p>
         * 
         * @param stepInput
         *        The step input of the AWS Mainframe Modernization managed application step summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stepInput(M2ManagedApplicationStepInput stepInput);

        /**
         * <p>
         * The step input of the AWS Mainframe Modernization managed application step summary.
         * </p>
         * This is a convenience method that creates an instance of the {@link M2ManagedApplicationStepInput.Builder}
         * avoiding the need to create one manually via {@link M2ManagedApplicationStepInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link M2ManagedApplicationStepInput.Builder#build()} is called
         * immediately and its result is passed to {@link #stepInput(M2ManagedApplicationStepInput)}.
         * 
         * @param stepInput
         *        a consumer that will call methods on {@link M2ManagedApplicationStepInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stepInput(M2ManagedApplicationStepInput)
         */
        default Builder stepInput(Consumer<M2ManagedApplicationStepInput.Builder> stepInput) {
            return stepInput(M2ManagedApplicationStepInput.builder().applyMutation(stepInput).build());
        }

        /**
         * <p>
         * The step output of the AWS Mainframe Modernization managed application step summary.
         * </p>
         * 
         * @param stepOutput
         *        The step output of the AWS Mainframe Modernization managed application step summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stepOutput(M2ManagedApplicationStepOutput stepOutput);

        /**
         * <p>
         * The step output of the AWS Mainframe Modernization managed application step summary.
         * </p>
         * This is a convenience method that creates an instance of the {@link M2ManagedApplicationStepOutput.Builder}
         * avoiding the need to create one manually via {@link M2ManagedApplicationStepOutput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link M2ManagedApplicationStepOutput.Builder#build()} is called
         * immediately and its result is passed to {@link #stepOutput(M2ManagedApplicationStepOutput)}.
         * 
         * @param stepOutput
         *        a consumer that will call methods on {@link M2ManagedApplicationStepOutput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stepOutput(M2ManagedApplicationStepOutput)
         */
        default Builder stepOutput(Consumer<M2ManagedApplicationStepOutput.Builder> stepOutput) {
            return stepOutput(M2ManagedApplicationStepOutput.builder().applyMutation(stepOutput).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private M2ManagedApplicationStepInput stepInput;

        private M2ManagedApplicationStepOutput stepOutput;

        private BuilderImpl() {
        }

        private BuilderImpl(M2ManagedApplicationStepSummary model) {
            stepInput(model.stepInput);
            stepOutput(model.stepOutput);
        }

        public final M2ManagedApplicationStepInput.Builder getStepInput() {
            return stepInput != null ? stepInput.toBuilder() : null;
        }

        public final void setStepInput(M2ManagedApplicationStepInput.BuilderImpl stepInput) {
            this.stepInput = stepInput != null ? stepInput.build() : null;
        }

        @Override
        public final Builder stepInput(M2ManagedApplicationStepInput stepInput) {
            this.stepInput = stepInput;
            return this;
        }

        public final M2ManagedApplicationStepOutput.Builder getStepOutput() {
            return stepOutput != null ? stepOutput.toBuilder() : null;
        }

        public final void setStepOutput(M2ManagedApplicationStepOutput.BuilderImpl stepOutput) {
            this.stepOutput = stepOutput != null ? stepOutput.build() : null;
        }

        @Override
        public final Builder stepOutput(M2ManagedApplicationStepOutput stepOutput) {
            this.stepOutput = stepOutput;
            return this;
        }

        @Override
        public M2ManagedApplicationStepSummary build() {
            return new M2ManagedApplicationStepSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
