/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apptest.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the scripts summary.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ScriptSummary implements SdkPojo, Serializable, ToCopyableBuilder<ScriptSummary.Builder, ScriptSummary> {
    private static final SdkField<String> SCRIPT_LOCATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("scriptLocation").getter(getter(ScriptSummary::scriptLocation)).setter(setter(Builder::scriptLocation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scriptLocation").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(ScriptSummary::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCRIPT_LOCATION_FIELD,
            TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String scriptLocation;

    private final String type;

    private ScriptSummary(BuilderImpl builder) {
        this.scriptLocation = builder.scriptLocation;
        this.type = builder.type;
    }

    /**
     * <p>
     * The script location of the script summary.
     * </p>
     * 
     * @return The script location of the script summary.
     */
    public final String scriptLocation() {
        return scriptLocation;
    }

    /**
     * <p>
     * The type of the script summary.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ScriptType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the script summary.
     * @see ScriptType
     */
    public final ScriptType type() {
        return ScriptType.fromValue(type);
    }

    /**
     * <p>
     * The type of the script summary.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ScriptType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the script summary.
     * @see ScriptType
     */
    public final String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(scriptLocation());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScriptSummary)) {
            return false;
        }
        ScriptSummary other = (ScriptSummary) obj;
        return Objects.equals(scriptLocation(), other.scriptLocation()) && Objects.equals(typeAsString(), other.typeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ScriptSummary").add("ScriptLocation", scriptLocation()).add("Type", typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "scriptLocation":
            return Optional.ofNullable(clazz.cast(scriptLocation()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("scriptLocation", SCRIPT_LOCATION_FIELD);
        map.put("type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ScriptSummary, T> g) {
        return obj -> g.apply((ScriptSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ScriptSummary> {
        /**
         * <p>
         * The script location of the script summary.
         * </p>
         * 
         * @param scriptLocation
         *        The script location of the script summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scriptLocation(String scriptLocation);

        /**
         * <p>
         * The type of the script summary.
         * </p>
         * 
         * @param type
         *        The type of the script summary.
         * @see ScriptType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScriptType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of the script summary.
         * </p>
         * 
         * @param type
         *        The type of the script summary.
         * @see ScriptType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScriptType
         */
        Builder type(ScriptType type);
    }

    static final class BuilderImpl implements Builder {
        private String scriptLocation;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(ScriptSummary model) {
            scriptLocation(model.scriptLocation);
            type(model.type);
        }

        public final String getScriptLocation() {
            return scriptLocation;
        }

        public final void setScriptLocation(String scriptLocation) {
            this.scriptLocation = scriptLocation;
        }

        @Override
        public final Builder scriptLocation(String scriptLocation) {
            this.scriptLocation = scriptLocation;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ScriptType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public ScriptSummary build() {
            return new ScriptSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
