/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apptest.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines the step run summary.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StepRunSummary implements SdkPojo, Serializable, ToCopyableBuilder<StepRunSummary.Builder, StepRunSummary> {
    private static final SdkField<MainframeActionSummary> MAINFRAME_ACTION_FIELD = SdkField
            .<MainframeActionSummary> builder(MarshallingType.SDK_POJO).memberName("mainframeAction")
            .getter(getter(StepRunSummary::mainframeAction)).setter(setter(Builder::mainframeAction))
            .constructor(MainframeActionSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mainframeAction").build()).build();

    private static final SdkField<CompareActionSummary> COMPARE_ACTION_FIELD = SdkField
            .<CompareActionSummary> builder(MarshallingType.SDK_POJO).memberName("compareAction")
            .getter(getter(StepRunSummary::compareAction)).setter(setter(Builder::compareAction))
            .constructor(CompareActionSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("compareAction").build()).build();

    private static final SdkField<ResourceActionSummary> RESOURCE_ACTION_FIELD = SdkField
            .<ResourceActionSummary> builder(MarshallingType.SDK_POJO).memberName("resourceAction")
            .getter(getter(StepRunSummary::resourceAction)).setter(setter(Builder::resourceAction))
            .constructor(ResourceActionSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceAction").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAINFRAME_ACTION_FIELD,
            COMPARE_ACTION_FIELD, RESOURCE_ACTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final MainframeActionSummary mainframeAction;

    private final CompareActionSummary compareAction;

    private final ResourceActionSummary resourceAction;

    private final Type type;

    private StepRunSummary(BuilderImpl builder) {
        this.mainframeAction = builder.mainframeAction;
        this.compareAction = builder.compareAction;
        this.resourceAction = builder.resourceAction;
        this.type = builder.type;
    }

    /**
     * <p>
     * The mainframe action of the step run summary.
     * </p>
     * 
     * @return The mainframe action of the step run summary.
     */
    public final MainframeActionSummary mainframeAction() {
        return mainframeAction;
    }

    /**
     * <p>
     * The compare action of the step run summary.
     * </p>
     * 
     * @return The compare action of the step run summary.
     */
    public final CompareActionSummary compareAction() {
        return compareAction;
    }

    /**
     * <p>
     * The resource action of the step run summary.
     * </p>
     * 
     * @return The resource action of the step run summary.
     */
    public final ResourceActionSummary resourceAction() {
        return resourceAction;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(mainframeAction());
        hashCode = 31 * hashCode + Objects.hashCode(compareAction());
        hashCode = 31 * hashCode + Objects.hashCode(resourceAction());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StepRunSummary)) {
            return false;
        }
        StepRunSummary other = (StepRunSummary) obj;
        return Objects.equals(mainframeAction(), other.mainframeAction())
                && Objects.equals(compareAction(), other.compareAction())
                && Objects.equals(resourceAction(), other.resourceAction());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StepRunSummary").add("MainframeAction", mainframeAction()).add("CompareAction", compareAction())
                .add("ResourceAction", resourceAction()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "mainframeAction":
            return Optional.ofNullable(clazz.cast(mainframeAction()));
        case "compareAction":
            return Optional.ofNullable(clazz.cast(compareAction()));
        case "resourceAction":
            return Optional.ofNullable(clazz.cast(resourceAction()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #mainframeAction()} initialized to the given value.
     *
     * <p>
     * The mainframe action of the step run summary.
     * </p>
     * 
     * @param mainframeAction
     *        The mainframe action of the step run summary.
     */
    public static StepRunSummary fromMainframeAction(MainframeActionSummary mainframeAction) {
        return builder().mainframeAction(mainframeAction).build();
    }

    /**
     * Create an instance of this class with {@link #mainframeAction()} initialized to the given value.
     *
     * <p>
     * The mainframe action of the step run summary.
     * </p>
     * 
     * @param mainframeAction
     *        The mainframe action of the step run summary.
     */
    public static StepRunSummary fromMainframeAction(Consumer<MainframeActionSummary.Builder> mainframeAction) {
        MainframeActionSummary.Builder builder = MainframeActionSummary.builder();
        mainframeAction.accept(builder);
        return fromMainframeAction(builder.build());
    }

    /**
     * Create an instance of this class with {@link #compareAction()} initialized to the given value.
     *
     * <p>
     * The compare action of the step run summary.
     * </p>
     * 
     * @param compareAction
     *        The compare action of the step run summary.
     */
    public static StepRunSummary fromCompareAction(CompareActionSummary compareAction) {
        return builder().compareAction(compareAction).build();
    }

    /**
     * Create an instance of this class with {@link #compareAction()} initialized to the given value.
     *
     * <p>
     * The compare action of the step run summary.
     * </p>
     * 
     * @param compareAction
     *        The compare action of the step run summary.
     */
    public static StepRunSummary fromCompareAction(Consumer<CompareActionSummary.Builder> compareAction) {
        CompareActionSummary.Builder builder = CompareActionSummary.builder();
        compareAction.accept(builder);
        return fromCompareAction(builder.build());
    }

    /**
     * Create an instance of this class with {@link #resourceAction()} initialized to the given value.
     *
     * <p>
     * The resource action of the step run summary.
     * </p>
     * 
     * @param resourceAction
     *        The resource action of the step run summary.
     */
    public static StepRunSummary fromResourceAction(ResourceActionSummary resourceAction) {
        return builder().resourceAction(resourceAction).build();
    }

    /**
     * Create an instance of this class with {@link #resourceAction()} initialized to the given value.
     *
     * <p>
     * The resource action of the step run summary.
     * </p>
     * 
     * @param resourceAction
     *        The resource action of the step run summary.
     */
    public static StepRunSummary fromResourceAction(Consumer<ResourceActionSummary.Builder> resourceAction) {
        ResourceActionSummary.Builder builder = ResourceActionSummary.builder();
        resourceAction.accept(builder);
        return fromResourceAction(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("mainframeAction", MAINFRAME_ACTION_FIELD);
        map.put("compareAction", COMPARE_ACTION_FIELD);
        map.put("resourceAction", RESOURCE_ACTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StepRunSummary, T> g) {
        return obj -> g.apply((StepRunSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StepRunSummary> {
        /**
         * <p>
         * The mainframe action of the step run summary.
         * </p>
         * 
         * @param mainframeAction
         *        The mainframe action of the step run summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mainframeAction(MainframeActionSummary mainframeAction);

        /**
         * <p>
         * The mainframe action of the step run summary.
         * </p>
         * This is a convenience method that creates an instance of the {@link MainframeActionSummary.Builder} avoiding
         * the need to create one manually via {@link MainframeActionSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MainframeActionSummary.Builder#build()} is called immediately and
         * its result is passed to {@link #mainframeAction(MainframeActionSummary)}.
         * 
         * @param mainframeAction
         *        a consumer that will call methods on {@link MainframeActionSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #mainframeAction(MainframeActionSummary)
         */
        default Builder mainframeAction(Consumer<MainframeActionSummary.Builder> mainframeAction) {
            return mainframeAction(MainframeActionSummary.builder().applyMutation(mainframeAction).build());
        }

        /**
         * <p>
         * The compare action of the step run summary.
         * </p>
         * 
         * @param compareAction
         *        The compare action of the step run summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder compareAction(CompareActionSummary compareAction);

        /**
         * <p>
         * The compare action of the step run summary.
         * </p>
         * This is a convenience method that creates an instance of the {@link CompareActionSummary.Builder} avoiding
         * the need to create one manually via {@link CompareActionSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CompareActionSummary.Builder#build()} is called immediately and
         * its result is passed to {@link #compareAction(CompareActionSummary)}.
         * 
         * @param compareAction
         *        a consumer that will call methods on {@link CompareActionSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #compareAction(CompareActionSummary)
         */
        default Builder compareAction(Consumer<CompareActionSummary.Builder> compareAction) {
            return compareAction(CompareActionSummary.builder().applyMutation(compareAction).build());
        }

        /**
         * <p>
         * The resource action of the step run summary.
         * </p>
         * 
         * @param resourceAction
         *        The resource action of the step run summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceAction(ResourceActionSummary resourceAction);

        /**
         * <p>
         * The resource action of the step run summary.
         * </p>
         * This is a convenience method that creates an instance of the {@link ResourceActionSummary.Builder} avoiding
         * the need to create one manually via {@link ResourceActionSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ResourceActionSummary.Builder#build()} is called immediately and
         * its result is passed to {@link #resourceAction(ResourceActionSummary)}.
         * 
         * @param resourceAction
         *        a consumer that will call methods on {@link ResourceActionSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceAction(ResourceActionSummary)
         */
        default Builder resourceAction(Consumer<ResourceActionSummary.Builder> resourceAction) {
            return resourceAction(ResourceActionSummary.builder().applyMutation(resourceAction).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private MainframeActionSummary mainframeAction;

        private CompareActionSummary compareAction;

        private ResourceActionSummary resourceAction;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(StepRunSummary model) {
            mainframeAction(model.mainframeAction);
            compareAction(model.compareAction);
            resourceAction(model.resourceAction);
        }

        public final MainframeActionSummary.Builder getMainframeAction() {
            return mainframeAction != null ? mainframeAction.toBuilder() : null;
        }

        public final void setMainframeAction(MainframeActionSummary.BuilderImpl mainframeAction) {
            Object oldValue = this.mainframeAction;
            this.mainframeAction = mainframeAction != null ? mainframeAction.build() : null;
            handleUnionValueChange(Type.MAINFRAME_ACTION, oldValue, this.mainframeAction);
        }

        @Override
        public final Builder mainframeAction(MainframeActionSummary mainframeAction) {
            Object oldValue = this.mainframeAction;
            this.mainframeAction = mainframeAction;
            handleUnionValueChange(Type.MAINFRAME_ACTION, oldValue, this.mainframeAction);
            return this;
        }

        public final CompareActionSummary.Builder getCompareAction() {
            return compareAction != null ? compareAction.toBuilder() : null;
        }

        public final void setCompareAction(CompareActionSummary.BuilderImpl compareAction) {
            Object oldValue = this.compareAction;
            this.compareAction = compareAction != null ? compareAction.build() : null;
            handleUnionValueChange(Type.COMPARE_ACTION, oldValue, this.compareAction);
        }

        @Override
        public final Builder compareAction(CompareActionSummary compareAction) {
            Object oldValue = this.compareAction;
            this.compareAction = compareAction;
            handleUnionValueChange(Type.COMPARE_ACTION, oldValue, this.compareAction);
            return this;
        }

        public final ResourceActionSummary.Builder getResourceAction() {
            return resourceAction != null ? resourceAction.toBuilder() : null;
        }

        public final void setResourceAction(ResourceActionSummary.BuilderImpl resourceAction) {
            Object oldValue = this.resourceAction;
            this.resourceAction = resourceAction != null ? resourceAction.build() : null;
            handleUnionValueChange(Type.RESOURCE_ACTION, oldValue, this.resourceAction);
        }

        @Override
        public final Builder resourceAction(ResourceActionSummary resourceAction) {
            Object oldValue = this.resourceAction;
            this.resourceAction = resourceAction;
            handleUnionValueChange(Type.RESOURCE_ACTION, oldValue, this.resourceAction);
            return this;
        }

        @Override
        public StepRunSummary build() {
            return new StepRunSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see StepRunSummary#type()
     */
    public enum Type {
        MAINFRAME_ACTION,

        COMPARE_ACTION,

        RESOURCE_ACTION,

        UNKNOWN_TO_SDK_VERSION
    }
}
