/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apptest.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the TN3270 protocol.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TN3270 implements SdkPojo, Serializable, ToCopyableBuilder<TN3270.Builder, TN3270> {
    private static final SdkField<Script> SCRIPT_FIELD = SdkField.<Script> builder(MarshallingType.SDK_POJO).memberName("script")
            .getter(getter(TN3270::script)).setter(setter(Builder::script)).constructor(Script::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("script").build()).build();

    private static final SdkField<List<String>> EXPORT_DATA_SET_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("exportDataSetNames")
            .getter(getter(TN3270::exportDataSetNames))
            .setter(setter(Builder::exportDataSetNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exportDataSetNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCRIPT_FIELD,
            EXPORT_DATA_SET_NAMES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Script script;

    private final List<String> exportDataSetNames;

    private TN3270(BuilderImpl builder) {
        this.script = builder.script;
        this.exportDataSetNames = builder.exportDataSetNames;
    }

    /**
     * <p>
     * The script of the TN3270 protocol.
     * </p>
     * 
     * @return The script of the TN3270 protocol.
     */
    public final Script script() {
        return script;
    }

    /**
     * For responses, this returns true if the service returned a value for the ExportDataSetNames property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasExportDataSetNames() {
        return exportDataSetNames != null && !(exportDataSetNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The data set names of the TN3270 protocol.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasExportDataSetNames} method.
     * </p>
     * 
     * @return The data set names of the TN3270 protocol.
     */
    public final List<String> exportDataSetNames() {
        return exportDataSetNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(script());
        hashCode = 31 * hashCode + Objects.hashCode(hasExportDataSetNames() ? exportDataSetNames() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TN3270)) {
            return false;
        }
        TN3270 other = (TN3270) obj;
        return Objects.equals(script(), other.script()) && hasExportDataSetNames() == other.hasExportDataSetNames()
                && Objects.equals(exportDataSetNames(), other.exportDataSetNames());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TN3270").add("Script", script())
                .add("ExportDataSetNames", hasExportDataSetNames() ? exportDataSetNames() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "script":
            return Optional.ofNullable(clazz.cast(script()));
        case "exportDataSetNames":
            return Optional.ofNullable(clazz.cast(exportDataSetNames()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("script", SCRIPT_FIELD);
        map.put("exportDataSetNames", EXPORT_DATA_SET_NAMES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TN3270, T> g) {
        return obj -> g.apply((TN3270) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TN3270> {
        /**
         * <p>
         * The script of the TN3270 protocol.
         * </p>
         * 
         * @param script
         *        The script of the TN3270 protocol.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder script(Script script);

        /**
         * <p>
         * The script of the TN3270 protocol.
         * </p>
         * This is a convenience method that creates an instance of the {@link Script.Builder} avoiding the need to
         * create one manually via {@link Script#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Script.Builder#build()} is called immediately and its result is
         * passed to {@link #script(Script)}.
         * 
         * @param script
         *        a consumer that will call methods on {@link Script.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #script(Script)
         */
        default Builder script(Consumer<Script.Builder> script) {
            return script(Script.builder().applyMutation(script).build());
        }

        /**
         * <p>
         * The data set names of the TN3270 protocol.
         * </p>
         * 
         * @param exportDataSetNames
         *        The data set names of the TN3270 protocol.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportDataSetNames(Collection<String> exportDataSetNames);

        /**
         * <p>
         * The data set names of the TN3270 protocol.
         * </p>
         * 
         * @param exportDataSetNames
         *        The data set names of the TN3270 protocol.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportDataSetNames(String... exportDataSetNames);
    }

    static final class BuilderImpl implements Builder {
        private Script script;

        private List<String> exportDataSetNames = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TN3270 model) {
            script(model.script);
            exportDataSetNames(model.exportDataSetNames);
        }

        public final Script.Builder getScript() {
            return script != null ? script.toBuilder() : null;
        }

        public final void setScript(Script.BuilderImpl script) {
            this.script = script != null ? script.build() : null;
        }

        @Override
        public final Builder script(Script script) {
            this.script = script;
            return this;
        }

        public final Collection<String> getExportDataSetNames() {
            if (exportDataSetNames instanceof SdkAutoConstructList) {
                return null;
            }
            return exportDataSetNames;
        }

        public final void setExportDataSetNames(Collection<String> exportDataSetNames) {
            this.exportDataSetNames = ExportDataSetNamesCopier.copy(exportDataSetNames);
        }

        @Override
        public final Builder exportDataSetNames(Collection<String> exportDataSetNames) {
            this.exportDataSetNames = ExportDataSetNamesCopier.copy(exportDataSetNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exportDataSetNames(String... exportDataSetNames) {
            exportDataSetNames(Arrays.asList(exportDataSetNames));
            return this;
        }

        @Override
        public TN3270 build() {
            return new TN3270(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
