/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apptest.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies a test run step summary.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TestRunStepSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<TestRunStepSummary.Builder, TestRunStepSummary> {
    private static final SdkField<String> STEP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("stepName").getter(getter(TestRunStepSummary::stepName)).setter(setter(Builder::stepName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stepName").build()).build();

    private static final SdkField<String> TEST_RUN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("testRunId").getter(getter(TestRunStepSummary::testRunId)).setter(setter(Builder::testRunId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testRunId").build()).build();

    private static final SdkField<String> TEST_CASE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("testCaseId").getter(getter(TestRunStepSummary::testCaseId)).setter(setter(Builder::testCaseId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testCaseId").build()).build();

    private static final SdkField<Integer> TEST_CASE_VERSION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("testCaseVersion").getter(getter(TestRunStepSummary::testCaseVersion))
            .setter(setter(Builder::testCaseVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testCaseVersion").build()).build();

    private static final SdkField<String> TEST_SUITE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("testSuiteId").getter(getter(TestRunStepSummary::testSuiteId)).setter(setter(Builder::testSuiteId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testSuiteId").build()).build();

    private static final SdkField<Integer> TEST_SUITE_VERSION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("testSuiteVersion").getter(getter(TestRunStepSummary::testSuiteVersion))
            .setter(setter(Builder::testSuiteVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testSuiteVersion").build()).build();

    private static final SdkField<Boolean> BEFORE_STEP_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("beforeStep").getter(getter(TestRunStepSummary::beforeStep)).setter(setter(Builder::beforeStep))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("beforeStep").build()).build();

    private static final SdkField<Boolean> AFTER_STEP_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("afterStep").getter(getter(TestRunStepSummary::afterStep)).setter(setter(Builder::afterStep))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("afterStep").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(TestRunStepSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> STATUS_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("statusReason").getter(getter(TestRunStepSummary::statusReason)).setter(setter(Builder::statusReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusReason").build()).build();

    private static final SdkField<Instant> RUN_START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("runStartTime").getter(getter(TestRunStepSummary::runStartTime)).setter(setter(Builder::runStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runStartTime").build()).build();

    private static final SdkField<Instant> RUN_END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("runEndTime").getter(getter(TestRunStepSummary::runEndTime)).setter(setter(Builder::runEndTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runEndTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STEP_NAME_FIELD,
            TEST_RUN_ID_FIELD, TEST_CASE_ID_FIELD, TEST_CASE_VERSION_FIELD, TEST_SUITE_ID_FIELD, TEST_SUITE_VERSION_FIELD,
            BEFORE_STEP_FIELD, AFTER_STEP_FIELD, STATUS_FIELD, STATUS_REASON_FIELD, RUN_START_TIME_FIELD, RUN_END_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String stepName;

    private final String testRunId;

    private final String testCaseId;

    private final Integer testCaseVersion;

    private final String testSuiteId;

    private final Integer testSuiteVersion;

    private final Boolean beforeStep;

    private final Boolean afterStep;

    private final String status;

    private final String statusReason;

    private final Instant runStartTime;

    private final Instant runEndTime;

    private TestRunStepSummary(BuilderImpl builder) {
        this.stepName = builder.stepName;
        this.testRunId = builder.testRunId;
        this.testCaseId = builder.testCaseId;
        this.testCaseVersion = builder.testCaseVersion;
        this.testSuiteId = builder.testSuiteId;
        this.testSuiteVersion = builder.testSuiteVersion;
        this.beforeStep = builder.beforeStep;
        this.afterStep = builder.afterStep;
        this.status = builder.status;
        this.statusReason = builder.statusReason;
        this.runStartTime = builder.runStartTime;
        this.runEndTime = builder.runEndTime;
    }

    /**
     * <p>
     * The step name of the test run step summary.
     * </p>
     * 
     * @return The step name of the test run step summary.
     */
    public final String stepName() {
        return stepName;
    }

    /**
     * <p>
     * The test run ID of the test run step summary.
     * </p>
     * 
     * @return The test run ID of the test run step summary.
     */
    public final String testRunId() {
        return testRunId;
    }

    /**
     * <p>
     * The test case ID of the test run step summary.
     * </p>
     * 
     * @return The test case ID of the test run step summary.
     */
    public final String testCaseId() {
        return testCaseId;
    }

    /**
     * <p>
     * The test case version of the test run step summary.
     * </p>
     * 
     * @return The test case version of the test run step summary.
     */
    public final Integer testCaseVersion() {
        return testCaseVersion;
    }

    /**
     * <p>
     * The test suite ID of the test run step summary.
     * </p>
     * 
     * @return The test suite ID of the test run step summary.
     */
    public final String testSuiteId() {
        return testSuiteId;
    }

    /**
     * <p>
     * The test suite version of the test run step summary.
     * </p>
     * 
     * @return The test suite version of the test run step summary.
     */
    public final Integer testSuiteVersion() {
        return testSuiteVersion;
    }

    /**
     * <p>
     * The before step of the test run step summary.
     * </p>
     * 
     * @return The before step of the test run step summary.
     */
    public final Boolean beforeStep() {
        return beforeStep;
    }

    /**
     * <p>
     * The after step of the test run step summary.
     * </p>
     * 
     * @return The after step of the test run step summary.
     */
    public final Boolean afterStep() {
        return afterStep;
    }

    /**
     * <p>
     * The status of the test run step summary.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link StepRunStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the test run step summary.
     * @see StepRunStatus
     */
    public final StepRunStatus status() {
        return StepRunStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the test run step summary.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link StepRunStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the test run step summary.
     * @see StepRunStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The status reason of the test run step summary.
     * </p>
     * 
     * @return The status reason of the test run step summary.
     */
    public final String statusReason() {
        return statusReason;
    }

    /**
     * <p>
     * The run start time of the test run step summary.
     * </p>
     * 
     * @return The run start time of the test run step summary.
     */
    public final Instant runStartTime() {
        return runStartTime;
    }

    /**
     * <p>
     * The run end time of the test run step summary.
     * </p>
     * 
     * @return The run end time of the test run step summary.
     */
    public final Instant runEndTime() {
        return runEndTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stepName());
        hashCode = 31 * hashCode + Objects.hashCode(testRunId());
        hashCode = 31 * hashCode + Objects.hashCode(testCaseId());
        hashCode = 31 * hashCode + Objects.hashCode(testCaseVersion());
        hashCode = 31 * hashCode + Objects.hashCode(testSuiteId());
        hashCode = 31 * hashCode + Objects.hashCode(testSuiteVersion());
        hashCode = 31 * hashCode + Objects.hashCode(beforeStep());
        hashCode = 31 * hashCode + Objects.hashCode(afterStep());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusReason());
        hashCode = 31 * hashCode + Objects.hashCode(runStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(runEndTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TestRunStepSummary)) {
            return false;
        }
        TestRunStepSummary other = (TestRunStepSummary) obj;
        return Objects.equals(stepName(), other.stepName()) && Objects.equals(testRunId(), other.testRunId())
                && Objects.equals(testCaseId(), other.testCaseId()) && Objects.equals(testCaseVersion(), other.testCaseVersion())
                && Objects.equals(testSuiteId(), other.testSuiteId())
                && Objects.equals(testSuiteVersion(), other.testSuiteVersion())
                && Objects.equals(beforeStep(), other.beforeStep()) && Objects.equals(afterStep(), other.afterStep())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusReason(), other.statusReason()) && Objects.equals(runStartTime(), other.runStartTime())
                && Objects.equals(runEndTime(), other.runEndTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TestRunStepSummary").add("StepName", stepName()).add("TestRunId", testRunId())
                .add("TestCaseId", testCaseId()).add("TestCaseVersion", testCaseVersion()).add("TestSuiteId", testSuiteId())
                .add("TestSuiteVersion", testSuiteVersion()).add("BeforeStep", beforeStep()).add("AfterStep", afterStep())
                .add("Status", statusAsString()).add("StatusReason", statusReason()).add("RunStartTime", runStartTime())
                .add("RunEndTime", runEndTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "stepName":
            return Optional.ofNullable(clazz.cast(stepName()));
        case "testRunId":
            return Optional.ofNullable(clazz.cast(testRunId()));
        case "testCaseId":
            return Optional.ofNullable(clazz.cast(testCaseId()));
        case "testCaseVersion":
            return Optional.ofNullable(clazz.cast(testCaseVersion()));
        case "testSuiteId":
            return Optional.ofNullable(clazz.cast(testSuiteId()));
        case "testSuiteVersion":
            return Optional.ofNullable(clazz.cast(testSuiteVersion()));
        case "beforeStep":
            return Optional.ofNullable(clazz.cast(beforeStep()));
        case "afterStep":
            return Optional.ofNullable(clazz.cast(afterStep()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "statusReason":
            return Optional.ofNullable(clazz.cast(statusReason()));
        case "runStartTime":
            return Optional.ofNullable(clazz.cast(runStartTime()));
        case "runEndTime":
            return Optional.ofNullable(clazz.cast(runEndTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("stepName", STEP_NAME_FIELD);
        map.put("testRunId", TEST_RUN_ID_FIELD);
        map.put("testCaseId", TEST_CASE_ID_FIELD);
        map.put("testCaseVersion", TEST_CASE_VERSION_FIELD);
        map.put("testSuiteId", TEST_SUITE_ID_FIELD);
        map.put("testSuiteVersion", TEST_SUITE_VERSION_FIELD);
        map.put("beforeStep", BEFORE_STEP_FIELD);
        map.put("afterStep", AFTER_STEP_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("statusReason", STATUS_REASON_FIELD);
        map.put("runStartTime", RUN_START_TIME_FIELD);
        map.put("runEndTime", RUN_END_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TestRunStepSummary, T> g) {
        return obj -> g.apply((TestRunStepSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TestRunStepSummary> {
        /**
         * <p>
         * The step name of the test run step summary.
         * </p>
         * 
         * @param stepName
         *        The step name of the test run step summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stepName(String stepName);

        /**
         * <p>
         * The test run ID of the test run step summary.
         * </p>
         * 
         * @param testRunId
         *        The test run ID of the test run step summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder testRunId(String testRunId);

        /**
         * <p>
         * The test case ID of the test run step summary.
         * </p>
         * 
         * @param testCaseId
         *        The test case ID of the test run step summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder testCaseId(String testCaseId);

        /**
         * <p>
         * The test case version of the test run step summary.
         * </p>
         * 
         * @param testCaseVersion
         *        The test case version of the test run step summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder testCaseVersion(Integer testCaseVersion);

        /**
         * <p>
         * The test suite ID of the test run step summary.
         * </p>
         * 
         * @param testSuiteId
         *        The test suite ID of the test run step summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder testSuiteId(String testSuiteId);

        /**
         * <p>
         * The test suite version of the test run step summary.
         * </p>
         * 
         * @param testSuiteVersion
         *        The test suite version of the test run step summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder testSuiteVersion(Integer testSuiteVersion);

        /**
         * <p>
         * The before step of the test run step summary.
         * </p>
         * 
         * @param beforeStep
         *        The before step of the test run step summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder beforeStep(Boolean beforeStep);

        /**
         * <p>
         * The after step of the test run step summary.
         * </p>
         * 
         * @param afterStep
         *        The after step of the test run step summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder afterStep(Boolean afterStep);

        /**
         * <p>
         * The status of the test run step summary.
         * </p>
         * 
         * @param status
         *        The status of the test run step summary.
         * @see StepRunStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StepRunStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the test run step summary.
         * </p>
         * 
         * @param status
         *        The status of the test run step summary.
         * @see StepRunStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StepRunStatus
         */
        Builder status(StepRunStatus status);

        /**
         * <p>
         * The status reason of the test run step summary.
         * </p>
         * 
         * @param statusReason
         *        The status reason of the test run step summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusReason(String statusReason);

        /**
         * <p>
         * The run start time of the test run step summary.
         * </p>
         * 
         * @param runStartTime
         *        The run start time of the test run step summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runStartTime(Instant runStartTime);

        /**
         * <p>
         * The run end time of the test run step summary.
         * </p>
         * 
         * @param runEndTime
         *        The run end time of the test run step summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runEndTime(Instant runEndTime);
    }

    static final class BuilderImpl implements Builder {
        private String stepName;

        private String testRunId;

        private String testCaseId;

        private Integer testCaseVersion;

        private String testSuiteId;

        private Integer testSuiteVersion;

        private Boolean beforeStep;

        private Boolean afterStep;

        private String status;

        private String statusReason;

        private Instant runStartTime;

        private Instant runEndTime;

        private BuilderImpl() {
        }

        private BuilderImpl(TestRunStepSummary model) {
            stepName(model.stepName);
            testRunId(model.testRunId);
            testCaseId(model.testCaseId);
            testCaseVersion(model.testCaseVersion);
            testSuiteId(model.testSuiteId);
            testSuiteVersion(model.testSuiteVersion);
            beforeStep(model.beforeStep);
            afterStep(model.afterStep);
            status(model.status);
            statusReason(model.statusReason);
            runStartTime(model.runStartTime);
            runEndTime(model.runEndTime);
        }

        public final String getStepName() {
            return stepName;
        }

        public final void setStepName(String stepName) {
            this.stepName = stepName;
        }

        @Override
        public final Builder stepName(String stepName) {
            this.stepName = stepName;
            return this;
        }

        public final String getTestRunId() {
            return testRunId;
        }

        public final void setTestRunId(String testRunId) {
            this.testRunId = testRunId;
        }

        @Override
        public final Builder testRunId(String testRunId) {
            this.testRunId = testRunId;
            return this;
        }

        public final String getTestCaseId() {
            return testCaseId;
        }

        public final void setTestCaseId(String testCaseId) {
            this.testCaseId = testCaseId;
        }

        @Override
        public final Builder testCaseId(String testCaseId) {
            this.testCaseId = testCaseId;
            return this;
        }

        public final Integer getTestCaseVersion() {
            return testCaseVersion;
        }

        public final void setTestCaseVersion(Integer testCaseVersion) {
            this.testCaseVersion = testCaseVersion;
        }

        @Override
        public final Builder testCaseVersion(Integer testCaseVersion) {
            this.testCaseVersion = testCaseVersion;
            return this;
        }

        public final String getTestSuiteId() {
            return testSuiteId;
        }

        public final void setTestSuiteId(String testSuiteId) {
            this.testSuiteId = testSuiteId;
        }

        @Override
        public final Builder testSuiteId(String testSuiteId) {
            this.testSuiteId = testSuiteId;
            return this;
        }

        public final Integer getTestSuiteVersion() {
            return testSuiteVersion;
        }

        public final void setTestSuiteVersion(Integer testSuiteVersion) {
            this.testSuiteVersion = testSuiteVersion;
        }

        @Override
        public final Builder testSuiteVersion(Integer testSuiteVersion) {
            this.testSuiteVersion = testSuiteVersion;
            return this;
        }

        public final Boolean getBeforeStep() {
            return beforeStep;
        }

        public final void setBeforeStep(Boolean beforeStep) {
            this.beforeStep = beforeStep;
        }

        @Override
        public final Builder beforeStep(Boolean beforeStep) {
            this.beforeStep = beforeStep;
            return this;
        }

        public final Boolean getAfterStep() {
            return afterStep;
        }

        public final void setAfterStep(Boolean afterStep) {
            this.afterStep = afterStep;
        }

        @Override
        public final Builder afterStep(Boolean afterStep) {
            this.afterStep = afterStep;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(StepRunStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusReason() {
            return statusReason;
        }

        public final void setStatusReason(String statusReason) {
            this.statusReason = statusReason;
        }

        @Override
        public final Builder statusReason(String statusReason) {
            this.statusReason = statusReason;
            return this;
        }

        public final Instant getRunStartTime() {
            return runStartTime;
        }

        public final void setRunStartTime(Instant runStartTime) {
            this.runStartTime = runStartTime;
        }

        @Override
        public final Builder runStartTime(Instant runStartTime) {
            this.runStartTime = runStartTime;
            return this;
        }

        public final Instant getRunEndTime() {
            return runEndTime;
        }

        public final void setRunEndTime(Instant runEndTime) {
            this.runEndTime = runEndTime;
        }

        @Override
        public final Builder runEndTime(Instant runEndTime) {
            this.runEndTime = runEndTime;
            return this;
        }

        @Override
        public TestRunStepSummary build() {
            return new TestRunStepSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
