/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.apptest.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateTestCaseRequest extends AppTestRequest implements
        ToCopyableBuilder<UpdateTestCaseRequest.Builder, UpdateTestCaseRequest> {
    private static final SdkField<String> TEST_CASE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("testCaseId").getter(getter(UpdateTestCaseRequest::testCaseId)).setter(setter(Builder::testCaseId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("testCaseId").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(UpdateTestCaseRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<List<Step>> STEPS_FIELD = SdkField
            .<List<Step>> builder(MarshallingType.LIST)
            .memberName("steps")
            .getter(getter(UpdateTestCaseRequest::steps))
            .setter(setter(Builder::steps))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("steps").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Step> builder(MarshallingType.SDK_POJO)
                                            .constructor(Step::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEST_CASE_ID_FIELD,
            DESCRIPTION_FIELD, STEPS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String testCaseId;

    private final String description;

    private final List<Step> steps;

    private UpdateTestCaseRequest(BuilderImpl builder) {
        super(builder);
        this.testCaseId = builder.testCaseId;
        this.description = builder.description;
        this.steps = builder.steps;
    }

    /**
     * <p>
     * The test case ID of the test case.
     * </p>
     * 
     * @return The test case ID of the test case.
     */
    public final String testCaseId() {
        return testCaseId;
    }

    /**
     * <p>
     * The description of the test case.
     * </p>
     * 
     * @return The description of the test case.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the Steps property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasSteps() {
        return steps != null && !(steps instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The steps of the test case.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSteps} method.
     * </p>
     * 
     * @return The steps of the test case.
     */
    public final List<Step> steps() {
        return steps;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(testCaseId());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasSteps() ? steps() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateTestCaseRequest)) {
            return false;
        }
        UpdateTestCaseRequest other = (UpdateTestCaseRequest) obj;
        return Objects.equals(testCaseId(), other.testCaseId()) && Objects.equals(description(), other.description())
                && hasSteps() == other.hasSteps() && Objects.equals(steps(), other.steps());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateTestCaseRequest").add("TestCaseId", testCaseId()).add("Description", description())
                .add("Steps", hasSteps() ? steps() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "testCaseId":
            return Optional.ofNullable(clazz.cast(testCaseId()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "steps":
            return Optional.ofNullable(clazz.cast(steps()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("testCaseId", TEST_CASE_ID_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("steps", STEPS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateTestCaseRequest, T> g) {
        return obj -> g.apply((UpdateTestCaseRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends AppTestRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateTestCaseRequest> {
        /**
         * <p>
         * The test case ID of the test case.
         * </p>
         * 
         * @param testCaseId
         *        The test case ID of the test case.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder testCaseId(String testCaseId);

        /**
         * <p>
         * The description of the test case.
         * </p>
         * 
         * @param description
         *        The description of the test case.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The steps of the test case.
         * </p>
         * 
         * @param steps
         *        The steps of the test case.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder steps(Collection<Step> steps);

        /**
         * <p>
         * The steps of the test case.
         * </p>
         * 
         * @param steps
         *        The steps of the test case.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder steps(Step... steps);

        /**
         * <p>
         * The steps of the test case.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.apptest.model.Step.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.apptest.model.Step#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.apptest.model.Step.Builder#build()} is called immediately and its
         * result is passed to {@link #steps(List<Step>)}.
         * 
         * @param steps
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.apptest.model.Step.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #steps(java.util.Collection<Step>)
         */
        Builder steps(Consumer<Step.Builder>... steps);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AppTestRequest.BuilderImpl implements Builder {
        private String testCaseId;

        private String description;

        private List<Step> steps = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateTestCaseRequest model) {
            super(model);
            testCaseId(model.testCaseId);
            description(model.description);
            steps(model.steps);
        }

        public final String getTestCaseId() {
            return testCaseId;
        }

        public final void setTestCaseId(String testCaseId) {
            this.testCaseId = testCaseId;
        }

        @Override
        public final Builder testCaseId(String testCaseId) {
            this.testCaseId = testCaseId;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<Step.Builder> getSteps() {
            List<Step.Builder> result = StepListCopier.copyToBuilder(this.steps);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSteps(Collection<Step.BuilderImpl> steps) {
            this.steps = StepListCopier.copyFromBuilder(steps);
        }

        @Override
        public final Builder steps(Collection<Step> steps) {
            this.steps = StepListCopier.copy(steps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder steps(Step... steps) {
            steps(Arrays.asList(steps));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder steps(Consumer<Step.Builder>... steps) {
            steps(Stream.of(steps).map(c -> Step.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateTestCaseRequest build() {
            return new UpdateTestCaseRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
