/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apptest.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.apptest.model.AppTestRequest;
import software.amazon.awssdk.services.apptest.model.PropertiesCopier;
import software.amazon.awssdk.services.apptest.model.Resource;
import software.amazon.awssdk.services.apptest.model.ResourceListCopier;
import software.amazon.awssdk.services.apptest.model.ServiceSettings;
import software.amazon.awssdk.services.apptest.model.TagMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateTestConfigurationRequest
extends AppTestRequest
implements ToCopyableBuilder<Builder, CreateTestConfigurationRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreateTestConfigurationRequest.getter(CreateTestConfigurationRequest::name)).setter(CreateTestConfigurationRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CreateTestConfigurationRequest.getter(CreateTestConfigurationRequest::description)).setter(CreateTestConfigurationRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<List<Resource>> RESOURCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("resources").getter(CreateTestConfigurationRequest.getter(CreateTestConfigurationRequest::resources)).setter(CreateTestConfigurationRequest.setter(Builder::resources)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resources").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Resource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("properties").getter(CreateTestConfigurationRequest.getter(CreateTestConfigurationRequest::properties)).setter(CreateTestConfigurationRequest.setter(Builder::properties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("properties").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateTestConfigurationRequest.getter(CreateTestConfigurationRequest::clientToken)).setter(CreateTestConfigurationRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(CreateTestConfigurationRequest.getter(CreateTestConfigurationRequest::tags)).setter(CreateTestConfigurationRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<ServiceSettings> SERVICE_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("serviceSettings").getter(CreateTestConfigurationRequest.getter(CreateTestConfigurationRequest::serviceSettings)).setter(CreateTestConfigurationRequest.setter(Builder::serviceSettings)).constructor(ServiceSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceSettings").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD, RESOURCES_FIELD, PROPERTIES_FIELD, CLIENT_TOKEN_FIELD, TAGS_FIELD, SERVICE_SETTINGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateTestConfigurationRequest.memberNameToFieldInitializer();
    private final String name;
    private final String description;
    private final List<Resource> resources;
    private final Map<String, String> properties;
    private final String clientToken;
    private final Map<String, String> tags;
    private final ServiceSettings serviceSettings;

    private CreateTestConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.resources = builder.resources;
        this.properties = builder.properties;
        this.clientToken = builder.clientToken;
        this.tags = builder.tags;
        this.serviceSettings = builder.serviceSettings;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasResources() {
        return this.resources != null && !(this.resources instanceof SdkAutoConstructList);
    }

    public final List<Resource> resources() {
        return this.resources;
    }

    public final boolean hasProperties() {
        return this.properties != null && !(this.properties instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> properties() {
        return this.properties;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final ServiceSettings serviceSettings() {
        return this.serviceSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResources() ? this.resources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProperties() ? this.properties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceSettings());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTestConfigurationRequest)) {
            return false;
        }
        CreateTestConfigurationRequest other = (CreateTestConfigurationRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && this.hasResources() == other.hasResources() && Objects.equals(this.resources(), other.resources()) && this.hasProperties() == other.hasProperties() && Objects.equals(this.properties(), other.properties()) && Objects.equals(this.clientToken(), other.clientToken()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.serviceSettings(), other.serviceSettings());
    }

    public final String toString() {
        return ToString.builder((String)"CreateTestConfigurationRequest").add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("Resources", this.hasResources() ? this.resources() : null).add("Properties", this.hasProperties() ? this.properties() : null).add("ClientToken", (Object)this.clientToken()).add("Tags", this.hasTags() ? this.tags() : null).add("ServiceSettings", (Object)this.serviceSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "resources": {
                return Optional.ofNullable(clazz.cast(this.resources()));
            }
            case "properties": {
                return Optional.ofNullable(clazz.cast(this.properties()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "serviceSettings": {
                return Optional.ofNullable(clazz.cast(this.serviceSettings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("resources", RESOURCES_FIELD);
        map.put("properties", PROPERTIES_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("serviceSettings", SERVICE_SETTINGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateTestConfigurationRequest, T> g) {
        return obj -> g.apply((CreateTestConfigurationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppTestRequest.BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private List<Resource> resources = DefaultSdkAutoConstructList.getInstance();
        private Map<String, String> properties = DefaultSdkAutoConstructMap.getInstance();
        private String clientToken;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private ServiceSettings serviceSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTestConfigurationRequest model) {
            super(model);
            this.name(model.name);
            this.description(model.description);
            this.resources(model.resources);
            this.properties(model.properties);
            this.clientToken(model.clientToken);
            this.tags(model.tags);
            this.serviceSettings(model.serviceSettings);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<Resource.Builder> getResources() {
            List<Resource.Builder> result = ResourceListCopier.copyToBuilder(this.resources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResources(Collection<Resource.BuilderImpl> resources) {
            this.resources = ResourceListCopier.copyFromBuilder(resources);
        }

        @Override
        public final Builder resources(Collection<Resource> resources) {
            this.resources = ResourceListCopier.copy(resources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resources(Resource ... resources) {
            this.resources(Arrays.asList(resources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resources(Consumer<Resource.Builder> ... resources) {
            this.resources(Stream.of(resources).map(c -> (Resource)((Resource.Builder)Resource.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Map<String, String> getProperties() {
            if (this.properties instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.properties;
        }

        public final void setProperties(Map<String, String> properties) {
            this.properties = PropertiesCopier.copy(properties);
        }

        @Override
        public final Builder properties(Map<String, String> properties) {
            this.properties = PropertiesCopier.copy(properties);
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final ServiceSettings.Builder getServiceSettings() {
            return this.serviceSettings != null ? this.serviceSettings.toBuilder() : null;
        }

        public final void setServiceSettings(ServiceSettings.BuilderImpl serviceSettings) {
            this.serviceSettings = serviceSettings != null ? serviceSettings.build() : null;
        }

        @Override
        public final Builder serviceSettings(ServiceSettings serviceSettings) {
            this.serviceSettings = serviceSettings;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateTestConfigurationRequest build() {
            return new CreateTestConfigurationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends AppTestRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateTestConfigurationRequest> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder resources(Collection<Resource> var1);

        public Builder resources(Resource ... var1);

        public Builder resources(Consumer<Resource.Builder> ... var1);

        public Builder properties(Map<String, String> var1);

        public Builder clientToken(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder serviceSettings(ServiceSettings var1);

        default public Builder serviceSettings(Consumer<ServiceSettings.Builder> serviceSettings) {
            return this.serviceSettings((ServiceSettings)((ServiceSettings.Builder)ServiceSettings.builder().applyMutation(serviceSettings)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

