/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.arcregionswitch.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum EvaluationStatus {
    PASSED("passed"),
    ACTION_REQUIRED("actionRequired"),
    PENDING_EVALUATION("pendingEvaluation"),
    UNKNOWN("unknown"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, EvaluationStatus> VALUE_MAP;
    private final String value;

    private EvaluationStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static EvaluationStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<EvaluationStatus> knownValues() {
        EnumSet<EvaluationStatus> knownValues = EnumSet.allOf(EvaluationStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(EvaluationStatus.class, EvaluationStatus::toString);
    }
}

