/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.arcregionswitch.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A summarized representation of a plan execution. This structure contains key information about an execution without
 * all the detailed step data.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AbbreviatedExecution implements SdkPojo, Serializable,
        ToCopyableBuilder<AbbreviatedExecution.Builder, AbbreviatedExecution> {
    private static final SdkField<String> PLAN_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("planArn").getter(getter(AbbreviatedExecution::planArn)).setter(setter(Builder::planArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("planArn").build()).build();

    private static final SdkField<String> EXECUTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("executionId").getter(getter(AbbreviatedExecution::executionId)).setter(setter(Builder::executionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionId").build()).build();

    private static final SdkField<String> VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("version")
            .getter(getter(AbbreviatedExecution::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt").getter(getter(AbbreviatedExecution::updatedAt)).setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build()).build();

    private static final SdkField<String> COMMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("comment")
            .getter(getter(AbbreviatedExecution::comment)).setter(setter(Builder::comment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("comment").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("startTime").getter(getter(AbbreviatedExecution::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("endTime").getter(getter(AbbreviatedExecution::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build()).build();

    private static final SdkField<String> MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("mode")
            .getter(getter(AbbreviatedExecution::modeAsString)).setter(setter(Builder::mode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mode").build()).build();

    private static final SdkField<String> EXECUTION_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("executionState").getter(getter(AbbreviatedExecution::executionStateAsString))
            .setter(setter(Builder::executionState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionState").build()).build();

    private static final SdkField<String> EXECUTION_ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("executionAction").getter(getter(AbbreviatedExecution::executionActionAsString))
            .setter(setter(Builder::executionAction))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionAction").build()).build();

    private static final SdkField<String> EXECUTION_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("executionRegion").getter(getter(AbbreviatedExecution::executionRegion))
            .setter(setter(Builder::executionRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionRegion").build()).build();

    private static final SdkField<String> ACTUAL_RECOVERY_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("actualRecoveryTime").getter(getter(AbbreviatedExecution::actualRecoveryTime))
            .setter(setter(Builder::actualRecoveryTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actualRecoveryTime").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PLAN_ARN_FIELD,
            EXECUTION_ID_FIELD, VERSION_FIELD, UPDATED_AT_FIELD, COMMENT_FIELD, START_TIME_FIELD, END_TIME_FIELD, MODE_FIELD,
            EXECUTION_STATE_FIELD, EXECUTION_ACTION_FIELD, EXECUTION_REGION_FIELD, ACTUAL_RECOVERY_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String planArn;

    private final String executionId;

    private final String version;

    private final Instant updatedAt;

    private final String comment;

    private final Instant startTime;

    private final Instant endTime;

    private final String mode;

    private final String executionState;

    private final String executionAction;

    private final String executionRegion;

    private final String actualRecoveryTime;

    private AbbreviatedExecution(BuilderImpl builder) {
        this.planArn = builder.planArn;
        this.executionId = builder.executionId;
        this.version = builder.version;
        this.updatedAt = builder.updatedAt;
        this.comment = builder.comment;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.mode = builder.mode;
        this.executionState = builder.executionState;
        this.executionAction = builder.executionAction;
        this.executionRegion = builder.executionRegion;
        this.actualRecoveryTime = builder.actualRecoveryTime;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the plan.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the plan.
     */
    public final String planArn() {
        return planArn;
    }

    /**
     * <p>
     * The execution identifier of a plan execution.
     * </p>
     * 
     * @return The execution identifier of a plan execution.
     */
    public final String executionId() {
        return executionId;
    }

    /**
     * <p>
     * The version for the plan.
     * </p>
     * 
     * @return The version for the plan.
     */
    public final String version() {
        return version;
    }

    /**
     * <p>
     * The timestamp when the plan execution was last updated.
     * </p>
     * 
     * @return The timestamp when the plan execution was last updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    /**
     * <p>
     * An optional comment about the plan execution.
     * </p>
     * 
     * @return An optional comment about the plan execution.
     */
    public final String comment() {
        return comment;
    }

    /**
     * <p>
     * The timestamp when the plan execution was started.
     * </p>
     * 
     * @return The timestamp when the plan execution was started.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The timestamp when the plan execution was ended.
     * </p>
     * 
     * @return The timestamp when the plan execution was ended.
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * The plan execution mode. Valid values are <code>Practice</code>, for testing without making actual changes, or
     * <code>Recovery</code>, for actual traffic shifting and application recovery.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mode} will return
     * {@link ExecutionMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #modeAsString}.
     * </p>
     * 
     * @return The plan execution mode. Valid values are <code>Practice</code>, for testing without making actual
     *         changes, or <code>Recovery</code>, for actual traffic shifting and application recovery.
     * @see ExecutionMode
     */
    public final ExecutionMode mode() {
        return ExecutionMode.fromValue(mode);
    }

    /**
     * <p>
     * The plan execution mode. Valid values are <code>Practice</code>, for testing without making actual changes, or
     * <code>Recovery</code>, for actual traffic shifting and application recovery.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mode} will return
     * {@link ExecutionMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #modeAsString}.
     * </p>
     * 
     * @return The plan execution mode. Valid values are <code>Practice</code>, for testing without making actual
     *         changes, or <code>Recovery</code>, for actual traffic shifting and application recovery.
     * @see ExecutionMode
     */
    public final String modeAsString() {
        return mode;
    }

    /**
     * <p>
     * The plan execution state. Provides the state of a plan execution, for example, In Progress or Paused by Operator.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #executionState}
     * will return {@link ExecutionState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #executionStateAsString}.
     * </p>
     * 
     * @return The plan execution state. Provides the state of a plan execution, for example, In Progress or Paused by
     *         Operator.
     * @see ExecutionState
     */
    public final ExecutionState executionState() {
        return ExecutionState.fromValue(executionState);
    }

    /**
     * <p>
     * The plan execution state. Provides the state of a plan execution, for example, In Progress or Paused by Operator.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #executionState}
     * will return {@link ExecutionState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #executionStateAsString}.
     * </p>
     * 
     * @return The plan execution state. Provides the state of a plan execution, for example, In Progress or Paused by
     *         Operator.
     * @see ExecutionState
     */
    public final String executionStateAsString() {
        return executionState;
    }

    /**
     * <p>
     * The plan execution action. Valid values are <code>Activate</code>, to activate an Amazon Web Services Region, or
     * <code>Deactivate</code>, to deactivate a Region.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #executionAction}
     * will return {@link ExecutionAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #executionActionAsString}.
     * </p>
     * 
     * @return The plan execution action. Valid values are <code>Activate</code>, to activate an Amazon Web Services
     *         Region, or <code>Deactivate</code>, to deactivate a Region.
     * @see ExecutionAction
     */
    public final ExecutionAction executionAction() {
        return ExecutionAction.fromValue(executionAction);
    }

    /**
     * <p>
     * The plan execution action. Valid values are <code>Activate</code>, to activate an Amazon Web Services Region, or
     * <code>Deactivate</code>, to deactivate a Region.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #executionAction}
     * will return {@link ExecutionAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #executionActionAsString}.
     * </p>
     * 
     * @return The plan execution action. Valid values are <code>Activate</code>, to activate an Amazon Web Services
     *         Region, or <code>Deactivate</code>, to deactivate a Region.
     * @see ExecutionAction
     */
    public final String executionActionAsString() {
        return executionAction;
    }

    /**
     * <p>
     * The Amazon Web Services Region for a plan execution.
     * </p>
     * 
     * @return The Amazon Web Services Region for a plan execution.
     */
    public final String executionRegion() {
        return executionRegion;
    }

    /**
     * <p>
     * The actual recovery time that Region switch calculates for a plan execution. Actual recovery time includes the
     * time for the plan to run added to the time elapsed until the application health alarms that you've specified are
     * healthy again.
     * </p>
     * 
     * @return The actual recovery time that Region switch calculates for a plan execution. Actual recovery time
     *         includes the time for the plan to run added to the time elapsed until the application health alarms that
     *         you've specified are healthy again.
     */
    public final String actualRecoveryTime() {
        return actualRecoveryTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(planArn());
        hashCode = 31 * hashCode + Objects.hashCode(executionId());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(comment());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(modeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(executionStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(executionActionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(executionRegion());
        hashCode = 31 * hashCode + Objects.hashCode(actualRecoveryTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AbbreviatedExecution)) {
            return false;
        }
        AbbreviatedExecution other = (AbbreviatedExecution) obj;
        return Objects.equals(planArn(), other.planArn()) && Objects.equals(executionId(), other.executionId())
                && Objects.equals(version(), other.version()) && Objects.equals(updatedAt(), other.updatedAt())
                && Objects.equals(comment(), other.comment()) && Objects.equals(startTime(), other.startTime())
                && Objects.equals(endTime(), other.endTime()) && Objects.equals(modeAsString(), other.modeAsString())
                && Objects.equals(executionStateAsString(), other.executionStateAsString())
                && Objects.equals(executionActionAsString(), other.executionActionAsString())
                && Objects.equals(executionRegion(), other.executionRegion())
                && Objects.equals(actualRecoveryTime(), other.actualRecoveryTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AbbreviatedExecution").add("PlanArn", planArn()).add("ExecutionId", executionId())
                .add("Version", version()).add("UpdatedAt", updatedAt()).add("Comment", comment()).add("StartTime", startTime())
                .add("EndTime", endTime()).add("Mode", modeAsString()).add("ExecutionState", executionStateAsString())
                .add("ExecutionAction", executionActionAsString()).add("ExecutionRegion", executionRegion())
                .add("ActualRecoveryTime", actualRecoveryTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "planArn":
            return Optional.ofNullable(clazz.cast(planArn()));
        case "executionId":
            return Optional.ofNullable(clazz.cast(executionId()));
        case "version":
            return Optional.ofNullable(clazz.cast(version()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        case "comment":
            return Optional.ofNullable(clazz.cast(comment()));
        case "startTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "endTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "mode":
            return Optional.ofNullable(clazz.cast(modeAsString()));
        case "executionState":
            return Optional.ofNullable(clazz.cast(executionStateAsString()));
        case "executionAction":
            return Optional.ofNullable(clazz.cast(executionActionAsString()));
        case "executionRegion":
            return Optional.ofNullable(clazz.cast(executionRegion()));
        case "actualRecoveryTime":
            return Optional.ofNullable(clazz.cast(actualRecoveryTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("planArn", PLAN_ARN_FIELD);
        map.put("executionId", EXECUTION_ID_FIELD);
        map.put("version", VERSION_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        map.put("comment", COMMENT_FIELD);
        map.put("startTime", START_TIME_FIELD);
        map.put("endTime", END_TIME_FIELD);
        map.put("mode", MODE_FIELD);
        map.put("executionState", EXECUTION_STATE_FIELD);
        map.put("executionAction", EXECUTION_ACTION_FIELD);
        map.put("executionRegion", EXECUTION_REGION_FIELD);
        map.put("actualRecoveryTime", ACTUAL_RECOVERY_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AbbreviatedExecution, T> g) {
        return obj -> g.apply((AbbreviatedExecution) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AbbreviatedExecution> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the plan.
         * </p>
         * 
         * @param planArn
         *        The Amazon Resource Name (ARN) of the plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder planArn(String planArn);

        /**
         * <p>
         * The execution identifier of a plan execution.
         * </p>
         * 
         * @param executionId
         *        The execution identifier of a plan execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionId(String executionId);

        /**
         * <p>
         * The version for the plan.
         * </p>
         * 
         * @param version
         *        The version for the plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(String version);

        /**
         * <p>
         * The timestamp when the plan execution was last updated.
         * </p>
         * 
         * @param updatedAt
         *        The timestamp when the plan execution was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);

        /**
         * <p>
         * An optional comment about the plan execution.
         * </p>
         * 
         * @param comment
         *        An optional comment about the plan execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder comment(String comment);

        /**
         * <p>
         * The timestamp when the plan execution was started.
         * </p>
         * 
         * @param startTime
         *        The timestamp when the plan execution was started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The timestamp when the plan execution was ended.
         * </p>
         * 
         * @param endTime
         *        The timestamp when the plan execution was ended.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * The plan execution mode. Valid values are <code>Practice</code>, for testing without making actual changes,
         * or <code>Recovery</code>, for actual traffic shifting and application recovery.
         * </p>
         * 
         * @param mode
         *        The plan execution mode. Valid values are <code>Practice</code>, for testing without making actual
         *        changes, or <code>Recovery</code>, for actual traffic shifting and application recovery.
         * @see ExecutionMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExecutionMode
         */
        Builder mode(String mode);

        /**
         * <p>
         * The plan execution mode. Valid values are <code>Practice</code>, for testing without making actual changes,
         * or <code>Recovery</code>, for actual traffic shifting and application recovery.
         * </p>
         * 
         * @param mode
         *        The plan execution mode. Valid values are <code>Practice</code>, for testing without making actual
         *        changes, or <code>Recovery</code>, for actual traffic shifting and application recovery.
         * @see ExecutionMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExecutionMode
         */
        Builder mode(ExecutionMode mode);

        /**
         * <p>
         * The plan execution state. Provides the state of a plan execution, for example, In Progress or Paused by
         * Operator.
         * </p>
         * 
         * @param executionState
         *        The plan execution state. Provides the state of a plan execution, for example, In Progress or Paused
         *        by Operator.
         * @see ExecutionState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExecutionState
         */
        Builder executionState(String executionState);

        /**
         * <p>
         * The plan execution state. Provides the state of a plan execution, for example, In Progress or Paused by
         * Operator.
         * </p>
         * 
         * @param executionState
         *        The plan execution state. Provides the state of a plan execution, for example, In Progress or Paused
         *        by Operator.
         * @see ExecutionState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExecutionState
         */
        Builder executionState(ExecutionState executionState);

        /**
         * <p>
         * The plan execution action. Valid values are <code>Activate</code>, to activate an Amazon Web Services Region,
         * or <code>Deactivate</code>, to deactivate a Region.
         * </p>
         * 
         * @param executionAction
         *        The plan execution action. Valid values are <code>Activate</code>, to activate an Amazon Web Services
         *        Region, or <code>Deactivate</code>, to deactivate a Region.
         * @see ExecutionAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExecutionAction
         */
        Builder executionAction(String executionAction);

        /**
         * <p>
         * The plan execution action. Valid values are <code>Activate</code>, to activate an Amazon Web Services Region,
         * or <code>Deactivate</code>, to deactivate a Region.
         * </p>
         * 
         * @param executionAction
         *        The plan execution action. Valid values are <code>Activate</code>, to activate an Amazon Web Services
         *        Region, or <code>Deactivate</code>, to deactivate a Region.
         * @see ExecutionAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExecutionAction
         */
        Builder executionAction(ExecutionAction executionAction);

        /**
         * <p>
         * The Amazon Web Services Region for a plan execution.
         * </p>
         * 
         * @param executionRegion
         *        The Amazon Web Services Region for a plan execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionRegion(String executionRegion);

        /**
         * <p>
         * The actual recovery time that Region switch calculates for a plan execution. Actual recovery time includes
         * the time for the plan to run added to the time elapsed until the application health alarms that you've
         * specified are healthy again.
         * </p>
         * 
         * @param actualRecoveryTime
         *        The actual recovery time that Region switch calculates for a plan execution. Actual recovery time
         *        includes the time for the plan to run added to the time elapsed until the application health alarms
         *        that you've specified are healthy again.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actualRecoveryTime(String actualRecoveryTime);
    }

    static final class BuilderImpl implements Builder {
        private String planArn;

        private String executionId;

        private String version;

        private Instant updatedAt;

        private String comment;

        private Instant startTime;

        private Instant endTime;

        private String mode;

        private String executionState;

        private String executionAction;

        private String executionRegion;

        private String actualRecoveryTime;

        private BuilderImpl() {
        }

        private BuilderImpl(AbbreviatedExecution model) {
            planArn(model.planArn);
            executionId(model.executionId);
            version(model.version);
            updatedAt(model.updatedAt);
            comment(model.comment);
            startTime(model.startTime);
            endTime(model.endTime);
            mode(model.mode);
            executionState(model.executionState);
            executionAction(model.executionAction);
            executionRegion(model.executionRegion);
            actualRecoveryTime(model.actualRecoveryTime);
        }

        public final String getPlanArn() {
            return planArn;
        }

        public final void setPlanArn(String planArn) {
            this.planArn = planArn;
        }

        @Override
        public final Builder planArn(String planArn) {
            this.planArn = planArn;
            return this;
        }

        public final String getExecutionId() {
            return executionId;
        }

        public final void setExecutionId(String executionId) {
            this.executionId = executionId;
        }

        @Override
        public final Builder executionId(String executionId) {
            this.executionId = executionId;
            return this;
        }

        public final String getVersion() {
            return version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getComment() {
            return comment;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        @Override
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getMode() {
            return mode;
        }

        public final void setMode(String mode) {
            this.mode = mode;
        }

        @Override
        public final Builder mode(String mode) {
            this.mode = mode;
            return this;
        }

        @Override
        public final Builder mode(ExecutionMode mode) {
            this.mode(mode == null ? null : mode.toString());
            return this;
        }

        public final String getExecutionState() {
            return executionState;
        }

        public final void setExecutionState(String executionState) {
            this.executionState = executionState;
        }

        @Override
        public final Builder executionState(String executionState) {
            this.executionState = executionState;
            return this;
        }

        @Override
        public final Builder executionState(ExecutionState executionState) {
            this.executionState(executionState == null ? null : executionState.toString());
            return this;
        }

        public final String getExecutionAction() {
            return executionAction;
        }

        public final void setExecutionAction(String executionAction) {
            this.executionAction = executionAction;
        }

        @Override
        public final Builder executionAction(String executionAction) {
            this.executionAction = executionAction;
            return this;
        }

        @Override
        public final Builder executionAction(ExecutionAction executionAction) {
            this.executionAction(executionAction == null ? null : executionAction.toString());
            return this;
        }

        public final String getExecutionRegion() {
            return executionRegion;
        }

        public final void setExecutionRegion(String executionRegion) {
            this.executionRegion = executionRegion;
        }

        @Override
        public final Builder executionRegion(String executionRegion) {
            this.executionRegion = executionRegion;
            return this;
        }

        public final String getActualRecoveryTime() {
            return actualRecoveryTime;
        }

        public final void setActualRecoveryTime(String actualRecoveryTime) {
            this.actualRecoveryTime = actualRecoveryTime;
        }

        @Override
        public final Builder actualRecoveryTime(String actualRecoveryTime) {
            this.actualRecoveryTime = actualRecoveryTime;
            return this;
        }

        @Override
        public AbbreviatedExecution build() {
            return new AbbreviatedExecution(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
