/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.arcregionswitch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration for ARC routing controls used in a Region switch plan. Routing controls are simple on/off switches that
 * you can use to shift traffic away from an impaired Region.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ArcRoutingControlConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ArcRoutingControlConfiguration.Builder, ArcRoutingControlConfiguration> {
    private static final SdkField<Integer> TIMEOUT_MINUTES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("timeoutMinutes").getter(getter(ArcRoutingControlConfiguration::timeoutMinutes))
            .setter(setter(Builder::timeoutMinutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeoutMinutes").build()).build();

    private static final SdkField<String> CROSS_ACCOUNT_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("crossAccountRole").getter(getter(ArcRoutingControlConfiguration::crossAccountRole))
            .setter(setter(Builder::crossAccountRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("crossAccountRole").build()).build();

    private static final SdkField<String> EXTERNAL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("externalId").getter(getter(ArcRoutingControlConfiguration::externalId))
            .setter(setter(Builder::externalId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("externalId").build()).build();

    private static final SdkField<Map<String, List<ArcRoutingControlState>>> REGION_AND_ROUTING_CONTROLS_FIELD = SdkField
            .<Map<String, List<ArcRoutingControlState>>> builder(MarshallingType.MAP)
            .memberName("regionAndRoutingControls")
            .getter(getter(ArcRoutingControlConfiguration::regionAndRoutingControls))
            .setter(setter(Builder::regionAndRoutingControls))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("regionAndRoutingControls").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<List<ArcRoutingControlState>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<ArcRoutingControlState> builder(
                                                                            MarshallingType.SDK_POJO)
                                                                            .constructor(ArcRoutingControlState::builder)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build()).build())
                                                            .build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIMEOUT_MINUTES_FIELD,
            CROSS_ACCOUNT_ROLE_FIELD, EXTERNAL_ID_FIELD, REGION_AND_ROUTING_CONTROLS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer timeoutMinutes;

    private final String crossAccountRole;

    private final String externalId;

    private final Map<String, List<ArcRoutingControlState>> regionAndRoutingControls;

    private ArcRoutingControlConfiguration(BuilderImpl builder) {
        this.timeoutMinutes = builder.timeoutMinutes;
        this.crossAccountRole = builder.crossAccountRole;
        this.externalId = builder.externalId;
        this.regionAndRoutingControls = builder.regionAndRoutingControls;
    }

    /**
     * <p>
     * The timeout value specified for the configuration.
     * </p>
     * 
     * @return The timeout value specified for the configuration.
     */
    public final Integer timeoutMinutes() {
        return timeoutMinutes;
    }

    /**
     * <p>
     * The cross account role for the configuration.
     * </p>
     * 
     * @return The cross account role for the configuration.
     */
    public final String crossAccountRole() {
        return crossAccountRole;
    }

    /**
     * <p>
     * The external ID (secret key) for the configuration.
     * </p>
     * 
     * @return The external ID (secret key) for the configuration.
     */
    public final String externalId() {
        return externalId;
    }

    /**
     * For responses, this returns true if the service returned a value for the RegionAndRoutingControls property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasRegionAndRoutingControls() {
        return regionAndRoutingControls != null && !(regionAndRoutingControls instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The Region and ARC routing controls for the configuration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRegionAndRoutingControls} method.
     * </p>
     * 
     * @return The Region and ARC routing controls for the configuration.
     */
    public final Map<String, List<ArcRoutingControlState>> regionAndRoutingControls() {
        return regionAndRoutingControls;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(timeoutMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(crossAccountRole());
        hashCode = 31 * hashCode + Objects.hashCode(externalId());
        hashCode = 31 * hashCode + Objects.hashCode(hasRegionAndRoutingControls() ? regionAndRoutingControls() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ArcRoutingControlConfiguration)) {
            return false;
        }
        ArcRoutingControlConfiguration other = (ArcRoutingControlConfiguration) obj;
        return Objects.equals(timeoutMinutes(), other.timeoutMinutes())
                && Objects.equals(crossAccountRole(), other.crossAccountRole())
                && Objects.equals(externalId(), other.externalId())
                && hasRegionAndRoutingControls() == other.hasRegionAndRoutingControls()
                && Objects.equals(regionAndRoutingControls(), other.regionAndRoutingControls());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ArcRoutingControlConfiguration").add("TimeoutMinutes", timeoutMinutes())
                .add("CrossAccountRole", crossAccountRole()).add("ExternalId", externalId())
                .add("RegionAndRoutingControls", hasRegionAndRoutingControls() ? regionAndRoutingControls() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "timeoutMinutes":
            return Optional.ofNullable(clazz.cast(timeoutMinutes()));
        case "crossAccountRole":
            return Optional.ofNullable(clazz.cast(crossAccountRole()));
        case "externalId":
            return Optional.ofNullable(clazz.cast(externalId()));
        case "regionAndRoutingControls":
            return Optional.ofNullable(clazz.cast(regionAndRoutingControls()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("timeoutMinutes", TIMEOUT_MINUTES_FIELD);
        map.put("crossAccountRole", CROSS_ACCOUNT_ROLE_FIELD);
        map.put("externalId", EXTERNAL_ID_FIELD);
        map.put("regionAndRoutingControls", REGION_AND_ROUTING_CONTROLS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ArcRoutingControlConfiguration, T> g) {
        return obj -> g.apply((ArcRoutingControlConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ArcRoutingControlConfiguration> {
        /**
         * <p>
         * The timeout value specified for the configuration.
         * </p>
         * 
         * @param timeoutMinutes
         *        The timeout value specified for the configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeoutMinutes(Integer timeoutMinutes);

        /**
         * <p>
         * The cross account role for the configuration.
         * </p>
         * 
         * @param crossAccountRole
         *        The cross account role for the configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder crossAccountRole(String crossAccountRole);

        /**
         * <p>
         * The external ID (secret key) for the configuration.
         * </p>
         * 
         * @param externalId
         *        The external ID (secret key) for the configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder externalId(String externalId);

        /**
         * <p>
         * The Region and ARC routing controls for the configuration.
         * </p>
         * 
         * @param regionAndRoutingControls
         *        The Region and ARC routing controls for the configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regionAndRoutingControls(Map<String, ? extends Collection<ArcRoutingControlState>> regionAndRoutingControls);
    }

    static final class BuilderImpl implements Builder {
        private Integer timeoutMinutes;

        private String crossAccountRole;

        private String externalId;

        private Map<String, List<ArcRoutingControlState>> regionAndRoutingControls = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ArcRoutingControlConfiguration model) {
            timeoutMinutes(model.timeoutMinutes);
            crossAccountRole(model.crossAccountRole);
            externalId(model.externalId);
            regionAndRoutingControls(model.regionAndRoutingControls);
        }

        public final Integer getTimeoutMinutes() {
            return timeoutMinutes;
        }

        public final void setTimeoutMinutes(Integer timeoutMinutes) {
            this.timeoutMinutes = timeoutMinutes;
        }

        @Override
        public final Builder timeoutMinutes(Integer timeoutMinutes) {
            this.timeoutMinutes = timeoutMinutes;
            return this;
        }

        public final String getCrossAccountRole() {
            return crossAccountRole;
        }

        public final void setCrossAccountRole(String crossAccountRole) {
            this.crossAccountRole = crossAccountRole;
        }

        @Override
        public final Builder crossAccountRole(String crossAccountRole) {
            this.crossAccountRole = crossAccountRole;
            return this;
        }

        public final String getExternalId() {
            return externalId;
        }

        public final void setExternalId(String externalId) {
            this.externalId = externalId;
        }

        @Override
        public final Builder externalId(String externalId) {
            this.externalId = externalId;
            return this;
        }

        public final Map<String, List<ArcRoutingControlState.Builder>> getRegionAndRoutingControls() {
            Map<String, List<ArcRoutingControlState.Builder>> result = RegionAndRoutingControlsCopier
                    .copyToBuilder(this.regionAndRoutingControls);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setRegionAndRoutingControls(
                Map<String, ? extends Collection<ArcRoutingControlState.BuilderImpl>> regionAndRoutingControls) {
            this.regionAndRoutingControls = RegionAndRoutingControlsCopier.copyFromBuilder(regionAndRoutingControls);
        }

        @Override
        public final Builder regionAndRoutingControls(
                Map<String, ? extends Collection<ArcRoutingControlState>> regionAndRoutingControls) {
            this.regionAndRoutingControls = RegionAndRoutingControlsCopier.copy(regionAndRoutingControls);
            return this;
        }

        @Override
        public ArcRoutingControlConfiguration build() {
            return new ArcRoutingControlConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
