/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.arcregionswitch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration for an Amazon Web Services ECS capacity increase.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EcsCapacityIncreaseConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<EcsCapacityIncreaseConfiguration.Builder, EcsCapacityIncreaseConfiguration> {
    private static final SdkField<Integer> TIMEOUT_MINUTES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("timeoutMinutes").getter(getter(EcsCapacityIncreaseConfiguration::timeoutMinutes))
            .setter(setter(Builder::timeoutMinutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeoutMinutes").build()).build();

    private static final SdkField<List<Service>> SERVICES_FIELD = SdkField
            .<List<Service>> builder(MarshallingType.LIST)
            .memberName("services")
            .getter(getter(EcsCapacityIncreaseConfiguration::services))
            .setter(setter(Builder::services))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("services").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Service> builder(MarshallingType.SDK_POJO)
                                            .constructor(Service::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<EcsUngraceful> UNGRACEFUL_FIELD = SdkField.<EcsUngraceful> builder(MarshallingType.SDK_POJO)
            .memberName("ungraceful").getter(getter(EcsCapacityIncreaseConfiguration::ungraceful))
            .setter(setter(Builder::ungraceful)).constructor(EcsUngraceful::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ungraceful").build()).build();

    private static final SdkField<Integer> TARGET_PERCENT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("targetPercent").getter(getter(EcsCapacityIncreaseConfiguration::targetPercent))
            .setter(setter(Builder::targetPercent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetPercent").build()).build();

    private static final SdkField<String> CAPACITY_MONITORING_APPROACH_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("capacityMonitoringApproach")
            .getter(getter(EcsCapacityIncreaseConfiguration::capacityMonitoringApproachAsString))
            .setter(setter(Builder::capacityMonitoringApproach))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("capacityMonitoringApproach").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIMEOUT_MINUTES_FIELD,
            SERVICES_FIELD, UNGRACEFUL_FIELD, TARGET_PERCENT_FIELD, CAPACITY_MONITORING_APPROACH_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer timeoutMinutes;

    private final List<Service> services;

    private final EcsUngraceful ungraceful;

    private final Integer targetPercent;

    private final String capacityMonitoringApproach;

    private EcsCapacityIncreaseConfiguration(BuilderImpl builder) {
        this.timeoutMinutes = builder.timeoutMinutes;
        this.services = builder.services;
        this.ungraceful = builder.ungraceful;
        this.targetPercent = builder.targetPercent;
        this.capacityMonitoringApproach = builder.capacityMonitoringApproach;
    }

    /**
     * <p>
     * The timeout value specified for the configuration.
     * </p>
     * 
     * @return The timeout value specified for the configuration.
     */
    public final Integer timeoutMinutes() {
        return timeoutMinutes;
    }

    /**
     * For responses, this returns true if the service returned a value for the Services property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasServices() {
        return services != null && !(services instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The services specified for the configuration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasServices} method.
     * </p>
     * 
     * @return The services specified for the configuration.
     */
    public final List<Service> services() {
        return services;
    }

    /**
     * <p>
     * The settings for ungraceful execution.
     * </p>
     * 
     * @return The settings for ungraceful execution.
     */
    public final EcsUngraceful ungraceful() {
        return ungraceful;
    }

    /**
     * <p>
     * The target percentage specified for the configuration.
     * </p>
     * 
     * @return The target percentage specified for the configuration.
     */
    public final Integer targetPercent() {
        return targetPercent;
    }

    /**
     * <p>
     * The monitoring approach specified for the configuration, for example, <code>Most_Recent</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #capacityMonitoringApproach} will return {@link EcsCapacityMonitoringApproach#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #capacityMonitoringApproachAsString}.
     * </p>
     * 
     * @return The monitoring approach specified for the configuration, for example, <code>Most_Recent</code>.
     * @see EcsCapacityMonitoringApproach
     */
    public final EcsCapacityMonitoringApproach capacityMonitoringApproach() {
        return EcsCapacityMonitoringApproach.fromValue(capacityMonitoringApproach);
    }

    /**
     * <p>
     * The monitoring approach specified for the configuration, for example, <code>Most_Recent</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #capacityMonitoringApproach} will return {@link EcsCapacityMonitoringApproach#UNKNOWN_TO_SDK_VERSION}. The
     * raw value returned by the service is available from {@link #capacityMonitoringApproachAsString}.
     * </p>
     * 
     * @return The monitoring approach specified for the configuration, for example, <code>Most_Recent</code>.
     * @see EcsCapacityMonitoringApproach
     */
    public final String capacityMonitoringApproachAsString() {
        return capacityMonitoringApproach;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(timeoutMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(hasServices() ? services() : null);
        hashCode = 31 * hashCode + Objects.hashCode(ungraceful());
        hashCode = 31 * hashCode + Objects.hashCode(targetPercent());
        hashCode = 31 * hashCode + Objects.hashCode(capacityMonitoringApproachAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EcsCapacityIncreaseConfiguration)) {
            return false;
        }
        EcsCapacityIncreaseConfiguration other = (EcsCapacityIncreaseConfiguration) obj;
        return Objects.equals(timeoutMinutes(), other.timeoutMinutes()) && hasServices() == other.hasServices()
                && Objects.equals(services(), other.services()) && Objects.equals(ungraceful(), other.ungraceful())
                && Objects.equals(targetPercent(), other.targetPercent())
                && Objects.equals(capacityMonitoringApproachAsString(), other.capacityMonitoringApproachAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EcsCapacityIncreaseConfiguration").add("TimeoutMinutes", timeoutMinutes())
                .add("Services", hasServices() ? services() : null).add("Ungraceful", ungraceful())
                .add("TargetPercent", targetPercent()).add("CapacityMonitoringApproach", capacityMonitoringApproachAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "timeoutMinutes":
            return Optional.ofNullable(clazz.cast(timeoutMinutes()));
        case "services":
            return Optional.ofNullable(clazz.cast(services()));
        case "ungraceful":
            return Optional.ofNullable(clazz.cast(ungraceful()));
        case "targetPercent":
            return Optional.ofNullable(clazz.cast(targetPercent()));
        case "capacityMonitoringApproach":
            return Optional.ofNullable(clazz.cast(capacityMonitoringApproachAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("timeoutMinutes", TIMEOUT_MINUTES_FIELD);
        map.put("services", SERVICES_FIELD);
        map.put("ungraceful", UNGRACEFUL_FIELD);
        map.put("targetPercent", TARGET_PERCENT_FIELD);
        map.put("capacityMonitoringApproach", CAPACITY_MONITORING_APPROACH_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EcsCapacityIncreaseConfiguration, T> g) {
        return obj -> g.apply((EcsCapacityIncreaseConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EcsCapacityIncreaseConfiguration> {
        /**
         * <p>
         * The timeout value specified for the configuration.
         * </p>
         * 
         * @param timeoutMinutes
         *        The timeout value specified for the configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeoutMinutes(Integer timeoutMinutes);

        /**
         * <p>
         * The services specified for the configuration.
         * </p>
         * 
         * @param services
         *        The services specified for the configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder services(Collection<Service> services);

        /**
         * <p>
         * The services specified for the configuration.
         * </p>
         * 
         * @param services
         *        The services specified for the configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder services(Service... services);

        /**
         * <p>
         * The services specified for the configuration.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.arcregionswitch.model.Service.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.arcregionswitch.model.Service#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.arcregionswitch.model.Service.Builder#build()} is called immediately
         * and its result is passed to {@link #services(List<Service>)}.
         * 
         * @param services
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.arcregionswitch.model.Service.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #services(java.util.Collection<Service>)
         */
        Builder services(Consumer<Service.Builder>... services);

        /**
         * <p>
         * The settings for ungraceful execution.
         * </p>
         * 
         * @param ungraceful
         *        The settings for ungraceful execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ungraceful(EcsUngraceful ungraceful);

        /**
         * <p>
         * The settings for ungraceful execution.
         * </p>
         * This is a convenience method that creates an instance of the {@link EcsUngraceful.Builder} avoiding the need
         * to create one manually via {@link EcsUngraceful#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EcsUngraceful.Builder#build()} is called immediately and its
         * result is passed to {@link #ungraceful(EcsUngraceful)}.
         * 
         * @param ungraceful
         *        a consumer that will call methods on {@link EcsUngraceful.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ungraceful(EcsUngraceful)
         */
        default Builder ungraceful(Consumer<EcsUngraceful.Builder> ungraceful) {
            return ungraceful(EcsUngraceful.builder().applyMutation(ungraceful).build());
        }

        /**
         * <p>
         * The target percentage specified for the configuration.
         * </p>
         * 
         * @param targetPercent
         *        The target percentage specified for the configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetPercent(Integer targetPercent);

        /**
         * <p>
         * The monitoring approach specified for the configuration, for example, <code>Most_Recent</code>.
         * </p>
         * 
         * @param capacityMonitoringApproach
         *        The monitoring approach specified for the configuration, for example, <code>Most_Recent</code>.
         * @see EcsCapacityMonitoringApproach
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EcsCapacityMonitoringApproach
         */
        Builder capacityMonitoringApproach(String capacityMonitoringApproach);

        /**
         * <p>
         * The monitoring approach specified for the configuration, for example, <code>Most_Recent</code>.
         * </p>
         * 
         * @param capacityMonitoringApproach
         *        The monitoring approach specified for the configuration, for example, <code>Most_Recent</code>.
         * @see EcsCapacityMonitoringApproach
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EcsCapacityMonitoringApproach
         */
        Builder capacityMonitoringApproach(EcsCapacityMonitoringApproach capacityMonitoringApproach);
    }

    static final class BuilderImpl implements Builder {
        private Integer timeoutMinutes;

        private List<Service> services = DefaultSdkAutoConstructList.getInstance();

        private EcsUngraceful ungraceful;

        private Integer targetPercent;

        private String capacityMonitoringApproach;

        private BuilderImpl() {
        }

        private BuilderImpl(EcsCapacityIncreaseConfiguration model) {
            timeoutMinutes(model.timeoutMinutes);
            services(model.services);
            ungraceful(model.ungraceful);
            targetPercent(model.targetPercent);
            capacityMonitoringApproach(model.capacityMonitoringApproach);
        }

        public final Integer getTimeoutMinutes() {
            return timeoutMinutes;
        }

        public final void setTimeoutMinutes(Integer timeoutMinutes) {
            this.timeoutMinutes = timeoutMinutes;
        }

        @Override
        public final Builder timeoutMinutes(Integer timeoutMinutes) {
            this.timeoutMinutes = timeoutMinutes;
            return this;
        }

        public final List<Service.Builder> getServices() {
            List<Service.Builder> result = ServiceListCopier.copyToBuilder(this.services);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setServices(Collection<Service.BuilderImpl> services) {
            this.services = ServiceListCopier.copyFromBuilder(services);
        }

        @Override
        public final Builder services(Collection<Service> services) {
            this.services = ServiceListCopier.copy(services);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder services(Service... services) {
            services(Arrays.asList(services));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder services(Consumer<Service.Builder>... services) {
            services(Stream.of(services).map(c -> Service.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final EcsUngraceful.Builder getUngraceful() {
            return ungraceful != null ? ungraceful.toBuilder() : null;
        }

        public final void setUngraceful(EcsUngraceful.BuilderImpl ungraceful) {
            this.ungraceful = ungraceful != null ? ungraceful.build() : null;
        }

        @Override
        public final Builder ungraceful(EcsUngraceful ungraceful) {
            this.ungraceful = ungraceful;
            return this;
        }

        public final Integer getTargetPercent() {
            return targetPercent;
        }

        public final void setTargetPercent(Integer targetPercent) {
            this.targetPercent = targetPercent;
        }

        @Override
        public final Builder targetPercent(Integer targetPercent) {
            this.targetPercent = targetPercent;
            return this;
        }

        public final String getCapacityMonitoringApproach() {
            return capacityMonitoringApproach;
        }

        public final void setCapacityMonitoringApproach(String capacityMonitoringApproach) {
            this.capacityMonitoringApproach = capacityMonitoringApproach;
        }

        @Override
        public final Builder capacityMonitoringApproach(String capacityMonitoringApproach) {
            this.capacityMonitoringApproach = capacityMonitoringApproach;
            return this;
        }

        @Override
        public final Builder capacityMonitoringApproach(EcsCapacityMonitoringApproach capacityMonitoringApproach) {
            this.capacityMonitoringApproach(capacityMonitoringApproach == null ? null : capacityMonitoringApproach.toString());
            return this;
        }

        @Override
        public EcsCapacityIncreaseConfiguration build() {
            return new EcsCapacityIncreaseConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
