/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.arcregionswitch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The settings for ungraceful execution.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EcsUngraceful implements SdkPojo, Serializable, ToCopyableBuilder<EcsUngraceful.Builder, EcsUngraceful> {
    private static final SdkField<Integer> MINIMUM_SUCCESS_PERCENTAGE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("minimumSuccessPercentage").getter(getter(EcsUngraceful::minimumSuccessPercentage))
            .setter(setter(Builder::minimumSuccessPercentage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minimumSuccessPercentage").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(MINIMUM_SUCCESS_PERCENTAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer minimumSuccessPercentage;

    private EcsUngraceful(BuilderImpl builder) {
        this.minimumSuccessPercentage = builder.minimumSuccessPercentage;
    }

    /**
     * <p>
     * The minimum success percentage specified for the configuration.
     * </p>
     * 
     * @return The minimum success percentage specified for the configuration.
     */
    public final Integer minimumSuccessPercentage() {
        return minimumSuccessPercentage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(minimumSuccessPercentage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EcsUngraceful)) {
            return false;
        }
        EcsUngraceful other = (EcsUngraceful) obj;
        return Objects.equals(minimumSuccessPercentage(), other.minimumSuccessPercentage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EcsUngraceful").add("MinimumSuccessPercentage", minimumSuccessPercentage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "minimumSuccessPercentage":
            return Optional.ofNullable(clazz.cast(minimumSuccessPercentage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("minimumSuccessPercentage", MINIMUM_SUCCESS_PERCENTAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EcsUngraceful, T> g) {
        return obj -> g.apply((EcsUngraceful) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EcsUngraceful> {
        /**
         * <p>
         * The minimum success percentage specified for the configuration.
         * </p>
         * 
         * @param minimumSuccessPercentage
         *        The minimum success percentage specified for the configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minimumSuccessPercentage(Integer minimumSuccessPercentage);
    }

    static final class BuilderImpl implements Builder {
        private Integer minimumSuccessPercentage;

        private BuilderImpl() {
        }

        private BuilderImpl(EcsUngraceful model) {
            minimumSuccessPercentage(model.minimumSuccessPercentage);
        }

        public final Integer getMinimumSuccessPercentage() {
            return minimumSuccessPercentage;
        }

        public final void setMinimumSuccessPercentage(Integer minimumSuccessPercentage) {
            this.minimumSuccessPercentage = minimumSuccessPercentage;
        }

        @Override
        public final Builder minimumSuccessPercentage(Integer minimumSuccessPercentage) {
            this.minimumSuccessPercentage = minimumSuccessPercentage;
            return this;
        }

        @Override
        public EcsUngraceful build() {
            return new EcsUngraceful(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
