/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.arcregionswitch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration for approval steps in a Region switch plan execution. Approval steps require manual intervention before
 * the execution can proceed.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExecutionApprovalConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ExecutionApprovalConfiguration.Builder, ExecutionApprovalConfiguration> {
    private static final SdkField<Integer> TIMEOUT_MINUTES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("timeoutMinutes").getter(getter(ExecutionApprovalConfiguration::timeoutMinutes))
            .setter(setter(Builder::timeoutMinutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeoutMinutes").build()).build();

    private static final SdkField<String> APPROVAL_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("approvalRole").getter(getter(ExecutionApprovalConfiguration::approvalRole))
            .setter(setter(Builder::approvalRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("approvalRole").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIMEOUT_MINUTES_FIELD,
            APPROVAL_ROLE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer timeoutMinutes;

    private final String approvalRole;

    private ExecutionApprovalConfiguration(BuilderImpl builder) {
        this.timeoutMinutes = builder.timeoutMinutes;
        this.approvalRole = builder.approvalRole;
    }

    /**
     * <p>
     * The timeout value specified for the configuration.
     * </p>
     * 
     * @return The timeout value specified for the configuration.
     */
    public final Integer timeoutMinutes() {
        return timeoutMinutes;
    }

    /**
     * <p>
     * The IAM approval role for the configuration.
     * </p>
     * 
     * @return The IAM approval role for the configuration.
     */
    public final String approvalRole() {
        return approvalRole;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(timeoutMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(approvalRole());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExecutionApprovalConfiguration)) {
            return false;
        }
        ExecutionApprovalConfiguration other = (ExecutionApprovalConfiguration) obj;
        return Objects.equals(timeoutMinutes(), other.timeoutMinutes()) && Objects.equals(approvalRole(), other.approvalRole());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExecutionApprovalConfiguration").add("TimeoutMinutes", timeoutMinutes())
                .add("ApprovalRole", approvalRole()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "timeoutMinutes":
            return Optional.ofNullable(clazz.cast(timeoutMinutes()));
        case "approvalRole":
            return Optional.ofNullable(clazz.cast(approvalRole()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("timeoutMinutes", TIMEOUT_MINUTES_FIELD);
        map.put("approvalRole", APPROVAL_ROLE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExecutionApprovalConfiguration, T> g) {
        return obj -> g.apply((ExecutionApprovalConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExecutionApprovalConfiguration> {
        /**
         * <p>
         * The timeout value specified for the configuration.
         * </p>
         * 
         * @param timeoutMinutes
         *        The timeout value specified for the configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeoutMinutes(Integer timeoutMinutes);

        /**
         * <p>
         * The IAM approval role for the configuration.
         * </p>
         * 
         * @param approvalRole
         *        The IAM approval role for the configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder approvalRole(String approvalRole);
    }

    static final class BuilderImpl implements Builder {
        private Integer timeoutMinutes;

        private String approvalRole;

        private BuilderImpl() {
        }

        private BuilderImpl(ExecutionApprovalConfiguration model) {
            timeoutMinutes(model.timeoutMinutes);
            approvalRole(model.approvalRole);
        }

        public final Integer getTimeoutMinutes() {
            return timeoutMinutes;
        }

        public final void setTimeoutMinutes(Integer timeoutMinutes) {
            this.timeoutMinutes = timeoutMinutes;
        }

        @Override
        public final Builder timeoutMinutes(Integer timeoutMinutes) {
            this.timeoutMinutes = timeoutMinutes;
            return this;
        }

        public final String getApprovalRole() {
            return approvalRole;
        }

        public final void setApprovalRole(String approvalRole) {
            this.approvalRole = approvalRole;
        }

        @Override
        public final Builder approvalRole(String approvalRole) {
            this.approvalRole = approvalRole;
            return this;
        }

        @Override
        public ExecutionApprovalConfiguration build() {
            return new ExecutionApprovalConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
