/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.arcregionswitch.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents an event that occurred during a plan execution. These events provide a detailed timeline of the execution
 * process.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExecutionEvent implements SdkPojo, Serializable, ToCopyableBuilder<ExecutionEvent.Builder, ExecutionEvent> {
    private static final SdkField<Instant> TIMESTAMP_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("timestamp").getter(getter(ExecutionEvent::timestamp)).setter(setter(Builder::timestamp))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timestamp").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(ExecutionEvent::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<String> STEP_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("stepName").getter(getter(ExecutionEvent::stepName)).setter(setter(Builder::stepName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stepName").build()).build();

    private static final SdkField<String> EXECUTION_BLOCK_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("executionBlockType").getter(getter(ExecutionEvent::executionBlockTypeAsString))
            .setter(setter(Builder::executionBlockType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionBlockType").build())
            .build();

    private static final SdkField<List<String>> RESOURCES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("resources")
            .getter(getter(ExecutionEvent::resources))
            .setter(setter(Builder::resources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> ERROR_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("error")
            .getter(getter(ExecutionEvent::error)).setter(setter(Builder::error))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("error").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(ExecutionEvent::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> EVENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("eventId").getter(getter(ExecutionEvent::eventId)).setter(setter(Builder::eventId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventId").build()).build();

    private static final SdkField<String> PREVIOUS_EVENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("previousEventId").getter(getter(ExecutionEvent::previousEventId))
            .setter(setter(Builder::previousEventId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("previousEventId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIMESTAMP_FIELD, TYPE_FIELD,
            STEP_NAME_FIELD, EXECUTION_BLOCK_TYPE_FIELD, RESOURCES_FIELD, ERROR_FIELD, DESCRIPTION_FIELD, EVENT_ID_FIELD,
            PREVIOUS_EVENT_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Instant timestamp;

    private final String type;

    private final String stepName;

    private final String executionBlockType;

    private final List<String> resources;

    private final String error;

    private final String description;

    private final String eventId;

    private final String previousEventId;

    private ExecutionEvent(BuilderImpl builder) {
        this.timestamp = builder.timestamp;
        this.type = builder.type;
        this.stepName = builder.stepName;
        this.executionBlockType = builder.executionBlockType;
        this.resources = builder.resources;
        this.error = builder.error;
        this.description = builder.description;
        this.eventId = builder.eventId;
        this.previousEventId = builder.previousEventId;
    }

    /**
     * <p>
     * The timestamp for an execution event.
     * </p>
     * 
     * @return The timestamp for an execution event.
     */
    public final Instant timestamp() {
        return timestamp;
    }

    /**
     * <p>
     * The type of an execution event.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ExecutionEventType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of an execution event.
     * @see ExecutionEventType
     */
    public final ExecutionEventType type() {
        return ExecutionEventType.fromValue(type);
    }

    /**
     * <p>
     * The type of an execution event.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ExecutionEventType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of an execution event.
     * @see ExecutionEventType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The step name for an execution event.
     * </p>
     * 
     * @return The step name for an execution event.
     */
    public final String stepName() {
        return stepName;
    }

    /**
     * <p>
     * The execution block type for an execution event.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #executionBlockType} will return {@link ExecutionBlockType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #executionBlockTypeAsString}.
     * </p>
     * 
     * @return The execution block type for an execution event.
     * @see ExecutionBlockType
     */
    public final ExecutionBlockType executionBlockType() {
        return ExecutionBlockType.fromValue(executionBlockType);
    }

    /**
     * <p>
     * The execution block type for an execution event.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #executionBlockType} will return {@link ExecutionBlockType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #executionBlockTypeAsString}.
     * </p>
     * 
     * @return The execution block type for an execution event.
     * @see ExecutionBlockType
     */
    public final String executionBlockTypeAsString() {
        return executionBlockType;
    }

    /**
     * For responses, this returns true if the service returned a value for the Resources property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasResources() {
        return resources != null && !(resources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The resources for an execution event.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResources} method.
     * </p>
     * 
     * @return The resources for an execution event.
     */
    public final List<String> resources() {
        return resources;
    }

    /**
     * <p>
     * Errors for an execution event.
     * </p>
     * 
     * @return Errors for an execution event.
     */
    public final String error() {
        return error;
    }

    /**
     * <p>
     * The description for an execution event.
     * </p>
     * 
     * @return The description for an execution event.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The event ID for an execution event.
     * </p>
     * 
     * @return The event ID for an execution event.
     */
    public final String eventId() {
        return eventId;
    }

    /**
     * <p>
     * The event ID of the previous execution event.
     * </p>
     * 
     * @return The event ID of the previous execution event.
     */
    public final String previousEventId() {
        return previousEventId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(timestamp());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(stepName());
        hashCode = 31 * hashCode + Objects.hashCode(executionBlockTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasResources() ? resources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(error());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(eventId());
        hashCode = 31 * hashCode + Objects.hashCode(previousEventId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExecutionEvent)) {
            return false;
        }
        ExecutionEvent other = (ExecutionEvent) obj;
        return Objects.equals(timestamp(), other.timestamp()) && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(stepName(), other.stepName())
                && Objects.equals(executionBlockTypeAsString(), other.executionBlockTypeAsString())
                && hasResources() == other.hasResources() && Objects.equals(resources(), other.resources())
                && Objects.equals(error(), other.error()) && Objects.equals(description(), other.description())
                && Objects.equals(eventId(), other.eventId()) && Objects.equals(previousEventId(), other.previousEventId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExecutionEvent").add("Timestamp", timestamp()).add("Type", typeAsString())
                .add("StepName", stepName()).add("ExecutionBlockType", executionBlockTypeAsString())
                .add("Resources", hasResources() ? resources() : null).add("Error", error()).add("Description", description())
                .add("EventId", eventId()).add("PreviousEventId", previousEventId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "timestamp":
            return Optional.ofNullable(clazz.cast(timestamp()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "stepName":
            return Optional.ofNullable(clazz.cast(stepName()));
        case "executionBlockType":
            return Optional.ofNullable(clazz.cast(executionBlockTypeAsString()));
        case "resources":
            return Optional.ofNullable(clazz.cast(resources()));
        case "error":
            return Optional.ofNullable(clazz.cast(error()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "eventId":
            return Optional.ofNullable(clazz.cast(eventId()));
        case "previousEventId":
            return Optional.ofNullable(clazz.cast(previousEventId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("timestamp", TIMESTAMP_FIELD);
        map.put("type", TYPE_FIELD);
        map.put("stepName", STEP_NAME_FIELD);
        map.put("executionBlockType", EXECUTION_BLOCK_TYPE_FIELD);
        map.put("resources", RESOURCES_FIELD);
        map.put("error", ERROR_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("eventId", EVENT_ID_FIELD);
        map.put("previousEventId", PREVIOUS_EVENT_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExecutionEvent, T> g) {
        return obj -> g.apply((ExecutionEvent) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExecutionEvent> {
        /**
         * <p>
         * The timestamp for an execution event.
         * </p>
         * 
         * @param timestamp
         *        The timestamp for an execution event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timestamp(Instant timestamp);

        /**
         * <p>
         * The type of an execution event.
         * </p>
         * 
         * @param type
         *        The type of an execution event.
         * @see ExecutionEventType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExecutionEventType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of an execution event.
         * </p>
         * 
         * @param type
         *        The type of an execution event.
         * @see ExecutionEventType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExecutionEventType
         */
        Builder type(ExecutionEventType type);

        /**
         * <p>
         * The step name for an execution event.
         * </p>
         * 
         * @param stepName
         *        The step name for an execution event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stepName(String stepName);

        /**
         * <p>
         * The execution block type for an execution event.
         * </p>
         * 
         * @param executionBlockType
         *        The execution block type for an execution event.
         * @see ExecutionBlockType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExecutionBlockType
         */
        Builder executionBlockType(String executionBlockType);

        /**
         * <p>
         * The execution block type for an execution event.
         * </p>
         * 
         * @param executionBlockType
         *        The execution block type for an execution event.
         * @see ExecutionBlockType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExecutionBlockType
         */
        Builder executionBlockType(ExecutionBlockType executionBlockType);

        /**
         * <p>
         * The resources for an execution event.
         * </p>
         * 
         * @param resources
         *        The resources for an execution event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resources(Collection<String> resources);

        /**
         * <p>
         * The resources for an execution event.
         * </p>
         * 
         * @param resources
         *        The resources for an execution event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resources(String... resources);

        /**
         * <p>
         * Errors for an execution event.
         * </p>
         * 
         * @param error
         *        Errors for an execution event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder error(String error);

        /**
         * <p>
         * The description for an execution event.
         * </p>
         * 
         * @param description
         *        The description for an execution event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The event ID for an execution event.
         * </p>
         * 
         * @param eventId
         *        The event ID for an execution event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventId(String eventId);

        /**
         * <p>
         * The event ID of the previous execution event.
         * </p>
         * 
         * @param previousEventId
         *        The event ID of the previous execution event.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder previousEventId(String previousEventId);
    }

    static final class BuilderImpl implements Builder {
        private Instant timestamp;

        private String type;

        private String stepName;

        private String executionBlockType;

        private List<String> resources = DefaultSdkAutoConstructList.getInstance();

        private String error;

        private String description;

        private String eventId;

        private String previousEventId;

        private BuilderImpl() {
        }

        private BuilderImpl(ExecutionEvent model) {
            timestamp(model.timestamp);
            type(model.type);
            stepName(model.stepName);
            executionBlockType(model.executionBlockType);
            resources(model.resources);
            error(model.error);
            description(model.description);
            eventId(model.eventId);
            previousEventId(model.previousEventId);
        }

        public final Instant getTimestamp() {
            return timestamp;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ExecutionEventType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getStepName() {
            return stepName;
        }

        public final void setStepName(String stepName) {
            this.stepName = stepName;
        }

        @Override
        public final Builder stepName(String stepName) {
            this.stepName = stepName;
            return this;
        }

        public final String getExecutionBlockType() {
            return executionBlockType;
        }

        public final void setExecutionBlockType(String executionBlockType) {
            this.executionBlockType = executionBlockType;
        }

        @Override
        public final Builder executionBlockType(String executionBlockType) {
            this.executionBlockType = executionBlockType;
            return this;
        }

        @Override
        public final Builder executionBlockType(ExecutionBlockType executionBlockType) {
            this.executionBlockType(executionBlockType == null ? null : executionBlockType.toString());
            return this;
        }

        public final Collection<String> getResources() {
            if (resources instanceof SdkAutoConstructList) {
                return null;
            }
            return resources;
        }

        public final void setResources(Collection<String> resources) {
            this.resources = ResourcesCopier.copy(resources);
        }

        @Override
        public final Builder resources(Collection<String> resources) {
            this.resources = ResourcesCopier.copy(resources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resources(String... resources) {
            resources(Arrays.asList(resources));
            return this;
        }

        public final String getError() {
            return error;
        }

        public final void setError(String error) {
            this.error = error;
        }

        @Override
        public final Builder error(String error) {
            this.error = error;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getEventId() {
            return eventId;
        }

        public final void setEventId(String eventId) {
            this.eventId = eventId;
        }

        @Override
        public final Builder eventId(String eventId) {
            this.eventId = eventId;
            return this;
        }

        public final String getPreviousEventId() {
            return previousEventId;
        }

        public final void setPreviousEventId(String previousEventId) {
            this.previousEventId = previousEventId;
        }

        @Override
        public final Builder previousEventId(String previousEventId) {
            this.previousEventId = previousEventId;
            return this;
        }

        @Override
        public ExecutionEvent build() {
            return new ExecutionEvent(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
