/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.arcregionswitch.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetPlanExecutionResponse extends ArcRegionSwitchResponse implements
        ToCopyableBuilder<GetPlanExecutionResponse.Builder, GetPlanExecutionResponse> {
    private static final SdkField<String> PLAN_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("planArn").getter(getter(GetPlanExecutionResponse::planArn)).setter(setter(Builder::planArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("planArn").build()).build();

    private static final SdkField<String> EXECUTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("executionId").getter(getter(GetPlanExecutionResponse::executionId)).setter(setter(Builder::executionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionId").build()).build();

    private static final SdkField<String> VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("version")
            .getter(getter(GetPlanExecutionResponse::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt").getter(getter(GetPlanExecutionResponse::updatedAt)).setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build()).build();

    private static final SdkField<String> COMMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("comment")
            .getter(getter(GetPlanExecutionResponse::comment)).setter(setter(Builder::comment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("comment").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("startTime").getter(getter(GetPlanExecutionResponse::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("endTime").getter(getter(GetPlanExecutionResponse::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build()).build();

    private static final SdkField<String> MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("mode")
            .getter(getter(GetPlanExecutionResponse::modeAsString)).setter(setter(Builder::mode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mode").build()).build();

    private static final SdkField<String> EXECUTION_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("executionState").getter(getter(GetPlanExecutionResponse::executionStateAsString))
            .setter(setter(Builder::executionState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionState").build()).build();

    private static final SdkField<String> EXECUTION_ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("executionAction").getter(getter(GetPlanExecutionResponse::executionActionAsString))
            .setter(setter(Builder::executionAction))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionAction").build()).build();

    private static final SdkField<String> EXECUTION_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("executionRegion").getter(getter(GetPlanExecutionResponse::executionRegion))
            .setter(setter(Builder::executionRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionRegion").build()).build();

    private static final SdkField<List<StepState>> STEP_STATES_FIELD = SdkField
            .<List<StepState>> builder(MarshallingType.LIST)
            .memberName("stepStates")
            .getter(getter(GetPlanExecutionResponse::stepStates))
            .setter(setter(Builder::stepStates))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stepStates").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StepState> builder(MarshallingType.SDK_POJO)
                                            .constructor(StepState::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Plan> PLAN_FIELD = SdkField.<Plan> builder(MarshallingType.SDK_POJO).memberName("plan")
            .getter(getter(GetPlanExecutionResponse::plan)).setter(setter(Builder::plan)).constructor(Plan::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("plan").build()).build();

    private static final SdkField<String> ACTUAL_RECOVERY_TIME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("actualRecoveryTime").getter(getter(GetPlanExecutionResponse::actualRecoveryTime))
            .setter(setter(Builder::actualRecoveryTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actualRecoveryTime").build())
            .build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(GetPlanExecutionResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PLAN_ARN_FIELD,
            EXECUTION_ID_FIELD, VERSION_FIELD, UPDATED_AT_FIELD, COMMENT_FIELD, START_TIME_FIELD, END_TIME_FIELD, MODE_FIELD,
            EXECUTION_STATE_FIELD, EXECUTION_ACTION_FIELD, EXECUTION_REGION_FIELD, STEP_STATES_FIELD, PLAN_FIELD,
            ACTUAL_RECOVERY_TIME_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String planArn;

    private final String executionId;

    private final String version;

    private final Instant updatedAt;

    private final String comment;

    private final Instant startTime;

    private final Instant endTime;

    private final String mode;

    private final String executionState;

    private final String executionAction;

    private final String executionRegion;

    private final List<StepState> stepStates;

    private final Plan plan;

    private final String actualRecoveryTime;

    private final String nextToken;

    private GetPlanExecutionResponse(BuilderImpl builder) {
        super(builder);
        this.planArn = builder.planArn;
        this.executionId = builder.executionId;
        this.version = builder.version;
        this.updatedAt = builder.updatedAt;
        this.comment = builder.comment;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.mode = builder.mode;
        this.executionState = builder.executionState;
        this.executionAction = builder.executionAction;
        this.executionRegion = builder.executionRegion;
        this.stepStates = builder.stepStates;
        this.plan = builder.plan;
        this.actualRecoveryTime = builder.actualRecoveryTime;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the plan.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the plan.
     */
    public final String planArn() {
        return planArn;
    }

    /**
     * <p>
     * The execution identifier of a plan execution.
     * </p>
     * 
     * @return The execution identifier of a plan execution.
     */
    public final String executionId() {
        return executionId;
    }

    /**
     * <p>
     * The version for the plan.
     * </p>
     * 
     * @return The version for the plan.
     */
    public final String version() {
        return version;
    }

    /**
     * <p>
     * The timestamp when the plan execution was last updated.
     * </p>
     * 
     * @return The timestamp when the plan execution was last updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    /**
     * <p>
     * A comment included on the plan execution.
     * </p>
     * 
     * @return A comment included on the plan execution.
     */
    public final String comment() {
        return comment;
    }

    /**
     * <p>
     * The time (UTC) when the plan execution started.
     * </p>
     * 
     * @return The time (UTC) when the plan execution started.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The time (UTC) when the plan execution ended.
     * </p>
     * 
     * @return The time (UTC) when the plan execution ended.
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * The plan execution mode. Valid values are <code>Practice</code>, for testing without making actual changes, or
     * <code>Recovery</code>, for actual traffic shifting and application recovery.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mode} will return
     * {@link ExecutionMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #modeAsString}.
     * </p>
     * 
     * @return The plan execution mode. Valid values are <code>Practice</code>, for testing without making actual
     *         changes, or <code>Recovery</code>, for actual traffic shifting and application recovery.
     * @see ExecutionMode
     */
    public final ExecutionMode mode() {
        return ExecutionMode.fromValue(mode);
    }

    /**
     * <p>
     * The plan execution mode. Valid values are <code>Practice</code>, for testing without making actual changes, or
     * <code>Recovery</code>, for actual traffic shifting and application recovery.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mode} will return
     * {@link ExecutionMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #modeAsString}.
     * </p>
     * 
     * @return The plan execution mode. Valid values are <code>Practice</code>, for testing without making actual
     *         changes, or <code>Recovery</code>, for actual traffic shifting and application recovery.
     * @see ExecutionMode
     */
    public final String modeAsString() {
        return mode;
    }

    /**
     * <p>
     * The plan execution state. Provides the state of a plan execution, for example, In Progress or Paused by Operator.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #executionState}
     * will return {@link ExecutionState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #executionStateAsString}.
     * </p>
     * 
     * @return The plan execution state. Provides the state of a plan execution, for example, In Progress or Paused by
     *         Operator.
     * @see ExecutionState
     */
    public final ExecutionState executionState() {
        return ExecutionState.fromValue(executionState);
    }

    /**
     * <p>
     * The plan execution state. Provides the state of a plan execution, for example, In Progress or Paused by Operator.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #executionState}
     * will return {@link ExecutionState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #executionStateAsString}.
     * </p>
     * 
     * @return The plan execution state. Provides the state of a plan execution, for example, In Progress or Paused by
     *         Operator.
     * @see ExecutionState
     */
    public final String executionStateAsString() {
        return executionState;
    }

    /**
     * <p>
     * The plan execution action. Valid values are <code>Activate</code>, to activate an Amazon Web Services Region, or
     * <code>Deactivate</code>, to deactivate a Region.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #executionAction}
     * will return {@link ExecutionAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #executionActionAsString}.
     * </p>
     * 
     * @return The plan execution action. Valid values are <code>Activate</code>, to activate an Amazon Web Services
     *         Region, or <code>Deactivate</code>, to deactivate a Region.
     * @see ExecutionAction
     */
    public final ExecutionAction executionAction() {
        return ExecutionAction.fromValue(executionAction);
    }

    /**
     * <p>
     * The plan execution action. Valid values are <code>Activate</code>, to activate an Amazon Web Services Region, or
     * <code>Deactivate</code>, to deactivate a Region.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #executionAction}
     * will return {@link ExecutionAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #executionActionAsString}.
     * </p>
     * 
     * @return The plan execution action. Valid values are <code>Activate</code>, to activate an Amazon Web Services
     *         Region, or <code>Deactivate</code>, to deactivate a Region.
     * @see ExecutionAction
     */
    public final String executionActionAsString() {
        return executionAction;
    }

    /**
     * <p>
     * The Amazon Web Services Region for a plan execution.
     * </p>
     * 
     * @return The Amazon Web Services Region for a plan execution.
     */
    public final String executionRegion() {
        return executionRegion;
    }

    /**
     * For responses, this returns true if the service returned a value for the StepStates property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasStepStates() {
        return stepStates != null && !(stepStates instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The states of the steps in the plan execution.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStepStates} method.
     * </p>
     * 
     * @return The states of the steps in the plan execution.
     */
    public final List<StepState> stepStates() {
        return stepStates;
    }

    /**
     * <p>
     * The details of the Region switch plan.
     * </p>
     * 
     * @return The details of the Region switch plan.
     */
    public final Plan plan() {
        return plan;
    }

    /**
     * <p>
     * The actual recovery time that Region switch calculates for a plan execution. Actual recovery time includes the
     * time for the plan to run added to the time elapsed until the application health alarms that you've specified are
     * healthy again.
     * </p>
     * 
     * @return The actual recovery time that Region switch calculates for a plan execution. Actual recovery time
     *         includes the time for the plan to run added to the time elapsed until the application health alarms that
     *         you've specified are healthy again.
     */
    public final String actualRecoveryTime() {
        return actualRecoveryTime;
    }

    /**
     * <p>
     * Specifies that you want to receive the next page of results. Valid only if you received a <code>nextToken</code>
     * response in the previous request. If you did, it indicates that more output is available. Set this parameter to
     * the value provided by the previous call's <code>nextToken</code> response to request the next page of results.
     * </p>
     * 
     * @return Specifies that you want to receive the next page of results. Valid only if you received a
     *         <code>nextToken</code> response in the previous request. If you did, it indicates that more output is
     *         available. Set this parameter to the value provided by the previous call's <code>nextToken</code>
     *         response to request the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(planArn());
        hashCode = 31 * hashCode + Objects.hashCode(executionId());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(comment());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(modeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(executionStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(executionActionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(executionRegion());
        hashCode = 31 * hashCode + Objects.hashCode(hasStepStates() ? stepStates() : null);
        hashCode = 31 * hashCode + Objects.hashCode(plan());
        hashCode = 31 * hashCode + Objects.hashCode(actualRecoveryTime());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPlanExecutionResponse)) {
            return false;
        }
        GetPlanExecutionResponse other = (GetPlanExecutionResponse) obj;
        return Objects.equals(planArn(), other.planArn()) && Objects.equals(executionId(), other.executionId())
                && Objects.equals(version(), other.version()) && Objects.equals(updatedAt(), other.updatedAt())
                && Objects.equals(comment(), other.comment()) && Objects.equals(startTime(), other.startTime())
                && Objects.equals(endTime(), other.endTime()) && Objects.equals(modeAsString(), other.modeAsString())
                && Objects.equals(executionStateAsString(), other.executionStateAsString())
                && Objects.equals(executionActionAsString(), other.executionActionAsString())
                && Objects.equals(executionRegion(), other.executionRegion()) && hasStepStates() == other.hasStepStates()
                && Objects.equals(stepStates(), other.stepStates()) && Objects.equals(plan(), other.plan())
                && Objects.equals(actualRecoveryTime(), other.actualRecoveryTime())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetPlanExecutionResponse").add("PlanArn", planArn()).add("ExecutionId", executionId())
                .add("Version", version()).add("UpdatedAt", updatedAt()).add("Comment", comment()).add("StartTime", startTime())
                .add("EndTime", endTime()).add("Mode", modeAsString()).add("ExecutionState", executionStateAsString())
                .add("ExecutionAction", executionActionAsString()).add("ExecutionRegion", executionRegion())
                .add("StepStates", hasStepStates() ? stepStates() : null).add("Plan", plan())
                .add("ActualRecoveryTime", actualRecoveryTime()).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "planArn":
            return Optional.ofNullable(clazz.cast(planArn()));
        case "executionId":
            return Optional.ofNullable(clazz.cast(executionId()));
        case "version":
            return Optional.ofNullable(clazz.cast(version()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        case "comment":
            return Optional.ofNullable(clazz.cast(comment()));
        case "startTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "endTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "mode":
            return Optional.ofNullable(clazz.cast(modeAsString()));
        case "executionState":
            return Optional.ofNullable(clazz.cast(executionStateAsString()));
        case "executionAction":
            return Optional.ofNullable(clazz.cast(executionActionAsString()));
        case "executionRegion":
            return Optional.ofNullable(clazz.cast(executionRegion()));
        case "stepStates":
            return Optional.ofNullable(clazz.cast(stepStates()));
        case "plan":
            return Optional.ofNullable(clazz.cast(plan()));
        case "actualRecoveryTime":
            return Optional.ofNullable(clazz.cast(actualRecoveryTime()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("planArn", PLAN_ARN_FIELD);
        map.put("executionId", EXECUTION_ID_FIELD);
        map.put("version", VERSION_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        map.put("comment", COMMENT_FIELD);
        map.put("startTime", START_TIME_FIELD);
        map.put("endTime", END_TIME_FIELD);
        map.put("mode", MODE_FIELD);
        map.put("executionState", EXECUTION_STATE_FIELD);
        map.put("executionAction", EXECUTION_ACTION_FIELD);
        map.put("executionRegion", EXECUTION_REGION_FIELD);
        map.put("stepStates", STEP_STATES_FIELD);
        map.put("plan", PLAN_FIELD);
        map.put("actualRecoveryTime", ACTUAL_RECOVERY_TIME_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetPlanExecutionResponse, T> g) {
        return obj -> g.apply((GetPlanExecutionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ArcRegionSwitchResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetPlanExecutionResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the plan.
         * </p>
         * 
         * @param planArn
         *        The Amazon Resource Name (ARN) of the plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder planArn(String planArn);

        /**
         * <p>
         * The execution identifier of a plan execution.
         * </p>
         * 
         * @param executionId
         *        The execution identifier of a plan execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionId(String executionId);

        /**
         * <p>
         * The version for the plan.
         * </p>
         * 
         * @param version
         *        The version for the plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(String version);

        /**
         * <p>
         * The timestamp when the plan execution was last updated.
         * </p>
         * 
         * @param updatedAt
         *        The timestamp when the plan execution was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);

        /**
         * <p>
         * A comment included on the plan execution.
         * </p>
         * 
         * @param comment
         *        A comment included on the plan execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder comment(String comment);

        /**
         * <p>
         * The time (UTC) when the plan execution started.
         * </p>
         * 
         * @param startTime
         *        The time (UTC) when the plan execution started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The time (UTC) when the plan execution ended.
         * </p>
         * 
         * @param endTime
         *        The time (UTC) when the plan execution ended.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * The plan execution mode. Valid values are <code>Practice</code>, for testing without making actual changes,
         * or <code>Recovery</code>, for actual traffic shifting and application recovery.
         * </p>
         * 
         * @param mode
         *        The plan execution mode. Valid values are <code>Practice</code>, for testing without making actual
         *        changes, or <code>Recovery</code>, for actual traffic shifting and application recovery.
         * @see ExecutionMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExecutionMode
         */
        Builder mode(String mode);

        /**
         * <p>
         * The plan execution mode. Valid values are <code>Practice</code>, for testing without making actual changes,
         * or <code>Recovery</code>, for actual traffic shifting and application recovery.
         * </p>
         * 
         * @param mode
         *        The plan execution mode. Valid values are <code>Practice</code>, for testing without making actual
         *        changes, or <code>Recovery</code>, for actual traffic shifting and application recovery.
         * @see ExecutionMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExecutionMode
         */
        Builder mode(ExecutionMode mode);

        /**
         * <p>
         * The plan execution state. Provides the state of a plan execution, for example, In Progress or Paused by
         * Operator.
         * </p>
         * 
         * @param executionState
         *        The plan execution state. Provides the state of a plan execution, for example, In Progress or Paused
         *        by Operator.
         * @see ExecutionState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExecutionState
         */
        Builder executionState(String executionState);

        /**
         * <p>
         * The plan execution state. Provides the state of a plan execution, for example, In Progress or Paused by
         * Operator.
         * </p>
         * 
         * @param executionState
         *        The plan execution state. Provides the state of a plan execution, for example, In Progress or Paused
         *        by Operator.
         * @see ExecutionState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExecutionState
         */
        Builder executionState(ExecutionState executionState);

        /**
         * <p>
         * The plan execution action. Valid values are <code>Activate</code>, to activate an Amazon Web Services Region,
         * or <code>Deactivate</code>, to deactivate a Region.
         * </p>
         * 
         * @param executionAction
         *        The plan execution action. Valid values are <code>Activate</code>, to activate an Amazon Web Services
         *        Region, or <code>Deactivate</code>, to deactivate a Region.
         * @see ExecutionAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExecutionAction
         */
        Builder executionAction(String executionAction);

        /**
         * <p>
         * The plan execution action. Valid values are <code>Activate</code>, to activate an Amazon Web Services Region,
         * or <code>Deactivate</code>, to deactivate a Region.
         * </p>
         * 
         * @param executionAction
         *        The plan execution action. Valid values are <code>Activate</code>, to activate an Amazon Web Services
         *        Region, or <code>Deactivate</code>, to deactivate a Region.
         * @see ExecutionAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExecutionAction
         */
        Builder executionAction(ExecutionAction executionAction);

        /**
         * <p>
         * The Amazon Web Services Region for a plan execution.
         * </p>
         * 
         * @param executionRegion
         *        The Amazon Web Services Region for a plan execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionRegion(String executionRegion);

        /**
         * <p>
         * The states of the steps in the plan execution.
         * </p>
         * 
         * @param stepStates
         *        The states of the steps in the plan execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stepStates(Collection<StepState> stepStates);

        /**
         * <p>
         * The states of the steps in the plan execution.
         * </p>
         * 
         * @param stepStates
         *        The states of the steps in the plan execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stepStates(StepState... stepStates);

        /**
         * <p>
         * The states of the steps in the plan execution.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.arcregionswitch.model.StepState.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.arcregionswitch.model.StepState#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.arcregionswitch.model.StepState.Builder#build()} is called immediately
         * and its result is passed to {@link #stepStates(List<StepState>)}.
         * 
         * @param stepStates
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.arcregionswitch.model.StepState.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #stepStates(java.util.Collection<StepState>)
         */
        Builder stepStates(Consumer<StepState.Builder>... stepStates);

        /**
         * <p>
         * The details of the Region switch plan.
         * </p>
         * 
         * @param plan
         *        The details of the Region switch plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder plan(Plan plan);

        /**
         * <p>
         * The details of the Region switch plan.
         * </p>
         * This is a convenience method that creates an instance of the {@link Plan.Builder} avoiding the need to create
         * one manually via {@link Plan#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Plan.Builder#build()} is called immediately and its result is
         * passed to {@link #plan(Plan)}.
         * 
         * @param plan
         *        a consumer that will call methods on {@link Plan.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #plan(Plan)
         */
        default Builder plan(Consumer<Plan.Builder> plan) {
            return plan(Plan.builder().applyMutation(plan).build());
        }

        /**
         * <p>
         * The actual recovery time that Region switch calculates for a plan execution. Actual recovery time includes
         * the time for the plan to run added to the time elapsed until the application health alarms that you've
         * specified are healthy again.
         * </p>
         * 
         * @param actualRecoveryTime
         *        The actual recovery time that Region switch calculates for a plan execution. Actual recovery time
         *        includes the time for the plan to run added to the time elapsed until the application health alarms
         *        that you've specified are healthy again.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actualRecoveryTime(String actualRecoveryTime);

        /**
         * <p>
         * Specifies that you want to receive the next page of results. Valid only if you received a
         * <code>nextToken</code> response in the previous request. If you did, it indicates that more output is
         * available. Set this parameter to the value provided by the previous call's <code>nextToken</code> response to
         * request the next page of results.
         * </p>
         * 
         * @param nextToken
         *        Specifies that you want to receive the next page of results. Valid only if you received a
         *        <code>nextToken</code> response in the previous request. If you did, it indicates that more output is
         *        available. Set this parameter to the value provided by the previous call's <code>nextToken</code>
         *        response to request the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ArcRegionSwitchResponse.BuilderImpl implements Builder {
        private String planArn;

        private String executionId;

        private String version;

        private Instant updatedAt;

        private String comment;

        private Instant startTime;

        private Instant endTime;

        private String mode;

        private String executionState;

        private String executionAction;

        private String executionRegion;

        private List<StepState> stepStates = DefaultSdkAutoConstructList.getInstance();

        private Plan plan;

        private String actualRecoveryTime;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetPlanExecutionResponse model) {
            super(model);
            planArn(model.planArn);
            executionId(model.executionId);
            version(model.version);
            updatedAt(model.updatedAt);
            comment(model.comment);
            startTime(model.startTime);
            endTime(model.endTime);
            mode(model.mode);
            executionState(model.executionState);
            executionAction(model.executionAction);
            executionRegion(model.executionRegion);
            stepStates(model.stepStates);
            plan(model.plan);
            actualRecoveryTime(model.actualRecoveryTime);
            nextToken(model.nextToken);
        }

        public final String getPlanArn() {
            return planArn;
        }

        public final void setPlanArn(String planArn) {
            this.planArn = planArn;
        }

        @Override
        public final Builder planArn(String planArn) {
            this.planArn = planArn;
            return this;
        }

        public final String getExecutionId() {
            return executionId;
        }

        public final void setExecutionId(String executionId) {
            this.executionId = executionId;
        }

        @Override
        public final Builder executionId(String executionId) {
            this.executionId = executionId;
            return this;
        }

        public final String getVersion() {
            return version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getComment() {
            return comment;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        @Override
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getMode() {
            return mode;
        }

        public final void setMode(String mode) {
            this.mode = mode;
        }

        @Override
        public final Builder mode(String mode) {
            this.mode = mode;
            return this;
        }

        @Override
        public final Builder mode(ExecutionMode mode) {
            this.mode(mode == null ? null : mode.toString());
            return this;
        }

        public final String getExecutionState() {
            return executionState;
        }

        public final void setExecutionState(String executionState) {
            this.executionState = executionState;
        }

        @Override
        public final Builder executionState(String executionState) {
            this.executionState = executionState;
            return this;
        }

        @Override
        public final Builder executionState(ExecutionState executionState) {
            this.executionState(executionState == null ? null : executionState.toString());
            return this;
        }

        public final String getExecutionAction() {
            return executionAction;
        }

        public final void setExecutionAction(String executionAction) {
            this.executionAction = executionAction;
        }

        @Override
        public final Builder executionAction(String executionAction) {
            this.executionAction = executionAction;
            return this;
        }

        @Override
        public final Builder executionAction(ExecutionAction executionAction) {
            this.executionAction(executionAction == null ? null : executionAction.toString());
            return this;
        }

        public final String getExecutionRegion() {
            return executionRegion;
        }

        public final void setExecutionRegion(String executionRegion) {
            this.executionRegion = executionRegion;
        }

        @Override
        public final Builder executionRegion(String executionRegion) {
            this.executionRegion = executionRegion;
            return this;
        }

        public final List<StepState.Builder> getStepStates() {
            List<StepState.Builder> result = StepStatesCopier.copyToBuilder(this.stepStates);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setStepStates(Collection<StepState.BuilderImpl> stepStates) {
            this.stepStates = StepStatesCopier.copyFromBuilder(stepStates);
        }

        @Override
        public final Builder stepStates(Collection<StepState> stepStates) {
            this.stepStates = StepStatesCopier.copy(stepStates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stepStates(StepState... stepStates) {
            stepStates(Arrays.asList(stepStates));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder stepStates(Consumer<StepState.Builder>... stepStates) {
            stepStates(Stream.of(stepStates).map(c -> StepState.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Plan.Builder getPlan() {
            return plan != null ? plan.toBuilder() : null;
        }

        public final void setPlan(Plan.BuilderImpl plan) {
            this.plan = plan != null ? plan.build() : null;
        }

        @Override
        public final Builder plan(Plan plan) {
            this.plan = plan;
            return this;
        }

        public final String getActualRecoveryTime() {
            return actualRecoveryTime;
        }

        public final void setActualRecoveryTime(String actualRecoveryTime) {
            this.actualRecoveryTime = actualRecoveryTime;
        }

        @Override
        public final Builder actualRecoveryTime(String actualRecoveryTime) {
            this.actualRecoveryTime = actualRecoveryTime;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetPlanExecutionResponse build() {
            return new GetPlanExecutionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
