/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.arcregionswitch.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;

@Generated("software.amazon.awssdk:codegen")
final class KubernetesScalingAppsCopier {
    static List<Map<String, Map<String, KubernetesScalingResource>>> copy(
            Collection<? extends Map<String, ? extends Map<String, ? extends KubernetesScalingResource>>> kubernetesScalingAppsParam) {
        List<Map<String, Map<String, KubernetesScalingResource>>> list;
        if (kubernetesScalingAppsParam == null || kubernetesScalingAppsParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<Map<String, Map<String, KubernetesScalingResource>>> modifiableList = new ArrayList<>(
                    kubernetesScalingAppsParam.size());
            kubernetesScalingAppsParam.forEach(entry -> {
                Map<String, Map<String, KubernetesScalingResource>> map;
                if (entry == null || entry instanceof SdkAutoConstructMap) {
                    map = DefaultSdkAutoConstructMap.getInstance();
                } else {
                    Map<String, Map<String, KubernetesScalingResource>> modifiableMap = new LinkedHashMap<>(entry.size());
                    entry.forEach((key, value) -> {
                        Map<String, KubernetesScalingResource> map1;
                        if (value == null || value instanceof SdkAutoConstructMap) {
                            map1 = DefaultSdkAutoConstructMap.getInstance();
                        } else {
                            Map<String, KubernetesScalingResource> modifiableMap1 = new LinkedHashMap<>(value.size());
                            value.forEach((key1, value1) -> {
                                modifiableMap1.put(key1, value1);
                            });
                            map1 = Collections.unmodifiableMap(modifiableMap1);
                        }
                        modifiableMap.put(key, map1);
                    });
                    map = Collections.unmodifiableMap(modifiableMap);
                }
                modifiableList.add(map);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<Map<String, Map<String, KubernetesScalingResource>>> copyFromBuilder(
            Collection<? extends Map<String, ? extends Map<String, ? extends KubernetesScalingResource.Builder>>> kubernetesScalingAppsParam) {
        List<Map<String, Map<String, KubernetesScalingResource>>> list;
        if (kubernetesScalingAppsParam == null || kubernetesScalingAppsParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<Map<String, Map<String, KubernetesScalingResource>>> modifiableList = new ArrayList<>(
                    kubernetesScalingAppsParam.size());
            kubernetesScalingAppsParam.forEach(entry -> {
                Map<String, Map<String, KubernetesScalingResource>> map;
                if (entry == null || entry instanceof SdkAutoConstructMap) {
                    map = DefaultSdkAutoConstructMap.getInstance();
                } else {
                    Map<String, Map<String, KubernetesScalingResource>> modifiableMap = new LinkedHashMap<>(entry.size());
                    entry.forEach((key, value) -> {
                        Map<String, KubernetesScalingResource> map1;
                        if (value == null || value instanceof SdkAutoConstructMap) {
                            map1 = DefaultSdkAutoConstructMap.getInstance();
                        } else {
                            Map<String, KubernetesScalingResource> modifiableMap1 = new LinkedHashMap<>(value.size());
                            value.forEach((key1, value1) -> {
                                KubernetesScalingResource member = value1 == null ? null : value1.build();
                                modifiableMap1.put(key1, member);
                            });
                            map1 = Collections.unmodifiableMap(modifiableMap1);
                        }
                        modifiableMap.put(key, map1);
                    });
                    map = Collections.unmodifiableMap(modifiableMap);
                }
                modifiableList.add(map);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<Map<String, Map<String, KubernetesScalingResource.Builder>>> copyToBuilder(
            Collection<? extends Map<String, ? extends Map<String, ? extends KubernetesScalingResource>>> kubernetesScalingAppsParam) {
        List<Map<String, Map<String, KubernetesScalingResource.Builder>>> list;
        if (kubernetesScalingAppsParam == null || kubernetesScalingAppsParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<Map<String, Map<String, KubernetesScalingResource.Builder>>> modifiableList = new ArrayList<>(
                    kubernetesScalingAppsParam.size());
            kubernetesScalingAppsParam
                    .forEach(entry -> {
                        Map<String, Map<String, KubernetesScalingResource.Builder>> map;
                        if (entry == null || entry instanceof SdkAutoConstructMap) {
                            map = DefaultSdkAutoConstructMap.getInstance();
                        } else {
                            Map<String, Map<String, KubernetesScalingResource.Builder>> modifiableMap = new LinkedHashMap<>(entry
                                    .size());
                            entry.forEach((key, value) -> {
                                Map<String, KubernetesScalingResource.Builder> map1;
                                if (value == null || value instanceof SdkAutoConstructMap) {
                                    map1 = DefaultSdkAutoConstructMap.getInstance();
                                } else {
                                    Map<String, KubernetesScalingResource.Builder> modifiableMap1 = new LinkedHashMap<>(value
                                            .size());
                                    value.forEach((key1, value1) -> {
                                        KubernetesScalingResource.Builder member = value1 == null ? null : value1.toBuilder();
                                        modifiableMap1.put(key1, member);
                                    });
                                    map1 = Collections.unmodifiableMap(modifiableMap1);
                                }
                                modifiableMap.put(key, map1);
                            });
                            map = Collections.unmodifiableMap(modifiableMap);
                        }
                        modifiableList.add(map);
                    });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
