/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.arcregionswitch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines a Kubernetes resource to scale in an Amazon EKS cluster.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class KubernetesScalingResource implements SdkPojo, Serializable,
        ToCopyableBuilder<KubernetesScalingResource.Builder, KubernetesScalingResource> {
    private static final SdkField<String> NAMESPACE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("namespace").getter(getter(KubernetesScalingResource::namespace)).setter(setter(Builder::namespace))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespace").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(KubernetesScalingResource::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> HPA_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("hpaName").getter(getter(KubernetesScalingResource::hpaName)).setter(setter(Builder::hpaName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hpaName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAMESPACE_FIELD, NAME_FIELD,
            HPA_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String namespace;

    private final String name;

    private final String hpaName;

    private KubernetesScalingResource(BuilderImpl builder) {
        this.namespace = builder.namespace;
        this.name = builder.name;
        this.hpaName = builder.hpaName;
    }

    /**
     * <p>
     * The namespace for the Kubernetes resource.
     * </p>
     * 
     * @return The namespace for the Kubernetes resource.
     */
    public final String namespace() {
        return namespace;
    }

    /**
     * <p>
     * The name for the Kubernetes resource.
     * </p>
     * 
     * @return The name for the Kubernetes resource.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The hpaname for the Kubernetes resource.
     * </p>
     * 
     * @return The hpaname for the Kubernetes resource.
     */
    public final String hpaName() {
        return hpaName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(namespace());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hpaName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KubernetesScalingResource)) {
            return false;
        }
        KubernetesScalingResource other = (KubernetesScalingResource) obj;
        return Objects.equals(namespace(), other.namespace()) && Objects.equals(name(), other.name())
                && Objects.equals(hpaName(), other.hpaName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("KubernetesScalingResource").add("Namespace", namespace()).add("Name", name())
                .add("HpaName", hpaName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "namespace":
            return Optional.ofNullable(clazz.cast(namespace()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "hpaName":
            return Optional.ofNullable(clazz.cast(hpaName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("namespace", NAMESPACE_FIELD);
        map.put("name", NAME_FIELD);
        map.put("hpaName", HPA_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<KubernetesScalingResource, T> g) {
        return obj -> g.apply((KubernetesScalingResource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, KubernetesScalingResource> {
        /**
         * <p>
         * The namespace for the Kubernetes resource.
         * </p>
         * 
         * @param namespace
         *        The namespace for the Kubernetes resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespace(String namespace);

        /**
         * <p>
         * The name for the Kubernetes resource.
         * </p>
         * 
         * @param name
         *        The name for the Kubernetes resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The hpaname for the Kubernetes resource.
         * </p>
         * 
         * @param hpaName
         *        The hpaname for the Kubernetes resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hpaName(String hpaName);
    }

    static final class BuilderImpl implements Builder {
        private String namespace;

        private String name;

        private String hpaName;

        private BuilderImpl() {
        }

        private BuilderImpl(KubernetesScalingResource model) {
            namespace(model.namespace);
            name(model.name);
            hpaName(model.hpaName);
        }

        public final String getNamespace() {
            return namespace;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getHpaName() {
            return hpaName;
        }

        public final void setHpaName(String hpaName) {
            this.hpaName = hpaName;
        }

        @Override
        public final Builder hpaName(String hpaName) {
            this.hpaName = hpaName;
            return this;
        }

        @Override
        public KubernetesScalingResource build() {
            return new KubernetesScalingResource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
