/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.arcregionswitch.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartPlanExecutionResponse extends ArcRegionSwitchResponse implements
        ToCopyableBuilder<StartPlanExecutionResponse.Builder, StartPlanExecutionResponse> {
    private static final SdkField<String> EXECUTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("executionId").getter(getter(StartPlanExecutionResponse::executionId))
            .setter(setter(Builder::executionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionId").build()).build();

    private static final SdkField<String> PLAN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("plan")
            .getter(getter(StartPlanExecutionResponse::plan)).setter(setter(Builder::plan))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("plan").build()).build();

    private static final SdkField<String> PLAN_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("planVersion").getter(getter(StartPlanExecutionResponse::planVersion))
            .setter(setter(Builder::planVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("planVersion").build()).build();

    private static final SdkField<String> ACTIVATE_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("activateRegion").getter(getter(StartPlanExecutionResponse::activateRegion))
            .setter(setter(Builder::activateRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("activateRegion").build()).build();

    private static final SdkField<String> DEACTIVATE_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("deactivateRegion").getter(getter(StartPlanExecutionResponse::deactivateRegion))
            .setter(setter(Builder::deactivateRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deactivateRegion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXECUTION_ID_FIELD,
            PLAN_FIELD, PLAN_VERSION_FIELD, ACTIVATE_REGION_FIELD, DEACTIVATE_REGION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String executionId;

    private final String plan;

    private final String planVersion;

    private final String activateRegion;

    private final String deactivateRegion;

    private StartPlanExecutionResponse(BuilderImpl builder) {
        super(builder);
        this.executionId = builder.executionId;
        this.plan = builder.plan;
        this.planVersion = builder.planVersion;
        this.activateRegion = builder.activateRegion;
        this.deactivateRegion = builder.deactivateRegion;
    }

    /**
     * <p>
     * The execution identifier of a plan execution.
     * </p>
     * 
     * @return The execution identifier of a plan execution.
     */
    public final String executionId() {
        return executionId;
    }

    /**
     * <p>
     * The details of the Region switch plan.
     * </p>
     * 
     * @return The details of the Region switch plan.
     */
    public final String plan() {
        return plan;
    }

    /**
     * <p>
     * The version of the plan, a unique number generated by Region switch.
     * </p>
     * 
     * @return The version of the plan, a unique number generated by Region switch.
     */
    public final String planVersion() {
        return planVersion;
    }

    /**
     * <p>
     * The Amazon Web Services Region to activate.
     * </p>
     * 
     * @return The Amazon Web Services Region to activate.
     */
    public final String activateRegion() {
        return activateRegion;
    }

    /**
     * <p>
     * The Amazon Web Services Region to deactivate.
     * </p>
     * 
     * @return The Amazon Web Services Region to deactivate.
     */
    public final String deactivateRegion() {
        return deactivateRegion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(executionId());
        hashCode = 31 * hashCode + Objects.hashCode(plan());
        hashCode = 31 * hashCode + Objects.hashCode(planVersion());
        hashCode = 31 * hashCode + Objects.hashCode(activateRegion());
        hashCode = 31 * hashCode + Objects.hashCode(deactivateRegion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartPlanExecutionResponse)) {
            return false;
        }
        StartPlanExecutionResponse other = (StartPlanExecutionResponse) obj;
        return Objects.equals(executionId(), other.executionId()) && Objects.equals(plan(), other.plan())
                && Objects.equals(planVersion(), other.planVersion()) && Objects.equals(activateRegion(), other.activateRegion())
                && Objects.equals(deactivateRegion(), other.deactivateRegion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartPlanExecutionResponse").add("ExecutionId", executionId()).add("Plan", plan())
                .add("PlanVersion", planVersion()).add("ActivateRegion", activateRegion())
                .add("DeactivateRegion", deactivateRegion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "executionId":
            return Optional.ofNullable(clazz.cast(executionId()));
        case "plan":
            return Optional.ofNullable(clazz.cast(plan()));
        case "planVersion":
            return Optional.ofNullable(clazz.cast(planVersion()));
        case "activateRegion":
            return Optional.ofNullable(clazz.cast(activateRegion()));
        case "deactivateRegion":
            return Optional.ofNullable(clazz.cast(deactivateRegion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("executionId", EXECUTION_ID_FIELD);
        map.put("plan", PLAN_FIELD);
        map.put("planVersion", PLAN_VERSION_FIELD);
        map.put("activateRegion", ACTIVATE_REGION_FIELD);
        map.put("deactivateRegion", DEACTIVATE_REGION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartPlanExecutionResponse, T> g) {
        return obj -> g.apply((StartPlanExecutionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ArcRegionSwitchResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, StartPlanExecutionResponse> {
        /**
         * <p>
         * The execution identifier of a plan execution.
         * </p>
         * 
         * @param executionId
         *        The execution identifier of a plan execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionId(String executionId);

        /**
         * <p>
         * The details of the Region switch plan.
         * </p>
         * 
         * @param plan
         *        The details of the Region switch plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder plan(String plan);

        /**
         * <p>
         * The version of the plan, a unique number generated by Region switch.
         * </p>
         * 
         * @param planVersion
         *        The version of the plan, a unique number generated by Region switch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder planVersion(String planVersion);

        /**
         * <p>
         * The Amazon Web Services Region to activate.
         * </p>
         * 
         * @param activateRegion
         *        The Amazon Web Services Region to activate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activateRegion(String activateRegion);

        /**
         * <p>
         * The Amazon Web Services Region to deactivate.
         * </p>
         * 
         * @param deactivateRegion
         *        The Amazon Web Services Region to deactivate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deactivateRegion(String deactivateRegion);
    }

    static final class BuilderImpl extends ArcRegionSwitchResponse.BuilderImpl implements Builder {
        private String executionId;

        private String plan;

        private String planVersion;

        private String activateRegion;

        private String deactivateRegion;

        private BuilderImpl() {
        }

        private BuilderImpl(StartPlanExecutionResponse model) {
            super(model);
            executionId(model.executionId);
            plan(model.plan);
            planVersion(model.planVersion);
            activateRegion(model.activateRegion);
            deactivateRegion(model.deactivateRegion);
        }

        public final String getExecutionId() {
            return executionId;
        }

        public final void setExecutionId(String executionId) {
            this.executionId = executionId;
        }

        @Override
        public final Builder executionId(String executionId) {
            this.executionId = executionId;
            return this;
        }

        public final String getPlan() {
            return plan;
        }

        public final void setPlan(String plan) {
            this.plan = plan;
        }

        @Override
        public final Builder plan(String plan) {
            this.plan = plan;
            return this;
        }

        public final String getPlanVersion() {
            return planVersion;
        }

        public final void setPlanVersion(String planVersion) {
            this.planVersion = planVersion;
        }

        @Override
        public final Builder planVersion(String planVersion) {
            this.planVersion = planVersion;
            return this;
        }

        public final String getActivateRegion() {
            return activateRegion;
        }

        public final void setActivateRegion(String activateRegion) {
            this.activateRegion = activateRegion;
        }

        @Override
        public final Builder activateRegion(String activateRegion) {
            this.activateRegion = activateRegion;
            return this;
        }

        public final String getDeactivateRegion() {
            return deactivateRegion;
        }

        public final void setDeactivateRegion(String deactivateRegion) {
            this.deactivateRegion = deactivateRegion;
        }

        @Override
        public final Builder deactivateRegion(String deactivateRegion) {
            this.deactivateRegion = deactivateRegion;
            return this;
        }

        @Override
        public StartPlanExecutionResponse build() {
            return new StartPlanExecutionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
