/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.arcregionswitch.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.arcregionswitch.model.ArcRegionSwitchResponse;
import software.amazon.awssdk.services.arcregionswitch.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListTagsForResourceResponse
extends ArcRegionSwitchResponse
implements ToCopyableBuilder<Builder, ListTagsForResourceResponse> {
    private static final SdkField<Map<String, String>> RESOURCE_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("resourceTags").getter(ListTagsForResourceResponse.getter(ListTagsForResourceResponse::resourceTags)).setter(ListTagsForResourceResponse.setter(Builder::resourceTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceTags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListTagsForResourceResponse.memberNameToFieldInitializer();
    private final Map<String, String> resourceTags;

    private ListTagsForResourceResponse(BuilderImpl builder) {
        super(builder);
        this.resourceTags = builder.resourceTags;
    }

    public final boolean hasResourceTags() {
        return this.resourceTags != null && !(this.resourceTags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> resourceTags() {
        return this.resourceTags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourceTags() ? this.resourceTags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTagsForResourceResponse)) {
            return false;
        }
        ListTagsForResourceResponse other = (ListTagsForResourceResponse)((Object)obj);
        return this.hasResourceTags() == other.hasResourceTags() && Objects.equals(this.resourceTags(), other.resourceTags());
    }

    public final String toString() {
        return ToString.builder((String)"ListTagsForResourceResponse").add("ResourceTags", this.hasResourceTags() ? this.resourceTags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "resourceTags": {
                return Optional.ofNullable(clazz.cast(this.resourceTags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<Map<String, String>>> map = new HashMap<String, SdkField<Map<String, String>>>();
        map.put("resourceTags", RESOURCE_TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListTagsForResourceResponse, T> g) {
        return obj -> g.apply((ListTagsForResourceResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ArcRegionSwitchResponse.BuilderImpl
    implements Builder {
        private Map<String, String> resourceTags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListTagsForResourceResponse model) {
            super(model);
            this.resourceTags(model.resourceTags);
        }

        public final Map<String, String> getResourceTags() {
            if (this.resourceTags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.resourceTags;
        }

        public final void setResourceTags(Map<String, String> resourceTags) {
            this.resourceTags = TagsCopier.copy(resourceTags);
        }

        @Override
        public final Builder resourceTags(Map<String, String> resourceTags) {
            this.resourceTags = TagsCopier.copy(resourceTags);
            return this;
        }

        @Override
        public ListTagsForResourceResponse build() {
            return new ListTagsForResourceResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ArcRegionSwitchResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListTagsForResourceResponse> {
        public Builder resourceTags(Map<String, String> var1);
    }
}

