/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.arcregionswitch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.arcregionswitch.model.Step;
import software.amazon.awssdk.services.arcregionswitch.model.StepsCopier;
import software.amazon.awssdk.services.arcregionswitch.model.WorkflowTargetAction;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Workflow
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Workflow> {
    private static final SdkField<List<Step>> STEPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("steps").getter(Workflow.getter(Workflow::steps)).setter(Workflow.setter(Builder::steps)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("steps").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Step::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> WORKFLOW_TARGET_ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workflowTargetAction").getter(Workflow.getter(Workflow::workflowTargetActionAsString)).setter(Workflow.setter(Builder::workflowTargetAction)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workflowTargetAction").build()}).build();
    private static final SdkField<String> WORKFLOW_TARGET_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workflowTargetRegion").getter(Workflow.getter(Workflow::workflowTargetRegion)).setter(Workflow.setter(Builder::workflowTargetRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workflowTargetRegion").build()}).build();
    private static final SdkField<String> WORKFLOW_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workflowDescription").getter(Workflow.getter(Workflow::workflowDescription)).setter(Workflow.setter(Builder::workflowDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workflowDescription").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STEPS_FIELD, WORKFLOW_TARGET_ACTION_FIELD, WORKFLOW_TARGET_REGION_FIELD, WORKFLOW_DESCRIPTION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Workflow.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<Step> steps;
    private final String workflowTargetAction;
    private final String workflowTargetRegion;
    private final String workflowDescription;

    private Workflow(BuilderImpl builder) {
        this.steps = builder.steps;
        this.workflowTargetAction = builder.workflowTargetAction;
        this.workflowTargetRegion = builder.workflowTargetRegion;
        this.workflowDescription = builder.workflowDescription;
    }

    public final boolean hasSteps() {
        return this.steps != null && !(this.steps instanceof SdkAutoConstructList);
    }

    public final List<Step> steps() {
        return this.steps;
    }

    public final WorkflowTargetAction workflowTargetAction() {
        return WorkflowTargetAction.fromValue(this.workflowTargetAction);
    }

    public final String workflowTargetActionAsString() {
        return this.workflowTargetAction;
    }

    public final String workflowTargetRegion() {
        return this.workflowTargetRegion;
    }

    public final String workflowDescription() {
        return this.workflowDescription;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSteps() ? this.steps() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.workflowTargetActionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.workflowTargetRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.workflowDescription());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Workflow)) {
            return false;
        }
        Workflow other = (Workflow)obj;
        return this.hasSteps() == other.hasSteps() && Objects.equals(this.steps(), other.steps()) && Objects.equals(this.workflowTargetActionAsString(), other.workflowTargetActionAsString()) && Objects.equals(this.workflowTargetRegion(), other.workflowTargetRegion()) && Objects.equals(this.workflowDescription(), other.workflowDescription());
    }

    public final String toString() {
        return ToString.builder((String)"Workflow").add("Steps", this.hasSteps() ? this.steps() : null).add("WorkflowTargetAction", (Object)this.workflowTargetActionAsString()).add("WorkflowTargetRegion", (Object)this.workflowTargetRegion()).add("WorkflowDescription", (Object)this.workflowDescription()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "steps": {
                return Optional.ofNullable(clazz.cast(this.steps()));
            }
            case "workflowTargetAction": {
                return Optional.ofNullable(clazz.cast(this.workflowTargetActionAsString()));
            }
            case "workflowTargetRegion": {
                return Optional.ofNullable(clazz.cast(this.workflowTargetRegion()));
            }
            case "workflowDescription": {
                return Optional.ofNullable(clazz.cast(this.workflowDescription()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("steps", STEPS_FIELD);
        map.put("workflowTargetAction", WORKFLOW_TARGET_ACTION_FIELD);
        map.put("workflowTargetRegion", WORKFLOW_TARGET_REGION_FIELD);
        map.put("workflowDescription", WORKFLOW_DESCRIPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Workflow, T> g) {
        return obj -> g.apply((Workflow)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<Step> steps = DefaultSdkAutoConstructList.getInstance();
        private String workflowTargetAction;
        private String workflowTargetRegion;
        private String workflowDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(Workflow model) {
            this.steps(model.steps);
            this.workflowTargetAction(model.workflowTargetAction);
            this.workflowTargetRegion(model.workflowTargetRegion);
            this.workflowDescription(model.workflowDescription);
        }

        public final List<Step.Builder> getSteps() {
            List<Step.Builder> result = StepsCopier.copyToBuilder(this.steps);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSteps(Collection<Step.BuilderImpl> steps) {
            this.steps = StepsCopier.copyFromBuilder(steps);
        }

        @Override
        public final Builder steps(Collection<Step> steps) {
            this.steps = StepsCopier.copy(steps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder steps(Step ... steps) {
            this.steps(Arrays.asList(steps));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder steps(Consumer<Step.Builder> ... steps) {
            this.steps(Stream.of(steps).map(c -> (Step)((Step.Builder)Step.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getWorkflowTargetAction() {
            return this.workflowTargetAction;
        }

        public final void setWorkflowTargetAction(String workflowTargetAction) {
            this.workflowTargetAction = workflowTargetAction;
        }

        @Override
        public final Builder workflowTargetAction(String workflowTargetAction) {
            this.workflowTargetAction = workflowTargetAction;
            return this;
        }

        @Override
        public final Builder workflowTargetAction(WorkflowTargetAction workflowTargetAction) {
            this.workflowTargetAction(workflowTargetAction == null ? null : workflowTargetAction.toString());
            return this;
        }

        public final String getWorkflowTargetRegion() {
            return this.workflowTargetRegion;
        }

        public final void setWorkflowTargetRegion(String workflowTargetRegion) {
            this.workflowTargetRegion = workflowTargetRegion;
        }

        @Override
        public final Builder workflowTargetRegion(String workflowTargetRegion) {
            this.workflowTargetRegion = workflowTargetRegion;
            return this;
        }

        public final String getWorkflowDescription() {
            return this.workflowDescription;
        }

        public final void setWorkflowDescription(String workflowDescription) {
            this.workflowDescription = workflowDescription;
        }

        @Override
        public final Builder workflowDescription(String workflowDescription) {
            this.workflowDescription = workflowDescription;
            return this;
        }

        public Workflow build() {
            return new Workflow(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Workflow> {
        public Builder steps(Collection<Step> var1);

        public Builder steps(Step ... var1);

        public Builder steps(Consumer<Step.Builder> ... var1);

        public Builder workflowTargetAction(String var1);

        public Builder workflowTargetAction(WorkflowTargetAction var1);

        public Builder workflowTargetRegion(String var1);

        public Builder workflowDescription(String var1);
    }
}

