/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.arcregionswitch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The Amazon Route 53 health check.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Route53HealthCheck implements SdkPojo, Serializable,
        ToCopyableBuilder<Route53HealthCheck.Builder, Route53HealthCheck> {
    private static final SdkField<String> HOSTED_ZONE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("hostedZoneId").getter(getter(Route53HealthCheck::hostedZoneId)).setter(setter(Builder::hostedZoneId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hostedZoneId").build()).build();

    private static final SdkField<String> RECORD_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("recordName").getter(getter(Route53HealthCheck::recordName)).setter(setter(Builder::recordName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recordName").build()).build();

    private static final SdkField<String> HEALTH_CHECK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("healthCheckId").getter(getter(Route53HealthCheck::healthCheckId)).setter(setter(Builder::healthCheckId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("healthCheckId").build()).build();

    private static final SdkField<String> REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("region")
            .getter(getter(Route53HealthCheck::region)).setter(setter(Builder::region))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("region").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HOSTED_ZONE_ID_FIELD,
            RECORD_NAME_FIELD, HEALTH_CHECK_ID_FIELD, REGION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String hostedZoneId;

    private final String recordName;

    private final String healthCheckId;

    private final String region;

    private Route53HealthCheck(BuilderImpl builder) {
        this.hostedZoneId = builder.hostedZoneId;
        this.recordName = builder.recordName;
        this.healthCheckId = builder.healthCheckId;
        this.region = builder.region;
    }

    /**
     * <p>
     * The Amazon Route 53 health check hosted zone ID.
     * </p>
     * 
     * @return The Amazon Route 53 health check hosted zone ID.
     */
    public final String hostedZoneId() {
        return hostedZoneId;
    }

    /**
     * <p>
     * The Amazon Route 53 record name.
     * </p>
     * 
     * @return The Amazon Route 53 record name.
     */
    public final String recordName() {
        return recordName;
    }

    /**
     * <p>
     * The Amazon Route 53 health check ID.
     * </p>
     * 
     * @return The Amazon Route 53 health check ID.
     */
    public final String healthCheckId() {
        return healthCheckId;
    }

    /**
     * <p>
     * The Amazon Route 53 Region.
     * </p>
     * 
     * @return The Amazon Route 53 Region.
     */
    public final String region() {
        return region;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hostedZoneId());
        hashCode = 31 * hashCode + Objects.hashCode(recordName());
        hashCode = 31 * hashCode + Objects.hashCode(healthCheckId());
        hashCode = 31 * hashCode + Objects.hashCode(region());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Route53HealthCheck)) {
            return false;
        }
        Route53HealthCheck other = (Route53HealthCheck) obj;
        return Objects.equals(hostedZoneId(), other.hostedZoneId()) && Objects.equals(recordName(), other.recordName())
                && Objects.equals(healthCheckId(), other.healthCheckId()) && Objects.equals(region(), other.region());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Route53HealthCheck").add("HostedZoneId", hostedZoneId()).add("RecordName", recordName())
                .add("HealthCheckId", healthCheckId()).add("Region", region()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "hostedZoneId":
            return Optional.ofNullable(clazz.cast(hostedZoneId()));
        case "recordName":
            return Optional.ofNullable(clazz.cast(recordName()));
        case "healthCheckId":
            return Optional.ofNullable(clazz.cast(healthCheckId()));
        case "region":
            return Optional.ofNullable(clazz.cast(region()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("hostedZoneId", HOSTED_ZONE_ID_FIELD);
        map.put("recordName", RECORD_NAME_FIELD);
        map.put("healthCheckId", HEALTH_CHECK_ID_FIELD);
        map.put("region", REGION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Route53HealthCheck, T> g) {
        return obj -> g.apply((Route53HealthCheck) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Route53HealthCheck> {
        /**
         * <p>
         * The Amazon Route 53 health check hosted zone ID.
         * </p>
         * 
         * @param hostedZoneId
         *        The Amazon Route 53 health check hosted zone ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostedZoneId(String hostedZoneId);

        /**
         * <p>
         * The Amazon Route 53 record name.
         * </p>
         * 
         * @param recordName
         *        The Amazon Route 53 record name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recordName(String recordName);

        /**
         * <p>
         * The Amazon Route 53 health check ID.
         * </p>
         * 
         * @param healthCheckId
         *        The Amazon Route 53 health check ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder healthCheckId(String healthCheckId);

        /**
         * <p>
         * The Amazon Route 53 Region.
         * </p>
         * 
         * @param region
         *        The Amazon Route 53 Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder region(String region);
    }

    static final class BuilderImpl implements Builder {
        private String hostedZoneId;

        private String recordName;

        private String healthCheckId;

        private String region;

        private BuilderImpl() {
        }

        private BuilderImpl(Route53HealthCheck model) {
            hostedZoneId(model.hostedZoneId);
            recordName(model.recordName);
            healthCheckId(model.healthCheckId);
            region(model.region);
        }

        public final String getHostedZoneId() {
            return hostedZoneId;
        }

        public final void setHostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
        }

        @Override
        public final Builder hostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
            return this;
        }

        public final String getRecordName() {
            return recordName;
        }

        public final void setRecordName(String recordName) {
            this.recordName = recordName;
        }

        @Override
        public final Builder recordName(String recordName) {
            this.recordName = recordName;
            return this;
        }

        public final String getHealthCheckId() {
            return healthCheckId;
        }

        public final void setHealthCheckId(String healthCheckId) {
            this.healthCheckId = healthCheckId;
        }

        @Override
        public final Builder healthCheckId(String healthCheckId) {
            this.healthCheckId = healthCheckId;
            return this;
        }

        public final String getRegion() {
            return region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        @Override
        public Route53HealthCheck build() {
            return new Route53HealthCheck(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
