/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.arczonalshift;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.arczonalshift.ArcZonalShiftClient;
import software.amazon.awssdk.services.arczonalshift.ArcZonalShiftClientBuilder;
import software.amazon.awssdk.services.arczonalshift.ArcZonalShiftServiceClientConfiguration;
import software.amazon.awssdk.services.arczonalshift.DefaultArcZonalShiftBaseClientBuilder;
import software.amazon.awssdk.services.arczonalshift.DefaultArcZonalShiftClient;
import software.amazon.awssdk.services.arczonalshift.endpoints.ArcZonalShiftEndpointProvider;

@SdkInternalApi
final class DefaultArcZonalShiftClientBuilder
extends DefaultArcZonalShiftBaseClientBuilder<ArcZonalShiftClientBuilder, ArcZonalShiftClient>
implements ArcZonalShiftClientBuilder {
    DefaultArcZonalShiftClientBuilder() {
    }

    @Override
    public DefaultArcZonalShiftClientBuilder endpointProvider(ArcZonalShiftEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final ArcZonalShiftClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultArcZonalShiftClientBuilder.validateClientOptions(clientConfiguration);
        ArcZonalShiftServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultArcZonalShiftClient client = new DefaultArcZonalShiftClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private ArcZonalShiftServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return ArcZonalShiftServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

